/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.scheduler.impl.jobs;

import com.indy.engine.core.IEngineClient;
import com.indy.engine.core.common.CommonUtils;
import com.indy.engine.core.common.GlobalVarI;
import com.indy.engine.scheduler.impl.jobs.Messages;
import com.semarchy.xdi.engine.common.EngineFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;

public class PurgeLogJob
implements StatefulJob {
    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        Logger logger = LogManager.getLogger((String)"org.quartz");
        String jobName = arg0.getJobDetail().getKey().getName();
        logger.info(Messages.getString("PurgeLogJob.0") + jobName + Messages.getString("PurgeLogJob.1"));
        String host = (String)arg0.getJobDetail().getJobDataMap().get((Object)"host");
        boolean local = true;
        if (host == null) {
            host = GlobalVarI.currentHTTPHost;
        } else {
            local = false;
        }
        Object _port = arg0.getJobDetail().getJobDataMap().get((Object)"port");
        Integer port = -1;
        if (_port instanceof Integer) {
            port = (Integer)_port;
            local = false;
        } else if (_port instanceof String) {
            local = false;
            port = Integer.valueOf((String)_port);
        }
        if (port == null || port == -1) {
            port = GlobalVarI.currentHTTPPort;
        }
        IEngineClient engine = null;
        try {
            if (local) {
                ServiceLoader<IEngineClient> serviceLoader = ServiceLoader.load(IEngineClient.class);
                Iterator<IEngineClient> iterator = serviceLoader.iterator();
                while (iterator.hasNext()) {
                    IEngineClient _local;
                    engine = _local = iterator.next();
                }
                if (engine == null) {
                    throw new RuntimeException(Messages.getString("PurgeLogJob.2"));
                }
            } else {
                engine = EngineFactory.getEngine((String)host, (int)port, null).getRemoteObject();
            }
            Map map = CommonUtils.transformPurgeMap((Map)arg0.getJobDetail().getJobDataMap());
            engine.purgeLogs(map);
            logger.debug(Messages.getString("PurgeLogJob.3") + jobName + Messages.getString("PurgeLogJob.4"));
        }
        catch (Exception e) {
            logger.error(Messages.getString("PurgeLogJob.5") + jobName + Messages.getString("PurgeLogJob.6"), (Throwable)e);
            throw new JobExecutionException((Throwable)e);
        }
    }
}

