/*
 * Decompiled with CFR 0.152.
 */
package com.indy.shell;

import com.indy.administration.AdministrationService;
import com.indy.shell.Messages;
import com.indy.shell.ShellApplicationException;
import com.indy.shell.WorkspaceSynchronizer;
import com.indy.shell.internal.MappingBuilder;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IGenerationService;
import com.semarchy.xdi.designer.core.services.IMappingBuilderDelegate;
import com.semarchy.xdi.designer.core.services.IWorkspaceListener;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.apache.felix.shell.ShellService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

public class ShellApplication
implements IApplication {
    private static final String SCRIPT_PATH = "script";
    private static final String LOG_FILE = "logFile";
    private static final String IMPORT_FROM = "importFrom";
    private static final String BUILD_ALL = "cleanProjects";
    private static final String RESET_CACHE = "rebuildCache";
    private Logger logger = LogManager.getLogger(ShellApplication.class);
    private String importProjectLocation;
    private boolean buildAll = false;
    private boolean resetCache = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File[] parseArguments(String[] arguments) throws ShellApplicationException {
        String script = null;
        File logFile = null;
        boolean skipNext = false;
        int i = 0;
        while (i < arguments.length) {
            if (skipNext) {
                skipNext = false;
            } else {
                String s = arguments[i];
                if (s.equals("-script")) {
                    if (i + 1 >= arguments.length) throw new ShellApplicationException(Messages.ShellApplication_10);
                    if (arguments[i + 1].startsWith("-")) {
                        throw new ShellApplicationException(NLS.bind((String)Messages.ShellApplication_13, (Object)SCRIPT_PATH));
                    }
                    script = arguments[i + 1];
                    skipNext = true;
                } else if (s.equals("-logFile")) {
                    if (i + 1 >= arguments.length) throw new ShellApplicationException(NLS.bind((String)Messages.ShellApplication_13, (Object)LOG_FILE));
                    if (arguments[i + 1].startsWith("-")) {
                        throw new ShellApplicationException(NLS.bind((String)Messages.ShellApplication_13, (Object)LOG_FILE));
                    }
                    logFile = new File(arguments[i + 1]);
                    logFile.getParentFile().mkdirs();
                    skipNext = true;
                } else if (s.equals("-importFrom")) {
                    if (i + 1 >= arguments.length) throw new ShellApplicationException(NLS.bind((String)Messages.ShellApplication_13, (Object)IMPORT_FROM));
                    if (arguments[i + 1].startsWith("-")) {
                        throw new ShellApplicationException(NLS.bind((String)Messages.ShellApplication_13, (Object)IMPORT_FROM));
                    }
                    this.importProjectLocation = arguments[i + 1];
                    skipNext = true;
                } else if (s.equals("-cleanProjects")) {
                    this.buildAll = true;
                } else if (s.equals("-rebuildCache")) {
                    this.resetCache = true;
                }
            }
            ++i;
        }
        if (script == null) {
            throw new ShellApplicationException(NLS.bind((String)Messages.ShellApplication_13, (Object)SCRIPT_PATH));
        }
        File scriptFile = new File(script);
        if (scriptFile.exists() && scriptFile.isFile()) return new File[]{scriptFile, logFile};
        throw new ShellApplicationException(NLS.bind((String)Messages.ShellApplication_27, script));
    }

    public Object start(IApplicationContext context) throws Exception {
        String[] arguments = (String[])context.getArguments().get("application.args");
        File[] argumentsFiles = this.parseArguments(arguments);
        ShellService shellService = (ShellService)E4InjectorHelper.getService(ShellService.class);
        if (shellService == null) {
            this.logger.warn(Messages.ShellApplication_32);
            Bundle felixBundle = Platform.getBundle((String)"org.apache.felix.shell");
            if (felixBundle == null) {
                throw new ShellApplicationException(Messages.ShellApplication_34);
            }
            felixBundle.start();
            this.logger.info(Messages.ShellApplication_32);
            shellService = (ShellService)E4InjectorHelper.getService(ShellService.class);
            if (shellService == null) {
                throw new ShellApplicationException(Messages.ShellApplication_39 + ShellService.class.getName() + Messages.ShellApplication_40);
            }
        }
        this.initializeEnvironment();
        try {
            this.executeScript(shellService, argumentsFiles[0], argumentsFiles[1]);
        }
        finally {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
            Job.getJobManager().join((Object)"MAPPING_BUILD_JOB_FAMILY", (IProgressMonitor)new NullProgressMonitor());
            Job.getJobManager().join(ICacheService.class, (IProgressMonitor)new NullProgressMonitor());
        }
        return IApplication.EXIT_OK;
    }

    private void synchronizeWorkspace(String importProjectLocation) throws ShellApplicationException, FileNotFoundException {
        File sourceFolder = new File(importProjectLocation);
        if (!sourceFolder.exists()) {
            throw new FileNotFoundException(NLS.bind((String)Messages.ShellApplication_44, (Object)importProjectLocation));
        }
        if (!sourceFolder.isDirectory()) {
            throw new ShellApplicationException(NLS.bind((String)Messages.ShellApplication_46, (Object)importProjectLocation));
        }
        WorkspaceSynchronizer sync = new WorkspaceSynchronizer(sourceFolder);
        try {
            IStatus res = sync.synchronizeWithWorkspace();
            if (!res.isOK()) {
                throw new ShellApplicationException(res.getMessage(), res.getException());
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new ShellApplicationException(Messages.ShellApplication_47, ex);
        }
    }

    private void joinIndexJobs() throws ShellApplicationException {
        try {
            Job.getJobManager().join(ICacheService.class, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new ShellApplicationException("Failed during waiting for Index initialization", ex);
        }
    }

    private void initializeEnvironment() throws ShellApplicationException, FileNotFoundException {
        IWorkspaceListener listener = (IWorkspaceListener)E4InjectorHelper.getService(IWorkspaceListener.class);
        listener.listenWorkspace();
        AdministrationService adminService = (AdministrationService)E4InjectorHelper.getService(AdministrationService.class);
        if (adminService == null) {
            throw new ShellApplicationException(Messages.ShellApplication_57);
        }
        adminService.setCurrentRole(new String[]{"com.indy.administration.role.admin"});
        ICacheService cache = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
        if (!cache.isInit()) {
            cache.init(this.resetCache);
        }
        IMappingBuilderDelegate mappingBuilderDelegate = (IMappingBuilderDelegate)E4InjectorHelper.getService(IMappingBuilderDelegate.class);
        if (this.importProjectLocation != null) {
            this.synchronizeWorkspace(this.importProjectLocation);
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, (IProgressMonitor)new NullProgressMonitor());
                Job.getJobManager().join(ResourcesPlugin.FAMILY_MANUAL_REFRESH, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception ex) {
                if (ex instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new ShellApplicationException("Failed during waiting for build Jobs after project import", ex);
            }
        }
        if (this.buildAll) {
            IWorkspaceDescription desc = ResourcesPlugin.getWorkspace().getDescription();
            desc.setAutoBuilding(false);
            try {
                ResourcesPlugin.getWorkspace().setDescription(desc);
            }
            catch (CoreException e) {
                this.logger.warn("Failed to disable Workspace automatic build", (Throwable)e);
            }
            this.joinIndexJobs();
            MappingBuilder builder = new MappingBuilder();
            try {
                builder.buildMappings();
            }
            catch (MappingBuilder.BuildException e) {
                this.logger.error("Some errors occured during mapping build", (Throwable)e);
            }
        } else {
            if (mappingBuilderDelegate == null) {
                throw new ShellApplicationException(String.format("Could not find service %s", IMappingBuilderDelegate.class));
            }
            try {
                Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, (IProgressMonitor)new NullProgressMonitor());
                Job.getJobManager().join((Object)"MAPPING_BUILD_JOB_FAMILY", (IProgressMonitor)new NullProgressMonitor());
                Job.getJobManager().join(IGenerationService.ITaskSynchronizer.class, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new ShellApplicationException("Failed during waiting for build Jobs", ex);
            }
        }
        this.joinIndexJobs();
    }

    private void executeScript(ShellService shellService, File script, File logFile) throws Exception {
        PrintStream out = System.out;
        PrintStream err = System.err;
        boolean closeOutputStream = false;
        try {
            try {
                Throwable throwable = null;
                Object var8_9 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(script), StandardCharsets.UTF_8));){
                    if (logFile != null) {
                        out = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFile, true)));
                        System.setOut(out);
                        System.setErr(System.out);
                        closeOutputStream = true;
                    }
                    String line = null;
                    int count = 0;
                    out.println(Messages.ShellApplication_51 + script.getAbsolutePath() + "...");
                    while ((line = reader.readLine()) != null) {
                        ++count;
                        if (line.trim().isEmpty()) continue;
                        try {
                            out.println("> " + line);
                            if (line.startsWith("#")) continue;
                            boolean logCommandNotFound = false;
                            if (closeOutputStream) {
                                ServiceReference r;
                                int i = line.indexOf(" ");
                                String cmdName = line.trim();
                                if (i > 0) {
                                    cmdName = line.substring(0, i);
                                }
                                boolean bl = logCommandNotFound = (r = shellService.getCommandReference(cmdName)) == null;
                            }
                            if (logCommandNotFound) {
                                out.println("ERROR - Command not found");
                                continue;
                            }
                            shellService.executeCommand(line.trim(), out, err);
                        }
                        catch (Exception ex) {
                            System.err.println(Messages.ShellApplication_54 + count);
                            ex.printStackTrace();
                        }
                    }
                    out.println(Messages.ShellApplication_55 + script.getAbsolutePath() + Messages.ShellApplication_56);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                if (closeOutputStream) {
                    System.out.flush();
                    System.out.close();
                }
            }
        }
        finally {
            out.flush();
            err.flush();
            System.setOut(out);
            System.setErr(err);
        }
    }

    public void stop() {
    }
}

