/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.net.proxy;

import com.stambia.net.proxy.Messages;
import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class URLUtil {
    private static Field handlerField;
    private static Method openConnectionMethod;
    private static Method openConnectionWithProxyMethod;

    static {
        try {
            handlerField = URL.class.getDeclaredField("handler");
            openConnectionMethod = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class);
            openConnectionWithProxyMethod = URLStreamHandler.class.getDeclaredMethod("openConnection", URL.class, Proxy.class);
        }
        catch (Exception e) {
            Logger.getLogger(URLUtil.class.getName()).log(Level.WARNING, "unexpected", e);
        }
        handlerField.setAccessible(true);
        openConnectionMethod.setAccessible(true);
        openConnectionWithProxyMethod.setAccessible(true);
    }

    public static URL createURL(String str, AuthenticationType authenticationType, final String user, final String password, Proxy proxy, final String proxyUser, final String proxyPassword, SSLSocketFactory sslSocketFactory, HostnameVerifier hostnameVerifier) throws MalformedURLException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        if (authenticationType.equals((Object)AuthenticationType.BASIC)) {
            return URLUtil.createURL(str, conn -> URLUtil.setUserHeader(conn, user, password, proxyUser, proxyPassword), proxy, sslSocketFactory, hostnameVerifier);
        }
        return URLUtil.createURL(str, new URLOpenConnectionHandler(){

            @Override
            public void handle(URLConnection conn) throws IOException {
                try {
                    Method setAuthMethod = conn.getClass().getMethod("setAuthenticator", Authenticator.class);
                    setAuthMethod.invoke((Object)conn, new Authenticator(){

                        @Override
                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(user, password.toCharArray());
                        }
                    });
                }
                catch (NoSuchMethodException e) {
                    throw new IOException(Messages.getString("URLUtil.0"));
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                URLUtil.setUserHeader(conn, null, null, proxyUser, proxyPassword);
            }
        }, proxy, sslSocketFactory, hostnameVerifier);
    }

    public static void setUserHeader(URLConnection conn, String user, String password, String proxyUser, String proxyPassword) {
        String encoded;
        if (proxyUser != null && proxyPassword != null) {
            encoded = DatatypeConverter.printBase64Binary((byte[])(proxyUser + ":" + proxyPassword).getBytes());
            conn.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
        }
        if (user != null && password != null) {
            encoded = DatatypeConverter.printBase64Binary((byte[])(user + ":" + password).getBytes());
            conn.setRequestProperty("Authorization", "Basic " + encoded);
        }
    }

    public static URL createURL(String str, final URLOpenConnectionHandler handler, final Proxy proxy, final SSLSocketFactory sslSocketFactory, final HostnameVerifier hostnameVerifier) throws MalformedURLException, SecurityException, IllegalArgumentException, IllegalAccessException {
        URL url = new URL(str);
        final URLStreamHandler urlStreamHandler = (URLStreamHandler)handlerField.get(url);
        url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile(), new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL u) throws IOException {
                try {
                    URLConnection urlConnection = proxy == null ? (URLConnection)openConnectionMethod.invoke((Object)urlStreamHandler, u) : (URLConnection)openConnectionWithProxyMethod.invoke((Object)urlStreamHandler, u, proxy);
                    if (urlConnection instanceof HttpsURLConnection) {
                        HttpsURLConnection conn = (HttpsURLConnection)urlConnection;
                        if (sslSocketFactory != null) {
                            conn.setSSLSocketFactory(sslSocketFactory);
                        }
                        if (hostnameVerifier != null) {
                            conn.setHostnameVerifier(hostnameVerifier);
                        }
                    }
                    if (handler != null) {
                        handler.handle(urlConnection);
                    }
                    return urlConnection;
                }
                catch (Exception e) {
                    Logger.getLogger(URLUtil.class.getName()).log(Level.WARNING, "unexpected", e);
                    return u.openConnection();
                }
            }
        });
        return url;
    }

    public static enum AuthenticationType {
        BASIC,
        NTLM;

    }

    public static interface URLOpenConnectionHandler {
        public void handle(URLConnection var1) throws IOException;
    }
}

