/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.quartz.cron;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TriggerState implements Enumerator
{
    NORMAL(0, "Normal", "Normal"),
    PAUSED(1, "Paused", "Paused"),
    COMPLETE(2, "Complete", "Complete"),
    ERROR(3, "Error", "Error"),
    BLOCKED(4, "Blocked", "Blocked"),
    NONE(5, "None", "None"),
    UNKNOWN(6, "Unknown", "Unknown");

    public static final int NORMAL_VALUE = 0;
    public static final int PAUSED_VALUE = 1;
    public static final int COMPLETE_VALUE = 2;
    public static final int ERROR_VALUE = 3;
    public static final int BLOCKED_VALUE = 4;
    public static final int NONE_VALUE = 5;
    public static final int UNKNOWN_VALUE = 6;
    private static final TriggerState[] VALUES_ARRAY;
    public static final List<TriggerState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TriggerState[]{NORMAL, PAUSED, COMPLETE, ERROR, BLOCKED, NONE, UNKNOWN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TriggerState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TriggerState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TriggerState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TriggerState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TriggerState get(int value) {
        switch (value) {
            case 0: {
                return NORMAL;
            }
            case 1: {
                return PAUSED;
            }
            case 2: {
                return COMPLETE;
            }
            case 3: {
                return ERROR;
            }
            case 4: {
                return BLOCKED;
            }
            case 5: {
                return NONE;
            }
            case 6: {
                return UNKNOWN;
            }
        }
        return null;
    }

    private TriggerState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

