/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom;

import com.indy.gmf.proc.diagram.non_rcp.custom.ProcDiagramUtil;
import com.indy.ui.custom.out.EditorInputManager;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;

public class ArianeEditorInput
extends URIEditorInput {
    private List<URIEditorInput> arianeInputs = new ArrayList<URIEditorInput>();
    private int currentIndex = -1;
    private List<ArianeListener> listeners = new ArrayList<ArianeListener>();

    public ArianeEditorInput(URIEditorInput uri) {
        super(uri.getURI(), uri.getName());
        this.add(uri);
    }

    public ArianeEditorInput(IMemento memento) {
        super(memento);
    }

    protected String getBundleSymbolicName() {
        return "com.indy.gmf.process.diagram.non_rcp";
    }

    public void addListener(ArianeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ArianeListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePathAdded() {
        for (ArianeListener l : this.listeners) {
            l.handlePathAdded();
        }
    }

    protected void firePathRemoved() {
        for (ArianeListener l : this.listeners) {
            l.handlePathRemoved();
        }
    }

    public URI getURI() {
        return this.getCurrent().getURI();
    }

    public Object getAdapter(Class adapter) {
        Object result;
        if (EMFPlugin.IS_RESOURCES_BUNDLE_AVAILABLE && (result = URIEditorInput.EclipseUtil.getAdatper((Class)adapter, (URI)this.getURI())) != null) {
            return result;
        }
        return null;
    }

    public URIEditorInput getCurrent() {
        EditorInputManager eim = new EditorInputManager((IEditorInput)this.arianeInputs.get(this.currentIndex), "proc"){

            public void createDiagramFile() {
                try {
                    ProcDiagramUtil.createNewDiagram(this.getModelUri(), false);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        };
        return (URIEditorInput)eim.getInput();
    }

    public void add(URIEditorInput editorInput) {
        this.arianeInputs.add(editorInput);
        this.currentIndex = this.arianeInputs.size() - 1;
        this.firePathAdded();
    }

    public void goTo(int offset) {
        this.currentIndex = offset;
        while (this.arianeInputs.size() - 1 > this.currentIndex) {
            this.arianeInputs.remove(this.arianeInputs.size() - 1);
            this.firePathRemoved();
        }
    }

    public List<URIEditorInput> getPath() {
        return new ArrayList<URIEditorInput>(this.arianeInputs);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof URIEditorInput && this.getURI().equals(((URIEditorInput)o).getURI());
    }

    public static interface ArianeListener {
        public void handlePathAdded();

        public void handlePathRemoved();
    }
}

