/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.custom.commands;

import com.indy.gmf.proc.diagram.non_rcp.custom.commands.Messages;
import com.indy.gmf.proc.diagram.non_rcp.custom.commands.ShowHideCompartmentHelper;
import com.indy.gmf.proc.diagram.non_rcp.edit.parts.ActionProcessEditPart;
import com.indy.ui.custom.out.EditorInputManager;
import com.indy.ui.custom.out.Util;
import com.indy.ui.custom.out.gmf.IDiagramResourceInitializer;
import com.indy.ui.custom.out.gmf.StambiaGMFEditingDomainFactory;
import com.indy.ui.custom.out.services.IDiagramProviderService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.MemoryMonitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;

public class ShowHideAndArrangeBackgroundHandler
extends AbstractHandler {
    private void visit(ResourceVisitor v, IResource r) {
        try {
            r.accept((IResourceVisitor)v);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection s = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        final ResourceVisitor v = new ResourceVisitor();
        s.toList().stream().filter(o -> o instanceof IResource).forEach(r -> this.visit(v, (IResource)r));
        final Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        Job j = new Job(Messages.ShowHideAndArrangeBackgroundHandler_3){
            TransactionalEditingDomain domain;
            {
                super($anonymous0);
                this.domain = StambiaGMFEditingDomainFactory.instanceGMF.createEditingDomain();
            }

            private boolean freeMemory() {
                if (MemoryMonitor.isMemoryLow((int)50)) {
                    this.domain.getCommandStack().flush();
                    for (Resource r : this.domain.getResourceSet().getResources()) {
                        try {
                            r.unload();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.domain.getResourceSet().getResources().clear();
                    return true;
                }
                return false;
            }

            private DiagramEditPart createEditPart(final Diagram diagram) {
                final AtomicReference rr = new AtomicReference();
                shell.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        CopyToImageUtil copyToImageUtil = new CopyToImageUtil();
                        rr.set(copyToImageUtil.createDiagramEditPart(diagram, shell, PreferencesHint.USE_DEFAULTS));
                    }
                });
                return (DiagramEditPart)rr.get();
            }

            public IStatus run(IProgressMonitor monitor) {
                try {
                    ResourceSet resourceSet = this.domain.getResourceSet();
                    resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                    resourceSet.getLoadOptions().put("STB_OPTION_DISABLE_ALL_MAP_ADAPTER", Boolean.TRUE);
                    SubMonitor subRoot = SubMonitor.convert((IProgressMonitor)monitor, (int)v.procFiles.size());
                    MultiStatus errorStatus = new MultiStatus("com.indy.gmf.process.diagram.non_rcp", 4, Messages.ShowHideAndArrangeBackgroundHandler_4, null);
                    for (IFile f : v.procFiles) {
                        this.freeMemory();
                        if (monitor.isCanceled()) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                        SubMonitor m = subRoot.split(1);
                        m.setTaskName(f.getFullPath().toOSString());
                        URI semanticURI = Util.convertIFileToEMFURI((IFile)f);
                        URI diagramURI = EditorInputManager.getDiagramURI((URI)semanticURI, (String)"proc");
                        IDiagramProviderService service = (IDiagramProviderService)E4InjectorHelper.getService(IDiagramProviderService.class);
                        if (service != null) {
                            IDiagramResourceInitializer initializer = service.getInitializer(semanticURI);
                            if (initializer == null) {
                                throw new RuntimeException("No IDiagramResourceInitializer for the resource " + String.valueOf(semanticURI));
                            }
                            Resource semanticResource = resourceSet.getResource(semanticURI, true);
                            Resource diagramResource = null;
                            try {
                                try {
                                    diagramResource = initializer.createResourceDiagram(semanticResource, diagramURI);
                                    for (EObject obj : new ArrayList(diagramResource.getContents())) {
                                        if (!(obj instanceof Diagram)) continue;
                                        Diagram diagram = (Diagram)obj;
                                        CompoundCommand cc = new CompoundCommand();
                                        DiagramEditPart diagramEditPart = this.createEditPart(diagram);
                                        cc.add((Command)new ICommandProxy((ICommand)ShowHideCompartmentHelper.INSTANCE.createShowCompartmentCommand((ActionProcessEditPart)diagramEditPart, 1, false)));
                                        cc.add((Command)new ICommandProxy((ICommand)ShowHideCompartmentHelper.INSTANCE.createShowCompartmentCommand((ActionProcessEditPart)diagramEditPart, 2, false)));
                                        diagramEditPart.getDiagramEditDomain().getDiagramCommandStack().execute((Command)cc);
                                        diagramEditPart = this.createEditPart(diagram);
                                        ArrangeRequest req = new ArrangeRequest("arrangeAllAction");
                                        diagramEditPart.getDiagramEditDomain().getDiagramCommandStack().execute(diagramEditPart.getCommand((Request)req));
                                    }
                                    semanticResource.save(new HashMap());
                                }
                                catch (Exception ex) {
                                    errorStatus.add((IStatus)new Status(4, "com.indy.gmf.process.diagram.non_rcp", Messages.ShowHideAndArrangeBackgroundHandler_5 + String.valueOf(f), (Throwable)ex));
                                    if (diagramResource != null) {
                                        diagramResource.unload();
                                    }
                                    if (semanticResource == null) continue;
                                    semanticResource.unload();
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                if (diagramResource != null) {
                                    diagramResource.unload();
                                }
                                if (semanticResource != null) {
                                    semanticResource.unload();
                                }
                                throw throwable;
                            }
                            if (diagramResource != null) {
                                diagramResource.unload();
                            }
                            if (semanticResource == null) continue;
                            semanticResource.unload();
                            continue;
                        }
                        Status status = new Status(4, "com.indy.gmf.process.diagram.non_rcp", Messages.ShowHideAndArrangeBackgroundHandler_6);
                        return status;
                    }
                    if (errorStatus.getChildren().length > 0) {
                        MultiStatus multiStatus = errorStatus;
                        return multiStatus;
                    }
                    Status status = new Status(0, "com.indy.gmf.process.diagram.non_rcp", Messages.ShowHideAndArrangeBackgroundHandler_7);
                    return status;
                }
                finally {
                    this.domain.dispose();
                }
            }
        };
        j.setUser(true);
        j.schedule(100L);
        try {
            j.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        StatusManager.getManager().handle(j.getResult(), 3);
        return null;
    }

    class ResourceVisitor
    implements IResourceVisitor {
        Set<IFile> procFiles = new HashSet<IFile>();

        ResourceVisitor() {
        }

        public boolean visit(IResource resource) throws CoreException {
            if (resource.getType() == 4 && !resource.getProject().isOpen()) {
                return false;
            }
            if (resource.getType() == 2 && ("indy.build".equals(resource.getName()) || "indy.diagram".equals(resource.getName()))) {
                return false;
            }
            if (resource.getType() == 1 && "proc".equals(resource.getFileExtension())) {
                this.procFiles.add((IFile)resource);
            }
            return true;
        }
    }
}

