/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.proc.diagram.non_rcp.edit.parts;

import com.indy.gmf.proc.Link;
import com.indy.gmf.proc.MandatoryType;
import com.indy.gmf.proc.ProcPackage;
import com.indy.gmf.proc.diagram.non_rcp.custom.policies.PopupGenerationConditionHandle;
import com.indy.gmf.proc.diagram.non_rcp.edit.parts.figure.CustomSizedNodeFigure;
import com.indy.gmf.proc.diagram.non_rcp.edit.policies.LinkItemSemanticEditPolicy;
import com.indy.gmf.proc.diagram.non_rcp.messages.Messages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transform;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITreeBranchEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editpolicies.ConnectionEditPolicy;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.gef.ui.internal.editpolicies.GraphicalEditPolicyEx;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class LinkEditPart
extends ConnectionNodeEditPart
implements ITreeBranchEditPart {
    public static final int CIRCLE_CONNECTION_DECORATION_RADIUS = 5;
    public static final int VISUAL_ID = 4001;
    public static final Color THIS_FORE;
    public static final Color THIS_FORE_KO;
    public static final Color THIS_FORE_OK;
    public static final Color THIS_FORE_OK_KO;

    static {
        THIS_FORE_KO = THIS_FORE = new Color(null, 128, 0, 0);
        THIS_FORE_OK = new Color(null, 30, 210, 62);
        THIS_FORE_OK_KO = new Color(null, 28, 58, 215);
    }

    public LinkEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new LinkItemSemanticEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new ConnectionEditPolicy(){

            protected boolean shouldDeleteSemantic() {
                EditPart ep;
                Assert.isTrue((boolean)(this.getHost() instanceof AbstractConnectionEditPart));
                AbstractConnectionEditPart cep = (AbstractConnectionEditPart)this.getHost();
                if (cep instanceof ConnectionEditPart && !((ConnectionEditPart)cep).isSemanticConnection()) {
                    return false;
                }
                boolean isCanonical = false;
                if (cep.getSource() != null) {
                    ep = cep.getSource();
                    while (ep != null && ep instanceof ConnectionEditPart) {
                        ep = ep.getParent();
                    }
                    isCanonical = this.IsCanonical(ep);
                }
                if (cep.getTarget() != null) {
                    ep = cep.getTarget();
                    while (ep != null && ep instanceof ConnectionEditPart) {
                        ep = ep.getParent();
                    }
                    isCanonical = this.IsCanonical(ep);
                    isCanonical = isCanonical && this.IsCanonical(ep);
                }
                return isCanonical;
            }

            private boolean IsCanonical(EditPart ep) {
                EditPart parent = ep.getParent();
                return parent instanceof GraphicalEditPart ? ((GraphicalEditPart)parent).isCanonical() : false;
            }
        });
    }

    protected Connection createConnectionFigure() {
        return new ActionLink2Figure();
    }

    public ActionLink2Figure getPrimaryShape() {
        return (ActionLink2Figure)this.getFigure();
    }

    protected void handleNotificationEvent(Notification notification) {
        EditPolicy ep;
        if (notification.getNotifier() instanceof Link) {
            this.getPrimaryShape().updateFace();
            this.refreshTargetAnchor();
        }
        if (notification.getFeature() == ProcPackage.eINSTANCE.getLink_Mandatory()) {
            this.getPrimaryShape().updateTargetDecoration();
        }
        if ((notification.getFeature() == ProcPackage.eINSTANCE.getLink_ExecutionCondition() || notification.getFeature() == ProcPackage.eINSTANCE.getElement_GenerationCondition()) && (ep = this.getEditPolicy("DecorationPolicy")) != null && ep instanceof GraphicalEditPolicyEx) {
            ((GraphicalEditPolicyEx)ep).refresh();
        }
        super.handleNotificationEvent(notification);
    }

    protected ConnectionAnchor getTargetConnectionAnchor() {
        Link link;
        ConnectionAnchor anchor = super.getTargetConnectionAnchor();
        if (anchor instanceof CustomSizedNodeFigure.CustomAnchor && (link = this.getLink()) != null) {
            if (link.getMandatory() == MandatoryType.INHIBITORY) {
                ((CustomSizedNodeFigure.CustomAnchor)anchor).setIsWire(true);
            } else {
                ((CustomSizedNodeFigure.CustomAnchor)anchor).setIsWire(false);
            }
        }
        Rectangle r = this.getFigure().getBounds().getCopy();
        this.getFigure().translateToAbsolute((Translatable)r);
        return anchor;
    }

    protected Link getLink() {
        try {
            return (Link)((View)this.getModel()).getElement();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        return null;
    }

    public class ActionLink2Figure
    extends PolylineConnectionEx {
        public ActionLink2Figure() {
            this.updateFace();
            this.setTargetDecoration(this.createTargetDecoration());
            this.setSourceDecoration(this.createSourceDecoration());
        }

        private RotatableDecoration createSourceDecoration() {
            PolygonDecoration df = new PolygonDecoration();
            PointList pl = new PointList();
            Link link = LinkEditPart.this.getLink();
            if (link != null) {
                switch (link.getGenerationType()) {
                    case KO: {
                        df.setForegroundColor(THIS_FORE_KO);
                        break;
                    }
                    case OK: {
                        df.setForegroundColor(THIS_FORE_OK);
                        break;
                    }
                    case OKKO: {
                        df.setForegroundColor(THIS_FORE_OK_KO);
                    }
                }
                if (link.getGenerationCondition() != null && !link.getGenerationCondition().isEmpty()) {
                    pl.addPoint(LinkEditPart.this.getMapMode().DPtoLP(2), LinkEditPart.this.getMapMode().DPtoLP(-1));
                    pl.addPoint(LinkEditPart.this.getMapMode().DPtoLP(1), LinkEditPart.this.getMapMode().DPtoLP(1));
                }
            }
            df.setTemplate(pl);
            df.setScale((double)(-LinkEditPart.this.getMapMode().DPtoLP(7)), (double)LinkEditPart.this.getMapMode().DPtoLP(4));
            return df;
        }

        private RotatableDecoration createTargetDecoration() {
            Object df = null;
            Link link = LinkEditPart.this.getLink();
            if (link != null) {
                switch (link.getMandatory()) {
                    case MANDATORY: {
                        df = new PolygonDecoration();
                        break;
                    }
                    case NOT_MANDATORY: {
                        df = new PolylineDecoration();
                        break;
                    }
                    case INHIBITORY: {
                        df = new CircleDecoration();
                    }
                }
            }
            if (df == null) {
                df = new PolylineDecoration();
            }
            return df;
        }

        protected void updateTargetDecoration() {
            this.setTargetDecoration(this.createTargetDecoration());
        }

        protected void updateSourceDecoration() {
            this.setSourceDecoration(this.createSourceDecoration());
        }

        public void updateFace() {
            Link link = LinkEditPart.this.getLink();
            if (link != null) {
                if (link.getExecutionType() == null) {
                    this.setForegroundColor(THIS_FORE_OK);
                } else if (link.getExecutionType().getLiteral().equals("OK")) {
                    this.setForegroundColor(THIS_FORE_OK);
                } else if (link.getExecutionType().getLiteral().equals("OK_KO")) {
                    this.setForegroundColor(THIS_FORE_OK_KO);
                } else {
                    this.setForegroundColor(THIS_FORE);
                }
                this.updateSourceDecoration();
                String toolTip = null;
                if (link.getExecutionCondition() != null && !link.getExecutionCondition().isEmpty()) {
                    toolTip = Messages.LinkEditPart_2 + link.getExecutionCondition();
                }
                if (toolTip != null) {
                    this.setLineStyle(6);
                    if (this.getToolTip() == null) {
                        this.setToolTip((IFigure)new Label(toolTip));
                    } else if (this.getToolTip() instanceof Label) {
                        ((Label)this.getToolTip()).setText(toolTip);
                    }
                    this.setLineDash(new int[]{2, 3});
                    this.repaint();
                } else {
                    if (this.getToolTip() != null) {
                        ((Label)this.getToolTip()).setText(null);
                    }
                    this.setLineDash(new int[0]);
                    this.setLineStyle(1);
                    this.repaint();
                }
            }
        }
    }

    private class CircleDecoration
    extends Ellipse
    implements RotatableDecoration {
        private Transform transform = new Transform();

        private CircleDecoration() {
        }

        public void setReferencePoint(Point p) {
            Point _pt = ((Connection)LinkEditPart.this.getFigure()).getPoints().getPoint(((Connection)LinkEditPart.this.getFigure()).getPoints().size() - 1);
            Point pt = Point.SINGLETON;
            pt.setLocation(_pt);
            pt.negate().translate(this.getLocation());
            this.transform.setRotation(Math.atan2(pt.y, pt.x));
            Point pp = this.transform.getTransformed(new Point(-5, -5));
            Rectangle r = new Rectangle(pp.x, pp.y, 10, 10);
            this.setBounds(r);
        }

        public void setLocation(Point p) {
            Point pt = ((Connection)LinkEditPart.this.getFigure()).getPoints().getPoint(((Connection)LinkEditPart.this.getFigure()).getPoints().size() - 1);
            super.setLocation(new Point(pt.x, pt.y));
            this.transform.setTranslation((double)pt.x, (double)pt.y);
        }
    }

    private class GenerationConditionDecoration
    extends Figure
    implements RotatableDecoration {
        public GenerationConditionDecoration() {
            this.setLayoutManager((LayoutManager)new StackLayout());
            this.add((IFigure)new ImageFigure(PopupGenerationConditionHandle.PROPERTIES_IMAGE));
        }

        public void setReferencePoint(Point p) {
            Point _pt = ((Connection)LinkEditPart.this.getFigure()).getPoints().getPoint(0);
            _pt = _pt.getCopy();
            _pt.translate(-this.getPreferredSize().width / 2, 0);
            this.setLocation(_pt);
        }
    }
}

