/*
 * Decompiled with CFR 0.152.
 */
package com.indy.quartz.cron.editor.composite;

import com.indy.quartz.cron.editor.composite.BasicCronComposite;
import com.indy.quartz.cron.editor.composite.CronUnitConstante;
import com.indy.quartz.cron.editor.composite.DayCronComposite;
import com.indy.quartz.cron.editor.composite.Messages;
import com.indy.quartz.cron.editor.composite.MonthCronComposite;
import com.indy.quartz.cron.editor.composite.TriggerComposite;
import com.indy.ui.utils.FormMessageWrapper;
import com.stambia.quartz.cron.CronTrigger;
import com.stambia.quartz.cron.Trigger;
import com.stambia.quartz.cron.parser.CronParser;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.databinding.EMFDataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CronTriggerComposite
extends TriggerComposite {
    private CTabFolder tabFolder;
    private BasicCronComposite secondCronComposite;
    private BasicCronComposite minuteCronComposite;
    private BasicCronComposite hourCronComposite;
    private DayCronComposite dayCronComposite;
    private MonthCronComposite monthCronComposite;
    private BasicCronComposite yearCronComposite;
    private Text cronText;

    public CronTriggerComposite(Composite parent, FormToolkit toolkit, Trigger triggerEObject, EditingDomain domain, ComposedAdapterFactory adapterFactory, FormMessageWrapper mmng, EMFDataBindingContext ctx) {
        super(parent, toolkit, triggerEObject, domain, adapterFactory, mmng, ctx);
        this.updateCronText();
        triggerEObject.eAdapters().add((Object)new EContentAdapter(){

            public void notifyChanged(Notification msg) {
                super.notifyChanged(msg);
                CronTriggerComposite.this.updateCronText();
            }
        });
    }

    private void updateCronText() {
        if (!this.cronText.isDisposed()) {
            this.cronText.setText(CronParser.modelToCron((CronTrigger)((CronTrigger)this.triggerEObject)));
        }
    }

    @Override
    public void createComposite(Composite composite) {
        this.cronText = new Text(composite, 8);
        this.cronText.setLayoutData((Object)new GridData(4, 4, true, false));
        this.tabFolder = new CTabFolder(composite, 0);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, false));
        CronTrigger trigger = (CronTrigger)this.triggerEObject;
        CTabItem secondTab = new CTabItem(this.tabFolder, 0);
        secondTab.setText(Messages.CronTriggerComposite_0);
        this.secondCronComposite = new BasicCronComposite((Composite)this.tabFolder, this.toolkit, (EObject)trigger.getSecond(), this.domain, (DataBindingContext)this.ctx, CronUnitConstante.BasicUnit.SECOND, (IMessageManager)this.mmng);
        secondTab.setControl((Control)this.secondCronComposite.getComposite());
        CTabItem minuteTab = new CTabItem(this.tabFolder, 0);
        minuteTab.setText(Messages.CronTriggerComposite_1);
        this.minuteCronComposite = new BasicCronComposite((Composite)this.tabFolder, this.toolkit, (EObject)trigger.getMinute(), this.domain, (DataBindingContext)this.ctx, CronUnitConstante.BasicUnit.MINUTE, (IMessageManager)this.mmng);
        minuteTab.setControl((Control)this.minuteCronComposite.getComposite());
        CTabItem hourTab = new CTabItem(this.tabFolder, 0);
        hourTab.setText(Messages.CronTriggerComposite_2);
        this.hourCronComposite = new BasicCronComposite((Composite)this.tabFolder, this.toolkit, (EObject)trigger.getHour(), this.domain, (DataBindingContext)this.ctx, CronUnitConstante.BasicUnit.HOUR, (IMessageManager)this.mmng);
        hourTab.setControl((Control)this.hourCronComposite.getComposite());
        CTabItem dayTab = new CTabItem(this.tabFolder, 0);
        dayTab.setText(Messages.CronTriggerComposite_3);
        this.dayCronComposite = new DayCronComposite((Composite)this.tabFolder, this.toolkit, (EObject)trigger.getDay(), this.domain, (DataBindingContext)this.ctx, this.mmng);
        dayTab.setControl((Control)this.dayCronComposite.getComposite());
        CTabItem monthTab = new CTabItem(this.tabFolder, 0);
        monthTab.setText(Messages.CronTriggerComposite_4);
        this.monthCronComposite = new MonthCronComposite((Composite)this.tabFolder, this.toolkit, (EObject)trigger.getMonth(), this.domain, (DataBindingContext)this.ctx, this.mmng);
        monthTab.setControl((Control)this.monthCronComposite.getComposite());
        CTabItem yearTab = new CTabItem(this.tabFolder, 0);
        yearTab.setText(Messages.CronTriggerComposite_5);
        this.yearCronComposite = new BasicCronComposite((Composite)this.tabFolder, this.toolkit, (EObject)trigger.getYear(), this.domain, (DataBindingContext)this.ctx, CronUnitConstante.BasicUnit.YEAR, (IMessageManager)this.mmng);
        yearTab.setControl((Control)this.yearCronComposite.getComposite());
        this.tabFolder.setSelection(0);
    }

    @Override
    public void bind() {
        this.secondCronComposite.bind();
        this.minuteCronComposite.bind();
        this.hourCronComposite.bind();
        this.dayCronComposite.bind();
        this.monthCronComposite.bind();
        this.yearCronComposite.bind();
    }

    @Override
    public boolean isTriggerValid() {
        boolean noError = true;
        for (ValidationStatusProvider validationStatusProvider : this.ctx.getValidationStatusProviders()) {
            IStatus status = (IStatus)validationStatusProvider.getValidationStatus().getValue();
            if (status.getSeverity() != 4) continue;
            noError = false;
        }
        return noError;
    }
}

