/*
 * Decompiled with CFR 0.152.
 */
package com.indy.quartz.cron.editor.page;

import com.indy.engine.core.common.objects2.EngineScheduleDetail;
import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.engine.log.engine.EngineRegistry;
import com.indy.quartz.cron.editor.editor.input.PurgeEditorInput;
import com.indy.quartz.cron.editor.page.QuartzPage;
import com.indy.ui.common.messages.CronMessages;
import com.stambia.quartz.cron.CronPackage;
import com.stambia.quartz.cron.CronTrigger;
import com.stambia.quartz.cron.PurgeType;
import com.stambia.quartz.cron.PurgeUnit;
import com.stambia.quartz.cron.QuartzType;
import com.stambia.quartz.cron.RuntimeStatus;
import com.stambia.quartz.cron.Trigger;
import com.stambia.quartz.cron.TriggerState;
import com.stambia.quartz.cron.parser.CronParser;
import com.stambia.quartz.cron.presentation.PurgeStatusMenu;
import com.stambia.ui.tools.Utils;
import com.stambia.ui.tools.binding.BindingText;
import com.stambia.ui.tools.binding.UnboundedList;
import com.stambia.ui.tools.binding.UnboundedListCtrl;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PurgeEditorPage
extends QuartzPage {
    private PurgeType purge;
    private final String errorKey = "schedule/purge/keepValue";
    private final String keepValueFormError;
    private final String keepValueEmptyFormError;
    private String user;
    private String password;
    private final Logger logger;

    public PurgeEditorPage(FormEditor editor, PurgeType cronEObject, EditingDomain domain, ComposedAdapterFactory adapterFactory) {
        super(editor, (QuartzType)cronEObject, domain, adapterFactory, "Purge");
        this.keepValueFormError = CronMessages.get().PurgeEditorPage_1;
        this.keepValueEmptyFormError = CronMessages.get().PurgeEditorPage_2;
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.purge = cronEObject;
        if (editor.getEditorInput() instanceof PurgeEditorInput) {
            this.host = ((PurgeEditorInput)editor.getEditorInput()).getHost();
            this.port = ((PurgeEditorInput)editor.getEditorInput()).getPort();
            this.user = ((PurgeEditorInput)editor.getEditorInput()).getUser();
            this.password = ((PurgeEditorInput)editor.getEditorInput()).getPassword();
        }
    }

    @Override
    protected void createTopComposite(Composite parent) {
        Section purgeSection = Utils.createSection((FormToolkit)this.toolkit, (Composite)parent, (String)CronMessages.get().PurgeEditorPage_3);
        purgeSection.setLayout((Layout)new GridLayout());
        purgeSection.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite purgeComp = this.toolkit.createComposite((Composite)purgeSection);
        purgeComp.setLayout((Layout)new GridLayout(2, false));
        purgeComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolkit.createLabel(purgeComp, CronMessages.get().PurgeEditorPage_4);
        Composite keepComp = new Composite(purgeComp, 0);
        keepComp.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(4, 4, true, false);
        keepComp.setLayoutData((Object)gridData);
        Text keepText = this.toolkit.createText(keepComp, "");
        keepText.setLayoutData((Object)new GridData(35, -1));
        new BindingText((DataBindingContext)this.ctx, keepText, (EObject)this.purge, (EStructuralFeature)CronPackage.eINSTANCE.getPurgeType_NumberToKeep(), this.domain);
        keepFieldValidator valProvider = new keepFieldValidator((Control)keepText);
        this.ctx.addValidationStatusProvider((ValidationStatusProvider)valProvider);
        ControlDecorationSupport.create((ValidationStatusProvider)valProvider, (int)16512);
        CCombo purgeUnitCbx = new CCombo(keepComp, 2048);
        ComboViewer purgeUnitCbxViewer = new ComboViewer(purgeUnitCbx);
        purgeUnitCbxViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ArrayList<PurgeUnit> purgeUnitCbxInput = new ArrayList<PurgeUnit>();
        purgeUnitCbxInput.add(PurgeUnit.DAY);
        purgeUnitCbxInput.add(PurgeUnit.HOUR);
        purgeUnitCbxInput.add(PurgeUnit.MINUTE);
        purgeUnitCbxInput.add(PurgeUnit.SESSION);
        purgeUnitCbxViewer.setInput(purgeUnitCbxInput);
        IViewerObservableValue purgeUnitSelection = ViewerProperties.singleSelection().observe((Viewer)purgeUnitCbxViewer);
        DataBindingContext dbc = new DataBindingContext();
        dbc.bindValue((IObservableValue)purgeUnitSelection, EMFEditProperties.value((EditingDomain)this.domain, (EStructuralFeature)CronPackage.eINSTANCE.getPurgeType_PurgeUnit()).observe((Object)this.purge));
        Group amongGroup = new Group(purgeComp, 0);
        amongGroup.setBackground(purgeComp.getBackground());
        amongGroup.setText(CronMessages.get().PurgeEditorPage_6);
        GridData amongGridData = new GridData(4, 4, true, false);
        amongGridData.horizontalSpan = 2;
        amongGroup.setLayout((Layout)new GridLayout(2, false));
        amongGroup.setLayoutData((Object)amongGridData);
        this.toolkit.createLabel((Composite)amongGroup, CronMessages.get().PurgeEditorPage_7);
        new PurgeStatusMenu((Composite)amongGroup).bind(this.domain, (EObject)this.purge);
        this.toolkit.createLabel((Composite)amongGroup, CronMessages.get().PurgeEditorPage_8);
        UnboundedListCtrl listSession = new UnboundedListCtrl((Composite)amongGroup, 0, 2048, 0, "... ");
        new UnboundedList(listSession, (EStructuralFeature)CronPackage.eINSTANCE.getPurgeType_Sessions(), (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory), new AdapterFactoryItemDelegator((AdapterFactory)this.adapterFactory), this.domain).bind((EObject)this.purge);
        purgeSection.setClient((Control)purgeComp);
        if (this.getEditorInput() instanceof PurgeEditorInput && ((PurgeEditorInput)this.getEditorInput()).isNew()) {
            keepText.setText("");
        }
        super.createTopComposite(parent);
    }

    public String schedulePurge() {
        block23: {
            try {
                AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(this.host, Integer.valueOf(this.port), this.user, this.password);
                HashMap<String, Object> rules = new HashMap<String, Object>();
                rules.put("size", String.valueOf(this.purge.getNumberToKeep()));
                rules.put("host", null);
                rules.put("port", null);
                rules.put("unit", this.purge.getPurgeUnit().getLiteral().toLowerCase());
                ArrayList<Integer> list = new ArrayList<Integer>();
                if (this.purge.getStatus() != null && !this.purge.getStatus().isEmpty()) {
                    for (RuntimeStatus status : this.purge.getStatus()) {
                        switch (status.getValue()) {
                            case 0: {
                                list.add(1);
                                break;
                            }
                            case 1: {
                                list.add(-1);
                                break;
                            }
                            case 2: {
                                list.add(-2);
                                break;
                            }
                            case 3: {
                                list.add(-4);
                                break;
                            }
                        }
                    }
                }
                rules.put("purgeStatusList", list);
                HashMap mapSessionName = new HashMap();
                if (this.purge.getSessions() != null && !this.purge.getSessions().isEmpty()) {
                    int i = 0;
                    for (String session : this.purge.getSessions()) {
                        HashMap<String, String> mapDetail = new HashMap<String, String>();
                        mapDetail.put("filter", session);
                        mapSessionName.put(String.valueOf(i), mapDetail);
                        ++i;
                    }
                }
                rules.put("purgeSessionName", mapSessionName);
                EngineScheduleDetail esd = new EngineScheduleDetail(1);
                if (this.purge.getTrigger() == null) break block23;
                Trigger trigger = this.purge.getTrigger();
                if (trigger instanceof CronTrigger) {
                    esd.setCronExpression(CronParser.modelToCron((CronTrigger)((CronTrigger)this.purge.getTrigger())));
                    esd.setRepeatInterval(0L);
                }
                esd.setJobName(this.purge.getName());
                esd.setTriggerName(this.purge.getTriggerName());
                if (this.purge.getStart() != null && this.purge.getStart().compare(Utils.dateToXmlDate((Date)new Date())) == 1) {
                    esd.setStartTime(this.purge.getStart().toGregorianCalendar().getTime());
                }
                if (this.purge.getEnd() != null) {
                    esd.setEndTime(this.purge.getEnd().toGregorianCalendar().getTime());
                } else {
                    esd.setEndTime(null);
                }
                ArrayList<Map> lst = new ArrayList<Map>();
                lst.add(esd.toMap());
                ((Map)lst.get(0)).put("repeatCount", 0);
                try {
                    Map result = engine.scheduleLogsPurge(this.purge.getTriggerName(), lst, rules);
                    if (this.purge.getTriggerName() == null || this.purge.getTriggerName().isEmpty()) {
                        this.purge.setTriggerName((String)result.get("triggerName"));
                        if (this.getEditorInput() instanceof PurgeEditorInput) {
                            ((PurgeEditorInput)this.getEditorInput()).setPurgeEditorId(this.purge.getTriggerName());
                        }
                    }
                    this.refresh();
                    this.purge.setNextExecution(Utils.dateToXmlDate((Date)((Date)result.get("nextExecution"))));
                }
                catch (Exception e) {
                    if (e.getCause() instanceof UnmarshalException) {
                        engine.schedulePurgeLog(this.purge.getTriggerName(), lst, rules);
                        if (this.purge.getTriggerName() == null && this.getEditorInput() instanceof PurgeEditorInput) {
                            ((PurgeEditorInput)this.getEditorInput()).setisSaveAllowed(false);
                        }
                    }
                    throw e;
                }
                MessageBox mb = new MessageBox(Display.getDefault().getActiveShell(), 16);
                mb.setText(CronMessages.get().Succes);
                mb.setMessage(CronMessages.get().PurgeEditorPage_22);
                mb.open();
            }
            catch (RemoteException e) {
                Status status = new Status(4, "com.indy.quartz.cron.editor", e.getCause().getMessage(), (Throwable)e);
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)CronMessages.get().Error, (String)CronMessages.get().PurgeEditorPage_25, (IStatus)status);
            }
            catch (Exception e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
        }
        return this.purge.getTriggerName();
    }

    @Override
    protected Map<String, Object> refresh() {
        Map<String, Object> parameters = super.refresh(this.host, this.port, this.user, this.password, this.purge.getName());
        if (parameters.containsKey("triggerState")) {
            this.purge.setState(CronParser.getQuartzTriggerState((Object)parameters.get("triggerState")));
        } else {
            this.purge.setState(TriggerState.UNKNOWN);
        }
        return parameters;
    }

    class keepFieldValidator
    extends MultiValidator {
        private IObservableValue keepFieldObservable;

        public keepFieldValidator(Control text) {
            this.keepFieldObservable = WidgetProperties.text((int)24).observe((Widget)text);
        }

        public IStatus validate() {
            if (this.keepFieldObservable.getValue() instanceof String) {
                String value = (String)this.keepFieldObservable.getValue();
                if (value.isEmpty()) {
                    PurgeEditorPage.this.mmng.addMessage((Object)"schedule/purge/keepValue", PurgeEditorPage.this.keepValueEmptyFormError, null, 3);
                    return ValidationStatus.error((String)PurgeEditorPage.this.keepValueEmptyFormError);
                }
                try {
                    Integer.parseInt(value);
                }
                catch (Exception e) {
                    PurgeEditorPage.this.mmng.addMessage((Object)"schedule/purge/keepValue", PurgeEditorPage.this.keepValueFormError, null, 3);
                    return ValidationStatus.error((String)PurgeEditorPage.this.keepValueFormError);
                }
                PurgeEditorPage.this.mmng.removeMessage((Object)"schedule/purge/keepValue");
                return ValidationStatus.ok();
            }
            PurgeEditorPage.this.mmng.addMessage((Object)"schedule/purge/keepValue", PurgeEditorPage.this.keepValueFormError, null, 3);
            return ValidationStatus.error((String)PurgeEditorPage.this.keepValueFormError);
        }
    }
}

