/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.build.parser.sql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LightParser {
    static final String PRE = "\u00a7\u00a3\u20ac";
    static final String POST = "\u20ac\u00a3\u00a7";
    public static final int IS_CHAR = 0;
    public static final int IS_VAR = 1;
    public static final int IS_OTHER = 2;
    public static final int IS_XSL = 4;
    public static final int IS_RUNTIME = 5;
    String textToParse;
    String textTaged;
    String fieldsRegexp;
    String excludeRegexp;
    private List<String> fields;
    protected List<Bloc> blocs;
    private Set<String> unMatched;
    static LightParser INSTANCE = new LightParser();
    static final String dollarReplace = "\u00a4\u00a4dollar\u00a4\u00a4";
    private static final Pattern ENQUOTED_PATTERN = Pattern.compile("(\\\"[^\\\"]*\\\")");
    private static final Matcher ENQUOTED_MACTHER = ENQUOTED_PATTERN.matcher("");

    public String getTextTaged() {
        return this.textTaged;
    }

    public Set<String> getUnMatched() {
        return this.unMatched;
    }

    public LightParser(String textToParse) {
        this.fieldsRegexp = "[A-Za-z_][0-9A-Za-z_]*\\.(([A-Za-z_][0-9A-Za-z_/@]*)|(\"[^\"]*\")|(\\[[^\\]]*\\]))";
        String grp2 = "('[^']*')";
        String grp3 = "(\\$\\{[^{^}]*\\}\\$)";
        String grp4 = "(\\%\\{[^{^}]*\\}\\%)";
        String grp5 = "(\\%([^\\{]+)\\{[^{^}]*\\}[^\\%]*\\%)";
        this.excludeRegexp = "(" + grp2 + "|" + grp3 + "|" + grp4 + "|" + grp5 + ")";
        this.textToParse = textToParse;
    }

    public String remove() {
        if (this.textToParse != null && this.blocs != null) {
            StringBuilder ret = new StringBuilder();
            int i = 0;
            for (Bloc bloc : this.blocs) {
                if (bloc.type == 2) {
                    ret.append(bloc.txt);
                } else {
                    ret.append(PRE + i + POST);
                }
                ++i;
            }
            return ret.toString();
        }
        return this.textToParse;
    }

    public String restore(String str, boolean doubleChar) {
        if (this.textToParse != null && str != null && this.blocs != null) {
            String ret = str;
            int i = 0;
            for (Bloc bloc : this.blocs) {
                if (bloc.type != 2) {
                    ret = doubleChar && (bloc.type == 0 || bloc.type == 5) ? ret.replaceAll(PRE + i + POST, bloc.txt.replaceAll("\\$", "\\\\\\$").replaceAll("'", "''")) : ret.replaceAll(PRE + i + POST, bloc.txt.replaceAll("\\$", "\\\\\\$"));
                }
                ++i;
            }
            return ret;
        }
        return str;
    }

    public void parse() {
        Pattern pDeb2 = Pattern.compile(this.excludeRegexp);
        Matcher mDeb2 = pDeb2.matcher(this.textToParse);
        int deb = 0;
        this.blocs = new ArrayList<Bloc>();
        while (mDeb2.find()) {
            int iDeb = mDeb2.start();
            LightParser lightParser = INSTANCE;
            lightParser.getClass();
            this.blocs.add(lightParser.new Bloc(this.textToParse.substring(deb, iDeb)));
            int iFin = mDeb2.end();
            if (mDeb2.group(2) != null) {
                LightParser lightParser2 = INSTANCE;
                lightParser2.getClass();
                this.blocs.add(lightParser2.new Bloc(this.textToParse.substring(iDeb, iFin), 0));
            } else if (mDeb2.group(3) != null) {
                LightParser lightParser3 = INSTANCE;
                lightParser3.getClass();
                this.blocs.add(lightParser3.new Bloc(this.textToParse.substring(iDeb, iFin), 1));
            } else if (mDeb2.group(4) != null) {
                LightParser lightParser4 = INSTANCE;
                lightParser4.getClass();
                this.blocs.add(lightParser4.new Bloc(this.textToParse.substring(iDeb, iFin), 1));
            } else if (mDeb2.group(5) != null) {
                String type = mDeb2.group(6);
                if (type != null && (type.equals("x") || type.equals("xsl"))) {
                    LightParser lightParser5 = INSTANCE;
                    lightParser5.getClass();
                    this.blocs.add(lightParser5.new Bloc(this.textToParse.substring(iDeb, iFin), 4));
                } else {
                    LightParser lightParser6 = INSTANCE;
                    lightParser6.getClass();
                    this.blocs.add(lightParser6.new Bloc(this.textToParse.substring(iDeb, iFin), 5));
                }
            }
            deb = iFin;
        }
        if (this.textToParse.length() > deb) {
            LightParser lightParser = INSTANCE;
            lightParser.getClass();
            this.blocs.add(lightParser.new Bloc(this.textToParse.substring(deb)));
        }
        HashSet<String> localFields = new HashSet<String>();
        for (Bloc bloc : this.blocs) {
            localFields.addAll(bloc.detectColonne(this.fieldsRegexp));
        }
        this.fields = new ArrayList<String>();
        this.fields.addAll(localFields);
        Collections.sort(this.fields, (arg0, arg1) -> Integer.compare(arg1.length(), arg0.length()));
    }

    public String tagAllFields() {
        this.unMatched = new HashSet<String>();
        this.textTaged = this.blocs.stream().map(b -> b.tagAll()).collect(Collectors.joining(""));
        return this.textTaged;
    }

    public LightParser() {
    }

    public List<Object> iterate() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Bloc bloc : this.blocs) {
            if (!bloc.fields.isEmpty()) {
                String str = bloc.tagAll2();
                Pattern pDeb = Pattern.compile("#\\{[^{^}]*\\}#");
                Matcher mDeb = pDeb.matcher(str);
                int iFin = 0;
                while (mDeb.find()) {
                    int iDeb = mDeb.start();
                    if (iFin != iDeb) {
                        list.add(str.substring(iFin, iDeb));
                    }
                    iFin = mDeb.end();
                    Field field = new Field();
                    field.setValue(str.substring(iDeb + 2, iFin - 2));
                    list.add(field);
                }
                if (iFin >= str.length()) continue;
                list.add(str.substring(iFin, str.length()));
                continue;
            }
            list.add(bloc.txt);
        }
        return list;
    }

    class Bloc {
        String txt;
        int type;
        private List<String> fields;
        private String txtTagged;

        public Bloc(String string) {
            this.txt = string;
            this.type = 2;
        }

        public Bloc(String string, int type) {
            this.txt = string;
            this.type = type;
        }

        public String print() {
            if (this.type == 0 || this.type == 5 || this.type == 4) {
                return this.txt;
            }
            return this.txt;
        }

        public String tagAll() {
            String t = this.tagAll2();
            return t;
        }

        private String tagAll2() {
            if (this.type == 0 || this.type == 5 || this.type == 4 || this.type == 1) {
                return this.txt;
            }
            this.txtTagged = this.txt;
            int i = 0;
            for (String str : this.fields) {
                this.txtTagged = this.txtTagged.replace(str, "\u00a7\u00a3\u20acUNIQUE_ID_" + i + LightParser.POST);
                ++i;
            }
            i = 0;
            this.txtTagged = this.txtTagged.replace("$", LightParser.dollarReplace);
            Iterator<String> iterator = this.fields.iterator();
            while (iterator.hasNext()) {
                String s;
                String str;
                String str2 = str = iterator.next();
                ENQUOTED_MACTHER.reset(str);
                StringBuilder b = new StringBuilder();
                int cur = 0;
                while (ENQUOTED_MACTHER.find()) {
                    s = str.substring(cur, ENQUOTED_MACTHER.start());
                    if (s.contains(".[")) {
                        s = s.replace(".[", ".\"").replace("]", "\"");
                    }
                    b.append(s);
                    cur = ENQUOTED_MACTHER.end();
                    b.append(str.substring(ENQUOTED_MACTHER.start(), cur));
                }
                s = str.substring(cur);
                if (s.contains(".[")) {
                    s = s.replace(".[", ".\"").replace("]", "\"");
                }
                b.append(s);
                this.txtTagged = this.txtTagged.replace("\u00a7\u00a3\u20acUNIQUE_ID_" + i + LightParser.POST, "#{" + str2 + "}#");
                ++i;
            }
            return this.txtTagged;
        }

        public List<String> detectColonne(String regexp) {
            if (this.type == 0 || this.type == 5 || this.type == 4) {
                this.fields = Collections.EMPTY_LIST;
                return this.fields;
            }
            if (this.type == 1) {
                this.fields = new ArrayList<String>();
                this.fields.add(this.txt);
                return this.fields;
            }
            Pattern pDeb2 = Pattern.compile(regexp);
            Matcher mDeb2 = pDeb2.matcher(this.txt);
            boolean deb = false;
            ArrayList blocs = new ArrayList();
            ArrayList<String> result = null;
            while (mDeb2.find()) {
                if (result == null) {
                    result = new ArrayList<String>();
                }
                if (result.contains(mDeb2.group())) continue;
                result.add(mDeb2.group());
            }
            this.fields = result == null ? Collections.EMPTY_LIST : result;
            Collections.sort(this.fields, new Comparator<String>(){

                @Override
                public int compare(String arg0, String arg1) {
                    return Integer.valueOf(arg1.length()).compareTo(arg0.length());
                }
            });
            return this.fields;
        }
    }

    public class Field {
        String tableName;
        String fieldName;

        public String getFieldName() {
            return this.fieldName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String toString() {
            return this.tableName + "." + this.fieldName;
        }

        public void setValue(String substring) {
            int i = substring.indexOf(".");
            if (i > 0) {
                this.tableName = substring.substring(0, i);
                this.fieldName = substring.substring(i + 1);
            } else {
                this.tableName = null;
                this.fieldName = substring;
            }
        }
    }
}

