/*
 * Decompiled with CFR 0.152.
 */
package com.indy.libraries.build.parser.sql;

import com.indy.libraries.build.parser.sql.StandardVisitor;
import java.util.ArrayList;
import java.util.List;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class OuterJoinVisitorModificator
extends StandardVisitor {
    public static final int RIGHT_OUTER_SIDE = 1;
    public static final int OPERATOR_INNER_SIDE = 2;
    public static final int JOIN_MODE = 1;
    public static final int FILTER_MODE = 2;
    public static final int JOIN_MODE_BAK = 3;
    protected String outerExpression;
    protected int side;
    protected List<String> alias;

    public OuterJoinVisitorModificator(String outerExpression, List<String> alias, int side) {
        this.outerExpression = outerExpression;
        this.alias = alias;
        this.side = side;
    }

    private void add(Expression left, Expression right) {
        Column leftCol = null;
        Column rightCol = null;
        if (this.alias != null) {
            block4: for (String tmp : this.alias) {
                List<Column> tmp3;
                List<Column> tmp2;
                ArrayList<Column> innerCol = new ArrayList<Column>();
                ArrayList<Column> outerCol = new ArrayList<Column>();
                String innerSide = "";
                String innerAlias = null;
                String outerAlias = null;
                if (tmp.contains(",")) {
                    innerAlias = tmp.substring(0, tmp.indexOf(","));
                    outerAlias = tmp.substring(tmp.indexOf(",") + 1);
                } else {
                    innerAlias = tmp;
                    outerAlias = tmp;
                }
                if (innerAlias == null || outerAlias == null) continue;
                if (left instanceof Column) {
                    leftCol = (Column)left;
                    if (leftCol.getTable().getName().equals(innerAlias)) {
                        innerCol.add(leftCol);
                        innerSide = "left";
                    } else if (leftCol.getTable().getName().equals(outerAlias)) {
                        outerCol.add(leftCol);
                    }
                } else {
                    tmp2 = OuterJoinVisitorModificator.findColumn(left, innerAlias);
                    tmp3 = OuterJoinVisitorModificator.findColumn(left, outerAlias);
                    if (!tmp2.isEmpty()) {
                        innerCol.addAll(tmp2);
                        innerSide = "left";
                    } else if (!tmp3.isEmpty()) {
                        outerCol.addAll(tmp3);
                    }
                }
                if (right instanceof Column) {
                    rightCol = (Column)right;
                    if (rightCol.getTable().getName().equals(innerAlias)) {
                        innerCol.add(rightCol);
                        innerSide = "right";
                    } else if (rightCol.getTable().getName().equals(outerAlias)) {
                        outerCol.add(rightCol);
                    }
                } else {
                    tmp2 = OuterJoinVisitorModificator.findColumn(right, innerAlias);
                    tmp3 = OuterJoinVisitorModificator.findColumn(right, outerAlias);
                    if (!tmp2.isEmpty()) {
                        innerCol.addAll(tmp2);
                        innerSide = "right";
                    } else if (!tmp3.isEmpty()) {
                        outerCol.addAll(tmp3);
                    }
                }
                if (!innerCol.isEmpty() && !outerCol.isEmpty()) {
                    switch (this.side) {
                        case 1: {
                            for (Column c : outerCol) {
                                OuterJoinVisitorModificator.putOuterWordOnTheRight(c, this.outerExpression);
                            }
                            continue block4;
                        }
                        case 2: {
                            if (innerSide.equals("left")) {
                                if (left instanceof Function) {
                                    OuterJoinVisitorModificator.putOuterWordOnTheRight((Function)left, this.outerExpression);
                                    break;
                                }
                                OuterJoinVisitorModificator.putOuterWordOnTheRight((Column)innerCol.get(0), this.outerExpression);
                                break;
                            }
                            if (right instanceof Function) {
                                OuterJoinVisitorModificator.putOuterWordOnTheLeft((Function)right, this.outerExpression);
                                break;
                            }
                            OuterJoinVisitorModificator.putOuterWordOnTheLeft((Column)innerCol.get(0), this.outerExpression);
                        }
                    }
                    continue;
                }
                if (this.side != 1 || outerCol.isEmpty() || !innerCol.isEmpty()) continue;
                for (Column c : outerCol) {
                    OuterJoinVisitorModificator.putOuterWordOnTheRight(c, this.outerExpression);
                }
            }
        }
    }

    @Override
    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        Expression left = binaryExpression.getLeftExpression();
        Expression right = binaryExpression.getRightExpression();
        if (binaryExpression instanceof EqualsTo || binaryExpression instanceof NotEqualsTo || binaryExpression instanceof GreaterThan || binaryExpression instanceof GreaterThanEquals || binaryExpression instanceof MinorThan || binaryExpression instanceof MinorThanEquals) {
            this.add(left, right);
        }
        left.accept((ExpressionVisitor)this);
        right.accept((ExpressionVisitor)this);
    }

    public static List<Column> findColumnIntoFunction(Function f, String alias) {
        ArrayList<Column> retour = new ArrayList<Column>();
        for (Expression exp : f.getParameters().getExpressions()) {
            Column column;
            if (exp instanceof Column && (column = (Column)exp).getTable() != null && column.getTable().getName().equals(alias)) {
                retour.add(column);
                continue;
            }
            if (!(exp instanceof Function)) continue;
            Function function = (Function)exp;
            retour.addAll(OuterJoinVisitorModificator.findColumnIntoFunction(function, alias));
        }
        return retour;
    }

    public static List<Column> findColumn(Expression expr, final String alias) {
        final ArrayList<Column> retour = new ArrayList<Column>();
        if (expr != null) {
            if (expr instanceof Column) {
                if (expr instanceof Column && ((Column)expr).getTable() != null && ((Column)expr).getTable().getName().equals(alias)) {
                    retour.add((Column)expr);
                }
            } else {
                expr.accept((ExpressionVisitor)new StandardVisitor(){

                    @Override
                    public void visit(Column tableColumn) {
                        if (tableColumn instanceof Column && tableColumn.getTable() != null && tableColumn.getTable().getName() != null && tableColumn.getTable().getName().equals(alias)) {
                            retour.add(tableColumn);
                        }
                    }
                });
            }
        }
        return retour;
    }

    public static void putOuterWordOnTheLeft(Column c, String outer) {
        if (c.getTable().getName().indexOf(outer) == -1) {
            c.getTable().setName(outer + c.getTable().getName());
        }
    }

    public static void putOuterWordOnTheRight(Column c, String outer) {
        if (c.getColumnName().indexOf(outer) == -1) {
            c.setColumnName(c.getColumnName() + outer);
        }
    }

    public static void putOuterWordOnTheRight(Function f, String outer) {
        if (!f.getParameters().getExpressions().isEmpty() && f.getParameters().getExpressions().get(f.getParameters().getExpressions().size() - 1) instanceof StringValue) {
            return;
        }
        f.getParameters().getExpressions().add(new StringValue(" " + outer + " "));
    }

    public static void putOuterWordOnTheLeft(Function f, String outer) {
        if (f.getName().indexOf(outer) == -1) {
            f.setName(outer + f.getName());
        }
    }

    @Override
    public void visit(PlainSelect plainSelect) {
        if (plainSelect.getWhere() != null) {
            plainSelect.getWhere().accept((ExpressionVisitor)this);
        }
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        Expression left = isNullExpression.getLeftExpression();
        this.add(left, null);
        left.accept((ExpressionVisitor)this);
    }
}

