/*
 * Decompiled with CFR 0.152.
 */
package com.indy.ui.runtime.editor.page;

import com.indy.ui.runtime.editor.page.PurgePage;
import com.stambia.ui.tools.Utils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PurgeDetailsPage
implements IDetailsPage {
    private IManagedForm mform;
    private FormToolkit toolkit;
    private PurgePage.Purge input;
    private Label triggerName;
    private Label jobName;
    private Label cronExpr;
    private Label purgeSize;
    private Label purgeUnit;
    private Label startTime;
    private Label endTime;
    private Label nextExec;
    private Label status;
    private Label sessionNames;
    private Label triggerState;
    private Label lastExec;
    private Label triggerType;
    private Label startTimeOfDay;
    private Label repeatInterval;
    private Label intervalUnit;
    private Label dayOfWeek;
    private Label endTimeOfDay;
    private StackLayout stackLayout;
    private Composite cronComposite;
    private Composite dailyComposite;

    public void initialize(IManagedForm form) {
        this.mform = form;
        this.toolkit = this.mform.getToolkit();
    }

    public void dispose() {
    }

    public boolean isDirty() {
        return false;
    }

    public void commit(boolean onSave) {
    }

    public boolean setFormInput(Object input) {
        return false;
    }

    public void setFocus() {
    }

    public boolean isStale() {
        return false;
    }

    public void refresh() {
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.input = ssel.size() == 1 ? (PurgePage.Purge)ssel.getFirstElement() : null;
        this.update();
    }

    private void update() {
        if (this.input != null) {
            this.refreshCommonContents();
            if (this.input.getTriggerType().equals("CRON_TRIGGER")) {
                this.refreshCronTriggerContents();
                this.stackLayout.topControl = this.cronComposite;
            } else if (this.input.getTriggerType().equals("DAILY_INTERVAL_TRIGGER")) {
                this.refreshDailyTrigerContents();
                this.stackLayout.topControl = this.dailyComposite;
            }
        }
    }

    private void refreshCommonContents() {
        this.triggerName.setText(this.input.getTriggerName());
        this.jobName.setText(this.input.getJobName());
        this.purgeSize.setText(this.input.getPurgeSize());
        this.purgeUnit.setText(this.input.getPurgeUnit());
        this.status.setText(this.input.getStatus());
        this.sessionNames.setText(this.input.getSessionNames());
        this.startTime.setText(String.valueOf(this.input.getStartTime()));
        this.endTime.setText(this.input.getEndTime() != null ? String.valueOf(this.input.getEndTime()) : "Unknown");
        this.lastExec.setText(this.input.getLastExecution() != null ? String.valueOf(this.input.getLastExecution()) : "Unknown");
        this.nextExec.setText(String.valueOf(this.input.getNextExecution()));
        this.triggerState.setText(this.input.getTriggerState());
        this.triggerType.setText(this.input.getTriggerType());
    }

    private void refreshCronTriggerContents() {
        this.cronExpr.setText(this.input.getCronExpression());
    }

    private void refreshDailyTrigerContents() {
    }

    private void createCommonContents(Composite parent) {
        Composite comp = this.toolkit.createComposite(parent);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.toolkit.createLabel(comp, "Trigger name:");
        this.triggerName = this.toolkit.createLabel(comp, "");
        this.triggerName.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolkit.createLabel(comp, "Job name:");
        this.jobName = this.toolkit.createLabel(comp, "");
        this.jobName.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolkit.createLabel(comp, "Purge size:");
        this.purgeSize = this.toolkit.createLabel(comp, "");
        this.purgeSize.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolkit.createLabel(comp, "Purge unit:");
        this.purgeUnit = this.toolkit.createLabel(comp, "");
        this.purgeUnit.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolkit.createLabel(comp, "Status:");
        this.status = this.toolkit.createLabel(comp, "");
        this.status.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolkit.createLabel(comp, "Sessions:");
        this.sessionNames = this.toolkit.createLabel(comp, "");
        this.sessionNames.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolkit.createLabel(comp, "Start:");
        this.startTime = this.toolkit.createLabel(comp, "");
        this.startTime.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolkit.createLabel(comp, "End:");
        this.endTime = this.toolkit.createLabel(comp, "");
        this.endTime.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolkit.createLabel(comp, "Next execution:");
        this.nextExec = this.toolkit.createLabel(comp, "");
        this.nextExec.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolkit.createLabel(comp, "Last execution:");
        this.lastExec = this.toolkit.createLabel(comp, "");
        this.lastExec.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolkit.createLabel(comp, "Trigger state");
        this.triggerState = this.toolkit.createLabel(comp, "");
        this.triggerState.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolkit.createLabel(comp, "Trigger type");
        this.triggerType = this.toolkit.createLabel(comp, "");
        this.triggerType.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite triggerComp = this.toolkit.createComposite(comp);
        this.stackLayout = new StackLayout();
        triggerComp.setLayout((Layout)this.stackLayout);
        this.cronComposite = this.createCronTriggerContents(triggerComp);
        this.dailyComposite = this.createDailyIntervalTriggerContents(triggerComp);
    }

    private Composite createCronTriggerContents(Composite parent) {
        Composite comp = this.toolkit.createComposite(parent);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        this.toolkit.createLabel(comp, "Cron expression:");
        this.cronExpr = this.toolkit.createLabel(comp, "");
        this.cronExpr.setLayoutData((Object)new GridData(4, 4, true, false));
        return comp;
    }

    private Composite createDailyIntervalTriggerContents(Composite parent) {
        Composite comp = this.toolkit.createComposite(parent);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        comp.setLayout((Layout)gl);
        this.toolkit.createLabel(comp, "Start time of day:");
        this.startTimeOfDay = this.toolkit.createLabel(comp, "");
        this.startTimeOfDay.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolkit.createLabel(comp, "End time of day:");
        this.endTimeOfDay = this.toolkit.createLabel(comp, "");
        this.endTimeOfDay.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolkit.createLabel(comp, "Repeat interval:");
        this.repeatInterval = this.toolkit.createLabel(comp, "");
        this.repeatInterval.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolkit.createLabel(comp, "Interval unit:");
        this.intervalUnit = this.toolkit.createLabel(comp, "");
        this.intervalUnit.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toolkit.createLabel(comp, "On day of week:");
        this.dayOfWeek = this.toolkit.createLabel(comp, "");
        this.dayOfWeek.setLayoutData((Object)new GridData(4, 4, true, false));
        return comp;
    }

    public void createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        Section detailsSection = Utils.createSection((FormToolkit)this.toolkit, (Composite)parent, (String)"Purges details");
        detailsSection.setLayout((Layout)new GridLayout());
        detailsSection.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite client = this.toolkit.createComposite((Composite)detailsSection);
        client.setLayout((Layout)new GridLayout(2, false));
        client.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createCommonContents(client);
        detailsSection.setClient((Control)client);
    }
}

