/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.http;

import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.NTCredentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.auth.NTLMSchemeFactory;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.impl.routing.DefaultRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.client5.http.utils.URIUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.net.URIBuilder;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;

public class ApacheHttpClient
implements AutoCloseable {
    private CloseableHttpClient httpclient;

    private final <T> HttpClientResponseHandler<T> responseWrapper(HttpClientResponseHandler<T> handler) {
        return w -> {
            if (w.getCode() != 200) {
                throw new HttpException("Unexpected response status: " + w.getCode() + " " + w.getReasonPhrase());
            }
            return handler.handleResponse(w);
        };
    }

    private ApacheHttpClient(CloseableHttpClient httpclient) {
        this.httpclient = httpclient;
    }

    private static HttpClientConnectionManager connectionManager(SslConfig sslConfig) {
        PoolingHttpClientConnectionManagerBuilder managerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        if (sslConfig == null) {
            managerBuilder.useSystemProperties();
        } else {
            SSLConnectionSocketFactoryBuilder sslBuilder = SSLConnectionSocketFactoryBuilder.create();
            if (sslConfig.disableHostnameVerifier) {
                sslBuilder.setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            managerBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslBuilder.setSslContext(sslConfig.sslContext).build());
        }
        return managerBuilder.build();
    }

    private static ApacheHttpClient build(IProxyService proxyService, SslConfig sslConfig) {
        return new ApacheHttpClient(HttpClients.custom().setRoutePlanner((HttpRoutePlanner)new EclipseProxyRoutePlanner(proxyService)).setDefaultCredentialsProvider((CredentialsProvider)new CredentialsProviderWithEclipseProxy(proxyService)).setConnectionManager(ApacheHttpClient.connectionManager(sslConfig)).build());
    }

    public static ApacheHttpClient build(ProxyConfig proxyConfig, SslConfig sslConfig) {
        BasicCredentialsProvider credentialProvider = new BasicCredentialsProvider();
        if (proxyConfig.user != null && !proxyConfig.user.isEmpty() && proxyConfig.password != null) {
            credentialProvider.setCredentials(new AuthScope(proxyConfig.host, proxyConfig.port), (Credentials)new UsernamePasswordCredentials(proxyConfig.user, proxyConfig.password.toCharArray()));
        }
        return new ApacheHttpClient(HttpClients.custom().setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(new HttpHost(proxyConfig.host, proxyConfig.port))).setDefaultCredentialsProvider((CredentialsProvider)credentialProvider).setConnectionManager(ApacheHttpClient.connectionManager(sslConfig)).build());
    }

    public static ApacheHttpClient build(SslConfig sslConfig) {
        return ApacheHttpClient.build(E4InjectorHelper.getService(IProxyService.class), sslConfig);
    }

    public static ApacheHttpClient build() {
        return ApacheHttpClient.build(null);
    }

    @Override
    public void close() throws IOException {
        this.httpclient.close();
    }

    public <T> T getUnchecked(String address, Map<String, String> queryParams, Map<String, Object> headers, Credentials credentials, boolean preemptive, HttpClientResponseHandler<T> responseHandler) throws IOException {
        try {
            HttpGet get = new HttpGet(address);
            if (!queryParams.isEmpty()) {
                URI uriWithParam = new URIBuilder(get.getUri()).addParameters(queryParams.entrySet().stream().map(p -> new BasicNameValuePair((String)p.getKey(), (String)p.getValue())).collect(Collectors.toList())).build();
                get.setUri(uriWithParam);
            }
            return this.doExecute((HttpUriRequestBase)get, headers, credentials, preemptive, responseHandler);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private <T> T doExecute(HttpUriRequestBase request, Map<String, Object> headers, Credentials credentials, boolean preemptive, HttpClientResponseHandler<T> responseHandler) throws IOException {
        try {
            URI uri = request.getUri();
            HttpHost httpHost = URIUtils.extractHost((URI)uri);
            HttpClientContext localContext = HttpClientContext.create();
            if (preemptive && credentials != null) {
                BasicScheme basicAuth = new BasicScheme();
                basicAuth.initPreemptive(credentials);
                localContext.resetAuthExchange(httpHost, (AuthScheme)basicAuth);
            }
            if (credentials instanceof NTCredentials) {
                BasicCredentialsProvider provider = new BasicCredentialsProvider();
                provider.setCredentials(new AuthScope(null, null, -1, null, null), credentials);
                localContext.setCredentialsProvider((CredentialsProvider)provider);
                localContext.setAuthSchemeRegistry((Lookup)RegistryBuilder.create().register("NTLM", (Object)new NTLMSchemeFactory()).build());
            }
            headers.forEach((arg_0, arg_1) -> ((HttpUriRequestBase)request).setHeader(arg_0, arg_1));
            return (T)this.httpclient.execute((ClassicHttpRequest)request, (HttpContext)localContext, responseHandler);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public <T> T postUnchecked(String address, Map<String, String> params, Map<String, Object> headers, Credentials credentials, boolean preemptive, HttpClientResponseHandler<T> responseHandler) throws IOException {
        HttpPost post = new HttpPost(address);
        if (!params.isEmpty()) {
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params.entrySet().stream().map(p -> new BasicNameValuePair((String)p.getKey(), (String)p.getValue())).collect(Collectors.toList())));
        }
        headers.forEach((arg_0, arg_1) -> ((HttpPost)post).setHeader(arg_0, arg_1));
        return this.doExecute((HttpUriRequestBase)post, headers, credentials, preemptive, responseHandler);
    }

    public <T> T postUnchecked(String address, String body, Map<String, Object> headers, Credentials credentials, boolean preemptive, HttpClientResponseHandler<T> responseHandler) throws IOException {
        HttpPost post = new HttpPost(address);
        post.setEntity((HttpEntity)new StringEntity(body));
        headers.forEach((arg_0, arg_1) -> ((HttpPost)post).setHeader(arg_0, arg_1));
        return this.doExecute((HttpUriRequestBase)post, headers, credentials, preemptive, responseHandler);
    }

    public <T> T put(String address, Map<String, File> files, Map<String, Object> headers, Credentials credentials, boolean preemptive, HttpClientResponseHandler<T> responseHandler) throws IOException {
        return this.putUnchecked(address, files, headers, credentials, preemptive, this.responseWrapper(responseHandler));
    }

    public <T> T putUnchecked(String address, Map<String, File> files, Map<String, Object> headers, Credentials credentials, boolean preemptive, HttpClientResponseHandler<T> responseHandler) throws IOException {
        HttpPut put = new HttpPut(address);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        files.forEach((arg_0, arg_1) -> ((MultipartEntityBuilder)builder).addBinaryBody(arg_0, arg_1));
        put.setEntity(builder.build());
        headers.forEach((arg_0, arg_1) -> ((HttpPut)put).setHeader(arg_0, arg_1));
        return this.doExecute((HttpUriRequestBase)put, headers, credentials, preemptive, responseHandler);
    }

    public <T> T post(String address, Map<String, String> params, Map<String, Object> headers, Credentials credentials, boolean preemptive, HttpClientResponseHandler<T> responseHandler) throws IOException {
        return this.postUnchecked(address, params, headers, credentials, preemptive, this.responseWrapper(responseHandler));
    }

    public <T> T post(String address, String body, Map<String, Object> headers, Credentials credentials, boolean preemptive, HttpClientResponseHandler<T> responseHandler) throws IOException {
        return this.postUnchecked(address, body, headers, credentials, preemptive, this.responseWrapper(responseHandler));
    }

    public <T> T get(String address, Map<String, String> queryParams, Map<String, Object> headers, Credentials credentials, boolean preemptive, HttpClientResponseHandler<T> responseHandler) throws IOException {
        return this.getUnchecked(address, queryParams, headers, credentials, preemptive, this.responseWrapper(responseHandler));
    }

    public static Credentials createBasicAuthCredentials(String user, char[] password) {
        return new UsernamePasswordCredentials(user, password);
    }

    public static Credentials createNTAuthCredentials(String user, char[] password, String domain) {
        return new NTCredentials(user, password, null, domain);
    }

    private static class CredentialsProviderWithEclipseProxy
    implements CredentialsProvider {
        private final IProxyService proxyService;

        public CredentialsProviderWithEclipseProxy(IProxyService proxyService) {
            this.proxyService = proxyService;
        }

        private URI toURI(AuthScope authScope) throws URISyntaxException {
            return new URI(new HttpHost(authScope.getProtocol().toUpperCase(), authScope.getHost(), authScope.getPort()).toURI());
        }

        public Credentials getCredentials(AuthScope authScope, HttpContext arg1) {
            if (this.proxyService != null) {
                try {
                    IProxyData[] iProxyDataArray = this.proxyService.select(this.toURI(authScope));
                    int n = iProxyDataArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProxyData pData = iProxyDataArray[n2];
                        if (pData.isRequiresAuthentication()) {
                            return new UsernamePasswordCredentials(pData.getUserId(), pData.getPassword().toCharArray());
                        }
                        ++n2;
                    }
                }
                catch (URISyntaxException ex) {
                    throw new IllegalStateException("Cannot convert host to URI: " + String.valueOf(authScope), ex);
                }
            }
            return null;
        }
    }

    private static class EclipseProxyRoutePlanner
    extends DefaultRoutePlanner {
        private final IProxyService proxyService;

        public EclipseProxyRoutePlanner(IProxyService proxyService) {
            super(null);
            this.proxyService = proxyService;
        }

        protected HttpHost determineProxy(HttpHost target, HttpContext context) throws HttpException {
            if (this.proxyService != null) {
                URI targetURI;
                try {
                    targetURI = new URI(target.toURI());
                }
                catch (URISyntaxException ex) {
                    throw new HttpException("Cannot convert host to URI: " + String.valueOf(target), (Throwable)ex);
                }
                IProxyData[] datas = this.proxyService.select(targetURI);
                if (datas.length > 0) {
                    return new HttpHost(datas[0].getType(), datas[0].getHost(), datas[0].getPort());
                }
                if (target.getSchemeName().equalsIgnoreCase("https")) {
                    HttpHost httpTarget = new HttpHost("http", target.getHostName(), target.getPort());
                    try {
                        targetURI = new URI(httpTarget.toURI());
                    }
                    catch (URISyntaxException ex) {
                        throw new HttpException("Cannot convert host to URI: " + String.valueOf(target), (Throwable)ex);
                    }
                    datas = this.proxyService.select(targetURI);
                    if (datas.length > 0) {
                        return new HttpHost(datas[0].getHost(), datas[0].getPort());
                    }
                }
            }
            return null;
        }
    }

    public record ProxyConfig(String host, int port, String user, String password) {
    }

    public record SslConfig(SSLContext sslContext, boolean disableHostnameVerifier) {
        public SslConfig(SSLContext sslContext) {
            this(sslContext, false);
        }
    }
}

