/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class UpdateListCommand
extends RecordingCommand {
    private ArrayList<EObject> objectsToDelete = new ArrayList();
    private EList<EObject> oldObjects;
    private List<EObject> newObjects;
    private EStructuralFeature nameFeature;

    public ArrayList<EObject> getParamToDelete() {
        return this.objectsToDelete;
    }

    public void dispose() {
        this.objectsToDelete = null;
        this.oldObjects = null;
        this.newObjects = null;
        this.nameFeature = null;
        super.dispose();
    }

    public UpdateListCommand(TransactionalEditingDomain domain, EObject parent, EList<EObject> oldObjects, List<EObject> newObjects, EStructuralFeature nameFeature, List<EStructuralFeature> featuresToUpdate) {
        super(domain);
        this.oldObjects = oldObjects;
        this.objectsToDelete.addAll((Collection<EObject>)oldObjects);
        this.newObjects = newObjects;
        this.nameFeature = nameFeature;
    }

    protected void doExecute() {
        this.executeWithoutTransaction();
    }

    public void executeWithoutTransaction() {
        ArrayList<EObject> copy = new ArrayList<EObject>();
        copy.addAll((Collection<EObject>)this.oldObjects);
        for (EObject newObject : this.newObjects) {
            String newName = (String)newObject.eGet(this.nameFeature);
            boolean exist = false;
            for (EObject oldObject : copy) {
                String oldName = (String)oldObject.eGet(this.nameFeature);
                if (newName == null || oldName == null || !oldName.equals(newName)) continue;
                exist = true;
                this.objectsToDelete.remove(oldObject);
            }
            if (exist) continue;
            this.oldObjects.add((Object)newObject);
        }
    }
}

