/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.services.cache;

import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;

public class CacheEventURI {
    private URI modelURI;
    private String sourceID;
    private Type type;
    private boolean isUnduplicated;

    public CacheEventURI(String sourceID, URI modelURI, Type type, boolean isUnduplicated) {
        Assert.isNotNull((Object)sourceID);
        this.modelURI = modelURI;
        this.type = type;
        this.sourceID = sourceID;
        this.isUnduplicated = isUnduplicated;
    }

    public boolean isUnduplicated() {
        return this.isUnduplicated;
    }

    public String getSourceID() {
        return this.sourceID;
    }

    public URI getModelURI() {
        return this.modelURI;
    }

    public Type getType() {
        return this.type;
    }

    public boolean concernURI(URI uri) {
        if (this.modelURI != null && this.modelURI.trimFragment().equals(uri.trimFragment())) {
            return true;
        }
        String fragment = uri.fragment();
        String fileId = CacheHelper.extractEltInfo(fragment, "fileId");
        return this.sourceID.equals(fileId);
    }

    public String toString() {
        return "[Type : " + String.valueOf((Object)this.getType()) + "\nmodelURI:" + String.valueOf(this.getModelURI()) + "\nsourceID:" + this.getSourceID() + "]";
    }

    public static enum Type {
        ADDED,
        REMOVED,
        SYNCHRONIZED,
        INEXISTED,
        EXISTED,
        DUPLICATED,
        MOVED,
        OVERRIDEN;

    }
}

