/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.services.registry;

import com.semarchy.xdi.designer.core.models.EMFResourceOptions;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IRegistryContributionHelper;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.MemoryMonitor;
import com.semarchy.xdi.designer.core.utils.MutexSchedulingRule;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class AbstractRegistry<T>
implements IRegistryService.IRegistry<T> {
    private static final ISchedulingRule rule = new MutexSchedulingRule();
    private Collection<IRegistryService.IRegistryItemEventListener> itemEventListeners = new HashSet<IRegistryService.IRegistryItemEventListener>();
    private Collection<IRegistryService.IRegistryBatchEventListener> batchEventListeners = new HashSet<IRegistryService.IRegistryBatchEventListener>();
    private Map<String, List<IRegistryService.RegistryItem>> contentByResourceID = new HashMap<String, List<IRegistryService.RegistryItem>>();
    private Map<IRegistryService.IRegistryKey, IRegistryService.RegistryItem> contentMap = new HashMap<IRegistryService.IRegistryKey, IRegistryService.RegistryItem>();
    private volatile boolean eventOccured = false;
    private boolean isCacheInit = false;
    private RegisterJob registerJob = null;

    public abstract Class getRegistredClass();

    protected AbstractRegistry() {
        this.load();
    }

    protected void load() {
        block18: {
            File file = this.getSaveFile();
            try {
                if (!file.exists()) break block18;
                try {
                    Throwable throwable = null;
                    Object var3_6 = null;
                    try (ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));){
                        Object o = is.readObject();
                        IRegistryService.RegistryItem lastItem = null;
                        if (o instanceof Object[]) {
                            Object[] objectArray = (Object[])o;
                            int n = objectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object i = objectArray[n2];
                                lastItem = (IRegistryService.RegistryItem)i;
                                this.contentMap.put(lastItem.getRegistrationKey(), lastItem);
                                List<IRegistryService.RegistryItem> l = this.contentByResourceID.get(lastItem.getRegistrationKey().getProviderFileID());
                                if (l == null) {
                                    l = new ArrayList<IRegistryService.RegistryItem>();
                                    this.contentByResourceID.put(lastItem.getRegistrationKey().getProviderFileID(), l);
                                }
                                l.add(lastItem);
                                ++n2;
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (InvalidClassException ex) {
                    Class c = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
                    this.registerJob = new RegisterJob(c);
                }
                catch (Exception e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Something wrong occured while deserializing object", e);
                }
            }
            finally {
                file.delete();
            }
        }
    }

    @Override
    public synchronized boolean registerFrom(String resourceFileId, IRegistryService.IRegistrationContribution resource) throws Exception {
        if (!resource.getContributedRegistries().contains(this.getRegistredClass())) {
            return false;
        }
        List<IRegistryService.RegistryItem> currentItems = this.contentByResourceID.get(resourceFileId);
        List<Object> newItems = resource.createRegistryItemsFor(this.getRegistredClass());
        ArrayList toAdd = new ArrayList();
        ArrayList<IRegistryService.RegistryItem> toUpdate = new ArrayList<IRegistryService.RegistryItem>();
        boolean contentChanged = false;
        if (currentItems != null) {
            Iterator<IRegistryService.RegistryItem> curIt = currentItems.iterator();
            while (curIt.hasNext()) {
                IRegistryService.RegistryItem item = curIt.next();
                boolean matched = false;
                boolean curItRemoved = false;
                if (newItems != null) {
                    Iterator<Object> it = newItems.iterator();
                    while (it.hasNext()) {
                        IRegistryService.RegistryItem item2 = (IRegistryService.RegistryItem)it.next();
                        if (!item.getRegistrationKey().match(item2.getRegistrationKey())) continue;
                        matched = true;
                        if (item.equals(item2)) {
                            it.remove();
                            continue;
                        }
                        if (!curItRemoved) {
                            curIt.remove();
                            curItRemoved = true;
                        }
                        this.contentMap.remove(item.getRegistrationKey());
                        toUpdate.add(item2);
                        it.remove();
                        contentChanged = true;
                    }
                }
                if (matched) continue;
                curIt.remove();
                this.contentMap.remove(item.getRegistrationKey());
                this.fireEvent(item, Event.DELETED_ITEM);
                contentChanged = true;
            }
        }
        for (IRegistryService.RegistryItem i : toUpdate) {
            currentItems.add(i);
            this.contentMap.put(i.getRegistrationKey(), i);
            this.fireEvent(i, Event.UPDATED_ITEM);
        }
        for (Object o : newItems) {
            if (currentItems == null) {
                currentItems = new ArrayList<IRegistryService.RegistryItem>();
                this.contentByResourceID.put(resourceFileId, currentItems);
            }
            IRegistryService.RegistryItem i = (IRegistryService.RegistryItem)o;
            currentItems.add(i);
            this.contentMap.put(i.getRegistrationKey(), i);
            this.fireEvent(i, Event.ADDED_ITEM);
            contentChanged = true;
        }
        this.fireBatchEvent();
        return contentChanged;
    }

    protected synchronized void setEventOccured(boolean state) {
        this.eventOccured = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireBatchEvent() {
        if (!this.eventOccured) {
            return;
        }
        Collection<IRegistryService.IRegistryBatchEventListener> collection = this.batchEventListeners;
        synchronized (collection) {
            Iterator<IRegistryService.IRegistryBatchEventListener> iterator = this.batchEventListeners.iterator();
            while (iterator.hasNext()) {
                IRegistryService.IRegistryBatchEventListener l;
                final IRegistryService.IRegistryBatchEventListener listener = l = iterator.next();
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.handleBatchedEvent();
                    }

                    public void handleException(Throwable exception) {
                        exception.printStackTrace();
                    }
                });
            }
            this.setEventOccured(false);
        }
    }

    private void fireEvent(final IRegistryService.RegistryItem item, final Event event) {
        Iterator<IRegistryService.IRegistryItemEventListener> iterator = this.itemEventListeners.iterator();
        while (iterator.hasNext()) {
            IRegistryService.IRegistryItemEventListener l;
            final IRegistryService.IRegistryItemEventListener listener = l = iterator.next();
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    switch (event) {
                        case ADDED_ITEM: {
                            listener.handleItemAdded(item.getRegistrationKey(), item);
                            break;
                        }
                        case DELETED_ITEM: {
                            listener.handleItemRemoved(item.getRegistrationKey(), item);
                            break;
                        }
                        case UPDATED_ITEM: {
                            listener.handleItemUpdated(item.getRegistrationKey(), item);
                        }
                    }
                }

                public void handleException(Throwable exception) {
                    exception.printStackTrace();
                }
            });
        }
        if (!this.eventOccured) {
            this.setEventOccured(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean unregisterFrom(String resourceFileId) {
        List<IRegistryService.RegistryItem> l = this.contentByResourceID.get(resourceFileId);
        if (l != null) {
            this.contentByResourceID.remove(resourceFileId);
            Map<IRegistryService.IRegistryKey, IRegistryService.RegistryItem> map = this.contentMap;
            synchronized (map) {
                for (IRegistryService.RegistryItem o : l) {
                    this.contentMap.remove(o.getRegistrationKey());
                    this.fireEvent(o, Event.DELETED_ITEM);
                }
            }
        }
        this.fireBatchEvent();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Map<String, List<IRegistryService.RegistryItem>> map = this.contentByResourceID;
        synchronized (map) {
            for (String s : new ArrayList<String>(this.contentByResourceID.keySet())) {
                this.unregisterFrom(s);
            }
        }
        this.contentByResourceID.clear();
        this.contentMap.clear();
    }

    @Override
    public void addRegistryItemEventListener(IRegistryService.IRegistryItemEventListener listener) {
        if (listener != null) {
            this.itemEventListeners.add(listener);
        }
    }

    @Override
    public void removeRegistryItemEventListener(IRegistryService.IRegistryItemEventListener listener) {
        if (listener != null) {
            this.itemEventListeners.remove(listener);
        }
    }

    @Override
    public void addRegistryBatchEventListener(IRegistryService.IRegistryBatchEventListener listener) {
        if (listener != null) {
            this.batchEventListeners.add(listener);
        }
    }

    @Override
    public void removeRegistryBatchEventListener(IRegistryService.IRegistryBatchEventListener listener) {
        if (listener != null) {
            this.batchEventListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRegistryService.RegistryItem findRegistryItem(IRegistryService.IRegistryKey key) {
        Map<IRegistryService.IRegistryKey, IRegistryService.RegistryItem> map = this.contentMap;
        synchronized (map) {
            IRegistryService.RegistryItem res = this.contentMap.get(key);
            if (res != null) {
                return res;
            }
            for (IRegistryService.IRegistryKey u : this.contentMap.keySet()) {
                if (!key.match(u)) continue;
                return this.contentMap.get(u);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<IRegistryService.RegistryItem> findRegistryItem(IRegistryService.IRegistryMatcher matcher) {
        ArrayList<IRegistryService.RegistryItem> l = new ArrayList<IRegistryService.RegistryItem>();
        Map<IRegistryService.IRegistryKey, IRegistryService.RegistryItem> map = this.contentMap;
        synchronized (map) {
            for (IRegistryService.RegistryItem u : this.contentMap.values()) {
                if (!matcher.match(u.getRegistrationKey())) continue;
                l.add(u);
            }
        }
        return l;
    }

    protected Map<IRegistryService.IRegistryKey, IRegistryService.RegistryItem> getContentMap() {
        return this.contentMap;
    }

    @Override
    public List<T> getAll() {
        return new ArrayList<IRegistryService.RegistryItem>(this.contentMap.values());
    }

    protected final File getSaveFile() {
        IPath p = Platform.getStateLocation((Bundle)FrameworkUtil.getBundle(IRegistryService.class));
        p = p.append("/registries");
        IPath path = p.append(this.getRegistredClass().getName() + ".reg");
        return path.toFile();
    }

    public void save() throws FileNotFoundException, IOException {
        File f = this.getSaveFile();
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        ObjectOutputStream os = null;
        try {
            os = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            Object[] o = this.contentMap.values().toArray(new Object[this.contentMap.size()]);
            try {
                os.writeObject(o);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            if (os != null) {
                try {
                    os.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                os.close();
            }
        }
    }

    private static enum Event {
        DELETED_ITEM,
        ADDED_ITEM,
        UPDATED_ITEM;

    }

    class RegisterJob
    extends Job
    implements ICacheService.ICacheServiceListener {
        ICacheService cacheService;
        IRegistryContributionHelper registryContributionHelper;
        Class registryClass;
        ResourceSet resourceSet;

        public RegisterJob(Class registryClass) {
            super("Rebuild Registry " + registryClass.getName());
            this.cacheService = E4InjectorHelper.getService(ICacheService.class);
            this.registryContributionHelper = E4InjectorHelper.getService(IRegistryContributionHelper.class);
            this.registryClass = registryClass;
            if (this.cacheService.isInit()) {
                this.schedule(1000L);
            } else {
                this.cacheService.addCacheServiceListener(this);
            }
            this.setRule(rule);
        }

        private ResourceSet getResourceSet() {
            if (this.resourceSet == null || MemoryMonitor.isMemoryLow(30)) {
                if (this.resourceSet != null) {
                    Iterator it = this.resourceSet.getResources().iterator();
                    while (it.hasNext()) {
                        Resource r = (Resource)it.next();
                        if (r == null || !r.isLoaded()) continue;
                        r.unload();
                        it.remove();
                    }
                    this.resourceSet.getResources().clear();
                    System.gc();
                } else {
                    this.resourceSet = new ResourceSetImpl();
                    ((ResourceSetImpl)this.resourceSet).setURIResourceMap(new WeakHashMap());
                    this.resourceSet.setURIConverter((URIConverter)new InternalResourceURIConverter(false));
                    this.resourceSet.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_BATCH_VALIDATION, Boolean.TRUE);
                    this.resourceSet.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_REF_SYNC", Boolean.TRUE);
                    this.resourceSet.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_UPDATE", Boolean.TRUE);
                    this.resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
                    this.resourceSet.getLoadOptions().put("PROCESS_DANGLING_HREF", "RECORD");
                }
            }
            return this.resourceSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            ArrayList<String> sourceIds = null;
            ICacheService iCacheService = this.cacheService;
            synchronized (iCacheService) {
                sourceIds = new ArrayList<String>(this.registryContributionHelper.getSourceIdsContirbutingToRegistry(this.registryClass));
            }
            for (String id : sourceIds) {
                URI uri = this.cacheService.findResourceURIByFileId(id);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (uri == null) continue;
                try {
                    Resource re = this.getResourceSet().getResource(uri, true);
                    if (!(re instanceof IRegistryService.IRegistrationContribution)) continue;
                    AbstractRegistry.this.registerFrom(id, (IRegistryService.IRegistrationContribution)re);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.cacheService.removeCacheServiceListener(this);
            return Status.OK_STATUS;
        }

        @Override
        public void handleCacheInitialized() {
            this.schedule(100L);
            this.cacheService.removeCacheServiceListener(this);
        }

        @Override
        public void handleCacheInitializing() {
            this.cancel();
        }
    }
}

