/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.services.registry;

import com.semarchy.xdi.designer.core.services.IRegistryService;
import java.io.Serializable;
import org.eclipse.emf.common.util.URI;

public class LevelCodeInfo
implements IRegistryService.RegistryItem,
Serializable {
    private static final long serialVersionUID = -4399251402950564094L;
    private IRegistryService.IRegistryKey key;
    private String levelName;
    private transient URI imageURI;
    private String uriStr;
    private String levelCode;

    public LevelCodeInfo(String fileID, String techCode, String levelCode, String levelName, URI imagePath) {
        this.key = new LevelCodeKey(fileID, techCode, levelCode);
        this.levelName = levelName;
        this.imageURI = imagePath;
        this.uriStr = this.imageURI.toString();
        this.levelCode = levelCode;
    }

    public String getLevelCode() {
        return this.levelCode;
    }

    public URI getImageURI() {
        if (this.imageURI == null && this.uriStr != null) {
            this.imageURI = URI.createURI((String)this.uriStr);
        }
        return this.imageURI;
    }

    public String getLevelName() {
        return this.levelName;
    }

    @Override
    public IRegistryService.IRegistryKey getRegistrationKey() {
        return this.key;
    }

    public static class LevelCodeKey
    implements IRegistryService.IRegistryKey,
    Serializable {
        private static final long serialVersionUID = 441330945424618114L;
        private String fullCode;
        private String fileID;

        public LevelCodeKey(String fileID, String techCode, String levelCode) {
            this.fullCode = techCode + "/" + levelCode;
            this.fileID = fileID;
        }

        public String getFullCode() {
            return this.fullCode;
        }

        @Override
        public boolean match(Object o) {
            if (o instanceof LevelCodeKey) {
                return this.fullCode.equals(((LevelCodeKey)o).fullCode);
            }
            return false;
        }

        public int hashCode() {
            return this.fullCode.hashCode();
        }

        public boolean equals(Object obj) {
            return this.match(obj);
        }

        @Override
        public String getProviderFileID() {
            return this.fileID;
        }
    }

    public static class LevelCodeMatcher
    implements IRegistryService.IRegistryMatcher {
        private String levelCode;

        public LevelCodeMatcher(String levelCode) {
            this.levelCode = levelCode;
        }

        @Override
        public boolean match(Object o) {
            if (o instanceof LevelCodeKey) {
                return this.levelCode.equals(((LevelCodeKey)o).fullCode.split("/")[1]);
            }
            return false;
        }
    }
}

