/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.httprest.impl;

import com.indy.connector.httprest.core.WebServiceExchange;
import com.indy.connector.httprest.core.WebServiceInvoker;
import com.indy.connector.httprest.core.WebServiceMetaData;
import com.indy.engine.core.IJsonUtils;
import com.indy.engine.core.UtilsService;
import com.indy.runtime.utils.IOUtils;
import com.semarchy.xdi.base.core.auth.AuthenticationFactory;
import com.semarchy.xdi.base.core.auth.ProxyInformationsEnum;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.stambia.httprest.impl.CustomHttpEntityEnclosingRequest;
import com.stambia.httprest.impl.LoggerInputStream;
import com.stambia.httprest.impl.Messages;
import com.stambia.httprest.impl.MultipartContentBody;
import com.stambia.httprest.impl.WebServiceUtils;
import com.stambia.httprest.impl.XMLEventAdapter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WebServiceInvokerImpl
implements WebServiceInvoker {
    private final Logger logger = LogManager.getLogger((String)WebServiceInvokerImpl.class.getName());
    private CloseableHttpClient httpClient;
    private BasicCookieStore cookieStore;
    private Logger consoleLogger;
    private Logger actionCodeLogger;
    private WebServiceMetaData wsMetadata;
    private Integer delayBetweenInvocations = 0;
    private Integer functionalErrorAcceptanceNumber = -1;
    private Integer functionalErrorRetryNumber = 0;
    private Integer functionalErrorRetryDelay = 0;
    private Integer technicalErrorAcceptanceNumber = 0;
    private Integer technicalErrorRetryNumber = 0;
    private Integer technicalErrorRetryDelay = 0;
    private boolean firstRequest = true;
    private int acceptedFunctionalErrors = 0;
    private int acceptedTechnicalErrors = 0;

    public WebServiceInvokerImpl(final WebServiceMetaData metadata, Logger consoleLogger, Logger actionCodeLogger) throws EngineExceptionI {
        boolean isReadTimeout;
        this.wsMetadata = metadata;
        this.consoleLogger = consoleLogger;
        this.actionCodeLogger = actionCodeLogger;
        this.cookieStore = new BasicCookieStore();
        HttpRequestInterceptor requestInterceptor = new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                Logger l = WebServiceInvokerImpl.this.getLogger(metadata.logReqRes);
                if (l != null && l.isInfoEnabled()) {
                    l.info(WebServiceUtils.requestToRawHttp(request));
                }
            }
        };
        HttpResponseInterceptor responseInterceptor = new HttpResponseInterceptor(){

            public void process(HttpResponse resp, HttpContext context) throws HttpException, IOException {
                Logger l = WebServiceInvokerImpl.this.getLogger(metadata.logReqRes);
                if (l != null && l.isInfoEnabled()) {
                    l.info(WebServiceUtils.responseToRawHttp(resp));
                }
            }
        };
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        boolean isConnectionTimeout = metadata.connectionTimeout != null && !metadata.connectionTimeout.isEmpty();
        boolean bl = isReadTimeout = metadata.readTimeout != null && !metadata.readTimeout.isEmpty();
        if (isConnectionTimeout || isReadTimeout) {
            RequestConfig.Builder configBuilder = RequestConfig.custom();
            if (isConnectionTimeout) {
                try {
                    int connectionTimeout = Integer.parseInt(metadata.connectionTimeout);
                    configBuilder.setConnectTimeout(connectionTimeout);
                }
                catch (NumberFormatException e) {
                    throw new EngineExceptionI(Messages.getString("WebServiceInvokerImpl.0"), (Throwable)e);
                }
            }
            if (isReadTimeout) {
                try {
                    int readTimeout = Integer.parseInt(metadata.readTimeout);
                    configBuilder.setSocketTimeout(readTimeout);
                }
                catch (NumberFormatException e) {
                    throw new EngineExceptionI(Messages.getString("WebServiceInvokerImpl.1"), (Throwable)e);
                }
            }
            httpClientBuilder.setDefaultRequestConfig(configBuilder.build());
        }
        try {
            if (this.wsMetadata != null) {
                if (this.wsMetadata.enableCertificateVerification != null && !this.wsMetadata.enableCertificateVerification.booleanValue() || this.wsMetadata.enableHostnameVerification != null && !this.wsMetadata.enableHostnameVerification.booleanValue()) {
                    sslContext = this.customSSLContext();
                    HostnameVerifier verifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
                    if (Boolean.FALSE.equals(this.wsMetadata.enableHostnameVerification)) {
                        verifier = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                    }
                    httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this.buildBasicHttpClientConnectionManager(sslContext, verifier));
                } else if (this.wsMetadata.enableCertificateVerification != null && this.wsMetadata.enableCertificateVerification.booleanValue() && this.wsMetadata.enableHostnameVerification != null && this.wsMetadata.enableHostnameVerification.booleanValue()) {
                    sslContext = this.customSSLContext();
                    HostnameVerifier verifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
                    httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this.buildBasicHttpClientConnectionManager(sslContext, verifier));
                }
            }
        }
        catch (Exception ex) {
            this.logger.error(Messages.getString("WebServiceInvokerImpl.16"), (Throwable)ex);
        }
        BasicCredentialsProvider credentialsProvider = null;
        if (metadata.proxyParams != null) {
            String host = (String)metadata.proxyParams.get(ProxyInformationsEnum.host.name());
            String port = (String)metadata.proxyParams.get(ProxyInformationsEnum.port.name());
            String scheme = null;
            try {
                URL url = new URL(metadata.baseUrl);
                scheme = url.getProtocol();
            }
            catch (Exception ex) {
                this.logger.warn("unexpected", (Throwable)ex);
            }
            if (!"http".equals(scheme) && !"https".equals(scheme)) {
                throw new EngineExceptionI(String.format(Messages.getString("WebServiceInvokerImpl.2"), scheme));
            }
            if (host == null || host.isEmpty()) {
                throw new EngineExceptionI(Messages.getString("WebServiceInvokerImpl.3"));
            }
            if (port == null || port.isEmpty()) {
                throw new EngineExceptionI(Messages.getString("WebServiceInvokerImpl.4"));
            }
            int portNumber = -1;
            try {
                portNumber = Integer.valueOf(port);
            }
            catch (NumberFormatException ex) {
                throw new EngineExceptionI(String.format(Messages.getString("WebServiceInvokerImpl.5"), scheme));
            }
            HttpHost proxy = new HttpHost(host, portNumber);
            httpClientBuilder.setProxy(proxy);
            String userName = (String)metadata.proxyParams.get(ProxyInformationsEnum.username.name());
            String password = (String)metadata.proxyParams.get(ProxyInformationsEnum.password.name());
            if (userName != null) {
                credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(host, portNumber), (Credentials)new UsernamePasswordCredentials(userName, password));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
        if (metadata.securityParams != null && "ntlm".equals(metadata.securityParams.get("type"))) {
            String userName = (String)metadata.securityParams.get("userName");
            if (userName == null || userName.isEmpty()) {
                throw new EngineExceptionI(Messages.getString("WebServiceInvokerImpl.6"));
            }
            String domain = (String)metadata.securityParams.get("domain");
            if (domain == null || domain.isEmpty()) {
                throw new EngineExceptionI(Messages.getString("WebServiceInvokerImpl.7"));
            }
            if (userName.startsWith(domain) && userName.contains("\\")) {
                userName = userName.substring(userName.lastIndexOf("\\") + 1);
            }
            try {
                URL u = new URL(metadata.baseUrl);
                credentialsProvider = credentialsProvider != null ? credentialsProvider : new BasicCredentialsProvider();
                credentialsProvider.setCredentials(new AuthScope(u.getHost(), u.getPort()), (Credentials)new NTCredentials(userName, (String)metadata.securityParams.get("password"), InetAddress.getLocalHost().getHostName(), domain));
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
            catch (Exception ex) {
                this.logger.warn("unexpected", (Throwable)ex);
                throw new EngineExceptionI(Messages.getString("WebServiceInvokerImpl.8"), (Throwable)ex);
            }
        }
        this.delayBetweenInvocations = this.getIntFromMd(metadata.delayBetweenInvocations, 0);
        this.functionalErrorAcceptanceNumber = this.getIntFromMd(metadata.functionalErrorAcceptanceNumber, -1);
        this.functionalErrorRetryNumber = this.getIntFromMd(metadata.functionalErrorRetryNumber, 0);
        this.functionalErrorRetryDelay = this.getIntFromMd(metadata.functionalErrorRetryDelay, 0);
        this.technicalErrorAcceptanceNumber = this.getIntFromMd(metadata.technicalErrorAcceptanceNumber, 0);
        this.technicalErrorRetryNumber = this.getIntFromMd(metadata.technicalErrorRetryNumber, 0);
        this.technicalErrorRetryDelay = this.getIntFromMd(metadata.technicalErrorRetryDelay, 0);
        this.httpClient = httpClientBuilder.setDefaultCookieStore((CookieStore)this.cookieStore).addInterceptorLast(requestInterceptor).addInterceptorLast(responseInterceptor).build();
    }

    private BasicHttpClientConnectionManager buildBasicHttpClientConnectionManager(SSLContext sslContext, HostnameVerifier verifier) {
        SSLConnectionSocketFactory sslConnectionFactory = new SSLConnectionSocketFactory(sslContext, verifier);
        Registry registry = RegistryBuilder.create().register("https", (Object)sslConnectionFactory).register("http", (Object)new PlainConnectionSocketFactory()).build();
        return new BasicHttpClientConnectionManager((Lookup)registry);
    }

    public WebServiceInvokerImpl(WebServiceMetaData metadata) throws EngineExceptionI {
        this(metadata, LogManager.getLogger((String)"com.indy.engine.console"), LogManager.getLogger((String)"com.indy.engine.actionCodes"));
    }

    public WebServiceExchange.WebServiceResponse handleRequest(WebServiceMetaData metadata, WebServiceExchange exchange) throws Exception {
        if (!this.firstRequest && this.delayBetweenInvocations != null) {
            Thread.sleep(this.delayBetweenInvocations.intValue());
        }
        this.firstRequest = false;
        HttpRequestBase httpRequest = this.prepareHttpRequest(exchange, metadata);
        CloseableHttpResponse response = null;
        int statusCode = 200;
        int technicalTryNumber = 0;
        int functionalTryNumber = 0;
        while (response == null && technicalTryNumber <= this.technicalErrorRetryNumber || statusCode > 399 && functionalTryNumber <= this.functionalErrorRetryNumber) {
            try {
                response = this.httpClient.execute((HttpUriRequest)httpRequest);
                statusCode = response.getStatusLine().getStatusCode();
                if (statusCode <= 399) continue;
                if (++functionalTryNumber <= this.functionalErrorRetryNumber) {
                    response.close();
                    httpRequest.releaseConnection();
                    Thread.sleep(this.functionalErrorRetryDelay.intValue());
                    continue;
                }
                if (this.acceptedFunctionalErrors == this.functionalErrorAcceptanceNumber) {
                    throw new EngineExceptionI(Messages.getString("WebServiceInvokerImpl.9") + response.getStatusLine().toString());
                }
                ++this.acceptedFunctionalErrors;
            }
            catch (Exception e) {
                if (++technicalTryNumber <= this.technicalErrorRetryNumber) {
                    Thread.sleep(this.technicalErrorRetryDelay.intValue());
                    httpRequest.releaseConnection();
                } else {
                    if (this.acceptedTechnicalErrors == this.technicalErrorAcceptanceNumber) {
                        throw e;
                    }
                    ++this.acceptedTechnicalErrors;
                    exchange.addException(e);
                }
                if (!(e instanceof InterruptedException)) continue;
                Thread.currentThread().interrupt();
            }
        }
        if (response != null) {
            String stringStatusCode = String.valueOf(statusCode);
            WebServiceMetaData.WebServiceResponseMetaData respMd = this.getResponseMetadata(metadata, stringStatusCode);
            WebServiceExchange.WebServiceResponse wsre = this.handleResponse((HttpResponse)response, respMd, metadata.logReqRes);
            if (respMd != null) {
                exchange.addResponseExchange("A" + respMd.code, wsre);
            }
            return wsre;
        }
        return null;
    }

    private HttpRequestBase prepareHttpRequest(WebServiceExchange exchange, WebServiceMetaData metadata) throws Exception {
        String authHeader;
        this.verifyRequiredAndEmptyParameters(metadata.parameterByKey, exchange.params);
        exchange.params = this.replaceDefaultValues(metadata.parameterByKey, exchange.params);
        URI uri = this.buildURI(metadata, exchange.params);
        HttpRequestBase httpRequest = this.getHttpRequest(metadata.verb, uri);
        if (exchange.request != null) {
            if (httpRequest instanceof HttpTrace) {
                throw new EngineExceptionI(Messages.getString("WebServiceInvokerImpl.10"));
            }
            if (metadata.request.content != null) {
                this.addBodyToRequest((HttpEntityEnclosingRequestBase)httpRequest, metadata.request.content, exchange.request);
                if (metadata.request.content.contentType != null && !metadata.request.content.contentType.isEmpty()) {
                    httpRequest.setHeader("Content-Type", metadata.request.content.contentType);
                }
            } else if (metadata.request.multipart != null) {
                this.addMultipartBodyToRequest((HttpEntityEnclosingRequestBase)httpRequest, metadata.request.multipart, (Map)exchange.request.get(metadata.request.multipart.id));
            }
        }
        if (metadata.securityParams != null && (authHeader = AuthenticationFactory.getAuthHeader((Map)metadata.securityParams, (String)metadata.verb, (URL)uri.toURL(), (Map)metadata.proxyParams)) != null) {
            httpRequest.setHeader("Authorization", authHeader);
        }
        this.addHeadersAndCookies((HttpUriRequest)httpRequest, metadata, exchange.params, uri);
        return httpRequest;
    }

    private Map<String, String> replaceDefaultValues(Map<String, WebServiceMetaData.Parameter> metadataParams, Map<String, String> exchangeParams) {
        if (metadataParams != null) {
            if (exchangeParams == null) {
                exchangeParams = new HashMap<String, String>();
            }
            for (Map.Entry<String, WebServiceMetaData.Parameter> parameter : metadataParams.entrySet()) {
                String value;
                if (parameter.getValue().defaultValue == null || (value = exchangeParams.get(parameter.getKey())) != null) continue;
                exchangeParams.put(parameter.getKey(), parameter.getValue().defaultValue);
            }
        }
        return exchangeParams;
    }

    private URI buildURI(WebServiceMetaData metadata, Map<String, String> params) throws URISyntaxException, UnsupportedEncodingException {
        WebServiceMetaData.Parameter pmd;
        StringBuilder sb = new StringBuilder();
        if (params == null) {
            sb.append(metadata.getUrl());
        } else {
            ArrayList<String> list = new ArrayList<String>(metadata.getUrlParts());
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (param.getValue() == null) continue;
                pmd = (WebServiceMetaData.Parameter)metadata.parameterByKey.get(param.getKey());
                if (pmd.location != WebServiceMetaData.ParameterLocation.path) continue;
                list.set(pmd.urlPosition, URLEncoder.encode(param.getValue(), "UTF-8"));
            }
            for (String l : list) {
                sb.append(l);
            }
        }
        URIBuilder builder = new URIBuilder(sb.toString());
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (param.getValue() == null) continue;
                pmd = (WebServiceMetaData.Parameter)metadata.parameterByKey.get(param.getKey());
                if (pmd.location != WebServiceMetaData.ParameterLocation.query || param.getValue() == null) continue;
                builder.setParameter(param.getKey(), param.getValue());
            }
        }
        return new URI(builder.build().toString().replace("+", "%20"));
    }

    private HttpRequestBase getHttpRequest(String verb, URI uri) throws EngineExceptionI {
        return switch (verb) {
            case "POST" -> new HttpPost(uri);
            case "GET" -> new CustomHttpEntityEnclosingRequest(verb, uri);
            case "PUT" -> new HttpPut(uri);
            case "DELETE" -> new CustomHttpEntityEnclosingRequest(verb, uri);
            case "PATCH" -> new HttpPatch(uri);
            case "OPTIONS" -> new CustomHttpEntityEnclosingRequest(verb, uri);
            case "HEAD" -> new CustomHttpEntityEnclosingRequest(verb, uri);
            case "TRACE" -> new HttpTrace(uri);
            default -> throw new EngineExceptionI(Messages.getString("WebServiceInvokerImpl.11") + verb);
        };
    }

    private void addBodyToRequest(HttpEntityEnclosingRequestBase httpRequest, WebServiceMetaData.ContentMetadata contentMetadata, Map<String, Object> contentMap) throws Exception {
        Object content = contentMap.get(contentMetadata.id);
        switch (contentMetadata.mediaType) {
            case JSON: {
                IJsonUtils.Adapter xec = (IJsonUtils.Adapter)content;
                httpRequest.setEntity((HttpEntity)new ByteArrayEntity((byte[])xec.adapt(byte[].class, null)));
                break;
            }
            case XML: {
                IJsonUtils.Adapter xec = (IJsonUtils.Adapter)content;
                httpRequest.setEntity((HttpEntity)new ByteArrayEntity((byte[])xec.adapt(byte[].class, null)));
                break;
            }
            case BINARY: {
                httpRequest.setEntity((HttpEntity)new ByteArrayEntity((byte[])content));
                break;
            }
            case FORM: {
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                for (Map.Entry entry : ((Map)content).entrySet()) {
                    nvps.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
                }
                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvps, StandardCharsets.UTF_8);
                httpRequest.setEntity((HttpEntity)entity);
                break;
            }
            default: {
                httpRequest.setEntity((HttpEntity)new StringEntity((String)content));
            }
        }
    }

    private void addMultipartBodyToRequest(HttpEntityEnclosingRequestBase httpRequest, WebServiceMetaData.MultipartMetadata multipartMetadata, Map<String, Object> contentMap) throws Exception {
        httpRequest.setEntity(this.createMultipartEntity(multipartMetadata, contentMap));
    }

    private HttpEntity createMultipartEntity(WebServiceMetaData.MultipartMetadata multipartMetadata, Map<String, Object> contentMap) throws Exception {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setBoundary(multipartMetadata.boundary);
        builder.setContentType(ContentType.create((String)multipartMetadata.contentType));
        for (WebServiceMetaData.PartMetadata partMd : multipartMetadata.parts) {
            if (!contentMap.containsKey(partMd.partName)) continue;
            if (contentMap.get(partMd.partName) instanceof Map) {
                Map cMap = (Map)contentMap.get(partMd.partName);
                this.addPart(builder, partMd.partName, partMd, cMap);
                continue;
            }
            if (!(contentMap.get(partMd.partName) instanceof List)) continue;
            List listMaps = (List)contentMap.get(partMd.partName);
            int i = 0;
            while (i < listMaps.size()) {
                Map cMap = (Map)listMaps.get(i);
                this.addPart(builder, partMd.partName + "_" + i, partMd, cMap);
                ++i;
            }
        }
        return builder.build();
    }

    private void addPart(MultipartEntityBuilder builder, String partName, WebServiceMetaData.PartMetadata partMd, Map<String, Object> cMap) throws Exception {
        String newPartName = partName;
        String partFilename = partMd.partFilename;
        if (cMap.containsKey("partName") && !((String)cMap.get("partName")).isEmpty()) {
            newPartName = (String)cMap.get("partName");
        }
        if (cMap.containsKey("partFilename") && !((String)cMap.get("partFilename")).isEmpty()) {
            partFilename = (String)cMap.get("partFilename");
        }
        if (partMd.part != null && cMap.get(partMd.part.id) != null) {
            builder.addPart(newPartName, this.createContentBody(partMd, cMap.get(partMd.part.id), partFilename));
        }
        if (partMd.multipart != null && cMap.get(partMd.multipart.id) != null) {
            builder.addPart(newPartName, (ContentBody)new MultipartContentBody(this.createMultipartEntity(partMd.multipart, (Map)cMap.get(partMd.multipart.id))));
        }
    }

    private ContentBody createContentBody(WebServiceMetaData.PartMetadata partMd, Object content, String partFilename) throws Exception {
        return new ByteArrayBody(switch (partMd.part.mediaType) {
            case WebServiceMetaData.ContentType.JSON -> {
                IJsonUtils.Adapter xec = (IJsonUtils.Adapter)content;
                yield (byte[])xec.adapt(byte[].class, null);
            }
            case WebServiceMetaData.ContentType.XML -> {
                IJsonUtils.Adapter xec = (IJsonUtils.Adapter)content;
                yield (byte[])xec.adapt(byte[].class, null);
            }
            case WebServiceMetaData.ContentType.BINARY -> (byte[])content;
            case WebServiceMetaData.ContentType.FORM -> {
                ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
                for (Map.Entry entry : ((Map)content).entrySet()) {
                    nvps.add(new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue()));
                }
                yield URLEncodedUtils.format(nvps, (Charset)StandardCharsets.UTF_8).getBytes();
            }
            default -> ((String)content).getBytes();
        }, ContentType.create((String)partMd.part.contentType), partFilename);
    }

    private void addHeadersAndCookies(HttpUriRequest httpRequest, WebServiceMetaData metadata, Map<String, String> params, URI uri) {
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                if (param.getValue() == null) continue;
                WebServiceMetaData.Parameter pmd = (WebServiceMetaData.Parameter)metadata.parameterByKey.get(param.getKey());
                if (pmd.location == WebServiceMetaData.ParameterLocation.header) {
                    httpRequest.setHeader(param.getKey(), param.getValue());
                    continue;
                }
                if (pmd.location != WebServiceMetaData.ParameterLocation.cookie) continue;
                BasicClientCookie cookie = new BasicClientCookie(param.getKey(), param.getValue());
                cookie.setDomain(uri.getHost());
                cookie.setAttribute("domain", "true");
                this.cookieStore.addCookie((Cookie)cookie);
            }
        }
    }

    private WebServiceMetaData.WebServiceResponseMetaData getResponseMetadata(WebServiceMetaData metadata, String statusCode) {
        WebServiceMetaData.WebServiceResponseMetaData respMd = null;
        String stringStatusCode = String.valueOf(statusCode);
        for (WebServiceMetaData.WebServiceResponseMetaData rmd : metadata.responseByKey) {
            if (!stringStatusCode.equals(rmd.code)) continue;
            respMd = rmd;
        }
        if (respMd == null) {
            respMd = metadata.defaultResponse;
        }
        return respMd;
    }

    private WebServiceExchange.WebServiceResponse handleResponse(HttpResponse response, WebServiceMetaData.WebServiceResponseMetaData respMd, String logResponse) throws Exception {
        WebServiceExchange.WebServiceResponse wsre = new WebServiceExchange.WebServiceResponse();
        WebServiceExchange.ResponseInformation respInfos = new WebServiceExchange.ResponseInformation();
        respInfos.statusCode = String.valueOf(response.getStatusLine().getStatusCode());
        respInfos.reasonPhrase = response.getStatusLine().getReasonPhrase();
        respInfos.protocolVersion = response.getStatusLine().getProtocolVersion().toString();
        wsre.respInfos = respInfos;
        if (response.getEntity() != null) {
            ByteArrayOutputStream baos;
            Charset responseCharset = ContentType.getOrDefault((HttpEntity)response.getEntity()).getCharset();
            if (responseCharset == null) {
                responseCharset = StandardCharsets.UTF_8;
            }
            if (respMd != null && respMd.content != null && respMd.content.mediaType == WebServiceMetaData.ContentType.AUTO) {
                respMd.content = new WebServiceMetaData.ContentMetadata();
                respMd.content.mediaType = WebServiceMetaData.ContentType.TEXT;
                respMd.headers = new HashMap();
                Header[] headerArray = response.getAllHeaders();
                int n = headerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Header header = headerArray[n2];
                    respMd.headers.put(header.getName(), header.getValue());
                    if ("Set-Cookie".equals(header.getName())) {
                        String val = header.getValue();
                        WebServiceMetaData.CookieMetadata cookie = new WebServiceMetaData.CookieMetadata();
                        cookie.cookieName = val.split("=")[0];
                        cookie.valueFormat = "value only";
                        respMd.cookies.put(val.split("=")[0], cookie);
                    }
                    ++n2;
                }
            }
            InputStream is = response.getEntity().getContent();
            if (this.getLogger(logResponse) != null && response.getEntity().getContentLength() < 24000L) {
                is = new LoggerInputStream(is, this.getLogger(logResponse), responseCharset);
            }
            if (respMd == null || respMd.content == null || respMd.content.mediaType != WebServiceMetaData.ContentType.BINARY) {
                Throwable throwable = null;
                Object var9_9 = null;
                try {
                    baos = new ByteArrayOutputStream();
                    try {
                        IOUtils.copy((InputStream)is, (OutputStream)baos);
                        is = new ByteArrayInputStream(baos.toByteArray());
                        wsre.rawContent = baos.toString(responseCharset.name());
                    }
                    finally {
                        if (baos != null) {
                            baos.close();
                        }
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (respMd != null) {
                Header header;
                Header[] headerArray;
                if (respMd.headers != null) {
                    for (String s : respMd.headers.keySet()) {
                        headerArray = response.getAllHeaders();
                        int cookie = headerArray.length;
                        int val = 0;
                        while (val < cookie) {
                            header = headerArray[val];
                            if (s.equalsIgnoreCase(header.getName())) {
                                wsre.headers.put(s, header.getValue());
                            }
                            ++val;
                        }
                    }
                }
                if (respMd.cookies != null) {
                    for (Map.Entry entry : respMd.cookies.entrySet()) {
                        headerArray = response.getHeaders("Set-Cookie");
                        int cookie = headerArray.length;
                        int val = 0;
                        while (val < cookie) {
                            int equalIndex;
                            header = headerArray[val];
                            String headerValue = header.getValue();
                            String receviedCookieName = headerValue.substring(0, equalIndex = headerValue.indexOf(61));
                            if (receviedCookieName.equalsIgnoreCase(((WebServiceMetaData.CookieMetadata)entry.getValue()).cookieName)) {
                                String cookieName = (String)entry.getKey();
                                String cookieValue = ((WebServiceMetaData.CookieMetadata)entry.getValue()).valueFormat.equals("value only") ? headerValue.substring(equalIndex + 1, headerValue.indexOf(59)) : headerValue.substring(equalIndex + 1);
                                if (((WebServiceMetaData.CookieMetadata)entry.getValue()).valueSelectorRegexp != null && !((WebServiceMetaData.CookieMetadata)entry.getValue()).valueSelectorRegexp.isEmpty()) {
                                    Matcher matcher = Pattern.compile(((WebServiceMetaData.CookieMetadata)entry.getValue()).valueSelectorRegexp).matcher(cookieValue);
                                    if (matcher.matches()) {
                                        wsre.cookies.put("_" + cookieName, cookieValue);
                                    }
                                } else {
                                    wsre.cookies.put("_" + cookieName, cookieValue);
                                }
                            }
                            ++val;
                        }
                    }
                }
                if (respMd.content != null && respMd.content.mediaType != null) {
                    switch (respMd.content.mediaType) {
                        case JSON: {
                            HashMap<String, Boolean> prop = new HashMap<String, Boolean>();
                            prop.put("ADD_PROCESSING_ENCODING_INSTRUCTION", false);
                            XMLEventAdapter writer = new XMLEventAdapter();
                            UtilsService.getJsonUtils().jsonStreamToXMLEventWriter(is, responseCharset.name(), (XMLEventWriter)writer, "UTF-8", prop);
                            wsre.content = writer;
                            break;
                        }
                        case XML: {
                            XMLInputFactory ifactory = XMLInputFactory.newFactory();
                            ifactory.setProperty("javax.xml.stream.supportDTD", false);
                            XMLEventReader reader = ifactory.createXMLEventReader(is);
                            XMLEventAdapter writer = new XMLEventAdapter();
                            while (reader.hasNext()) {
                                writer.add(reader.nextEvent());
                            }
                            wsre.content = writer;
                            break;
                        }
                        case FORM: {
                            Throwable throwable = null;
                            Object var9_15 = null;
                            try {
                                baos = new ByteArrayOutputStream();
                                try {
                                    IOUtils.copy((InputStream)is, (OutputStream)baos);
                                    String data = baos.toString(responseCharset.name());
                                    HashMap<String, String> formMap = new HashMap<String, String>();
                                    String[] stringArray = data.split("&");
                                    int n = stringArray.length;
                                    int n3 = 0;
                                    while (n3 < n) {
                                        String s = stringArray[n3];
                                        String[] keyValue = s.split("=");
                                        if (keyValue.length == 2) {
                                            formMap.put(keyValue[0], keyValue[1]);
                                        }
                                        ++n3;
                                    }
                                    wsre.content = formMap;
                                    break;
                                }
                                finally {
                                    if (baos != null) {
                                        baos.close();
                                    }
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        case BINARY: {
                            Throwable throwable = null;
                            Object var9_17 = null;
                            try {
                                baos = new ByteArrayOutputStream();
                                try {
                                    IOUtils.copy((InputStream)is, (OutputStream)baos);
                                    wsre.content = baos.toByteArray();
                                    break;
                                }
                                finally {
                                    if (baos != null) {
                                        baos.close();
                                    }
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                        }
                        default: {
                            Throwable throwable = null;
                            Object var9_19 = null;
                            try {
                                baos = new ByteArrayOutputStream();
                                try {
                                    IOUtils.copy((InputStream)is, (OutputStream)baos);
                                    wsre.content = baos.toString(responseCharset.name());
                                    break;
                                }
                                finally {
                                    if (baos != null) {
                                        baos.close();
                                    }
                                }
                            }
                            catch (Throwable throwable5) {
                                if (throwable == null) {
                                    throwable = throwable5;
                                } else if (throwable != throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                                throw throwable;
                            }
                        }
                    }
                }
            }
            EntityUtils.consume((HttpEntity)response.getEntity());
        }
        return wsre;
    }

    private void verifyRequiredAndEmptyParameters(Map<String, WebServiceMetaData.Parameter> parameterByKey, Map<String, String> params) throws EngineExceptionI {
        if (parameterByKey != null) {
            for (Map.Entry<String, WebServiceMetaData.Parameter> param : parameterByKey.entrySet()) {
                if (param.getValue().required && param.getValue().defaultValue == null && (params == null || params.get(param.getKey()) == null)) {
                    throw new EngineExceptionI(Messages.getString("WebServiceInvokerImpl.12") + param.getKey() + Messages.getString("WebServiceInvokerImpl.13"));
                }
                if (param.getValue().allowEmptyValue || params == null || params.get(param.getKey()) == null || !params.get(param.getKey()).isEmpty()) continue;
                throw new EngineExceptionI(Messages.getString("WebServiceInvokerImpl.14") + param.getKey() + Messages.getString("WebServiceInvokerImpl.15"));
            }
        }
    }

    private SSLContext customSSLContext() throws Exception {
        SSLContextBuilder sslContextBuilder = SSLContexts.custom();
        boolean useDefaults = true;
        if (this.wsMetadata.keyStoreParams != null && !this.wsMetadata.keyStoreParams.isEmpty()) {
            this.setKeyStore(sslContextBuilder, (String)this.wsMetadata.keyStoreParams.get("filePath"), (String)this.wsMetadata.keyStoreParams.get("type"), (String)this.wsMetadata.keyStoreParams.get("password"));
            useDefaults = false;
        } else if (System.getProperty("javax.net.ssl.keyStore") != null) {
            this.setKeyStore(sslContextBuilder, System.getProperty("javax.net.ssl.keyStore"), System.getProperty("javax.net.ssl.keyStoreType"), System.getProperty("javax.net.ssl.keyStorePassword"));
            useDefaults = false;
        }
        if (Boolean.TRUE.equals(this.wsMetadata.enableCertificateVerification)) {
            if (this.wsMetadata.trustStoreParams != null && !this.wsMetadata.trustStoreParams.isEmpty()) {
                this.setTrustStore(sslContextBuilder, (String)this.wsMetadata.trustStoreParams.get("filePath"), (String)this.wsMetadata.trustStoreParams.get("type"), (String)this.wsMetadata.trustStoreParams.get("password"));
                useDefaults = false;
            } else if (System.getProperty("javax.net.ssl.trustStore") != null) {
                this.setTrustStore(sslContextBuilder, System.getProperty("javax.net.ssl.trustStore"), System.getProperty("javax.net.ssl.trustStoreType"), System.getProperty("javax.net.ssl.trustStorePassword"));
                useDefaults = false;
            }
        } else {
            sslContextBuilder.loadTrustMaterial(null, (chain, authType) -> true);
            useDefaults = false;
        }
        if (useDefaults) {
            return SSLContexts.createDefault();
        }
        return sslContextBuilder.build();
    }

    private void setKeyStore(SSLContextBuilder builder, String keyStorePath, String keyStoreType, String keyStorePassword) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        File keyStore;
        if (keyStorePath != null && (keyStore = new File(keyStorePath)).exists()) {
            builder.setKeyStoreType(keyStoreType).loadKeyMaterial(keyStore, keyStorePassword.toCharArray(), keyStorePassword.toCharArray());
        }
    }

    private void setTrustStore(SSLContextBuilder builder, String trustStorePath, String trustStoreType, String trustStorePassword) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        File trustStore;
        if (trustStorePath != null && (trustStore = new File(trustStorePath)).exists()) {
            builder.setKeyStoreType(trustStoreType).loadTrustMaterial(trustStore, trustStorePassword.toCharArray());
        }
    }

    private Logger getLogger(String logType) {
        block10: {
            if (logType == null) break block10;
            switch (logType) {
                case "console": {
                    return this.consoleLogger;
                }
                case "file": {
                    return this.actionCodeLogger;
                }
            }
            return null;
        }
        return null;
    }

    private Integer getIntFromMd(String val, Integer defaultValue) {
        if (val != null && !val.isEmpty()) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                this.logger.debug("number format invalid", (Throwable)e);
            }
        }
        return defaultValue;
    }
}

