/*
 * Decompiled with CFR 0.152.
 */
package com.indy.runtime.api.impl.jdbc;

import com.indy.engine.core.IScriptContext;
import com.indy.engine.core.actionCodes.convert.JdbcConverter;
import com.indy.engine.core.api.impl.CellMapProperties;
import com.indy.engine.core.api.impl.jdbc.JdbcReaderProperties;
import com.indy.engine.core.api.impl.jdbc.JdbcWriterProperties;
import com.indy.engine.core.jdbc.INamedResultSetsProcessor;
import com.indy.engine.core.jdbc.IPreparedStatementToResultSet;
import com.indy.engine.core.jdbc.IResultSetsKeyPairComparator;
import com.indy.runtime.api.ICellReader;
import com.indy.runtime.api.ICellWriter;
import com.indy.runtime.api.impl.jdbc.JdbcPreparedStatementToResultSet;
import com.indy.runtime.api.impl.jdbc.ResultSetsKeyPairComparator;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class NamedResultSetsProcessor
implements INamedResultSetsProcessor {
    private Map<String, Object> targetValues = new HashMap<String, Object>();
    private int batchSize = 30;
    private boolean dateAsTimestamp = false;
    private boolean keysAreOrdered = false;
    private IScriptContext __ctx__;
    private Map<String, ResultSetDefinition> resultSetDefinitions = new HashMap<String, ResultSetDefinition>();
    private Map<String, PreparedStatementDefinition> preparedStatementDefinitions = new HashMap<String, PreparedStatementDefinition>();
    private Map<String, MapDefinition> mapDefinitions = new HashMap<String, MapDefinition>();
    private Map<String, ListDefinition> listDefinitions = new HashMap<String, ListDefinition>();
    private Map<String, ComputedValueDefinition> computedValueDefinitions = new HashMap<String, ComputedValueDefinition>();
    private Map<String, ValueDefinition> valueDefinitions = new HashMap<String, ValueDefinition>();
    private List<String> targetIds = new ArrayList<String>();

    public NamedResultSetsProcessor(IScriptContext __ctx__) {
        this.__ctx__ = __ctx__;
    }

    public void declareResultSet(String id, String parentId) throws EngineExceptionI {
        this.resultSetDefinitions.put(id, new ResultSetDefinition(id, parentId));
    }

    public void declarePreparedStatementField(String targetFieldUniqueID, String targetPreparedStatement, String targetFieldName) throws EngineExceptionI {
        if (!this.preparedStatementDefinitions.containsKey(targetPreparedStatement)) {
            throw new EngineExceptionI("Unknown PreparedStatement");
        }
        PreparedStatementDefinition definition = this.preparedStatementDefinitions.get(targetPreparedStatement);
        IPreparedStatementToResultSet statement = definition.preparedStatement;
        int sourceType = this.valueDefinitions.get((Object)targetFieldUniqueID).jdbcType;
        int targetColumnIndex = definition.cellWriters.size() + 1;
        try {
            statement.setColumn(targetColumnIndex, targetFieldName, sourceType);
        }
        catch (SQLException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        CellMapProperties mapProperties = new CellMapProperties();
        mapProperties.targetIndex = targetColumnIndex;
        mapProperties.targetName = targetFieldName;
        mapProperties.targetType = sourceType;
        mapProperties.sourceType = sourceType;
        JdbcWriterProperties props = new JdbcWriterProperties();
        props.setDateAsTimestamp(this.dateAsTimestamp);
        try {
            definition.cellWriters.put(targetFieldUniqueID, (ICellWriter<PreparedStatement>)JdbcConverter.getPreparedStatementCellWriter((CellMapProperties)mapProperties, (JdbcWriterProperties)props));
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        this.valueDefinitions.get((Object)targetPreparedStatement).childFieldIDs.add(targetFieldUniqueID);
    }

    public void run() throws EngineExceptionI {
        try {
            this.initializeComparators();
            for (String string : this.preparedStatementDefinitions.keySet()) {
                this.__ctx__.getNamedObjectManager().waitReady(string);
            }
            for (ResultSetDefinition resultSetDefinition : this.resultSetDefinitions.values()) {
                if (!resultSetDefinition.isRoot) continue;
                this.iterateOn(resultSetDefinition);
            }
            for (PreparedStatementDefinition preparedStatementDefinition : this.preparedStatementDefinitions.values()) {
                if (preparedStatementDefinition.rowCount > 0) {
                    preparedStatementDefinition.preparedStatement.executeBatch();
                }
                preparedStatementDefinition.preparedStatement.end();
            }
            for (Map.Entry entry : this.resultSetDefinitions.entrySet()) {
                this.__ctx__.getNamedObjectManager().setCompleted((String)entry.getKey());
                ((ResultSetDefinition)entry.getValue()).resultSet.close();
            }
        }
        catch (Exception exception) {
            throw new EngineExceptionI((Throwable)exception);
        }
    }

    private void initializeOrderedComparators(ResultSetDefinition currentDefinition, ResultSetDefinition parentDefinition) throws EngineExceptionI {
        ResultSetsKeyPairComparator comparator = new ResultSetsKeyPairComparator(parentDefinition.resultSet, currentDefinition.resultSet);
        int i = 0;
        while (i < parentDefinition.keys.size()) {
            try {
                comparator.declareKeyPairByName(parentDefinition.keys.get(i), currentDefinition.keys.get(i));
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
            ++i;
        }
        currentDefinition.comparator = comparator;
    }

    private void initializeNonOrderedComparators(ResultSetDefinition currentDefinition, ResultSetDefinition parentDefinition) throws EngineExceptionI {
        ResultSetsKeyPairComparator comparator = new ResultSetsKeyPairComparator(parentDefinition.resultSet, currentDefinition.resultSet);
        for (String name : parentDefinition.keys) {
            comparator.declareKeyPairByHomonymy(name);
        }
        currentDefinition.comparator = comparator;
    }

    private void initializeComparators() throws EngineExceptionI {
        for (ResultSetDefinition currentDefinition : this.resultSetDefinitions.values()) {
            ResultSetDefinition parentDefinition = currentDefinition.parentResultSet;
            if (parentDefinition == null) continue;
            if (currentDefinition.keys == null || parentDefinition.keys == null) {
                throw new EngineExceptionI("Unable to process a parent-child ResultSet without keys defined on each ResultSet");
            }
            if (this.keysAreOrdered) {
                this.initializeOrderedComparators(currentDefinition, parentDefinition);
                continue;
            }
            this.initializeNonOrderedComparators(currentDefinition, parentDefinition);
        }
    }

    private void setListValues(ResultSetDefinition definition) {
        for (ResultSetDefinition childDefinition : definition.childResultSets) {
            for (String listName : childDefinition.partiallyPopulatedObjectsInResultSetIteration) {
                this.targetValues.put(listName, this.listDefinitions.get((Object)listName).valueBeingPopulated);
                this.valueDefinitions.get((Object)listName).isSet = true;
                this.listDefinitions.get((Object)listName).valueBeingPopulated = new ArrayList<Object>();
            }
        }
    }

    private void iterateOn(ResultSetDefinition definition) throws EngineExceptionI {
        ResultSet resultSet = definition.resultSet;
        definition.partiallyPopulatedObjectsInResultSetIteration.clear();
        try {
            while (definition.isHeld || resultSet.next()) {
                if (!this.compareKeysWithParent(definition.id)) {
                    definition.isHeld = true;
                    break;
                }
                this.fillValues(definition.id);
                for (ResultSetDefinition childDefinition : definition.childResultSets) {
                    this.iterateOn(childDefinition);
                }
                this.setListValues(definition);
                this.setCompletedValues(definition.id);
                definition.isHeld = false;
            }
        }
        catch (SQLException e) {
            throw new EngineExceptionI((Throwable)e);
        }
    }

    private boolean compareKeysWithParent(String resultSetName) throws EngineExceptionI {
        if (!this.resultSetDefinitions.containsKey(resultSetName) || this.resultSetDefinitions.get((Object)resultSetName).comparator == null) {
            return true;
        }
        return this.resultSetDefinitions.get((Object)resultSetName).comparator.compare();
    }

    private boolean setCompletedValuesInPreparedStatements(List<String> valuesToReset) throws EngineExceptionI {
        boolean doContinue = false;
        try {
            for (Map.Entry<String, PreparedStatementDefinition> definitionEntry : this.preparedStatementDefinitions.entrySet()) {
                String preparedStatementID = definitionEntry.getKey();
                PreparedStatementDefinition definition = definitionEntry.getValue();
                ValueDefinition valueDefinition = this.valueDefinitions.get(preparedStatementID);
                if (valueDefinition.isSet || !this.areChildFieldsCompleted(valueDefinition)) continue;
                doContinue = true;
                IPreparedStatementToResultSet targetPreparedStatement = definition.preparedStatement;
                for (Map.Entry<String, ICellWriter<PreparedStatement>> cellWriterEntry : definition.cellWriters.entrySet()) {
                    cellWriterEntry.getValue().write((Object)targetPreparedStatement, this.targetValues.get(cellWriterEntry.getKey()));
                }
                targetPreparedStatement.addBatch();
                ++definition.rowCount;
                if (definition.rowCount > this.batchSize) {
                    targetPreparedStatement.executeBatch();
                    definition.rowCount = 0;
                }
                valueDefinition.isSet = true;
                valuesToReset.add(preparedStatementID);
            }
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        return doContinue;
    }

    private boolean areChildFieldsCompleted(ValueDefinition valueDefinition) {
        boolean isComplete = true;
        for (String childFieldID : valueDefinition.childFieldIDs) {
            boolean bl = isComplete = isComplete && this.valueDefinitions.get((Object)childFieldID).isSet;
        }
        return isComplete;
    }

    private boolean setCompletedValuesInMaps(List<String> valuesToReset) {
        boolean doContinue = false;
        for (Map.Entry<String, MapDefinition> definitionEntry : this.mapDefinitions.entrySet()) {
            String mapID = definitionEntry.getKey();
            MapDefinition definition = definitionEntry.getValue();
            ValueDefinition valueDefinition = this.valueDefinitions.get(mapID);
            if (valueDefinition.isSet || !this.areChildFieldsCompleted(valueDefinition)) continue;
            doContinue = true;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, String> mapFieldEntry : definition.mapFields.entrySet()) {
                map.put(mapFieldEntry.getKey(), this.targetValues.get(mapFieldEntry.getValue()));
            }
            this.targetValues.put(mapID, map);
            valueDefinition.isSet = true;
            valuesToReset.add(mapID);
        }
        return doContinue;
    }

    private boolean setCompletedValuesInLists(List<String> valuesToReset, String resultSetName) {
        boolean doContinue = false;
        for (Map.Entry<String, ListDefinition> definitionEntry : this.listDefinitions.entrySet()) {
            String listID = definitionEntry.getKey();
            ListDefinition definition = definitionEntry.getValue();
            ValueDefinition valueDefinition = this.valueDefinitions.get(listID);
            String childColumnID = valueDefinition.childFieldIDs.get(0);
            if (valuesToReset.contains(listID) || !this.valueDefinitions.get((Object)childColumnID).isSet) continue;
            doContinue = true;
            definition.valueBeingPopulated.add(this.targetValues.get(childColumnID));
            valuesToReset.add(listID);
            if (this.resultSetDefinitions.get((Object)resultSetName).partiallyPopulatedObjectsInResultSetIteration.contains(listID)) continue;
            this.resultSetDefinitions.get((Object)resultSetName).partiallyPopulatedObjectsInResultSetIteration.add(listID);
        }
        return doContinue;
    }

    private boolean setCompletedValuesInComputedValues() {
        boolean doContinue = false;
        for (Map.Entry<String, ComputedValueDefinition> definitionEntry : this.computedValueDefinitions.entrySet()) {
            String computedValueID = definitionEntry.getKey();
            ComputedValueDefinition definition = definitionEntry.getValue();
            ValueDefinition valueDefinition = this.valueDefinitions.get(computedValueID);
            if (valueDefinition.isSet || !this.areChildFieldsCompleted(valueDefinition)) continue;
            doContinue = true;
            this.targetValues.put(computedValueID, definition.function.apply(this.targetValues));
            valueDefinition.isSet = true;
        }
        return doContinue;
    }

    private void setCompletedValues(String resultSetName) throws EngineExceptionI {
        boolean doContinue = true;
        ArrayList<String> valuesToReset = new ArrayList<String>();
        while (doContinue) {
            doContinue = this.setCompletedValuesInPreparedStatements(valuesToReset);
            doContinue = this.setCompletedValuesInMaps(valuesToReset) || doContinue;
            doContinue = this.setCompletedValuesInComputedValues() || doContinue;
            boolean bl = doContinue = this.setCompletedValuesInLists(valuesToReset, resultSetName) || doContinue;
        }
        for (String valueToReset : valuesToReset) {
            this.resetValues(valueToReset, resultSetName);
        }
    }

    private void fillValues(String resultSetName) throws EngineExceptionI {
        ResultSet resultSet = this.resultSetDefinitions.get((Object)resultSetName).resultSet;
        Map<String, ICellReader<ResultSet>> requiredCellReaders = this.resultSetDefinitions.get((Object)resultSetName).cellReaders;
        if (requiredCellReaders != null) {
            for (Map.Entry<String, ICellReader<ResultSet>> entry : requiredCellReaders.entrySet()) {
                try {
                    this.targetValues.put(entry.getKey(), entry.getValue().read((Object)resultSet));
                }
                catch (Exception e) {
                    throw new EngineExceptionI((Throwable)e);
                }
                this.valueDefinitions.get((Object)entry.getKey()).isSet = true;
            }
        }
    }

    private void resetValues(String targetFieldID, String resultSetName) {
        if (!this.valueDefinitions.get((Object)targetFieldID).childFieldIDs.isEmpty() || this.resultSetDefinitions.get((Object)resultSetName).cellReaders.containsKey(targetFieldID)) {
            this.targetValues.put(targetFieldID, null);
            this.valueDefinitions.get((Object)targetFieldID).isSet = false;
            for (String childID : this.valueDefinitions.get((Object)targetFieldID).childFieldIDs) {
                this.resetValues(childID, resultSetName);
            }
        }
    }

    public void declareResultSetKeyNames(String id, List<String> listOfColumnNames) throws EngineExceptionI {
        if (!this.resultSetDefinitions.containsKey(id)) {
            throw new EngineExceptionI("Unknown Input ResultSet");
        }
        this.resultSetDefinitions.get((Object)id).keys = listOfColumnNames;
    }

    public void declareResultSetValue(String targetFieldUniqueId, String sourceResultSet, String sourceField) throws EngineExceptionI {
        ICellReader cellReader;
        int sourceType;
        int sourceColumnIndex;
        if (!this.resultSetDefinitions.containsKey(sourceResultSet)) {
            throw new EngineExceptionI("Unknown Input ResultSet");
        }
        this.declareTargetId(targetFieldUniqueId);
        ResultSet resultSet = this.resultSetDefinitions.get((Object)sourceResultSet).resultSet;
        try {
            sourceColumnIndex = resultSet.findColumn(sourceField);
            sourceType = resultSet.getMetaData().getColumnType(sourceColumnIndex);
        }
        catch (SQLException e) {
            throw new EngineExceptionI((Throwable)e);
        }
        CellMapProperties mapProperties = new CellMapProperties();
        mapProperties.sourceIndex = sourceColumnIndex;
        mapProperties.sourceName = sourceField;
        mapProperties.sourceType = sourceType;
        mapProperties.targetType = sourceType;
        JdbcReaderProperties props = new JdbcReaderProperties();
        props.setDateAsTimestamp(this.dateAsTimestamp);
        try {
            cellReader = JdbcConverter.getResultSetCellReader((CellMapProperties)mapProperties, (JdbcReaderProperties)props);
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        this.resultSetDefinitions.get((Object)sourceResultSet).cellReaders.put(targetFieldUniqueId, (ICellReader<ResultSet>)cellReader);
        this.valueDefinitions.put(targetFieldUniqueId, new ValueDefinition(sourceType));
    }

    private void declareTargetId(String targetFieldUniqueId) throws EngineExceptionI {
        if (this.targetIds.contains(targetFieldUniqueId)) {
            throw new EngineExceptionI("TargetID already exists");
        }
        this.targetIds.add(targetFieldUniqueId);
    }

    private void declareOutputObject(String targetFieldUniqueId) throws EngineExceptionI {
        this.declareTargetId(targetFieldUniqueId);
        this.valueDefinitions.put(targetFieldUniqueId, new ValueDefinition(2000));
    }

    public void declarePreparedStatement(String targetFieldUniqueId) throws EngineExceptionI {
        this.declareOutputObject(targetFieldUniqueId);
        this.preparedStatementDefinitions.put(targetFieldUniqueId, new PreparedStatementDefinition(targetFieldUniqueId));
    }

    public void declareMap(String targetFieldUniqueId) throws EngineExceptionI {
        this.declareOutputObject(targetFieldUniqueId);
        this.mapDefinitions.put(targetFieldUniqueId, new MapDefinition());
    }

    public void declareMapField(String targetFieldUniqueId, String mapName, String fieldName) throws EngineExceptionI {
        if (!this.mapDefinitions.containsKey(mapName)) {
            throw new EngineExceptionI("Unknown Map");
        }
        this.mapDefinitions.get((Object)mapName).mapFields.put(fieldName, targetFieldUniqueId);
        this.valueDefinitions.get((Object)mapName).childFieldIDs.add(targetFieldUniqueId);
    }

    public void declareList(String targetFieldUniqueId) throws EngineExceptionI {
        this.declareOutputObject(targetFieldUniqueId);
        this.listDefinitions.put(targetFieldUniqueId, new ListDefinition());
    }

    public void declareListField(String targetFieldUniqueId, String listName) throws EngineExceptionI {
        if (!this.listDefinitions.containsKey(listName)) {
            throw new EngineExceptionI("Unknown List");
        }
        this.valueDefinitions.get((Object)listName).childFieldIDs.add(targetFieldUniqueId);
    }

    public void configureManageDateAsTimestamp(boolean dateAsTimestamp) {
        this.dateAsTimestamp = dateAsTimestamp;
    }

    public void configureBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void declareComputedValue(String targetFieldUniqueId, List<String> requiredValues, Function<Map<String, Object>, ?> function, int jdbcType) throws EngineExceptionI {
        if (requiredValues == null || requiredValues.isEmpty()) {
            throw new EngineExceptionI("Required Values List cannot be empty");
        }
        this.declareOutputObject(targetFieldUniqueId);
        this.computedValueDefinitions.put(targetFieldUniqueId, new ComputedValueDefinition(function));
        this.valueDefinitions.put(targetFieldUniqueId, new ValueDefinition(jdbcType));
        this.valueDefinitions.get((Object)targetFieldUniqueId).childFieldIDs = requiredValues;
    }

    public void configureCompareKeysByHomonymy(boolean compareKeysByHomonymy) {
        this.keysAreOrdered = !compareKeysByHomonymy;
    }

    private class ComputedValueDefinition {
        Function<Map<String, Object>, ?> function;

        public ComputedValueDefinition(Function<Map<String, Object>, ?> function) {
            this.function = function;
        }
    }

    private class ListDefinition {
        List<Object> valueBeingPopulated = new ArrayList<Object>();

        private ListDefinition() {
        }
    }

    private class MapDefinition {
        Map<String, String> mapFields = new LinkedHashMap<String, String>();

        private MapDefinition() {
        }
    }

    private class PreparedStatementDefinition {
        private IPreparedStatementToResultSet preparedStatement;
        private Map<String, ICellWriter<PreparedStatement>> cellWriters = new HashMap<String, ICellWriter<PreparedStatement>>();
        int rowCount = 0;

        public PreparedStatementDefinition(String targetFieldUniqueId) throws EngineExceptionI {
            try {
                this.preparedStatement = new JdbcPreparedStatementToResultSet();
                NamedResultSetsProcessor.this.__ctx__.getNamedObjectManager().setObject(targetFieldUniqueId, (Object)this.preparedStatement);
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
    }

    private class ResultSetDefinition {
        private ResultSet resultSet;
        private String id;
        private List<String> keys = new ArrayList<String>();
        private boolean isHeld = false;
        private boolean isRoot;
        private List<ResultSetDefinition> childResultSets = new ArrayList<ResultSetDefinition>();
        private ResultSetDefinition parentResultSet;
        private Map<String, ICellReader<ResultSet>> cellReaders = new HashMap<String, ICellReader<ResultSet>>();
        private List<String> partiallyPopulatedObjectsInResultSetIteration = new ArrayList<String>();
        private IResultSetsKeyPairComparator comparator;

        public ResultSetDefinition(String resultSetID, String parentResultSetID) throws EngineExceptionI {
            try {
                ResultSet foundResultSet;
                this.id = resultSetID;
                Object namedObject = NamedResultSetsProcessor.this.__ctx__.getNamedObjectManager().waitObject(resultSetID);
                if (namedObject == null) {
                    throw new EngineExceptionI("Expected ResultSet is null");
                }
                if (!(namedObject instanceof ResultSet)) {
                    throw new EngineExceptionI("NamedObject is not a java.sql.ResultSet");
                }
                this.resultSet = foundResultSet = (ResultSet)namedObject;
                NamedResultSetsProcessor.this.__ctx__.getNamedObjectManager().setReady(resultSetID);
                if (parentResultSetID != null) {
                    this.isRoot = false;
                    if (!NamedResultSetsProcessor.this.resultSetDefinitions.containsKey(parentResultSetID)) {
                        throw new EngineExceptionI("Parent InputResultSet has not been declared");
                    }
                    this.parentResultSet = NamedResultSetsProcessor.this.resultSetDefinitions.get(parentResultSetID);
                    this.parentResultSet.childResultSets.add(this);
                } else {
                    this.isRoot = true;
                }
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }
    }

    private class ValueDefinition {
        private int jdbcType;
        private boolean isSet = false;
        List<String> childFieldIDs = new ArrayList<String>();

        public ValueDefinition(int jdbcType) {
            this.jdbcType = jdbcType;
        }
    }
}

