/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine;

import com.indy.a.PasswordManagerI;
import com.indy.engine.DebugLogI;
import com.indy.engine.EngineServerI;
import com.indy.engine.Messages;
import com.indy.engine.StartDelivery;
import com.indy.engine.VariableResolver;
import com.indy.engine.common.action.ActionConfiguration;
import com.indy.engine.common.jvm.JavaConfiguration;
import com.indy.engine.common.keystore.KeyStoreConfiguration;
import com.indy.engine.common.security.SecurityConfiguration;
import com.indy.engine.core.ISessionContext;
import com.indy.engine.core.RuntimeContext;
import com.indy.engine.core.common.XPathAPI;
import com.indy.engine.core.externalvalueresolver.ExternalValueResolverManager;
import com.indy.engine.core.manager.IActionContext;
import com.indy.engine.main.MainEngineI;
import com.indy.engine.main.listener.impl.EventManager;
import com.indy.engine.main.repository.IDeliveryRepository;
import com.indy.engine.main.repository.impl.FileRepository;
import com.indy.engine.main.repository.internal.DeliveryRepository;
import com.indy.engine.main.repository.internal.RepositoryManager;
import com.indy.engine.main.scripting.ScriptManagerI;
import com.indy.engine.shared.configuration.VariableHandler;
import com.indy.engine.shared.configuration.repository.AbstractRepositoryBean;
import com.indy.engine.shared.configuration.repository.DefaultRepositoryPluginConfiguration;
import com.indy.engine.shared.plugin.IPluginFactory;
import com.indy.engine.userLog.EmptyUserLog;
import com.indy.engine.wsdl.InvocationCommon;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import com.semarchy.xdi.engine.common.exceptions.OtherExceptionI;
import com.semarchy.xdi.runtime.xdg.HarvesterManager;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Global {
    public static final int DATABASE_HEALTH_CONNECTION_TIMEOUT = 60;
    public static String comIndyEngineConsoleLogger = "com.indy.engine.console";
    @Deprecated
    public static String comIndyEngineMainConsoleLogger = "com.indy.engine.main.console";
    public static String comIndyEngineUserConsoleLogger = "com.indy.engine.user.console";
    public static String comIndyEngineMainLogger = "com.indy.engine.main";
    public static String comIndyEngineWsdlLogger = "com.indy.engine.wsdl";
    public static String comIndyEngineActionCodes = "com.indy.engine.actionCodes";
    public static String comIndyEngineActions = "com.indy.engine.actions";
    public static String comIndyEngineSchedulerLogger = "org.quartz";
    public static final String comIndyEngineMemoryLogger = "com.indy.engine.memory";
    private static final Logger consoleLogger = LogManager.getLogger((String)comIndyEngineConsoleLogger);
    static final Logger userConsoleLogger = LogManager.getLogger((String)comIndyEngineUserConsoleLogger);
    public static String[] args;
    public static DebugLogI dLog;
    public static String XMLNS_SCEN;
    public static String REPOSITORY_CACHE_FOLDER;
    public static String DELIVERY_FOLDER;
    public static String DELIVERY_EXTENSION;
    public static String SESSION_FOLDER;
    public static String TEMPORARY_FOLDER;
    public static String VAR_PREFIXE;
    public static String SESSION_MAIN_PREFIXE;
    public static Integer DEFAULT_FETCH_SIZE;
    public static Integer DEFAULT_BATCH_SIZE;
    public static int DEFAULT_SESSION_REPORT_NUMBER;
    public static int DEFAULT_SESSION_LOG_LEVEL;
    public static boolean DEFAULT_CHILD_SESSION_LOG_LEVEL_INHERITANCE;
    public static int DEFAULT_SESSION_LOG_LEVEL_VALUE;
    public static int INHERIT_FROM_PARENT_SESSION_LOG_LEVEL_VALUE;
    public static boolean launchSchedulerEngine;
    public static boolean launchExecutionEngine;
    public static int DEFAULT_JDBC_RETRY_NB;
    public static long DEFAULT_JDBC_RETRY_DELAY;
    public static int DEFAULT_JDBC_CONN_TIMEOUT;
    public static int DEFAULT_JDBC_QUERY_TIMEOUT;
    public static final String ACTION_TYPE_CODE = "Code";
    public static final String ACTION_TYPE_PROCESS = "Process";
    public static final int USERLOG_MANAGER_CONNECTED = 1;
    public static final int USERLOG_MANAGER_NOT_CONNECTED = -1;
    public static final int REPORTLOG_NOTLOADED = 0;
    public static final int REPORTLOG_LOADED = 1;
    public static final int REPORTLOG_LOADING = 2;
    public static final int REPORTLOG_ERROR = -1;
    public static final int CONDITION_NEVER_TESTED = 0;
    public static final int CONDITION_TESTED = 1;
    public static final int CONDITION_ERROR = -1;
    public static final String TECH_OBJECT_START_DELIMITER = "\"";
    public static final String TECH_OBJECT_END_DELIMITER = "\"";
    public static final String VARIABLE_PATH_SEPARATOR = "/";
    public static final String VARIABLE_PATH_SUFFIXE = "/";
    public static final String LOG_FILENAME_SEPARATOR = "_";
    public static final String LOG_SESSIONID_CONCAT_CHAR = "_";
    public static final String RDBMS_CLOB_TYPE = "CLOB";
    public static String RDBMS_BLOB_TYPE;
    public static final String RDBMS_NUMERIC_TYPE = "NUMERIC";
    public static final String RDBMS_VARCHAR_TYPE = "VARCHAR";
    public static final String RDBMS_LOG_TABLE_PREFIX = "STB_LOG_";
    public static Locale locale;
    public static ResourceBundle userParametersBundle;
    public static ResourceBundle internalBundle;
    public static long MEMORY_LOG_SCAN_DELAY;
    public static String HTTP_HOST;
    public static Integer HTTP_PORT;
    public static String USERLOG_DEFAULT_NAME;
    public static String USERLOG_CLASS_NAME;
    public static String GLOBAL_DATE_FORMAT;
    public static String GLOBAL_MAX_DATE;
    public static String XML_DEFAULT_ENGINE_REPOSITORY;
    public static String XML_ENGINE_REPOSITORY;
    static boolean useDebugLogFile;
    static String debugLogFile;
    static int debugLevel;
    static String debugMode;
    static String debugCarriageReturn;
    public static String wsdlFilePath;
    public static String javaExtensionpath;
    private static Logger actionCodeLogger;
    public static String comIndyEngineRdbmsLogger;
    public static String comIndyEngineRdbms;
    private static Logger actionLogger;
    public static boolean internalActivateHttpRuntime;
    public static boolean enableAccessRestrictionOverHTTP;
    private static HarvesterManager xdgHarvester;
    static Map<String, Map<String, String>> allLogParameters;
    public static Boolean stackTraceOnStdOutput;
    public static Boolean statisticsOnStdOutput;
    public static List<String> sumVariables;
    public static InvocationCommon.KeepMessageStrategy webServiceKeepInputMessage;
    public static InvocationCommon.KeepMessageStrategy webServiceKeepOutputMessage;
    public static InvocationCommon.KeepMessageStrategy webServiceKeepFaultMessage;
    public static String soapServerThreadPoolSize;
    private static IDeliveryRepository defaultRepository;
    private static IDeliveryRepository defaultWsdlRepository;
    public static String webServiceHttpsKeyStoreFile;
    public static String webServiceHttpsKeyStoreType;
    public static String webServiceHttpsKeyStorePassword;
    public static String webServiceHttpsKeyPassword;
    public static String webServiceSecureProtocolType;
    public static String webServiceHttpsKeyStoreAlias;
    public static final String LOG_DEBUG = "DEBUG";
    public static final String LOG_INFO = "INFO";
    public static final String LOG_ERROR = "ERROR";
    public static final String LOG_WARNING = "WARNING";
    public static final int LOG_LEVEL0 = 0;
    public static final int LOG_LEVEL1 = 1;
    public static final int LOG_LEVEL2 = 2;
    public static final int LOG_LEVEL3 = 3;
    public static final int LOG_LEVEL4 = 4;
    public static final int LOG_LEVEL5 = 5;
    public static final int LOG_LEVEL6 = 6;
    public static final int LOG_LEVEL7 = 7;
    public static final int LOG_LEVEL8 = 8;
    public static final int LOG_LEVEL9 = 9;
    public static final String RDBMS_QUERY_DATE;
    private static ResourceBundle versionsBundle;
    private static String apiVersion;
    private static String commandVersion;
    static String preTimeStamp;
    public static EngineServerI engineServer;
    public static boolean commandLine;
    public static boolean onlylogupdate;
    public static int logRetryNumber;
    public static boolean startInternalDbOverride;
    private static InetAddress localHost;
    private static InetAddress loopbackAddress;
    private static boolean isRandomSecure;
    private static boolean activedeliverydocumentcloning;
    static List<EventManager.EventManagerLoader> eventsManagers;
    static SecurityConfiguration userConfiguration;
    static JavaConfiguration javaConfiguration;
    static Map<String, IDeliveryRepository> repositoryManagers;
    public static RuntimeContext runtimeContext;

    static {
        REPOSITORY_CACHE_FOLDER = "build/cache/repository";
        DELIVERY_FOLDER = "build/deliveries";
        DELIVERY_EXTENSION = "deliv";
        SESSION_FOLDER = "";
        TEMPORARY_FOLDER = "temp";
        DEFAULT_FETCH_SIZE = 1000;
        DEFAULT_BATCH_SIZE = 1000;
        DEFAULT_SESSION_REPORT_NUMBER = 10;
        DEFAULT_SESSION_LOG_LEVEL = MainEngineI.noLogLevel;
        DEFAULT_CHILD_SESSION_LOG_LEVEL_INHERITANCE = true;
        DEFAULT_SESSION_LOG_LEVEL_VALUE = -2;
        INHERIT_FROM_PARENT_SESSION_LOG_LEVEL_VALUE = -3;
        launchSchedulerEngine = false;
        launchExecutionEngine = true;
        DEFAULT_JDBC_RETRY_NB = 0;
        DEFAULT_JDBC_RETRY_DELAY = 1000L;
        DEFAULT_JDBC_CONN_TIMEOUT = 30;
        DEFAULT_JDBC_QUERY_TIMEOUT = 30;
        RDBMS_BLOB_TYPE = "BLOB";
        locale = Locale.getDefault();
        MEMORY_LOG_SCAN_DELAY = 10000L;
        HTTP_HOST = "";
        HTTP_PORT = 42200;
        USERLOG_DEFAULT_NAME = "";
        USERLOG_CLASS_NAME = "";
        GLOBAL_DATE_FORMAT = "yyyy/MM/dd HH:mm:ss.SSS";
        GLOBAL_MAX_DATE = "9999/99/99 99:99:99";
        XML_ENGINE_REPOSITORY = XML_DEFAULT_ENGINE_REPOSITORY = "properties/engineParameters.xml";
        useDebugLogFile = true;
        debugLogFile = "log/com.indy.engine.log";
        debugLevel = 0;
        debugMode = "INFO & DEBUG & ERROR & WARNING";
        debugCarriageReturn = System.getProperty("line.separator");
        comIndyEngineRdbmsLogger = "com.indy.engine.rdbmsLog";
        comIndyEngineRdbms = "com.indy.engine.jdbc";
        internalActivateHttpRuntime = true;
        enableAccessRestrictionOverHTTP = false;
        stackTraceOnStdOutput = true;
        statisticsOnStdOutput = true;
        webServiceKeepInputMessage = InvocationCommon.KeepMessageStrategy.if_error;
        webServiceKeepOutputMessage = InvocationCommon.KeepMessageStrategy.if_error;
        webServiceKeepFaultMessage = InvocationCommon.KeepMessageStrategy.if_error;
        RDBMS_QUERY_DATE = null;
        preTimeStamp = "";
        commandLine = false;
        logRetryNumber = 5;
        startInternalDbOverride = false;
        isRandomSecure = false;
        activedeliverydocumentcloning = false;
        eventsManagers = new ArrayList<EventManager.EventManagerLoader>();
        userConfiguration = null;
        javaConfiguration = null;
        repositoryManagers = new HashMap<String, IDeliveryRepository>();
    }

    public static Logger getLogger() {
        return Global.dLog.logger;
    }

    public static Logger getConsoleLogger() {
        return consoleLogger;
    }

    public static void printParametersToDebugLog() {
        Object str = "";
        str = (String)str + Global.dLog.carriageReturn + "--> defaultBatchSize :" + String.valueOf(DEFAULT_BATCH_SIZE);
        str = (String)str + Global.dLog.carriageReturn + "--> defaultFetchSize :" + String.valueOf(DEFAULT_FETCH_SIZE);
        str = (String)str + Global.dLog.carriageReturn + "--> deliveryExtension :" + DELIVERY_EXTENSION;
        str = (String)str + Global.dLog.carriageReturn + "--> deliveryFolder :" + DELIVERY_FOLDER;
        str = (String)str + Global.dLog.carriageReturn + "--> memoryLogScanDelay :" + MEMORY_LOG_SCAN_DELAY;
        str = (String)str + Global.dLog.carriageReturn + "--> sessionFolder :" + SESSION_FOLDER;
        str = (String)str + Global.dLog.carriageReturn + "--> userLogDefaultName :" + USERLOG_DEFAULT_NAME;
        str = (String)str + Global.dLog.carriageReturn + "Debug informations : " + Global.dLog.logLevel;
        str = (String)str + Global.dLog.carriageReturn + "--> logLevel :" + Global.dLog.logLevel;
        str = (String)str + Global.dLog.carriageReturn + "--> logMode :" + Global.dLog.logMode;
        dLog.write("Init", "Global->printParametersToDebugLog", (String)str, 0, 0, LOG_INFO);
    }

    public static int InitRessources(boolean sessMode) throws EngineExceptionI {
        File f;
        int ret = 0;
        if (XML_ENGINE_REPOSITORY.equals(XML_DEFAULT_ENGINE_REPOSITORY) && (f = new File("properties/repository.xml")).exists()) {
            XML_ENGINE_REPOSITORY = "properties/repository.xml";
        }
        try {
            Map<Document, File> docs = Util.getAllDocument(new File(XML_ENGINE_REPOSITORY));
            Global.initRepositories();
            Global.getLstParametersInRepository(docs);
            ExternalValueResolverManager.instance().init(XML_ENGINE_REPOSITORY);
            allLogParameters = Util.getLogsParametersInRepository(docs);
            ret = Global.CreateDebugLog();
            ret = 0;
            actionCodeLogger = LogManager.getLogger((String)comIndyEngineActionCodes);
            actionLogger = LogManager.getLogger((String)comIndyEngineActions);
        }
        catch (EngineExceptionI e) {
            if (dLog == null) {
                e.printStackTrace();
            } else {
                dLog.write("Init", "Global->getLstParametersInRepository", "Exception  : " + e.getMessage(), 0, 0, LOG_ERROR);
            }
            throw e;
        }
        catch (Exception e) {
            if (dLog == null) {
                e.printStackTrace();
            } else {
                dLog.write("Init", "Global->getLstParametersInRepository", "Exception  : " + e.getMessage(), 0, 0, LOG_ERROR);
            }
            throw new EngineExceptionI("Exception in getLstParametersInRepository", (Throwable)e);
        }
        if (ret != -1) {
            ret = Global.InitInternalRessources();
        }
        if (ret != -1) {
            Global.printParametersToDebugLog();
        }
        f = new File(TEMPORARY_FOLDER);
        try {
            f.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Global.initRuntimeContext();
        return ret;
    }

    public static Logger getActionLogger() {
        return actionLogger;
    }

    public static Logger getActionCodeLogger() {
        return actionCodeLogger;
    }

    static int InitInternalRessources() {
        int ret = 0;
        VAR_PREFIXE = "";
        try {
            internalBundle = ResourceBundle.getBundle("internalResources", locale);
            try {
                VAR_PREFIXE = internalBundle.getString("VAR_PREFIXE");
            }
            catch (NullPointerException e) {
                dLog.write("Init", "Global->InitInternalRessources", e.getMessage(), 0, 0, LOG_WARNING);
            }
            catch (MissingResourceException e) {
                dLog.write("Init", "Global->InitInternalRessources", e.getMessage(), 0, 0, LOG_WARNING);
            }
            catch (Exception e) {
                dLog.write("Init", "Global->InitInternalRessources", e.getMessage(), 0, 0, LOG_WARNING);
            }
            XMLNS_SCEN = internalBundle.getString("XMLNS_SCEN");
            SESSION_MAIN_PREFIXE = internalBundle.getString("SESSION_MAIN_PREFIXE");
        }
        catch (NullPointerException e) {
            System.out.println(e.getMessage());
            dLog.write("Init", "Global->InitInternalRessources", e.getMessage(), 0, 0, LOG_ERROR);
            return -1;
        }
        catch (MissingResourceException e) {
            System.out.println(e.getMessage());
            dLog.write("Init", "Global->InitInternalRessources", e.getMessage(), 0, 0, LOG_ERROR);
            return -1;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            dLog.write("Init", "Global->InitInternalRessources", e.getMessage(), 0, 0, LOG_ERROR);
            return -1;
        }
        return ret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initRepositories() throws EngineExceptionI {
        RepositoryManager rm = null;
        try {
            rm = new RepositoryManager();
        }
        catch (Exception ex) {
            throw new EngineExceptionI("Failed to initialize repositories", (Throwable)ex);
        }
        Iterator<IDeliveryRepository> it = rm.getRepositories();
        while (it.hasNext()) {
            IDeliveryRepository repo = it.next();
            if (repo.isDefault() && !repo.isWebservice()) {
                if (defaultRepository != null) throw new EngineExceptionI("Error, there is already a default repository: " + defaultRepository.getName() + ", impossible to add repo: " + repo.getName());
                defaultRepository = repo;
            } else if (repo.getName().equals("__default__")) {
                throw new EngineExceptionI("Error \"__default__\" (reserved word) repository must be the default repository");
            }
            String repositoryName = repo.getName();
            if (repositoryManagers.get(repositoryName) != null) {
                throw new EngineExceptionI("Error repository: " + repo.getName() + " already exists");
            }
            if (repositoryName.equals("webservices")) {
                if (defaultWsdlRepository != null) throw new EngineExceptionI("Error : There can't be two webservice repository.");
                if (!repo.isDefault()) {
                    throw new EngineExceptionI("Error \"" + repositoryName + "\" (reserved word) repository must be the default web service repository");
                }
                defaultWsdlRepository = repo;
            } else if (repo.isWebservice()) {
                if (defaultWsdlRepository != null) throw new EngineExceptionI("Error : There can't be two webservice repository.");
                if (!repo.isDefault()) {
                    throw new EngineExceptionI("Error webservice repository must be the default repository");
                }
                defaultWsdlRepository = repo;
            }
            repositoryManagers.put(repo.getName(), repo);
        }
        if (defaultRepository == null) {
            String name = "default";
            if (repositoryManagers.get("default") != null) {
                name = "__default__";
            }
            DefaultRepositoryPluginConfiguration conf = new DefaultRepositoryPluginConfiguration(DELIVERY_FOLDER, null, false, 0, AbstractRepositoryBean.ScanMode.direct, false, true, name);
            FileRepository deliveryRepositoryPlugin = new FileRepository((IPluginFactory.IPluginConfiguration)conf, null);
            defaultRepository = new DeliveryRepository(DELIVERY_FOLDER, false, deliveryRepositoryPlugin);
            repositoryManagers.put(name, defaultRepository);
        }
        if (defaultWsdlRepository != null) return;
        DefaultRepositoryPluginConfiguration conf = new DefaultRepositoryPluginConfiguration(DELIVERY_FOLDER + File.separator + "webservices", null, false, 0, AbstractRepositoryBean.ScanMode.direct, false, true, "webservices");
        FileRepository deliveryRepositoryPlugin = new FileRepository((IPluginFactory.IPluginConfiguration)conf, null);
        defaultWsdlRepository = new DeliveryRepository(null, false, deliveryRepositoryPlugin);
        repositoryManagers.put("webservices", defaultWsdlRepository);
    }

    private static int getLstParametersInRepository(Map<Document, File> docs) throws EngineExceptionI {
        int ret = 0;
        try {
            String[] current;
            Node nodeParameters;
            int i;
            NodeList nlLogs;
            for (Document doc : docs.keySet()) {
                nlLogs = XPathAPI.selectNodeList((Node)doc, (String)"/*/keystores");
                i = 0;
                while (i < nlLogs.getLength()) {
                    try {
                        NodeList nlLogsIn = XPathAPI.selectNodeList((Node)doc, (String)"/*/keystores/keystore");
                        if (i == 1) {
                            throw new EngineExceptionI("Error impossible to add more than one keystores node");
                        }
                        int j = 0;
                        while (j < nlLogsIn.getLength()) {
                            nodeParameters = nlLogsIn.item(j);
                            Node fileAttr = nodeParameters.getAttributes().getNamedItem("file");
                            try {
                                KeyStoreConfiguration.KeyStoreDefinition ksd;
                                if (fileAttr != null && fileAttr.getNodeValue() != null && !fileAttr.getNodeValue().isEmpty()) {
                                    File base = docs.get(doc);
                                    current = new File(base.getParentFile(), fileAttr.getNodeValue());
                                    ksd = KeyStoreConfiguration.getKeyStoreDefinition((File)new File(current.getAbsolutePath()));
                                } else {
                                    ksd = KeyStoreConfiguration.getKeyStoreDefinition((Node)nodeParameters);
                                }
                                ksd.init();
                                ksd.initKeyStore();
                            }
                            catch (Exception e) {
                                throw new EngineExceptionI("Error while initializing keystores: " + e.getMessage());
                            }
                            ++j;
                        }
                    }
                    catch (Exception e) {
                        Global.getConsoleLogger().error("Runtime Configuration Error", (Throwable)e);
                    }
                    ++i;
                }
            }
            for (Document doc : docs.keySet()) {
                File current2;
                File base;
                Node fileAttr;
                nlLogs = XPathAPI.selectNodeList((Node)doc, (String)"/*/events");
                i = 0;
                while (i < nlLogs.getLength()) {
                    nodeParameters = nlLogs.item(i);
                    fileAttr = nodeParameters.getAttributes().getNamedItem("file");
                    EventManager.EventManagerLoader eml = null;
                    if (fileAttr != null && fileAttr.getNodeValue() != null && !fileAttr.getNodeValue().isEmpty()) {
                        base = docs.get(doc);
                        File current3 = new File(base.getParentFile(), fileAttr.getNodeValue());
                        eml = new EventManager.EventManagerLoader(new File(current3.getAbsolutePath()));
                    } else {
                        eml = new EventManager.EventManagerLoader(nodeParameters);
                    }
                    eventsManagers.add(eml);
                    ++i;
                }
                nlLogs = XPathAPI.selectNodeList((Node)doc, (String)"/*/javaConfiguration");
                i = 0;
                while (i < nlLogs.getLength()) {
                    if (i == 1) {
                        throw new EngineExceptionI("Error impossible to add more than on javaConfiguration node");
                    }
                    nodeParameters = nlLogs.item(i);
                    fileAttr = nodeParameters.getAttributes().getNamedItem("file");
                    if (fileAttr != null && fileAttr.getNodeValue() != null && !fileAttr.getNodeValue().isEmpty()) {
                        File base2 = docs.get(doc);
                        current2 = new File(base2.getParentFile(), fileAttr.getNodeValue());
                        javaConfiguration = JavaConfiguration.getJavaConfiguration((File)new File(current2.getAbsolutePath()));
                    } else {
                        javaConfiguration = JavaConfiguration.getJavaConfiguration((Node)nodeParameters);
                    }
                    Global.getConsoleLogger().warn("You are using a deprecated configuration node (javaConfiguration) that will be removed in a future version. You should use the XDI_RUNTIME_OPTS variable instead for adding Java options.");
                    javaConfiguration.configure();
                    ++i;
                }
                nlLogs = XPathAPI.selectNodeList((Node)doc, (String)"/*/actionConfiguration");
                i = 0;
                while (i < nlLogs.getLength()) {
                    ActionConfiguration actionConfiguration;
                    nodeParameters = nlLogs.item(i);
                    fileAttr = nodeParameters.getAttributes().getNamedItem("file");
                    if (fileAttr != null && fileAttr.getNodeValue() != null && !fileAttr.getNodeValue().isEmpty()) {
                        base = docs.get(doc);
                        File current4 = new File(base.getParentFile(), fileAttr.getNodeValue());
                        actionConfiguration = ActionConfiguration.getActionConfiguration((File)new File(current4.getAbsolutePath()));
                    } else {
                        actionConfiguration = ActionConfiguration.getActionConfiguration((Node)nodeParameters);
                    }
                    actionConfiguration.configure();
                    ++i;
                }
                nlLogs = XPathAPI.selectNodeList((Node)doc, (String)"/*/engineParameters/parameter");
                i = 0;
                while (i < nlLogs.getLength()) {
                    block103: {
                        nodeParameters = nlLogs.item(i);
                        if (nodeParameters.getNodeName().equals("parameter")) {
                            NamedNodeMap logParameters = nodeParameters.getAttributes();
                            try {
                                KeyStoreConfiguration.KeyStoreDefinition pwdKsd;
                                String parameterName = logParameters.getNamedItem("name").getNodeValue();
                                String parameterValue = logParameters.getNamedItem("value").getNodeValue();
                                if (parameterName.equals("memoryLogScanDelay")) {
                                    MEMORY_LOG_SCAN_DELAY = Long.valueOf(logParameters.getNamedItem("value").getNodeValue());
                                    break block103;
                                }
                                if (parameterName.equals("temporaryFolder")) {
                                    TEMPORARY_FOLDER = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("sessionFolder")) {
                                    SESSION_FOLDER = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("deliveryFolder")) {
                                    DELIVERY_FOLDER = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("repositoryCacheFolder")) {
                                    REPOSITORY_CACHE_FOLDER = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("deliveryExtension")) {
                                    try {
                                        DELIVERY_EXTENSION = logParameters.getNamedItem("value").getNodeValue();
                                    }
                                    catch (Exception base3) {}
                                    break block103;
                                }
                                if (parameterName.equals("userLogDefaultName")) {
                                    try {
                                        USERLOG_DEFAULT_NAME = logParameters.getNamedItem("value").getNodeValue();
                                    }
                                    catch (Exception base3) {}
                                    break block103;
                                }
                                if (parameterName.equals("defaultFetchSize")) {
                                    try {
                                        DEFAULT_FETCH_SIZE = Integer.valueOf(logParameters.getNamedItem("value").getNodeValue());
                                    }
                                    catch (Exception base3) {}
                                    break block103;
                                }
                                if (parameterName.equals("defaultBatchSize")) {
                                    DEFAULT_BATCH_SIZE = Integer.valueOf(logParameters.getNamedItem("value").getNodeValue());
                                    break block103;
                                }
                                if (parameterName.equals("defaultJdbcConnectionTimeout")) {
                                    DEFAULT_JDBC_CONN_TIMEOUT = Integer.valueOf(logParameters.getNamedItem("value").getNodeValue());
                                    break block103;
                                }
                                if (parameterName.equals("defaultJdbcQueryTimeout")) {
                                    DEFAULT_JDBC_QUERY_TIMEOUT = Integer.valueOf(logParameters.getNamedItem("value").getNodeValue());
                                    break block103;
                                }
                                if (parameterName.equals("launchExecutionEngine")) {
                                    launchExecutionEngine = Boolean.valueOf(logParameters.getNamedItem("value").getNodeValue());
                                    break block103;
                                }
                                if (parameterName.equals("launchSchedulerEngine")) {
                                    launchSchedulerEngine = Boolean.valueOf(logParameters.getNamedItem("value").getNodeValue());
                                    break block103;
                                }
                                if (parameterName.equals("useDebugLogFile")) {
                                    useDebugLogFile = Boolean.valueOf(logParameters.getNamedItem("value").getNodeValue());
                                    break block103;
                                }
                                if (parameterName.equals("debugLogFile")) {
                                    debugLogFile = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("debugLevel")) {
                                    debugLevel = Integer.valueOf(logParameters.getNamedItem("value").getNodeValue());
                                    break block103;
                                }
                                if (parameterName.equals("debugMode")) {
                                    debugMode = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("debugCarriageReturn")) {
                                    debugCarriageReturn = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("defaultSessionReportNumber")) {
                                    DEFAULT_SESSION_REPORT_NUMBER = Integer.valueOf(logParameters.getNamedItem("value").getNodeValue());
                                    break block103;
                                }
                                if (parameterName.equals("httpHost")) {
                                    HTTP_HOST = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("httpServerPort")) {
                                    HTTP_PORT = Integer.parseInt(logParameters.getNamedItem("value").getNodeValue());
                                    break block103;
                                }
                                if (parameterName.equals("wsdlFilePath")) {
                                    wsdlFilePath = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("soapServerThreadPoolSize") || parameterName.equals("concurrentSessionsLimit")) {
                                    soapServerThreadPoolSize = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("webServiceSecureProtocol")) {
                                    webServiceSecureProtocolType = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("webServiceKeyStoreFile")) {
                                    webServiceHttpsKeyStoreFile = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("webServiceKeyStoreType")) {
                                    webServiceHttpsKeyStoreType = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("webServiceKeyStorePassword")) {
                                    webServiceHttpsKeyStorePassword = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("webServiceKeyPassword")) {
                                    webServiceHttpsKeyPassword = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("webServiceKeyAlias")) {
                                    webServiceHttpsKeyStoreAlias = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("javaExtensionpath")) {
                                    javaExtensionpath = logParameters.getNamedItem("value").getNodeValue();
                                    break block103;
                                }
                                if (parameterName.equals("stackTraceOnStdOutput")) {
                                    stackTraceOnStdOutput = Boolean.valueOf(parameterValue);
                                    break block103;
                                }
                                if (parameterName.equals("statisticsOnStdOutput")) {
                                    statisticsOnStdOutput = Boolean.valueOf(parameterValue);
                                    break block103;
                                }
                                if (parameterName.equals("sumVariables")) {
                                    sumVariables = new ArrayList<String>();
                                    current = parameterValue.split("\n|,");
                                    int e = current.length;
                                    int current4 = 0;
                                    while (current4 < e) {
                                        String p = current[current4];
                                        sumVariables.add(p.trim());
                                        ++current4;
                                    }
                                    break block103;
                                }
                                if (parameterName.toLowerCase().equals("activesecurerandomforsessionid")) {
                                    isRandomSecure = Boolean.valueOf(parameterValue);
                                    break block103;
                                }
                                if (parameterName.toLowerCase().equals("activedeliverydocumentcloning")) {
                                    activedeliverydocumentcloning = Boolean.valueOf(parameterValue);
                                    break block103;
                                }
                                if (parameterName.toLowerCase().equals("webserviceinputmessagekeep")) {
                                    webServiceKeepInputMessage = InvocationCommon.KeepMessageStrategy.valueOf(parameterValue);
                                    break block103;
                                }
                                if (parameterName.toLowerCase().equals("webserviceoutputmessagekeep")) {
                                    webServiceKeepOutputMessage = InvocationCommon.KeepMessageStrategy.valueOf(parameterValue);
                                    break block103;
                                }
                                if (parameterName.toLowerCase().equals("webservicefaultmessagekeep")) {
                                    webServiceKeepFaultMessage = InvocationCommon.KeepMessageStrategy.valueOf(parameterValue);
                                    break block103;
                                }
                                if (parameterName.toLowerCase().equals("passwordcipheringkeyname") || parameterName.toLowerCase().equals("globalpasswordcipheringkeyname")) {
                                    pwdKsd = KeyStoreConfiguration.getKeyStore((String)parameterValue);
                                    if (pwdKsd == null) {
                                        throw new Exception("Runtime Configuration Error: error while initializing security: key name cannot be found in any keystore node (please check your configuration)");
                                    }
                                    try {
                                        KeyStore ks = pwdKsd.initKeyStore();
                                        KeyStoreConfiguration.KeyStoreDefinition.Key ksKey = pwdKsd.getKey(parameterValue);
                                        PasswordManagerI newPasswordManager = new PasswordManagerI(ks, ksKey.getAlias(), ksKey.getPassword(), ksKey.getBlockCipherModeOperation());
                                        if (PasswordManagerI.c.equals(PasswordManagerI.a)) {
                                            PasswordManagerI.c = newPasswordManager;
                                        }
                                        PasswordManagerI.a = newPasswordManager;
                                    }
                                    catch (Exception e) {
                                        throw new Exception("Runtime Configuration Error: error while initializing keystores: could not load key");
                                    }
                                    Global.getConsoleLogger().info("Security: Keystore and keys loaded successfully - Specified key will be used");
                                    break block103;
                                }
                                if (parameterName.toLowerCase().equals("deliverypasswordcipheringkeyname")) {
                                    pwdKsd = KeyStoreConfiguration.getKeyStore((String)parameterValue);
                                    if (pwdKsd == null) {
                                        throw new Exception("Runtime Configuration Error: error while initializing security: key name cannot be found in any keystore node (please check your configuration)");
                                    }
                                    try {
                                        KeyStore ks = pwdKsd.initKeyStore();
                                        KeyStoreConfiguration.KeyStoreDefinition.Key ksKey = pwdKsd.getKey(parameterValue);
                                        PasswordManagerI.c = new PasswordManagerI(ks, ksKey.getAlias(), ksKey.getPassword(), ksKey.getBlockCipherModeOperation());
                                    }
                                    catch (Exception e) {
                                        throw new Exception("Runtime Configuration Error: error while initializing keystores: could not load key");
                                    }
                                    Global.getConsoleLogger().info("Security: Keystore and keys loaded successfully - Specified key will be used for deliveries");
                                    break block103;
                                }
                                if (parameterName.toLowerCase().equals("enablehttpclientconnections")) {
                                    internalActivateHttpRuntime = Boolean.valueOf(parameterValue);
                                } else if (parameterName.equals("defaultSessionLogLevel")) {
                                    DEFAULT_SESSION_LOG_LEVEL = Integer.valueOf(logParameters.getNamedItem("value").getNodeValue());
                                } else if (parameterName.equals("defaultChildSessionLogLevelInheritance")) {
                                    DEFAULT_CHILD_SESSION_LOG_LEVEL_INHERITANCE = Boolean.valueOf(parameterValue);
                                } else if (parameterName.equals("enableAccessRestrictionOverHTTP")) {
                                    enableAccessRestrictionOverHTTP = Boolean.valueOf(parameterValue);
                                }
                            }
                            catch (Exception e) {
                                Global.getConsoleLogger().error("Runtime Configuration Error", (Throwable)e);
                            }
                        }
                    }
                    ++i;
                }
                nlLogs = XPathAPI.selectNodeList((Node)doc, (String)"/*/security");
                i = 0;
                while (i < nlLogs.getLength()) {
                    try {
                        if (i == 1) {
                            throw new EngineExceptionI("Error impossible to add more than on security node");
                        }
                        nodeParameters = nlLogs.item(i);
                        fileAttr = nodeParameters.getAttributes().getNamedItem("file");
                        if (fileAttr != null && fileAttr.getNodeValue() != null && !fileAttr.getNodeValue().isEmpty()) {
                            File base4 = docs.get(doc);
                            current2 = new File(base4.getParentFile(), fileAttr.getNodeValue());
                            userConfiguration = SecurityConfiguration.getClientConfiguration((File)new File(current2.getAbsolutePath()));
                        } else {
                            userConfiguration = SecurityConfiguration.getClientConfiguration((Node)nodeParameters);
                        }
                        userConfiguration.init(new SecurityConfiguration.Encrypt(){

                            public String encrypt(String str) throws Throwable {
                                return PasswordManagerI.a.encryptPassword(str);
                            }

                            public String decrypt(String str) throws Throwable {
                                return PasswordManagerI.a.decryptPassword(str);
                            }
                        });
                        if (!enableAccessRestrictionOverHTTP && webServiceSecureProtocolType == null) {
                            if (userConfiguration.getAllowsList() == null || userConfiguration.getAllowsList().isEmpty()) {
                                throw new EngineExceptionI(Messages.getString("Global.2"));
                            }
                            if (!userConfiguration.isAllowLocalhostOnly()) {
                                throw new EngineExceptionI(Messages.getString("Global.3"));
                            }
                        }
                    }
                    catch (Exception e) {
                        Global.getConsoleLogger().error("Runtime Configuration Error", (Throwable)e);
                        throw new Exception("Runtime Configuration Error", e);
                    }
                    ++i;
                }
            }
            if (userConfiguration == null) {
                throw new EngineExceptionI(Messages.getString("Global.1"));
            }
            if (sumVariables == null) {
                sumVariables = new ArrayList<String>();
                sumVariables.add("SQL_NB_ROWS");
                sumVariables.add("SQL_STAT_INSERT");
                sumVariables.add("SQL_STAT_UPDATE");
                sumVariables.add("SQL_STAT_DELETE");
                sumVariables.add("XML_NB_ELEMENTS");
                sumVariables.add("XML_NB_ATTRIBUTES");
                sumVariables.add("OUT_FILE_SIZE");
                sumVariables.add("IN_FILE_SIZE");
                sumVariables.add("XML_NB_TEXTS");
                sumVariables.add("SQL_PK_ROWS");
                sumVariables.add("SQL_CAR_ROWS");
                sumVariables.add("WSDL_NB_DONE");
                sumVariables.add("WSDL_NB_ERROR");
            }
            if (HTTP_HOST.equals("")) {
                HTTP_HOST = Global.getLoopbackAddress().getHostName();
            }
            if (javaExtensionpath == null) {
                javaExtensionpath = "extension/java";
            }
            if (DEFAULT_SESSION_LOG_LEVEL == MainEngineI.noLogLevel) {
                Global.getConsoleLogger().error("Runtime Configuration Error : The logLevel value is not defined or is not an Integer");
                throw new EngineExceptionI("Runtime Configuration Error : The logLevel value is not defined or is not an Integer");
            }
        }
        catch (UnknownHostException e) {
            Logger logger = LogManager.getLogger((String)"com.indy.engine.main");
            logger.error("Global->getLstParametersInRepository", (Throwable)e);
            throw new EngineExceptionI("Exception in getLstParametersInRepository", (Throwable)e);
        }
        catch (Exception e) {
            Logger logger = LogManager.getLogger((String)"com.indy.engine.main");
            logger.error("Global->getLstParametersInRepository", (Throwable)e);
            throw new EngineExceptionI("Exception in getLstParametersInRepository", (Throwable)e);
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int CreateDebugLog() {
        int ret = 0;
        boolean useLogFile = false;
        try {
            useLogFile = useDebugLogFile;
            if (!useLogFile) {
                dLog = new DebugLogI();
                return ret;
            }
            try {
                dLog = new DebugLogI();
            }
            catch (NullPointerException e) {
                System.out.println(e.getMessage());
                return -1;
            }
            catch (MissingResourceException e) {
                System.out.println(e.getMessage());
                return -1;
            }
            try {
                dLog.setMode(debugMode);
            }
            catch (NullPointerException e) {
                dLog.setMode("INFO & DEBUG & ERROR & WARNING");
            }
            catch (MissingResourceException e) {
                dLog.setMode("INFO & DEBUG & ERROR & WARNING");
            }
            try {
                dLog.setLevel(debugLevel);
            }
            catch (NullPointerException e) {
                dLog.setLevel(999);
            }
            catch (MissingResourceException e) {
                dLog.setLevel(999);
            }
            try {
                dLog.setCarriageReturn(debugCarriageReturn);
                return ret;
            }
            catch (MissingResourceException e) {
                dLog.setCarriageReturn(System.getProperty("line.separator"));
                return ret;
            }
        }
        catch (NullPointerException e) {
            System.out.println(e.getMessage());
            return -1;
        }
        catch (MissingResourceException e) {
            System.out.println(e.getMessage());
            return -1;
        }
    }

    public static String getFatherInString(String actionName) {
        return actionName.substring(0, actionName.lastIndexOf("/"));
    }

    public static String getFatherInString(String actionName, int level) {
        if (level >= 0) {
            return actionName;
        }
        int i = 0;
        int levelPos = 0;
        int prevLevelPos = actionName.length();
        while (i != level && levelPos != -1) {
            --i;
            levelPos = actionName.lastIndexOf("/");
            if (levelPos == -1) continue;
            prevLevelPos = levelPos;
        }
        return actionName.substring(0, prevLevelPos);
    }

    public static String resolveVariableName(ISessionContext ctx, String pToResolveVar, String callingVariable) {
        return ctx.resolveVariableName(pToResolveVar, callingVariable);
    }

    public static String transformVariableExpression(String callingVariable, ISessionContext ctx, String vCode) {
        return VariableResolver.resolveVariableExpressions(callingVariable, ctx, vCode);
    }

    public static String transformStringParameter(IActionContext callingAction, String pValue, ISessionContext engineContext, boolean bindMode) throws EngineExceptionI {
        String s;
        try {
            String sValue;
            ScriptManagerI sManager;
            block7: {
                sManager = new ScriptManagerI();
                sValue = null;
                String varExpr = Global.transformVariableExpression(callingAction.getActionName(), engineContext, pValue);
                try {
                    sValue = sManager.executeSubstitutionScript(callingAction, varExpr, "e");
                    if (bindMode) {
                        sValue = sManager.executeSubstitutionScript(callingAction, sValue, "b");
                    }
                    sValue = sManager.executeSubstitutionScript(callingAction, sValue, "s");
                }
                catch (EngineExceptionI e) {
                    if (e.exceptionType == 7 && callingAction.getAllowsScriptingErrors()) break block7;
                    throw new EngineExceptionI((Throwable)e);
                }
            }
            s = sValue;
            sManager = null;
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI("Parameter '" + pValue + "' is null !", (Throwable)e);
        }
        catch (EngineExceptionI e) {
            throw new EngineExceptionI((Throwable)e);
        }
        catch (Exception e) {
            throw new EngineExceptionI((Throwable)e);
        }
        return s;
    }

    private static void load(Map<String, Map<String, String>> lstPropertiesAll, Document doc) throws ParserConfigurationException, SAXException, IOException, TransformerException, XPathFactoryConfigurationException, XPathExpressionException {
        NamedNodeMap logParameters;
        Node nodeParameters;
        NodeList nlParameters;
        NamedNodeMap logAtts;
        Node nodeLog;
        NodeList nlLogs = XPathAPI.selectNodeList((Node)doc, (String)"/*/logs/log");
        int i = 0;
        while (i < nlLogs.getLength()) {
            String enable;
            nodeLog = nlLogs.item(i);
            logAtts = nodeLog.getAttributes();
            String string = enable = logAtts.getNamedItem("enable") != null ? logAtts.getNamedItem("enable").getNodeValue() : null;
            if (enable == null || !enable.equals("false")) {
                String logName = logAtts.getNamedItem("userLogName").getNodeValue();
                if (logAtts.getNamedItem("userLogName").getNodeValue().equals(logName)) {
                    HashMap<String, String> lstProperties = new HashMap<String, String>();
                    lstPropertiesAll.put(logName, lstProperties);
                    lstProperties.put("userLogName", logAtts.getNamedItem("userLogName").getNodeValue());
                    lstProperties.put("userLogClass", logAtts.getNamedItem("userLogClass").getNodeValue());
                    if (logAtts.getNamedItem("synchMode") != null) {
                        lstProperties.put("synchMode", logAtts.getNamedItem("synchMode").getNodeValue());
                    }
                    String autoUpdate = "false";
                    try {
                        autoUpdate = logAtts.getNamedItem("autoUpdate").getNodeValue();
                    }
                    catch (Exception e) {
                        autoUpdate = "false";
                    }
                    lstProperties.put("autoUpdate", autoUpdate);
                    nlParameters = nodeLog.getChildNodes();
                    int j = 0;
                    while (j < nlParameters.getLength()) {
                        nodeParameters = nlParameters.item(j);
                        if (nodeParameters.getNodeName().equals("parameter")) {
                            logParameters = nodeParameters.getAttributes();
                            lstProperties.put(logParameters.getNamedItem("name").getNodeValue(), logParameters.getNamedItem("value").getNodeValue());
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        nlLogs = null;
        nlParameters = null;
        nodeLog = null;
        nodeParameters = null;
        logAtts = null;
        logParameters = null;
    }

    public static Map<String, String> getLstLogParametersInRepository(String logName) throws EngineExceptionI {
        return allLogParameters.get(logName);
    }

    public static Map<String, Map<String, String>> getAllLogParameters() {
        return allLogParameters;
    }

    public static String getRMIApiVersion() {
        if (versionsBundle == null) {
            versionsBundle = ResourceBundle.getBundle("engineVersions", locale);
        }
        try {
            apiVersion = versionsBundle.getString("rmiApiVersion");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return apiVersion;
    }

    public static String getCommandVersion() {
        if (versionsBundle == null) {
            versionsBundle = ResourceBundle.getBundle("engineVersions", locale);
        }
        try {
            commandVersion = versionsBundle.getString("commandVersion");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return commandVersion;
    }

    public static synchronized String getTimestamp() {
        String str = preTimeStamp;
        while (str.equals(preTimeStamp)) {
            str = Long.valueOf(System.currentTimeMillis()).toString();
        }
        preTimeStamp = str;
        return preTimeStamp;
    }

    public static Logger getUserConsoleLogger() {
        return userConsoleLogger;
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        if (localHost == null) {
            localHost = InetAddress.getLocalHost();
        }
        return localHost;
    }

    public static InetAddress getLoopbackAddress() throws UnknownHostException {
        if (loopbackAddress == null) {
            loopbackAddress = InetAddress.getLoopbackAddress();
        }
        return loopbackAddress;
    }

    public static boolean isActivedeliverydocumentcloning() {
        return activedeliverydocumentcloning;
    }

    public static boolean isRandomSecure() {
        return isRandomSecure;
    }

    public static boolean hasUser() {
        return userConfiguration != null && userConfiguration.getUsers() != null && userConfiguration.getUsers().size() > 0;
    }

    public static SecurityConfiguration.User getUser(String name) {
        if (userConfiguration == null) {
            return null;
        }
        return userConfiguration.getUser(name);
    }

    public static SecurityConfiguration.User getAnonymousUser() {
        if (userConfiguration == null) {
            return null;
        }
        return userConfiguration.getAnonymousUser();
    }

    public static SecurityConfiguration getUserConfiguration() {
        return userConfiguration;
    }

    public static Collection<EventManager> getLoadEventsManager() throws JAXBException {
        ArrayList<EventManager> list = new ArrayList<EventManager>();
        for (EventManager.EventManagerLoader loader : eventsManagers) {
            list.add(loader.getEventManager());
        }
        return list;
    }

    public static IDeliveryRepository getRepository(String name) throws EngineExceptionI {
        if (name == null) {
            if (defaultRepository == null) {
                throw new EngineExceptionI("Error there is no default repository");
            }
            return defaultRepository;
        }
        if (name.equals("webservices") || name.equals("wsdl")) {
            if (defaultWsdlRepository == null) {
                throw new EngineExceptionI("Error there is no default webservice repository");
            }
            return defaultWsdlRepository;
        }
        IDeliveryRepository repo = repositoryManagers.get(name);
        if (repo == null) {
            throw new EngineExceptionI("Error there is no repository named: \"" + name + "\"");
        }
        return repo;
    }

    public static String getSessionName() {
        if (StartDelivery.jobname != null) {
            return "." + StartDelivery.jobname;
        }
        if (StartDelivery.sessionName != null) {
            return "." + StartDelivery.sessionName;
        }
        if (StartDelivery.deliveryName != null) {
            return "." + StartDelivery.deliveryName.replace(":", "").replace("/", "_").replace("\\\\", "_");
        }
        return "";
    }

    public static String a(String a, String b) throws OtherExceptionI {
        if (a.equals("b.old")) {
            return PasswordManagerI.b.encryptPassword(b);
        }
        return PasswordManagerI.a.encryptPassword(b);
    }

    public static String b(String a, String b, String c) throws OtherExceptionI {
        if (a.equals("b.old")) {
            try {
                return PasswordManagerI.b.decryptPassword(b);
            }
            catch (Exception e) {
                try {
                    return PasswordManagerI.a.decryptPassword(b);
                }
                catch (Exception e2) {
                    throw e;
                }
            }
        }
        return PasswordManagerI.a.decryptPassword(b);
    }

    public static String c(String a, String b) throws Exception {
        if (b != null && !b.isEmpty()) {
            KeyStoreConfiguration.KeyStoreDefinition pwdKsd = KeyStoreConfiguration.getKeyStore((String)b);
            if (pwdKsd == null) {
                throw new EngineExceptionI("The key \"" + b + "\" could not be found in the runtime's configuration. Please make sure it is properly defined.");
            }
            KeyStore ks = pwdKsd.initKeyStore();
            KeyStoreConfiguration.KeyStoreDefinition.Key ksKey = pwdKsd.getKey(b);
            PasswordManagerI passwordManager = new PasswordManagerI(ks, ksKey.getAlias(), ksKey.getPassword(), ksKey.getBlockCipherModeOperation());
            return passwordManager.encryptPassword(a);
        }
        return PasswordManagerI.a.encryptPassword(a);
    }

    public static List<String> getRemoteHosts() {
        if (userConfiguration != null && userConfiguration.getRemoteHosts() != null) {
            return userConfiguration.getRemoteHosts();
        }
        return Collections.EMPTY_LIST;
    }

    public static Set<String> getRepositories() {
        return repositoryManagers.keySet();
    }

    public static HarvesterManager getXdgHarvestedManager() {
        if (xdgHarvester == null) {
            xdgHarvester = new HarvesterManager();
        }
        return xdgHarvester;
    }

    public static void initRuntimeContext() {
        runtimeContext = new RuntimeContext(){

            public InetAddress getLocalHost() throws UnknownHostException {
                return Global.getLocalHost();
            }
        };
        Global.runtimeContext.comIndyEngineActionCodes = comIndyEngineActionCodes;
        Global.runtimeContext.comIndyEngineRdbms = comIndyEngineRdbms;
        Global.runtimeContext.commandLine = commandLine;
        Global.runtimeContext.DEFAULT_BATCH_SIZE = DEFAULT_BATCH_SIZE;
        Global.runtimeContext.DEFAULT_FETCH_SIZE = DEFAULT_FETCH_SIZE;
        Global.runtimeContext.DEFAULT_JDBC_CONN_TIMEOUT = DEFAULT_JDBC_CONN_TIMEOUT;
        Global.runtimeContext.DEFAULT_JDBC_RETRY_DELAY = DEFAULT_JDBC_RETRY_NB;
        Global.runtimeContext.DEFAULT_JDBC_RETRY_NB = DEFAULT_JDBC_RETRY_NB;
        Global.runtimeContext.DELIVERY_EXTENSION = DELIVERY_EXTENSION;
        Global.runtimeContext.DELIVERY_FOLDER = DELIVERY_FOLDER;
        Global.runtimeContext.GLOBAL_DATE_FORMAT = GLOBAL_DATE_FORMAT;
        Global.runtimeContext.GLOBAL_MAX_DATE = GLOBAL_MAX_DATE;
        Global.runtimeContext.LOG_DEBUG = LOG_DEBUG;
        Global.runtimeContext.LOG_ERROR = LOG_ERROR;
        Global.runtimeContext.LOG_INFO = LOG_INFO;
        Global.runtimeContext.LOG_LEVEL1 = 1;
        Global.runtimeContext.LOG_LEVEL3 = 3;
        Global.runtimeContext.TECH_OBJECT_END_DELIMITER = "\"";
        Global.runtimeContext.TECH_OBJECT_START_DELIMITER = "\"";
        Global.runtimeContext.TEMPORARY_FOLDER = TEMPORARY_FOLDER;
        Global.runtimeContext.VAR_PREFIXE = VAR_PREFIXE;
        Global.runtimeContext.VARIABLE_PATH_SEPARATOR = "/";
        Global.runtimeContext.VARIABLE_PATH_SUFFIXE = "/";
        Global.runtimeContext.XML_ENGINE_REPOSITORY = XML_ENGINE_REPOSITORY;
    }

    static class Util {
        Util() {
        }

        private static Document getDocument(InputStream logInputStream) throws ParserConfigurationException, SAXException, IOException, EngineExceptionI {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(logInputStream);
            Util.updateNode(doc);
            doc.getDocumentElement().normalize();
            return doc;
        }

        private static void updateNode(Node node) throws EngineExceptionI {
            if (!(node instanceof Comment)) {
                NamedNodeMap nnm;
                if (node.getNodeValue() != null && !node.getNodeValue().isEmpty()) {
                    String nodeString = node.getNodeValue();
                    try {
                        String matched = VariableHandler.updateString((String)nodeString);
                        node.setNodeValue(matched);
                    }
                    catch (VariableHandler.VariableResolutionException ex) {
                        throw new EngineExceptionI(ex.getMessage());
                    }
                }
                if ((nnm = node.getAttributes()) != null) {
                    int i = 0;
                    while (i < nnm.getLength()) {
                        Util.updateNode(nnm.item(i));
                        ++i;
                    }
                }
                NodeList nl = node.getChildNodes();
                int i = 0;
                while (i < nl.getLength()) {
                    Util.updateNode(nl.item(i));
                    ++i;
                }
            }
        }

        static Map<Document, File> getAllDocument(File file) throws ParserConfigurationException, SAXException, IOException, TransformerException, XPathFactoryConfigurationException, XPathExpressionException, EngineExceptionI {
            HashMap<Document, File> docs = new HashMap<Document, File>();
            Document doc = null;
            try (FileInputStream is = null;){
                is = new FileInputStream(file);
                doc = Util.getDocument(is);
                docs.put(doc, file);
            }
            NodeList nlLogs = XPathAPI.selectNodeList((Node)doc, (String)"/*/include");
            int i = 0;
            while (i < nlLogs.getLength()) {
                Node nodeLog = nlLogs.item(i);
                NamedNodeMap logAtts = nodeLog.getAttributes();
                Node __file = logAtts.getNamedItem("file");
                if (file != null) {
                    File _file = new File(__file.getNodeValue());
                    if (!_file.isAbsolute()) {
                        File parent = file.getParentFile();
                        _file = new File(parent, __file.getNodeValue());
                    }
                    if (_file.exists()) {
                        docs.putAll(Util.getAllDocument(_file));
                    }
                }
                ++i;
            }
            return docs;
        }

        static Map<String, Map<String, String>> getLogsParametersInRepository(Map<Document, File> docs) throws EngineExceptionI {
            TreeMap<String, Map<String, String>> lstPropertiesAll = new TreeMap<String, Map<String, String>>();
            try {
                for (Document doc : docs.keySet()) {
                    Global.load(lstPropertiesAll, doc);
                }
            }
            catch (Exception e) {
                if (e instanceof EngineExceptionI) {
                    throw (EngineExceptionI)((Object)e);
                }
                throw new EngineExceptionI((Throwable)e);
            }
            if (lstPropertiesAll.isEmpty()) {
                Global.getConsoleLogger().warn("Warning : No log database defined in the runtime configuration.");
                HashMap<String, String> emptyLogProp = new HashMap<String, String>();
                emptyLogProp.put("autoUpdate", "false");
                emptyLogProp.put("userLogName", USERLOG_DEFAULT_NAME);
                emptyLogProp.put("userLogClass", EmptyUserLog.class.getCanonicalName());
                lstPropertiesAll.put(USERLOG_DEFAULT_NAME, emptyLogProp);
            }
            return lstPropertiesAll;
        }
    }
}

