/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.compiler;

import com.indy.engine.Global;
import com.indy.engine.compiler.Messages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

public class CompileAndLoad {
    File dir;
    private Method method;

    public CompileAndLoad(String dir) {
        this.dir = new File(dir);
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            this.method = sysclass.getDeclaredMethod("addURL", URL.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            Global.getConsoleLogger().warn("unexpected", (Throwable)e);
        }
        this.method.setAccessible(true);
    }

    public void compile() {
        this.compileAllFiles(this.dir);
    }

    public void loadClassPath(URLClassLoader classLoader) throws SecurityException, IllegalArgumentException, MalformedURLException, IllegalAccessException, InvocationTargetException {
        this.method.invoke((Object)classLoader, this.dir.toURI().toURL());
    }

    protected void compileAllFiles(File directory) {
        JavaCompiler jc = ToolProvider.getSystemJavaCompiler();
        File[] fileArray = directory.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String path = file.getAbsolutePath();
            if (file.isDirectory()) {
                this.compileAllFiles(file);
            } else if (file.getAbsolutePath().endsWith(".java")) {
                try {
                    String classFileName = file.getAbsolutePath().substring(0, file.getAbsolutePath().lastIndexOf(".java")) + ".class";
                    File classFile = new File(classFileName);
                    if (!classFile.exists() || classFile.lastModified() < file.lastModified()) {
                        if (Global.getConsoleLogger().isInfoEnabled()) {
                            Global.getConsoleLogger().info(Messages.getString("CompileAndLoad.0"), (Object)path);
                        }
                        jc.run(null, null, null, path);
                        if (Global.getConsoleLogger().isInfoEnabled()) {
                            Global.getConsoleLogger().info(Messages.getString("CompileAndLoad.1"), (Object)path);
                        }
                    }
                }
                catch (NullPointerException e) {
                    Global.getConsoleLogger().warn(Messages.getString("CompileAndLoad.2"), (Object)path);
                    Global.getConsoleLogger().warn(Messages.getString("CompileAndLoad.3"));
                    Global.getLogger().error(Messages.getString("CompileAndLoad.4"), (Object)path);
                }
            }
            ++n2;
        }
    }
}

