/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.main.scripting;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.common.scripting.StbScriptEngineManager;
import com.indy.engine.core.IScriptingEngineProvider;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.main.connections.ConnectionManagerI;
import com.indy.engine.core.main.connections.RuntimeDatasource;
import com.indy.engine.core.main.connections.impl.DefaultRuntimeDataSource;
import com.indy.engine.main.scripting.BSFRuntimeDataSource;
import com.indy.engine.main.scripting.Messages;
import com.indy.engine.main.scripting.ScriptingConnectionI;
import com.indy.engine.resolver.manager.secure.ICertifiable;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.util.concurrent.locks.ReentrantLock;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import org.apache.bsf.BSFManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ScriptingEngineProvider
implements IScriptingEngineProvider {
    public final Logger logger = LogManager.getLogger((String)"com.indy.engine");

    private BSFManager createBeanShellEngine(String language, ActionCodeTypeI action, String connectionName) throws EngineExceptionI {
        BSFManager bsfManager;
        Object tempStr = "";
        try {
            String managerName = "BSF_SCRIPTING." + language;
            ReentrantLock lockObject = action.getActionContext().getConnectionlock();
            lockObject.lockInterruptibly();
            try {
                if (!action.getActionContext().existsConnectionManager(managerName)) {
                    action.getActionContext().addNewConnectionManager(managerName, connectionName, "Scripting");
                }
                ConnectionManagerI connManager = action.getActionContext().getConnectionManager(managerName);
                connManager.addCertifiedObject(action instanceof ICertifiable && ((ICertifiable)action).isCertified());
                tempStr = managerName + "." + connectionName;
                if (!connManager.hasRuntimeDataSource()) {
                    BSFRuntimeDataSource dataSource = new BSFRuntimeDataSource();
                    connManager.setRuntimeDataSource((RuntimeDatasource)dataSource);
                    lockObject.unlock();
                    bsfManager = (BSFManager)dataSource.getConnection((String)tempStr).getUnderlyingConnection();
                    connManager.unlockAll();
                } else {
                    BSFRuntimeDataSource dataSource = (BSFRuntimeDataSource)connManager.getRuntimeDataSource();
                    bsfManager = (BSFManager)dataSource.getConnection((String)tempStr).getUnderlyingConnection();
                }
            }
            finally {
                if (lockObject.isHeldByCurrentThread() && lockObject.isLocked()) {
                    lockObject.unlock();
                }
            }
            action.debugLog("setConnection", Messages.getString("ScriptingEngineProvider.4") + connectionName, 1, "INFO");
        }
        catch (Exception e) {
            throw this.handleEngineCreationException(action, e);
        }
        return bsfManager;
    }

    private ScriptEngine createJSEngine(String language, ActionCodeTypeI action, String connectionName, ClassLoader cl) throws EngineExceptionI {
        ScriptEngine scriptEngine;
        try {
            String managerName = "SCRIPTING." + language + "." + connectionName;
            ReentrantLock lockObject = action.getActionContext().getConnectionlock();
            lockObject.lockInterruptibly();
            try {
                ConnectionManagerI connManager;
                if (!action.getActionContext().existsConnectionManager(managerName)) {
                    action.getActionContext().addNewConnectionManager(managerName, connectionName, "Scripting");
                    connManager = action.getActionContext().getConnectionManager(managerName);
                    connManager.addConnectionParameter("LANGUAGE", language);
                } else {
                    connManager = action.getActionContext().getConnectionManager(managerName);
                }
                if (!connManager.hasRuntimeDataSource()) {
                    StbScriptEngineManager scriptEngineManager = new StbScriptEngineManager(cl);
                    DefaultRuntimeDataSource dataSource = new DefaultRuntimeDataSource(k -> {
                        ScriptEngine se = scriptEngineManager.getEngineByName(language, cl);
                        if (se == null) {
                            throw new IllegalStateException(new EngineExceptionI(String.format(Messages.getString("ScriptingConnectionI.0"), language)));
                        }
                        return new ScriptingConnectionI(se);
                    });
                    connManager.setRuntimeDataSource((RuntimeDatasource)dataSource);
                    lockObject.unlock();
                    scriptEngine = (ScriptEngine)dataSource.getConnection(managerName).getUnderlyingConnection();
                    connManager.unlockAll();
                } else {
                    RuntimeDatasource dataSource = connManager.getRuntimeDataSource();
                    connManager.setRuntimeDataSource(dataSource);
                    lockObject.unlock();
                    scriptEngine = (ScriptEngine)dataSource.getConnection(managerName).getUnderlyingConnection();
                }
            }
            finally {
                if (lockObject.isHeldByCurrentThread() && lockObject.isLocked()) {
                    lockObject.unlock();
                }
            }
            action.debugLog("setConnection", Messages.getString("ScriptingEngineProvider.4") + connectionName, 1, "INFO");
        }
        catch (Exception e) {
            throw this.handleEngineCreationException(action, e);
        }
        return scriptEngine;
    }

    private EngineExceptionI handleEngineCreationException(ActionCodeTypeI action, Exception e) {
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (e instanceof EngineExceptionI) {
            return (EngineExceptionI)((Object)e);
        }
        action.publishVariable(VariableType.CORE_RET_MESS.getName(), (Object)(Messages.getString("ScriptingEngineProvider.8") + e.getMessage()), "String", false);
        return new EngineExceptionI((Throwable)e);
    }

    public IScriptingEngineProvider.IScriptingEngineWrapper createScriptingEngine(IScriptingEngineProvider.EngineRuntime engine, String language, String connectionName, ActionCodeTypeI action, ClassLoader cl) throws EngineExceptionI {
        switch (engine) {
            case BEANSHELL: {
                return new BeanShellEngine(this.createBeanShellEngine(language, action, connectionName));
            }
            case JS: {
                return new JSEngine(this.createJSEngine(language, action, connectionName, cl));
            }
        }
        throw new EngineExceptionI(String.format(Messages.getString("ScriptingEngineProvider.9"), engine));
    }

    class BeanShellEngine
    implements IScriptingEngineProvider.IScriptingEngineWrapper {
        BSFManager engine;

        BeanShellEngine(BSFManager engine) {
            this.engine = engine;
        }

        public void bindConnection(String connectionName, Object connection) throws EngineExceptionI {
            try {
                this.engine.getObjectRegistry().register(connectionName, connection);
            }
            catch (Exception e) {
                throw new EngineExceptionI(Messages.getString("ScriptingEngineProvider.0"), (Throwable)e);
            }
        }

        public void unbindConnection(String connectionName) throws EngineExceptionI {
            this.engine.getObjectRegistry().unregister(connectionName);
        }

        public Object getScriptingEngine() {
            return this.engine;
        }
    }

    class JSEngine
    implements IScriptingEngineProvider.IScriptingEngineWrapper {
        ScriptEngine engine;

        JSEngine(ScriptEngine engine) {
            this.engine = engine;
        }

        public void bindConnection(String connectionName, Object connection) throws EngineExceptionI {
            Bindings bindings = this.engine.getBindings(100);
            try {
                bindings.put(connectionName, connection);
            }
            catch (Exception e) {
                throw new EngineExceptionI((Throwable)e);
            }
        }

        public void unbindConnection(String connectionName) throws EngineExceptionI {
            Bindings bindings = this.engine.getBindings(100);
            bindings.remove(connectionName);
        }

        public Object getScriptingEngine() {
            return this.engine;
        }
    }
}

