/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.wsdl;

import com.indy.engine.EngineServerI;
import com.indy.engine.Global;
import com.indy.engine.delivery.Delivery;
import com.indy.engine.delivery.Utils;
import com.indy.engine.main.repository.IDeliveryRepository;
import com.indy.engine.wsdl.AskToClearRunnable;
import com.indy.engine.wsdl.DeliveryRestAPIHelper;
import com.indy.engine.wsdl.Invocation;
import com.indy.engine.wsdl.Messages;
import com.semarchy.xdi.runtime.httpserver.Application;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WsdlAPI {
    private static final String FAKE_BASE_URL = "http://localhost:42200/";
    public static final String DEFAULT_CATALOG_NAME = "default";
    private static final String SCHEMA_URI = "http://www.w3.org/2001/XMLSchema";
    static final String STAMBIA_XSD_PARAMETERS_URI = "http://stambia.com/xsd/parameters";
    private static final String STAMBIA_PARAMETERS_PREFIX = "stbXP";
    private static final String WSDL_URI = "http://schemas.xmlsoap.org/wsdl/";
    static final String USER_PARAMETERS_IN = "userParameters";
    static final String USER_PARAMETERS_OUT = "userParameters";
    static final String STAMBIA_OUTPUT = "stambiaOutput";
    static final String STAMBIA_OUTPUT_TYPE = "OutputType";
    static final String STAMBIA_INPUT = "stambiaInput";
    static final String STAMBIA_INPUT_TYPE = "InputType";
    static final String STAMBIA_WSDL_URI = "http://stambia.com/wsdl";
    public static final String STAMBIA_NO_NAMESAPCE_URI = "http://stambia.com/noNameSapce";
    public static final String STAMBIA_NO_NAMESPACE_URI = "http://stambia.com/noNamespace";
    private static final String STAMBIA_WSDL_PREFIX = "stbW";
    private static final String SOAP_PREFIX = "soap";
    private static final String SOAP_URI = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String STAMBIA_DOCUMENT_LITERAL_WRAPPER_URI = "http://stambia.com/document/literal/wrapped";
    static final String STAMBIA_DOCUMENT_LITERAL_WRAPPER_PREFIX = "stbWP";
    static final String DEF_NAME = "StambiaDelivery";
    static final String DEF_NAME_WSI = "DeliverableService";
    static final String NAME = "Delivery";
    static final String NAME_WSI = "Deliverable";
    static final String SERVICE_NAME = "DeliveryService";
    static final String SERVICE_NAME_REST = "DeliveryService";
    static final String SERVICE_NAME_WSI = "DeliverableService";
    static final String SERVICE_WSDL_NAME_WSI = "DeliverableService";
    static final String SERVICE_WSDL_NAME = "StambiaDeliveryService";
    static final String SERVICE_CTX_NONWSI = "nonwsi";
    static final String SERVICE_CTX_WSI = "wsi";
    static final String SERVICE_CTX_REST = "rest/";
    static final String ctxRestV1 = "rest/DeliveryService/1";
    static final String ctxRestV2 = "rest/DeliveryService/2";
    static final String ctxRestV3 = "rest/DeliveryService/3";
    static final String PORT_NAME = "DeliveryPortType";
    static final String PORT_NAME_WSI = "DeliverablePortType";
    static final String BINDING_NAME = "DeliveryBinding";
    static final String BINDING_NAME_WSI = "DeliverableBinding";
    static final String STAMBIA_STANDARD_PREFIX = "stbPS";
    static final String STAMBIA_STANDARD_URI = "http://stambia.com/xsd/standard";
    private static final String XSD_PREFIX = "xs";
    private static final String STAMBIA_NONAMESPACE_PREFIX = "noNS";
    private static final String STAMBIA_NONAMESAPCE_PREFIX = "noNS2";
    public static String STAMBIA_WSDL_PATH = "xdi-runtime-api-user-endpoint.wsdl";
    public static String STAMBIA_WSDL_PATH_WSI = "xdi-runtime-api-user-endpoint-wsi.wsdl";
    private Element definitions;
    public Element types;
    private Element xsdParametersSchema;
    private Element xsdStandardSchema;
    private Element xsdStandardSchemaWSI;
    private Element portType;
    private Element wsiPortType;
    private Element binding;
    private Element wsiBinding;
    Element service;
    Element wsiService;
    Map<String, String> allNamepsaces = new HashMap<String, String>();
    Map<String, Delivery> allDeliveries = new HashMap<String, Delivery>();
    EngineServerI engineServerI;
    private File wsdlMessageDir;
    IDeliveryRepository repo;
    private Element xsdWrappedSchema;
    private Element definitionsWSI;
    private MeteDataSchema metadataSchema = new MeteDataSchema();
    public MainLock mainLock = new MainLock();
    private Node xsdNoNamespace;
    static AskToClearRunnable clearRunnable;
    static Map<String, Invocation> askToDelete;
    static Thread threadDeleteFile;
    DeliveryRestAPIHelper deliveryRestHelper = new DeliveryRestAPIHelper();
    Logger log;
    Application sprintBootApp;

    static {
        askToDelete = Collections.synchronizedMap(new HashMap());
    }

    public static String STAMBIA_NO_NAMESPACE_URI(boolean wsiCompliant) {
        return wsiCompliant ? STAMBIA_NO_NAMESPACE_URI : STAMBIA_NO_NAMESAPCE_URI;
    }

    public static String STAMBIA_NONAMESPACE_PREFIX(boolean wsiCompliant) {
        return wsiCompliant ? STAMBIA_NONAMESPACE_PREFIX : STAMBIA_NONAMESAPCE_PREFIX;
    }

    public IDeliveryRepository getRepository() {
        return this.repo;
    }

    public Map<String, Delivery> getAllDeliveries() {
        return Collections.unmodifiableMap(this.allDeliveries);
    }

    public WsdlAPI(EngineServerI engineServerI, IDeliveryRepository repo) throws MalformedURLException {
        this.repo = repo;
        this.log = LogManager.getLogger((String)Global.comIndyEngineWsdlLogger);
        this.engineServerI = engineServerI;
        if (this.repo != null) {
            STAMBIA_WSDL_PATH = this.repo.getCacheFolder().getAbsolutePath() + File.separator + "xdi-runtime-api-user-endpoint-" + String.valueOf(Global.HTTP_PORT) + ".wsdl";
            STAMBIA_WSDL_PATH_WSI = this.repo.getCacheFolder().getAbsolutePath() + File.separator + "xdi-runtime-api-user-endpoint-" + String.valueOf(Global.HTTP_PORT) + "-wsi.wsdl";
        }
        this.wsdlMessageDir = new File(Global.TEMPORARY_FOLDER + File.separator + "wsdl" + File.separator + "messages" + File.separator + "out");
        if (!this.wsdlMessageDir.exists()) {
            this.wsdlMessageDir.mkdirs();
        }
    }

    public File getWsdlMessageDir() {
        return this.wsdlMessageDir;
    }

    private DocumentPair initDoc() throws ParserConfigurationException {
        this.log.info("initDoc");
        DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        this.definitions = doc.createElementNS(WSDL_URI, "definitions");
        doc.appendChild(this.definitions);
        this.types = doc.createElementNS(WSDL_URI, "types");
        Document docWSI = docBuilder.newDocument();
        this.types = doc.createElementNS(WSDL_URI, "types");
        this.definitions.setAttribute("xmlns:soap", SOAP_URI);
        this.definitions.setAttribute("xmlns:stbW", STAMBIA_WSDL_URI);
        this.definitions.setAttribute("xmlns:stbPS", STAMBIA_STANDARD_URI);
        this.definitions.setAttribute("targetNamespace", STAMBIA_WSDL_URI);
        this.xsdParametersSchema = doc.createElementNS(SCHEMA_URI, "schema");
        this.xsdParametersSchema.setAttribute("targetNamespace", STAMBIA_XSD_PARAMETERS_URI);
        this.xsdParametersSchema.setPrefix(XSD_PREFIX);
        this.definitions.setAttribute("xmlns:xs", SCHEMA_URI);
        DocumentPair pair = new DocumentPair(doc, docWSI);
        this.initStandarParameters(true, pair);
        this.initStandarParameters(false, pair);
        this.definitionsWSI = (Element)this.definitions.cloneNode(true);
        this.definitionsWSI.setAttribute("xmlns:stbWP", STAMBIA_DOCUMENT_LITERAL_WRAPPER_URI);
        this.xsdWrappedSchema = docWSI.createElementNS(SCHEMA_URI, "schema");
        this.xsdWrappedSchema.setAttribute("targetNamespace", STAMBIA_DOCUMENT_LITERAL_WRAPPER_URI);
        this.xsdWrappedSchema.setPrefix(XSD_PREFIX);
        this.definitionsWSI.setAttribute("xmlns:xs", SCHEMA_URI);
        Element stdImport = this.appendXsdNode(docWSI, this.xsdWrappedSchema, "import");
        stdImport.setAttribute("namespace", STAMBIA_STANDARD_URI);
        this.xsdWrappedSchema.appendChild(stdImport);
        docWSI.adoptNode(this.definitionsWSI);
        docWSI.appendChild(this.definitionsWSI);
        this.portType = doc.createElementNS(WSDL_URI, "portType");
        this.portType.setAttribute("name", PORT_NAME);
        this.binding = doc.createElementNS(WSDL_URI, "binding");
        this.binding.setAttribute("name", BINDING_NAME);
        this.binding.setAttribute("type", "stbW:DeliveryPortType");
        Element soapBinding = doc.createElementNS(SOAP_URI, "binding");
        soapBinding.setPrefix(SOAP_PREFIX);
        soapBinding.setAttribute("style", "document");
        soapBinding.setAttribute("transport", "http://schemas.xmlsoap.org/soap/http");
        this.binding.appendChild(soapBinding);
        this.service = doc.createElementNS(WSDL_URI, "service");
        this.service.setAttribute("name", "DeliveryService");
        Element port = doc.createElementNS(WSDL_URI, "port");
        port.setAttribute("name", PORT_NAME);
        port.setAttribute("binding", "stbW:DeliveryBinding");
        Element soapAddress = doc.createElementNS(SOAP_URI, "address");
        soapAddress.setPrefix(SOAP_PREFIX);
        soapAddress.setAttribute("location", "http://localhost:42200/nonwsi");
        this.service.appendChild(port);
        port.appendChild(soapAddress);
        this.wsiPortType = docWSI.createElementNS(WSDL_URI, "portType");
        this.wsiPortType.setAttribute("name", PORT_NAME_WSI);
        this.wsiBinding = docWSI.createElementNS(WSDL_URI, "binding");
        this.wsiBinding.setAttribute("name", BINDING_NAME_WSI);
        this.wsiBinding.setAttribute("type", "stbW:DeliverablePortType");
        Element soapBindingWsi = docWSI.createElementNS(SOAP_URI, "binding");
        soapBindingWsi.setPrefix(SOAP_PREFIX);
        soapBindingWsi.setAttribute("style", "document");
        soapBindingWsi.setAttribute("transport", "http://schemas.xmlsoap.org/soap/http");
        this.wsiBinding.appendChild(soapBindingWsi);
        this.wsiService = docWSI.createElementNS(WSDL_URI, "service");
        this.wsiService.setAttribute("name", "DeliverableService");
        Element wsiPort = docWSI.createElementNS(WSDL_URI, "port");
        wsiPort.setAttribute("name", PORT_NAME_WSI);
        wsiPort.setAttribute("binding", "stbW:DeliverableBinding");
        Element wsiSoapAddress = docWSI.createElementNS(SOAP_URI, "address");
        wsiSoapAddress.setPrefix(SOAP_PREFIX);
        wsiSoapAddress.setAttribute("location", "http://localhost:42200/wsi");
        wsiPort.appendChild(wsiSoapAddress);
        this.wsiService.appendChild(wsiPort);
        return pair;
    }

    private Element createElement(Document doc, Element parent, String name, String type, String minOccurs, String maxOccurs, String _default) {
        Element element = this.appendXsdNode(doc, parent, "element");
        if (minOccurs != null) {
            element.setAttribute("minOccurs", minOccurs);
        }
        if (maxOccurs != null) {
            element.setAttribute("maxOccurs", maxOccurs);
        }
        element.setAttribute("name", name);
        if (type != null) {
            element.setAttribute("type", "xs:" + type);
        }
        if (_default != null) {
            element.setAttribute(DEFAULT_CATALOG_NAME, _default);
        }
        return element;
    }

    private Element createAttribute(Document doc, Element parent, String name, String type, String use, String _default) {
        Element attribute = this.appendXsdNode(doc, parent, "attribute");
        if (use != null) {
            attribute.setAttribute("use", use);
        }
        attribute.setAttribute("name", name);
        if (type != null) {
            attribute.setAttribute("type", "xs:" + type);
        }
        if (_default != null) {
            attribute.setAttribute(DEFAULT_CATALOG_NAME, _default);
        }
        return attribute;
    }

    private void initStandarParameters(boolean isWsiCompliant, DocumentPair pair) {
        if (isWsiCompliant) {
            this.xsdStandardSchemaWSI = pair.docWSI.createElementNS(SCHEMA_URI, "schema");
            this.xsdStandardSchemaWSI.setAttribute("targetNamespace", STAMBIA_STANDARD_URI);
            this.xsdStandardSchemaWSI.setPrefix(XSD_PREFIX);
            Element complexType = this.appendXsdNode(pair.docWSI, this.xsdStandardSchemaWSI, "complexType");
            complexType.setAttribute("name", STAMBIA_INPUT_TYPE);
            this.createAttribute(pair.docWSI, complexType, "pAsynchronous", "boolean", "optional", "false");
            this.createAttribute(pair.docWSI, complexType, "pSessionId", "string", "optional", null);
            this.createAttribute(pair.docWSI, complexType, "pParentSessionId", "string", "optional", null);
            this.createAttribute(pair.docWSI, complexType, "pLogLevel", "int", "optional", null);
            this.createAttribute(pair.docWSI, complexType, "pSessionName", "string", "optional", null);
            complexType = this.appendXsdNode(pair.docWSI, this.xsdStandardSchemaWSI, "complexType");
            complexType.setAttribute("name", STAMBIA_OUTPUT_TYPE);
            this.createAttribute(pair.docWSI, complexType, "pSessionId", "string", "optional", null);
        } else {
            this.xsdStandardSchema = pair.doc.createElementNS(SCHEMA_URI, "schema");
            this.xsdStandardSchema.setAttribute("targetNamespace", STAMBIA_STANDARD_URI);
            this.xsdStandardSchema.setPrefix(XSD_PREFIX);
            Element stambiaInput = this.createElement(pair.doc, this.xsdStandardSchema, STAMBIA_INPUT, null, null, null, null);
            Element complexType = this.appendXsdNode(pair.doc, stambiaInput, "complexType");
            this.createAttribute(pair.doc, complexType, "synchronous", "boolean", "optional", "true");
            this.createAttribute(pair.doc, complexType, "sessionId", "string", "optional", null);
            this.createAttribute(pair.doc, complexType, "parentSessionId", "string", "optional", null);
            this.createAttribute(pair.doc, complexType, "logLevel", "int", "optional", null);
            this.createAttribute(pair.doc, complexType, "sessionName", "string", "optional", null);
            Element stambiaOutput = this.createElement(pair.doc, this.xsdStandardSchema, STAMBIA_OUTPUT, null, null, null, null);
            complexType = this.appendXsdNode(pair.doc, stambiaOutput, "complexType");
            this.createAttribute(pair.doc, complexType, "sessionId", "string", "optional", null);
        }
    }

    public Element appendXsdNode(Document doc, Element elt, String type) {
        return this.appendXsdNode(doc, elt, type, -1);
    }

    public Element appendXsdNode(Document doc, Element elt, String type, int position) {
        Element _elt = doc.createElementNS(SCHEMA_URI, type);
        _elt.setPrefix(XSD_PREFIX);
        if (position > -1) {
            Node node = elt.getChildNodes().item(position);
            elt.insertBefore(_elt, node);
        } else {
            elt.appendChild(_elt);
        }
        return _elt;
    }

    private void parseDelivery(DeliveryInfo info, List<Element> result, boolean wsiCompliant, DocumentPair pair) throws Exception {
        Element elt;
        String outputMessageName;
        Document doc = wsiCompliant ? pair.docWSI : pair.doc;
        Delivery currentDelivery = info.deliv;
        String name = info.name;
        Object qname = "deliv_" + info.name.replaceAll("[^A-Za-z0-9]", "_");
        String inputMessageName = "in_" + (String)qname;
        String outputParametersTypeName = outputMessageName = "out_" + (String)qname;
        String inputParametersTypeName = inputMessageName;
        String inputwrappedName = qname;
        String outputwrappedName = (String)qname + "_Ouput";
        Object operationName = qname;
        if (wsiCompliant) {
            qname = info.name.replaceAll("[^A-Za-z0-9]", "_");
            qname = (((String)qname).substring(0, 1).matches("[^A-Za-z]") ? "_" : "") + (String)qname;
            inputMessageName = (String)qname + "InputMessage";
            outputMessageName = (String)qname + "OutputMessage";
            inputwrappedName = (String)qname + "Input";
            outputwrappedName = (String)qname + "Output";
            operationName = qname;
        }
        this.setPort((String)operationName, inputMessageName, outputMessageName, wsiCompliant, pair);
        this.setBinding(name, (String)operationName, wsiCompliant, pair);
        Element outputMessage = this.setStandardOutput(outputMessageName, outputwrappedName, wsiCompliant, pair);
        Element inputMessage = this.setStandardInput(inputMessageName, inputwrappedName, wsiCompliant, pair);
        Element sinputParams = null;
        Element soutputParams = null;
        Element sfaultParams = null;
        Element sequenceInput = null;
        Element sequenceOutput = null;
        if (wsiCompliant) {
            Element stambiaInput = this.createElement(doc, this.xsdWrappedSchema, inputwrappedName, null, null, null, null);
            Element complexTypeInput = this.appendXsdNode(doc, stambiaInput, "complexType");
            Element complexContentInput = this.appendXsdNode(doc, complexTypeInput, "complexContent");
            Element extensionInput = this.appendXsdNode(doc, complexContentInput, "extension");
            extensionInput.setAttribute("base", "stbPS:InputType");
            sinputParams = sequenceInput = this.appendXsdNode(doc, extensionInput, "sequence");
            Element stambiaOutput = this.createElement(doc, this.xsdWrappedSchema, outputwrappedName, null, null, null, null);
            Element complexTypeOutput = this.appendXsdNode(doc, stambiaOutput, "complexType");
            Element complexContentOutput = this.appendXsdNode(doc, complexTypeOutput, "complexContent");
            Element extensionOutput = this.appendXsdNode(doc, complexContentOutput, "extension");
            extensionOutput.setAttribute("base", "stbPS:OutputType");
            soutputParams = sequenceOutput = this.appendXsdNode(doc, extensionOutput, "sequence");
            sfaultParams = doc.createElementNS(SCHEMA_URI, "sequence");
            sfaultParams.setPrefix(XSD_PREFIX);
        } else {
            sinputParams = doc.createElementNS(SCHEMA_URI, "sequence");
            sinputParams.setPrefix(XSD_PREFIX);
            soutputParams = doc.createElementNS(SCHEMA_URI, "sequence");
            soutputParams.setPrefix(XSD_PREFIX);
            sfaultParams = doc.createElementNS(SCHEMA_URI, "sequence");
            sfaultParams.setPrefix(XSD_PREFIX);
        }
        for (String key : currentDelivery.getParameters().keySet()) {
            Delivery.Parameter param = currentDelivery.getParameters().get(key);
            if (param.isInput()) {
                this.createParams(doc, sinputParams, param);
            }
            if (param.isOutput()) {
                this.createParams(doc, soutputParams, param);
            }
            if (!param.isFault()) continue;
            this.createParams(doc, sfaultParams, param);
        }
        if (!wsiCompliant && sinputParams.getChildNodes().getLength() > 0) {
            Element inputParams = doc.createElementNS(SCHEMA_URI, "complexType");
            inputParams.appendChild(sinputParams);
            inputParams.setPrefix(XSD_PREFIX);
            inputParams.setAttribute("name", inputParametersTypeName);
            this.xsdParametersSchema.appendChild(inputParams);
            elt = null;
            elt = doc.createElementNS(WSDL_URI, "part");
            inputMessage.appendChild(elt);
            elt.setAttribute("name", "userParameters");
            elt.setAttribute("type", "stbXP:" + inputParametersTypeName);
        }
        result.add(inputMessage);
        if (!wsiCompliant && soutputParams.getChildNodes().getLength() > 0) {
            Element outputParams = doc.createElementNS(SCHEMA_URI, "complexType");
            outputParams.setPrefix(XSD_PREFIX);
            outputParams.setAttribute("name", outputParametersTypeName);
            outputParams.appendChild(soutputParams);
            this.xsdParametersSchema.appendChild(outputParams);
            elt = null;
            elt = doc.createElementNS(WSDL_URI, "part");
            outputMessage.appendChild(elt);
            elt.setAttribute("name", "userParameters");
            elt.setAttribute("type", "stbXP:" + outputParametersTypeName);
        }
        result.add(outputMessage);
        for (Delivery.Route _route : currentDelivery.getRoutes()) {
            String attributeName;
            String routeId = _route.getId();
            String targetnamespaceStr = this.getMetaDataSchema().getSchemaMap().get(routeId);
            if (targetnamespaceStr != null) {
                boolean noNamespace = false;
                if (targetnamespaceStr.equals(STAMBIA_NO_NAMESPACE_URI)) {
                    noNamespace = true;
                    if (!wsiCompliant) {
                        targetnamespaceStr = STAMBIA_NO_NAMESAPCE_URI;
                    }
                }
                if (!this.allNamepsaces.containsKey(targetnamespaceStr)) {
                    if (targetnamespaceStr.equals(WsdlAPI.STAMBIA_NO_NAMESPACE_URI(wsiCompliant))) {
                        this.allNamepsaces.put(targetnamespaceStr, WsdlAPI.STAMBIA_NONAMESPACE_PREFIX(wsiCompliant));
                    } else {
                        this.allNamepsaces.put(targetnamespaceStr, "ns" + (this.allNamepsaces.size() + 1));
                    }
                }
                if (!noNamespace) {
                    _route.setTargetNameSpace(targetnamespaceStr);
                    _route.setTargetPrefix(this.allNamepsaces.get(targetnamespaceStr));
                } else {
                    _route.setTargetNameSpace(null);
                    _route.setTargetPrefix(null);
                }
            }
            if (_route.isInput() && _route.getType().equals("xsd")) {
                Element elt2 = null;
                if (wsiCompliant) {
                    elt2 = this.appendXsdNode(doc, sequenceInput, "element");
                    attributeName = "ref";
                } else {
                    elt2 = doc.createElementNS(WSDL_URI, "part");
                    inputMessage.appendChild(elt2);
                    elt2.setAttribute("name", _route.getElementName());
                    attributeName = "element";
                }
                if (targetnamespaceStr != null) {
                    elt2.setAttribute(attributeName, this.allNamepsaces.get(targetnamespaceStr) + ":" + _route.getElementName());
                } else {
                    elt2.setAttribute(attributeName, WsdlAPI.STAMBIA_NONAMESPACE_PREFIX(wsiCompliant) + ":" + _route.getElementName());
                }
            }
            if (!_route.isOutput() || !_route.getType().equals("xsd")) continue;
            Element elt3 = null;
            if (wsiCompliant) {
                elt3 = this.appendXsdNode(doc, sequenceOutput, "element");
                attributeName = "ref";
                elt3.setAttribute("maxOccurs", "1");
                elt3.setAttribute("minOccurs", "0");
            } else {
                elt3 = doc.createElementNS(WSDL_URI, "part");
                outputMessage.appendChild(elt3);
                elt3.setAttribute("name", _route.getElementName());
                attributeName = "element";
            }
            if (targetnamespaceStr != null) {
                elt3.setAttribute(attributeName, this.allNamepsaces.get(targetnamespaceStr) + ":" + _route.getElementName());
                continue;
            }
            elt3.setAttribute(attributeName, WsdlAPI.STAMBIA_NONAMESPACE_PREFIX(wsiCompliant) + ":" + _route.getElementName());
        }
    }

    private Element setStandardOutput(String outputMessageName, String wrappedElementName, boolean wsiCompliant, DocumentPair pair) {
        Element outputMessage = pair.doc.createElementNS(WSDL_URI, "message");
        outputMessage.setAttribute("name", outputMessageName);
        Element part = pair.doc.createElementNS(WSDL_URI, "part");
        outputMessage.appendChild(part);
        String partName = wsiCompliant ? "body" : STAMBIA_OUTPUT;
        Object attributeValue = wsiCompliant ? "stbWP:" + wrappedElementName : "stbPS:stambiaOutput";
        part.setAttribute("name", partName);
        part.setAttribute("element", (String)attributeValue);
        return outputMessage;
    }

    private Element setStandardInput(String inputMessageName, String wrappedElementName, boolean wsiCompliant, DocumentPair pair) {
        Element inputMessage = pair.doc.createElementNS(WSDL_URI, "message");
        inputMessage.setAttribute("name", inputMessageName);
        Element part = pair.doc.createElementNS(WSDL_URI, "part");
        inputMessage.appendChild(part);
        String partName = wsiCompliant ? "body" : STAMBIA_INPUT;
        Object attributeValue = wsiCompliant ? "stbWP:" + wrappedElementName : "stbPS:stambiaInput";
        part.setAttribute("name", partName);
        part.setAttribute("element", (String)attributeValue);
        return inputMessage;
    }

    private void createParams(Document doc, Element sequence, Delivery.Parameter _param) {
        Element param = doc.createElementNS(SCHEMA_URI, "element");
        param.setAttribute("minOccurs", "0");
        param.setPrefix(XSD_PREFIX);
        param.setAttribute("name", _param.getName());
        String type = _param.getType();
        if (type != null) {
            if (type.equals("String")) {
                param.setAttribute("type", "xs:string");
            } else if (type.equals("Boolean")) {
                param.setAttribute("type", "xs:boolean");
            } else if (type.equals("Integer")) {
                param.setAttribute("type", "xs:integer");
            }
        }
        sequence.appendChild(param);
    }

    private void setBinding(String action, String operation, boolean wsiCompliant, DocumentPair pair) {
        Document doc = wsiCompliant ? pair.docWSI : pair.doc;
        Element bindingOperation = doc.createElementNS(WSDL_URI, "operation");
        if (wsiCompliant) {
            this.wsiBinding.appendChild(bindingOperation);
        } else {
            this.binding.appendChild(bindingOperation);
        }
        bindingOperation.setAttribute("name", operation);
        Element soapAction = doc.createElementNS(SOAP_URI, "operation");
        soapAction.setPrefix(SOAP_PREFIX);
        soapAction.setAttribute("soapAction", action);
        bindingOperation.appendChild(soapAction);
        Element bindingInput = doc.createElementNS(WSDL_URI, "input");
        bindingOperation.appendChild(bindingInput);
        Element soapBody = doc.createElementNS(SOAP_URI, "body");
        soapBody.setPrefix(SOAP_PREFIX);
        soapBody.setAttribute("use", "literal");
        bindingInput.appendChild(soapBody);
        Element bindingOutput = doc.createElementNS(WSDL_URI, "output");
        bindingOperation.appendChild(bindingOutput);
        soapBody = doc.createElementNS(SOAP_URI, "body");
        soapBody.setPrefix(SOAP_PREFIX);
        soapBody.setAttribute("use", "literal");
        bindingOutput.appendChild(soapBody);
    }

    private void setPort(String qname, String inputMessageName, String outputMessageName, boolean wsiCompliant, DocumentPair pair) {
        Document doc = wsiCompliant ? pair.docWSI : pair.doc;
        Element operation = doc.createElementNS(WSDL_URI, "operation");
        operation.setAttribute("name", qname);
        if (wsiCompliant) {
            this.wsiPortType.appendChild(operation);
        } else {
            this.portType.appendChild(operation);
        }
        Element input = doc.createElementNS(WSDL_URI, "input");
        operation.appendChild(input);
        input.setAttribute("message", "stbW:" + inputMessageName);
        Element output = doc.createElementNS(WSDL_URI, "output");
        operation.appendChild(output);
        output.setAttribute("message", "stbW:" + outputMessageName);
    }

    void askToClear(String _session, long delay) {
        Invocation invoc = askToDelete.get(_session);
        if (invoc != null) {
            this.askToClear(invoc, delay);
        }
    }

    void askToClear(Invocation invocation, long delay) {
        if (delay <= 0L) {
            invocation.clear();
        } else {
            invocation.delayBeforeClear = System.currentTimeMillis() + delay;
            askToDelete.put(invocation.getSessionId(), invocation);
            clearRunnable._notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initWSDL() throws Exception {
        this.log.info("initWsdl");
        MainLock mainLock = this.mainLock;
        synchronized (mainLock) {
            ArrayList<Lock> list;
            List<Lock> list2 = this.mainLock.invocationLock;
            synchronized (list2) {
                list = new ArrayList<Lock>(this.mainLock.invocationLock);
            }
            for (Lock lock : list) {
                lock.waitEndLock();
            }
            this.mainLock.removeAllLock();
            this.metadataSchema = new MeteDataSchema();
            this.allDeliveries.clear();
            Map<String, List<Node>> schemaNodes = this.metadataSchema.getSchemaNodes();
            DocumentPair pair = this.initDoc();
            DeliveryRestAPIHelper.CatalogConfiguration catalogConf = new DeliveryRestAPIHelper.CatalogConfiguration(DEFAULT_CATALOG_NAME);
            if (this.repo != null) {
                catalogConf.setProperty(DeliveryRestAPIHelper.CatalogConfiguration.SWAGGER2_FILE_PATH, this.repo.getCacheFolder().getAbsolutePath() + File.separator + "xdi-runtime-api-user-endpoint-" + String.valueOf(Global.HTTP_PORT) + String.format("-swagger2-%s.json", DEFAULT_CATALOG_NAME));
                catalogConf.setProperty(DeliveryRestAPIHelper.CatalogConfiguration.SWAGGER2_BASE_PATH, "/rest/DeliveryService/3/default");
                catalogConf.setProperty(DeliveryRestAPIHelper.CatalogConfiguration.OPENAPI3_FILE_PATH, this.repo.getCacheFolder().getAbsolutePath() + File.separator + "xdi-runtime-api-user-endpoint-" + String.valueOf(Global.HTTP_PORT) + String.format("-openAPI303-%s.json", DEFAULT_CATALOG_NAME));
                catalogConf.setProperty(DeliveryRestAPIHelper.CatalogConfiguration.OPENAPI3_URL, "/rest/DeliveryService/3/default");
            }
            DeliveryRestAPIHelper.Catalog catalog = DeliveryRestAPIHelper.initCatalog(catalogConf);
            ArrayList<DeliveryInfo> deliveries = new ArrayList<DeliveryInfo>();
            HashMap<String, String> jsonSchemas = new HashMap<String, String>();
            if (this.repo != null) {
                boolean[] bs;
                Object namespace;
                for (String name : this.repo.getLstDeliveries(null)) {
                    File deliv = this.repo.getDeliveryFile(name);
                    if (!deliv.getName().endsWith(".deliv")) continue;
                    try {
                        HashMap<String, List<Node>> _schemaNodes = new HashMap<String, List<Node>>();
                        Delivery currentDelivery = Utils.parseDelivery(deliv, this, true, _schemaNodes, jsonSchemas);
                        DeliveryInfo info = new DeliveryInfo();
                        info.deliv = currentDelivery;
                        info.name = name;
                        currentDelivery.setName(info.name);
                        this.allDeliveries.put(name, currentDelivery);
                        deliveries.add(info);
                        Iterator iterator = _schemaNodes.keySet().iterator();
                        while (iterator.hasNext()) {
                            namespace = (String)iterator.next();
                            List<Node> nodes = null;
                            if (!schemaNodes.isEmpty() && schemaNodes.containsKey(namespace)) {
                                nodes = schemaNodes.get(namespace);
                            } else {
                                nodes = new ArrayList();
                                schemaNodes.put((String)namespace, nodes);
                            }
                            nodes.addAll((Collection)_schemaNodes.get(namespace));
                        }
                    }
                    catch (Exception e) {
                        this.getLogger().error(Messages.getString("WsdlAPI.1"), (Object)deliv, (Object)e);
                    }
                }
                ArrayList<Element> messages = new ArrayList<Element>();
                ArrayList<Element> messagesWSI = new ArrayList<Element>();
                boolean[] blArray = new boolean[2];
                blArray[0] = true;
                namespace = bs = blArray;
                int info = bs.length;
                int n = 0;
                while (n < info) {
                    boolean wsiCompliant = namespace[n];
                    if (wsiCompliant || !wsiCompliant) {
                        for (DeliveryInfo deliv : deliveries) {
                            if (deliv.deliv.getInputType().isXmlOnly() && deliv.deliv.getOutputType().isXmlOnly()) {
                                ArrayList<Element> _messages = new ArrayList<Element>();
                                try {
                                    this.parseDelivery(deliv, _messages, wsiCompliant, pair);
                                }
                                catch (Exception e) {
                                    this.getLogger().error(Messages.getString("WsdlAPI.2"), (Object)deliv, (Object)e);
                                }
                                for (Element message : _messages) {
                                    if (wsiCompliant) {
                                        messagesWSI.add(message);
                                        continue;
                                    }
                                    messages.add(message);
                                }
                            }
                            catalog.add(deliv, jsonSchemas);
                        }
                    }
                    ++n;
                }
                this.deliveryRestHelper.addCatalog(catalog);
                for (String uri : this.allNamepsaces.keySet()) {
                    if (!uri.equals(STAMBIA_NO_NAMESPACE_URI)) {
                        this.definitions.setAttribute("xmlns:" + this.allNamepsaces.get(uri), uri);
                    }
                    if (uri.equals(STAMBIA_NO_NAMESAPCE_URI)) continue;
                    this.definitionsWSI.setAttribute("xmlns:" + this.allNamepsaces.get(uri), uri);
                    if (uri.equals(STAMBIA_DOCUMENT_LITERAL_WRAPPER_URI)) continue;
                    Element stdImport = this.appendXsdNode(pair.docWSI, this.xsdWrappedSchema, "import", 0);
                    stdImport.setAttribute("namespace", uri);
                }
                if (!schemaNodes.isEmpty()) {
                    for (String nameSpace : schemaNodes.keySet()) {
                        List<Node> source = schemaNodes.get(nameSpace);
                        ArrayList<Node> schemas = new ArrayList<Node>(source.size());
                        for (Node n2 : source) {
                            schemas.add(n2);
                        }
                        Node firstSchema = (Node)schemas.remove(0);
                        pair.doc.adoptNode(firstSchema);
                        for (Node schema : schemas) {
                            this.mergeSchema(firstSchema, schema, nameSpace, pair.doc);
                        }
                        if (nameSpace.equals(STAMBIA_NO_NAMESPACE_URI)) {
                            this.xsdNoNamespace = firstSchema;
                        }
                        this.types.appendChild(firstSchema);
                    }
                }
                if (this.types.getChildNodes().getLength() > 0) {
                    this.types.insertBefore(this.xsdStandardSchema, this.types.getFirstChild());
                } else {
                    this.types.appendChild(this.xsdStandardSchema);
                }
                if (this.xsdParametersSchema.getChildNodes().getLength() > 0) {
                    this.definitions.setAttribute("xmlns:stbXP", STAMBIA_XSD_PARAMETERS_URI);
                    this.types.appendChild(this.xsdParametersSchema);
                } else {
                    this.xsdParametersSchema = null;
                }
                this.definitions.setAttribute("xmlns:xs", SCHEMA_URI);
                this.definitions.appendChild(this.types);
                for (Element message : messages) {
                    this.definitions.appendChild(message);
                }
                this.definitions.appendChild(this.portType);
                this.definitions.appendChild(this.binding);
                this.definitions.appendChild(this.service);
                if (this.xsdNoNamespace != null) {
                    this.xsdNoNamespace.getAttributes().getNamedItem("targetNamespace").setNodeValue(STAMBIA_NO_NAMESAPCE_URI);
                }
                this.definitions.setAttribute("name", DEF_NAME);
                this.writeFile(STAMBIA_WSDL_PATH, pair.doc);
                try {
                    this.deliveryRestHelper.getCatalog(DEFAULT_CATALOG_NAME).serializeFile();
                }
                catch (Exception ex) {
                    throw new Exception(Messages.getString("WsdlAPI.3") + DEFAULT_CATALOG_NAME, ex);
                }
                pair.docWSI.adoptNode(this.types);
                this.types.appendChild(this.xsdWrappedSchema);
                if (this.xsdStandardSchema != null) {
                    this.types.removeChild(this.xsdStandardSchema);
                }
                if (this.xsdParametersSchema != null) {
                    this.types.removeChild(this.xsdParametersSchema);
                }
                this.definitionsWSI.setAttribute("xmlns:xs", SCHEMA_URI);
                this.types.appendChild(this.xsdStandardSchemaWSI);
                this.definitionsWSI.appendChild(this.types);
                for (Element message : messagesWSI) {
                    pair.docWSI.adoptNode(message);
                    this.definitionsWSI.appendChild(message);
                }
                this.definitionsWSI.appendChild(this.wsiPortType);
                this.definitionsWSI.appendChild(this.wsiBinding);
                this.definitionsWSI.appendChild(this.wsiService);
                if (this.xsdNoNamespace != null) {
                    this.xsdNoNamespace.getAttributes().getNamedItem("targetNamespace").setNodeValue(STAMBIA_NO_NAMESPACE_URI);
                }
                this.definitionsWSI.setAttribute("name", "DeliverableService");
                this.writeFile(STAMBIA_WSDL_PATH_WSI, pair.docWSI);
            }
        }
    }

    private void mergeSchema(Node firstSchema, Node schema, String targetNamespace, Document doc) {
        String elementName;
        Node element;
        String prefix = "Namespace merging: " + targetNamespace;
        this.log.info(prefix + " start");
        int firstSchemaNbElement = firstSchema.getChildNodes().getLength();
        int schemaNbElement = schema.getChildNodes().getLength();
        if (firstSchemaNbElement != schemaNbElement) {
            this.log.info(prefix + Messages.getString("WsdlAPI.4"));
        }
        HashMap<String, Node> firstSchemaElements = new HashMap<String, Node>();
        HashMap<String, Node> schemaElements = new HashMap<String, Node>();
        ArrayList<Node> nodeToAddToSchema = new ArrayList<Node>();
        int i = 0;
        while (i < firstSchemaNbElement) {
            element = firstSchema.getChildNodes().item(i);
            elementName = element.getAttributes().getNamedItem("name").getNodeValue();
            if (elementName != null) {
                firstSchemaElements.put(elementName, element);
            }
            ++i;
        }
        i = 0;
        while (i < schemaNbElement) {
            element = schema.getChildNodes().item(i);
            elementName = element.getAttributes().getNamedItem("name").getNodeValue();
            if (elementName != null) {
                schemaElements.put(elementName, element);
            }
            ++i;
        }
        ArrayList<String> nodeNameToBeCompared = new ArrayList<String>();
        for (String elementName2 : firstSchemaElements.keySet()) {
            if (!schemaElements.containsKey(elementName2)) {
                this.log.info(prefix + Messages.getString("WsdlAPI.5") + elementName2 + Messages.getString("WsdlAPI.6"));
                continue;
            }
            nodeNameToBeCompared.add(elementName2);
        }
        for (String elementName2 : schemaElements.keySet()) {
            if (!firstSchemaElements.containsKey(elementName2)) {
                this.log.info(prefix + Messages.getString("WsdlAPI.7") + elementName2 + Messages.getString("WsdlAPI.8"));
                nodeToAddToSchema.add((Node)schemaElements.get(elementName2));
                continue;
            }
            this.log.warn(prefix + Messages.getString("WsdlAPI.9") + elementName2 + Messages.getString("WsdlAPI.10"));
        }
        for (Node node : nodeToAddToSchema) {
            doc.adoptNode(node);
            firstSchema.appendChild(node);
        }
        this.log.info(prefix + " end");
    }

    public DeliveryRestAPIHelper getDeliveryRestHelper() {
        return this.deliveryRestHelper;
    }

    public void writeFile(String wsdlPath, Document doc) throws TransformerException, IOException {
        TransformerFactory transfac = TransformerFactory.newInstance(TransformerFactoryImpl.class.getName(), null);
        transfac.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transfac.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer trans = transfac.newTransformer();
        trans.setOutputProperty("omit-xml-declaration", "yes");
        trans.setOutputProperty("indent", "yes");
        trans.setOutputProperty("encoding", "UTF-8");
        if (!new File(wsdlPath).getParentFile().exists()) {
            new File(wsdlPath).getParentFile().mkdirs();
        }
        Throwable throwable = null;
        Object var6_7 = null;
        try (OutputStreamWriter fw = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(wsdlPath)), StandardCharsets.UTF_8);){
            StreamResult result = new StreamResult(fw);
            DOMSource source = new DOMSource(doc);
            trans.transform(source, result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Exception startSOAPServer() throws Exception {
        this.sprintBootApp = new Application();
        Exception t = null;
        this.log.info("Starting soapServer...");
        this.sprintBootApp.start();
        try {
            clearRunnable = new AskToClearRunnable();
            threadDeleteFile = new Thread(clearRunnable);
            threadDeleteFile.setName("SoapPersistenceFileCleaner");
            threadDeleteFile.setDaemon(true);
            threadDeleteFile.start();
            StringBuilder runtimeLocalBasePath = new StringBuilder();
            if (Global.webServiceSecureProtocolType != null) {
                runtimeLocalBasePath.append("https");
            } else {
                runtimeLocalBasePath.append("http");
            }
            runtimeLocalBasePath.append("://").append(Global.HTTP_HOST).append(":").append(Global.HTTP_PORT);
            Global.getConsoleLogger().info("SOAP Endpoint (local url): {}/{}/{}?WSDL", (Object)runtimeLocalBasePath, (Object)SERVICE_CTX_WSI, (Object)"DeliverableService");
            Global.getConsoleLogger().info("SOAP Legacy \"Non WSI-Compliant\" Endpoint (local url): {}/{}/{}?WSDL", (Object)runtimeLocalBasePath, (Object)SERVICE_CTX_NONWSI, (Object)"DeliverableService");
            this.deliveryRestHelper.catalogs.keySet().stream().sorted().forEach(catalogName -> {
                Global.getConsoleLogger().info("HTTP Rest v3 - Endpoint (local url): {}/{}/{}/<path>", (Object)runtimeLocalBasePath, (Object)ctxRestV3, catalogName);
                Global.getConsoleLogger().info("HTTP Rest v3 - UI (local url): {}/{}/{}?swagger-ui", (Object)runtimeLocalBasePath, (Object)ctxRestV3, catalogName);
                Global.getConsoleLogger().info("HTTP Rest v3 - Definition (local url): {}/{}/{}?openapi3.json", (Object)runtimeLocalBasePath, (Object)ctxRestV3, catalogName);
                Global.getConsoleLogger().info("HTTP Rest v3 - Definition (local url): {}/{}/{}?swagger2.json", (Object)runtimeLocalBasePath, (Object)ctxRestV3, catalogName);
            });
            Global.getConsoleLogger().info("HTTP Rest v2 - Endpoint (local url): {}/{}/<deliveryName>", (Object)runtimeLocalBasePath, (Object)ctxRestV2);
            Global.getConsoleLogger().info("HTTP Rest v1 - Endpoint (local url): {}/{}/<deliveryName>", (Object)runtimeLocalBasePath, (Object)ctxRestV1);
            this.log.info("SOAP Server is started");
        }
        catch (Exception e) {
            t = e;
            Global.getConsoleLogger().info("Impossible to start SOAP server");
            this.log.error("Error", (Throwable)e);
        }
        return t;
    }

    public Exception stopSOAPServer() {
        try {
            this.sprintBootApp.stop();
            if (threadDeleteFile != null && threadDeleteFile.isAlive()) {
                threadDeleteFile.interrupt();
            }
            Global.getConsoleLogger().info("SOAP Server is stopped");
            this.log.info("SOAP Server is stopped");
        }
        catch (Exception e) {
            this.log.error("Impossible to stop SOAP Server", (Throwable)e);
            Global.getConsoleLogger().info("Impossible to stop SOAP Server");
            return e;
        }
        return null;
    }

    public Logger getLogger() {
        return this.log;
    }

    public MeteDataSchema getMetaDataSchema() {
        return this.metadataSchema;
    }

    public class DeliveryInfo {
        Delivery deliv;
        String name;
    }

    private record DocumentPair(Document doc, Document docWSI) {
    }

    class Lock {
        Lock() {
        }

        public synchronized void waitEndLock() {
        }
    }

    class MainLock {
        private List<Lock> invocationLock = Collections.synchronizedList(new ArrayList());

        MainLock() {
        }

        public synchronized void addLock(Lock lock) {
            this.invocationLock.add(lock);
        }

        public void removeLock(Lock lock) {
            this.invocationLock.remove(lock);
        }

        public void removeAllLock() {
            this.invocationLock.clear();
        }
    }

    public class MeteDataSchema {
        private Map<String, String> metadataSchema = new HashMap<String, String>();
        private Map<String, List<Node>> schemaNodes = new HashMap<String, List<Node>>();

        public Map<String, String> getSchemaMap() {
            return this.metadataSchema;
        }

        public Map<String, List<Node>> getSchemaNodes() {
            return this.schemaNodes;
        }
    }
}

