/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.indy.engine.common.security.PrivilegeException;
import com.indy.engine.remote.RemoteSessionManagement;
import com.indy.engine.wsdl.HttpRuntimeInvoker;
import com.indy.runtime.json.JsonNode;
import com.semarchy.xdi.engine.common.IRemoteSessionV01;
import com.semarchy.xdi.runtime.httpserver.HttpErrorHandler;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.http.HttpStatus;

public class RuntimeServlet
extends HttpServlet {
    protected final transient Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final HttpRuntimeInvoker invoker = new HttpRuntimeInvoker();
    private static final HttpErrorHandler errorHandler = new HttpErrorHandler();

    protected void doHandleError(int httpErrorCode, String message, Exception t, HttpServletResponse resp) {
        Consumer<String> errorConsumer = errorMessage -> {
            try {
                resp.sendError(httpErrorCode, errorMessage);
            }
            catch (IOException e) {
                this.logger.error((Object)e);
            }
        };
        errorHandler.handleError(message, t, errorConsumer);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.doGet(req, resp);
        }
        catch (Exception t) {
            this.handleError(t, resp);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String paramsInHeader = req.getHeader("Params-In-Header");
            String contentEncoding = req.getHeader("Content-Encoding");
            boolean igzip = contentEncoding != null && contentEncoding.equals("gzip");
            String acceptEncoding = req.getHeader("Accept-Encoding");
            boolean ogzip = acceptEncoding != null && acceptEncoding.equals("gzip");
            Object requestJsonStream = req.getInputStream();
            ServletInputStream data = null;
            if (paramsInHeader != null) {
                data = requestJsonStream;
                byte[] bytes = paramsInHeader.getBytes(StandardCharsets.UTF_8);
                requestJsonStream = new ByteArrayInputStream(bytes);
                if (igzip) {
                    requestJsonStream = new GZIPInputStream((InputStream)requestJsonStream);
                }
            }
            String principal = this.getPrincipal(req);
            String sessionID = req.getHeader("com.indy.engine.common.EngineFactory.sessionId");
            IRemoteSessionV01 remoteSession = RemoteSessionManagement.INSTANCE.getRemote(sessionID, req.getRemoteHost(), principal);
            Object invocationResult = invoker.invokeRuntimeMethod((InputStream)requestJsonStream, (InputStream)data, remoteSession);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (ogzip) {
                GZIPOutputStream gos = new GZIPOutputStream(baos);
                JsonNode.serialize((Object)invocationResult, (OutputStream)gos, (String)StandardCharsets.UTF_8.name());
                gos.finish();
                resp.setHeader("Content-Encoding", "gzip");
            } else {
                JsonNode.serialize((Object)invocationResult, (OutputStream)baos, (String)StandardCharsets.UTF_8.name());
            }
            byte[] bytes = baos.toByteArray();
            resp.setStatus(HttpStatus.OK.value());
            resp.getWriter().write(new String(bytes, StandardCharsets.UTF_8.name()));
        }
        catch (Exception t) {
            this.handleError(t, resp);
        }
    }

    private String getPrincipal(HttpServletRequest req) {
        try {
            Principal p = req.getUserPrincipal();
            if (p != null) {
                return p.getName();
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        return null;
    }

    private void handleError(Exception t, HttpServletResponse resp) {
        InvocationTargetException ite;
        Throwable throwable;
        if (t instanceof InvocationTargetException && (throwable = (ite = (InvocationTargetException)t).getTargetException()) instanceof Exception) {
            Exception e;
            t = e = (Exception)throwable;
        }
        try {
            throw t;
        }
        catch (PrivilegeException ex) {
            this.doHandleError(HttpStatus.FORBIDDEN.value(), "Execution grants required ", (Exception)((Object)ex), resp);
        }
        catch (Exception ex) {
            this.doHandleError(HttpStatus.BAD_REQUEST.value(), "Internal Error", ex, resp);
        }
    }
}

