/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.runtime.httpserver;

import com.google.common.net.InetAddresses;
import com.indy.engine.Global;
import com.indy.engine.common.security.SecurityConfiguration;
import com.indy.engine.core.security.Role;
import com.semarchy.xdi.runtime.httpserver.LegacyAnonymousAuthenticationFilter;
import com.semarchy.xdi.runtime.httpserver.LegacyBasicAuthenticationProvider;
import jakarta.servlet.Filter;
import jakarta.servlet.http.HttpServletRequest;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authorization.AuthorizationDecision;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.annotation.web.configurers.SessionManagementConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.expression.WebSecurityExpressionRoot;
import org.springframework.security.web.access.intercept.RequestAuthorizationContext;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.IpAddressMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@Configuration
@EnableWebSecurity
public class SecurityConfig {
    @Autowired
    private LegacyBasicAuthenticationProvider authProvider;
    private static final String UNIVERSAL_MATCH_PATTERN = "/**";

    @Bean
    public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
        SecurityConfiguration conf = Global.getUserConfiguration();
        if (conf != null && !conf.getUsers().isEmpty()) {
            http.addFilter((Filter)new LegacyAnonymousAuthenticationFilter()).httpBasic(Customizer.withDefaults()).csrf(c -> {
                HttpSecurityBuilder httpSecurityBuilder = c.disable();
            }).authorizeHttpRequests(a -> {
                AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)a.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/error")})).access(this.createAuthorizationManager(new Role[0]));
            }).authorizeHttpRequests(a -> {
                AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)a.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/rest/DeliveryService/1/*"), new AntPathRequestMatcher("/rest/StambiaDeliveryService/1/*"), new AntPathRequestMatcher("/wsi"), new AntPathRequestMatcher("/nonwsi"), new AntPathRequestMatcher("/wsi/*"), new AntPathRequestMatcher("/nonwsi/*"), new AntPathRequestMatcher("/rest/DeliveryService/2/*"), new AntPathRequestMatcher("/rest/StambiaDeliveryService/2/*")})).access(this.createAuthorizationManager(Role.values()));
            }).authorizeHttpRequests(a -> {
                AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)a.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/rest/DeliveryService/3/**"), new AntPathRequestMatcher("/rest/StambiaDeliveryService/3/**")})).access(this.createAuthorizationManager(Role.values()));
            }).authorizeHttpRequests(a -> {
                AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)a.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/swagger-ui/*")})).access(this.createAuthorizationManager(Role.Monitor, Role.Admin, Role.ExecuteAPI));
            }).authorizeHttpRequests(a -> {
                AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)a.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/v3/api-docs/*")})).access(this.createAuthorizationManager(Role.Monitor, Role.Admin, Role.ExecuteAPI));
            }).authorizeHttpRequests(a -> {
                AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)a.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/client/*")})).access(this.createAuthorizationManager(Role.values()));
            }).authorizeHttpRequests(a -> {
                AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)a.requestMatchers(new RequestMatcher[]{EndpointRequest.toAnyEndpoint().excluding(new String[]{"health"})})).access(this.createAuthorizationManager(Role.Admin, Role.Monitor));
            }).authorizeHttpRequests(a -> {
                AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)a.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/api/1/deliveries/**", HttpMethod.GET.name()), new AntPathRequestMatcher("/api/1/delivery-repositories/**", HttpMethod.GET.name())})).access(this.createAuthorizationManager(Role.View, Role.Admin));
            }).authorizeHttpRequests(a -> {
                AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)a.requestMatchers(new RequestMatcher[]{new AntPathRequestMatcher("/api/1/deliveries/**", HttpMethod.POST.name()), new AntPathRequestMatcher("/api/1/deliveries/**", HttpMethod.DELETE.name()), new AntPathRequestMatcher("/api/1/deliveries/**", HttpMethod.PUT.name())})).access(this.createAuthorizationManager(Role.Admin));
            }).authorizeHttpRequests(a -> {
                AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)a.requestMatchers(new RequestMatcher[]{EndpointRequest.to((String[])new String[]{"health"})})).access(this.createAuthorizationManager(new Role[0]));
            }).sessionManagement(s -> {
                SessionManagementConfigurer sessionManagementConfigurer = s.sessionCreationPolicy(SessionCreationPolicy.STATELESS);
            });
        } else {
            http.csrf(c -> {
                HttpSecurityBuilder httpSecurityBuilder = c.disable();
            });
        }
        http.headers(h -> {
            HeadersConfigurer headersConfigurer = h.frameOptions(f -> {
                HeadersConfigurer headersConfigurer = f.sameOrigin();
            });
        });
        http.authenticationProvider((AuthenticationProvider)this.authProvider);
        return (SecurityFilterChain)http.build();
    }

    private AuthorizationManager<RequestAuthorizationContext> createAuthorizationManager(Role ... roles) {
        return new RuntimeAuthorizationManager(Global.getRemoteHosts(), roles);
    }

    static class RuntimeAuthorizationManager
    implements AuthorizationManager<RequestAuthorizationContext> {
        private final List<String> allowedHosts;
        private final Role[] roles;

        RuntimeAuthorizationManager(List<String> allowedHosts, Role ... roles) {
            this.allowedHosts = allowedHosts;
            this.roles = roles;
        }

        public AuthorizationDecision check(Supplier<Authentication> auth, RequestAuthorizationContext context) {
            SafeWebSecurityExpressionRoot expressionRoot = new SafeWebSecurityExpressionRoot(auth, context.getRequest());
            boolean granted = this.check(expressionRoot);
            return new AuthorizationDecision(granted);
        }

        public boolean check(WebSecurityExpressionRoot expressionRoot) {
            return this.hasAnyAuthority(expressionRoot, this.roles) && this.hasAnyAllowedHost(expressionRoot);
        }

        private boolean hasAnyAllowedHost(WebSecurityExpressionRoot expressionRoot) {
            if (this.allowedHosts.isEmpty()) {
                return true;
            }
            return this.allowedHosts.stream().anyMatch(arg_0 -> ((WebSecurityExpressionRoot)expressionRoot).hasIpAddress(arg_0));
        }

        private boolean hasAnyAuthority(WebSecurityExpressionRoot expressionRoot, Role ... roles) {
            if (roles.length == 0) {
                return true;
            }
            return expressionRoot.hasAnyAuthority((String[])Arrays.stream(roles).map(Enum::name).toArray(String[]::new));
        }
    }

    static class SafeWebSecurityExpressionRoot
    extends WebSecurityExpressionRoot {
        SafeWebSecurityExpressionRoot(Supplier<Authentication> authentication, HttpServletRequest request) {
            super(authentication, request);
        }

        public boolean hasIpAddress(String ipAddressOrHost) {
            try {
                String ipAddress = ipAddressOrHost.contains("/") && InetAddresses.isInetAddress((String)ipAddressOrHost.substring(0, ipAddressOrHost.indexOf(47))) ? ipAddressOrHost : (InetAddresses.isInetAddress((String)ipAddressOrHost) ? ipAddressOrHost : InetAddress.getByName(ipAddressOrHost).getHostAddress());
                IpAddressMatcher matcher = new IpAddressMatcher(ipAddress);
                return matcher.matches(this.request);
            }
            catch (IllegalArgumentException e) {
                if (e.getCause() instanceof UnknownHostException) {
                    return false;
                }
                throw e;
            }
            catch (UnknownHostException e) {
                return false;
            }
        }
    }
}

