/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.index.internal;

import com.semarchy.xdi.designer.core.indexation.IndexationRegisterExtension;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.services.cache.CacheSourceEvent;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import com.semarchy.xdi.designer.index.internal.CacheImpl;
import com.semarchy.xdi.designer.index.internal.Messages;
import com.semarchy.xdi.designer.index.model.Source;
import com.semarchy.xdi.designer.index.parsers.StaxFastResourceLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.emf.common.util.URI;
import org.osgi.service.log.LogService;

public class CacheContent
implements ICacheService.IWorkspaceSynchronizer {
    private Map<URI, Entry> content = Collections.synchronizedMap(new HashMap());
    private Map<String, Collection<Entry>> idContent = Collections.synchronizedMap(new HashMap());
    private List<ICacheService.ICacheSourceEventListener> listeners = Collections.synchronizedList(new ArrayList());
    private boolean initializing = false;
    private XDIModelURIResolver modelResolver;

    public CacheContent(XDIModelURIResolver modelResolver) {
        this.modelResolver = modelResolver;
    }

    private String extractResourceID(URI uri) {
        StaxFastResourceLoader loader = new StaxFastResourceLoader();
        try {
            return loader.fastParse(uri);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void addEntry(Entry entry) {
        if (entry.getResourceID() == null) {
            return;
        }
        Entry current = this.content.get(entry.getResourceURI());
        if (current != null) {
            throw new RuntimeException();
        }
        this.content.put(entry.getResourceURI(), entry);
        Collection<Entry> c = this.idContent.get(entry.getResourceID());
        if (c == null) {
            c = new HashSet<Entry>();
            this.idContent.put(entry.getResourceID(), c);
            entry.setActive(true);
        }
        c.add(entry);
    }

    private void removeEntry(Entry entry) {
        this.content.remove(entry.getResourceURI());
        Collection<Entry> c = this.idContent.get(entry.getResourceID());
        c.remove(entry);
        if (entry.isActive() && !c.isEmpty()) {
            if (entry.isOverriding()) {
                boolean handled = false;
                Entry internalResource = null;
                for (Entry e : c) {
                    if (e.isInternalResource()) {
                        internalResource = e;
                        continue;
                    }
                    c.iterator().next().setActive(true);
                    handled = true;
                    break;
                }
                if (!handled) {
                    internalResource.setActive(true);
                }
            } else {
                c.iterator().next().setActive(true);
            }
        }
        if (c.isEmpty()) {
            this.idContent.remove(entry.getResourceID());
        }
    }

    public void handleAddedFile(URI uri) {
        if (!IndexationRegisterExtension.EXTENSION_MANAGER.getExtensionFile().containsKey(uri.fileExtension())) {
            return;
        }
        Entry entry = this.find(uri);
        if (entry == null) {
            String id = this.extractResourceID(uri);
            entry = new Entry(uri, id);
            entry.resourceID = id;
            Entry byID = this.find(entry.getResourceID());
            this.addEntry(entry);
            if (byID != null) {
                if (byID.getResourceURI().isPlatformPlugin()) {
                    byID.setActive(false);
                    entry.setActive(true);
                    entry.overridenInternalURI = byID.getResourceURI();
                    this.notifyListeners(new CacheSourceEvent(entry.getResourceID(), entry.getResourceURI(), byID.getResourceURI(), CacheSourceEvent.Event.OVERRIDE));
                } else {
                    entry.overridenInternalURI = byID.overridenInternalURI;
                    this.notifyListeners(new CacheSourceEvent(entry.getResourceID(), entry.getResourceURI(), null, CacheSourceEvent.Event.DUPLICATE));
                }
            } else {
                this.notifyListeners(new CacheSourceEvent(entry.getResourceID(), entry.getResourceURI(), null, CacheSourceEvent.Event.CREATE));
            }
        }
    }

    private Entry find(String resourceID) {
        Collection<Entry> c = this.idContent.get(resourceID);
        if (c != null) {
            Entry candidate = null;
            Iterator<Entry> iterator = c.iterator();
            while (iterator.hasNext()) {
                Entry e;
                candidate = e = iterator.next();
                if (!e.isActive()) continue;
                return e;
            }
            return candidate;
        }
        return null;
    }

    public void handleModifiedFile(final URI uri) {
        if (!IndexationRegisterExtension.EXTENSION_MANAGER.getExtensionFile().containsKey(uri.fileExtension())) {
            return;
        }
        final Entry currentEntry = this.find(uri);
        if (currentEntry == null) {
            this.handleAddedFile(uri);
        } else {
            final String newID = this.extractResourceID(uri);
            if (newID != null && newID.equals(currentEntry.getResourceID())) {
                if (currentEntry.isActive()) {
                    this.notifyListeners(new CacheSourceEvent(currentEntry.getResourceID(), currentEntry.getResourceURI(), null, CacheSourceEvent.Event.UPDATE));
                }
            } else {
                ArrayList<CacheSourceEvent> events = new ArrayList<CacheSourceEvent>();
                ArrayList<Runnable> changes = new ArrayList<Runnable>();
                final String oldID = currentEntry.getResourceID();
                final Entry oldIDEntry = this.find(oldID);
                if (oldIDEntry == null) {
                    throw new RuntimeException("wrong");
                }
                if (!oldIDEntry.isInternalResource()) {
                    if (!currentEntry.isActive()) {
                        events.add(new CacheSourceEvent(oldID, uri, null, CacheSourceEvent.Event.DELETE_DUPLICATE));
                        changes.add(new Runnable(){

                            @Override
                            public void run() {
                                CacheContent.this.removeEntry(currentEntry);
                            }
                        });
                    } else {
                        Collection<Entry> alternatives = this.idContent.get(oldID);
                        if (alternatives.size() > 1) {
                            final AtomicReference<Entry> replacement = new AtomicReference<Entry>();
                            for (Entry e : alternatives) {
                                if (e == oldIDEntry || e.isInternalResource()) continue;
                                replacement.set(e);
                                break;
                            }
                            if (replacement.get() != null) {
                                events.add(new CacheSourceEvent(oldID, ((Entry)replacement.get()).getResourceURI(), oldIDEntry.getResourceURI(), CacheSourceEvent.Event.REPLACE));
                                changes.add(new Runnable(){

                                    @Override
                                    public void run() {
                                        oldIDEntry.setActive(false);
                                        ((Entry)replacement.get()).setActive(true);
                                    }
                                });
                                events.add(new CacheSourceEvent(oldID, oldIDEntry.getResourceURI(), null, CacheSourceEvent.Event.DELETE_DUPLICATE));
                                changes.add(new Runnable(){

                                    @Override
                                    public void run() {
                                        CacheContent.this.removeEntry(oldIDEntry);
                                    }
                                });
                            } else if (oldIDEntry.isOverriding()) {
                                events.add(new CacheSourceEvent(oldID, oldIDEntry.overridenInternalURI, oldIDEntry.getResourceURI(), CacheSourceEvent.Event.RESTORE));
                                changes.add(new Runnable(){

                                    @Override
                                    public void run() {
                                        CacheContent.this.removeEntry(oldIDEntry);
                                        CacheContent.this.find(oldID).setActive(true);
                                    }
                                });
                            } else {
                                events.add(new CacheSourceEvent(oldID, oldIDEntry.getResourceURI(), null, CacheSourceEvent.Event.DELETE));
                                changes.add(new Runnable(){

                                    @Override
                                    public void run() {
                                        CacheContent.this.removeEntry(oldIDEntry);
                                    }
                                });
                            }
                        } else if (oldIDEntry.isOverriding()) {
                            events.add(new CacheSourceEvent(oldID, oldIDEntry.overridenInternalURI, oldIDEntry.getResourceURI(), CacheSourceEvent.Event.RESTORE));
                            changes.add(new Runnable(){

                                @Override
                                public void run() {
                                    CacheContent.this.removeEntry(oldIDEntry);
                                    CacheContent.this.find(oldID).setActive(true);
                                }
                            });
                        } else {
                            events.add(new CacheSourceEvent(oldID, oldIDEntry.getResourceURI(), null, CacheSourceEvent.Event.DELETE));
                            changes.add(new Runnable(){

                                @Override
                                public void run() {
                                    CacheContent.this.removeEntry(oldIDEntry);
                                }
                            });
                        }
                    }
                } else {
                    throw new RuntimeException(Messages.CacheContent_1);
                }
                final Entry newIDEntry = this.find(newID);
                if (newIDEntry != null) {
                    if (newIDEntry.isInternalResource()) {
                        events.add(new CacheSourceEvent(newID, uri, newIDEntry.getResourceURI(), CacheSourceEvent.Event.OVERRIDE));
                        changes.add(new Runnable(){

                            @Override
                            public void run() {
                                newIDEntry.setActive(false);
                                Entry e = new Entry(uri, newID);
                                e.overridenInternalURI = newIDEntry.getResourceURI();
                                e.active = true;
                                CacheContent.this.addEntry(e);
                            }
                        });
                    } else {
                        events.add(new CacheSourceEvent(newID, uri, null, CacheSourceEvent.Event.DUPLICATE));
                        changes.add(new Runnable(){

                            @Override
                            public void run() {
                                Entry e = new Entry(uri, newID);
                                e.active = false;
                                CacheContent.this.addEntry(e);
                            }
                        });
                    }
                } else {
                    events.add(new CacheSourceEvent(newID, uri, null, CacheSourceEvent.Event.CREATE));
                    changes.add(new Runnable(){

                        @Override
                        public void run() {
                            Entry e = new Entry(uri, newID);
                            CacheContent.this.addEntry(e);
                        }
                    });
                }
                for (Runnable r : changes) {
                    r.run();
                }
                for (CacheSourceEvent ev : events) {
                    this.notifyListeners(ev);
                }
            }
        }
    }

    public void handleDeletedFile(URI uri) {
        if (!IndexationRegisterExtension.EXTENSION_MANAGER.getExtensionFile().containsKey(uri.fileExtension())) {
            return;
        }
        Entry entry = this.find(uri);
        if (entry != null) {
            if (entry.isInternalResource()) {
                throw new RuntimeException(Messages.bind((String)Messages.CacheContent_2, (Object)uri));
            }
            if (!entry.isActive()) {
                this.removeEntry(entry);
                this.notifyListeners(new CacheSourceEvent(entry.getResourceID(), uri, null, CacheSourceEvent.Event.DELETE_DUPLICATE));
            } else {
                Collection<Entry> alternatives = this.idContent.get(entry.getResourceID());
                Entry replacement = null;
                ArrayList<Entry> notExistingAlternatives = new ArrayList<Entry>();
                for (Entry e : alternatives) {
                    if (e == entry || e.isInternalResource() || e.getResourceURI() == null) continue;
                    if (this.modelResolver.exists(uri)) {
                        replacement = e;
                        break;
                    }
                    notExistingAlternatives.add(e);
                }
                for (Entry e : notExistingAlternatives) {
                    e.setActive(false);
                    this.removeEntry(e);
                    this.notifyListeners(new CacheSourceEvent(entry.getResourceID(), e.getResourceURI(), null, CacheSourceEvent.Event.DELETE_DUPLICATE));
                }
                if (replacement != null) {
                    entry.setActive(false);
                    replacement.setActive(true);
                    this.notifyListeners(new CacheSourceEvent(entry.getResourceID(), replacement.getResourceURI(), entry.getResourceURI(), CacheSourceEvent.Event.REPLACE));
                    this.removeEntry(entry);
                    this.notifyListeners(new CacheSourceEvent(entry.getResourceID(), entry.getResourceURI(), null, CacheSourceEvent.Event.DELETE_DUPLICATE));
                } else if (entry.isOverriding()) {
                    this.removeEntry(entry);
                    if (this.find(entry.getResourceID()) == null) {
                        Entry e;
                        e = new Entry(entry.overridenInternalURI, entry.getResourceID());
                        this.addEntry(e);
                    }
                    this.notifyListeners(new CacheSourceEvent(entry.getResourceID(), entry.overridenInternalURI, entry.getResourceURI(), CacheSourceEvent.Event.RESTORE));
                } else {
                    this.removeEntry(entry);
                    this.notifyListeners(new CacheSourceEvent(entry.getResourceID(), entry.getResourceURI(), null, CacheSourceEvent.Event.DELETE));
                }
            }
        }
    }

    public void handleMoveFile(URI uri, IPath oldPath) {
        if (!IndexationRegisterExtension.EXTENSION_MANAGER.getExtensionFile().containsKey(uri.fileExtension())) {
            return;
        }
        URI oldURI = URIUtils.convertIPathToEMFURI2((IPath)oldPath);
        Entry entry = this.find(oldURI);
        if (entry != null) {
            this.content.remove(entry.getResourceURI());
            entry.resourceURI = uri;
            this.content.put(uri, entry);
            this.notifyListeners(new CacheSourceEvent(entry.getResourceID(), entry.getResourceURI(), oldURI, CacheSourceEvent.Event.MOVE));
        } else {
            this.handleAddedFile(uri);
        }
    }

    public void handleReplace(URI current, URI duplicate) {
        Entry cur = this.find(current);
        cur = this.find(cur.getResourceID());
        Entry dup = this.find(duplicate);
        cur.setActive(false);
        dup.setActive(true);
        try {
            this.notifyListeners(new CacheSourceEvent(cur.getResourceID(), dup.getResourceURI(), cur.getResourceURI(), CacheSourceEvent.Event.REPLACE));
        }
        catch (Throwable ex) {
            ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.semarchy.xdi.designer.index").info(Messages.bind((String)Messages.CacheContent_4, (Object)current, (Object)duplicate), (Object)ex);
            cur.setActive(true);
            dup.setActive(false);
        }
    }

    private Entry find(URI uri) {
        return this.content.get(uri);
    }

    void initialize(CacheImpl cache) {
        this.addEventListener(cache);
        this.idContent.clear();
        this.content.clear();
        this.initializing = true;
        try {
            Entry e;
            for (URI uri : cache.getInternalResourceRegistry().getInternalResourceURI()) {
                if (!IndexationRegisterExtension.EXTENSION_MANAGER.getExtensionFile().containsKey(uri.fileExtension())) continue;
                String id = this.extractResourceID(uri);
                if (id == null) {
                    ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.semarchy.xdi.designer.index").warn(Messages.CacheContent_6 + String.valueOf(uri));
                    continue;
                }
                e = new Entry(uri, id);
                this.addEntry(e);
            }
            ArrayList<Source> duplicateResources = new ArrayList<Source>();
            block8: for (Source s : cache.getSuper().getResource()) {
                if (s.getURI() == null) continue;
                switch (s.getState()) {
                    case SYNCHRO: 
                    case EXISTS: {
                        if (s.getURI() == null || !s.getURI().isPlatformResource()) continue block8;
                        e = new Entry(s.getURI(), s.getId());
                        this.addEntry(e);
                        Entry byID = this.find(e.getResourceID());
                        if (byID == e || !byID.getResourceURI().isPlatformPlugin()) continue block8;
                        byID.setActive(false);
                        e.setActive(true);
                        e.overridenInternalURI = byID.getResourceURI();
                        break;
                    }
                    case DUPLICATE: {
                        duplicateResources.add(s);
                    }
                }
            }
            for (Source f : duplicateResources) {
                this.handleAddedFile(f.getURI());
            }
        }
        finally {
            this.initializing = false;
        }
    }

    public void addEventListener(ICacheService.ICacheSourceEventListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeEventListener(ICacheService.ICacheSourceEventListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(final CacheSourceEvent event) {
        if (!this.initializing) {
            List<ICacheService.ICacheSourceEventListener> list = this.listeners;
            synchronized (list) {
                Iterator<ICacheService.ICacheSourceEventListener> iterator = this.listeners.iterator();
                while (iterator.hasNext()) {
                    ICacheService.ICacheSourceEventListener _l;
                    final ICacheService.ICacheSourceEventListener l = _l = iterator.next();
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            l.handleEvent(event);
                        }

                        public void handleException(Throwable exception) {
                            ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.semarchy.xdi.designer.index").error(Messages.CacheContent_7 + event.toString() + "}", (Object)exception);
                        }
                    });
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyBatch() {
        List<ICacheService.ICacheSourceEventListener> list = this.listeners;
        synchronized (list) {
            for (ICacheService.ICacheSourceEventListener l : this.listeners) {
                if (!(l instanceof ICacheService.IBatchedListener)) continue;
                final ICacheService.ICacheSourceEventListener _l = l;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        ((ICacheService.IBatchedListener)_l).handBatchedEvents();
                    }

                    public void handleException(Throwable exception) {
                        ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger("com.semarchy.xdi.designer.index").error(Messages.CacheContent_9, (Object)exception);
                    }
                });
            }
        }
    }

    private class Entry {
        private URI resourceURI;
        private String resourceID;
        private URI overridenInternalURI;
        private boolean active = false;

        public Entry(URI resourceURI, String ID) {
            this.resourceURI = resourceURI;
            this.resourceID = ID;
        }

        public URI getResourceURI() {
            return this.resourceURI;
        }

        public String getResourceID() {
            return this.resourceID;
        }

        boolean isInternalResource() {
            return this.resourceURI.isPlatformPlugin();
        }

        boolean isOverriding() {
            return this.overridenInternalURI != null;
        }

        boolean isActive() {
            return this.active;
        }

        void setActive(boolean active) {
            this.active = active;
        }
    }
}

