/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.log;

import com.indy.engine.core.classloader.IClassLoader;
import com.indy.engine.log.ILog;
import com.indy.engine.log.ListenerList;
import com.indy.engine.log.Messages;
import com.indy.engine.log.aggregation.ActionTree;
import com.indy.engine.log.aggregation.Aggregates;
import com.indy.engine.log.aggregation.SessionTree;
import com.indy.engine.log.engine.AnalyticsEngineWrapper;
import com.indy.engine.log.engine.EngineLog;
import com.indy.engine.log.engine.EngineRegistry;
import com.indy.engine.log.object.IEngineActionHeader;
import com.indy.engine.log.object.IEngineLogHeader;
import com.indy.engine.log.object.IEngineSessionHeader;
import com.indy.engine.log.object.ILogHeaderReader;
import com.indy.engine.log.object.impl.ActionList;
import com.indy.engine.log.rdbms.RdbmsLog;
import com.indy.engine.log.reader.IActionHeaderReader;
import com.indy.engine.log.reader.IEngineDeliveryReader;
import com.indy.engine.log.reader.IEngineErrorReader;
import com.indy.engine.log.reader.IEngineRuntimeReader;
import com.indy.engine.log.reader.IEngineStatisticReader;
import com.indy.engine.log.reader.IEngineVariableReader;
import com.indy.engine.log.reader.ISessionHeaderReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineSessionManager {
    Map<String, SessionStatistic> sessionsStatistic = new HashMap<String, SessionStatistic>();
    Map<String, ILog> logs = new HashMap<String, ILog>();
    SessionList sessionsCached = new SessionList();
    Map<String, Map<String, Object>> sessionsVariable = new HashMap<String, Map<String, Object>>();
    Map<String, Map<String, Object>> sessionsError = new HashMap<String, Map<String, Object>>();
    Map<String, Map<String, Object>> sessionsWarning = new HashMap<String, Map<String, Object>>();
    Map<String, SessionList> sessionsList = new HashMap<String, SessionList>();
    Map<String, Map<String, IEngineActionHeader>> actionsHeader = new HashMap<String, Map<String, IEngineActionHeader>>();
    Map<String, Map<Integer, IEngineLogHeader>> logsHeader = new HashMap<String, Map<Integer, IEngineLogHeader>>();
    private Map<String, ActionList> actionsList = new HashMap<String, ActionList>();
    private IClassLoader jdbcClassLoader;
    List<Log2> internalLogs = new ArrayList<Log2>();
    private static Logger logger = LoggerFactory.getLogger(EngineSessionManager.class);
    Date maxDate = null;
    Date minDate = null;
    public static final int REFRESH_SESSION_DETAIL_MODE = 0;
    public static final int REFRESH_SESSION_LOG_MODE = 1;
    public static final int REFRESH_SESSION_FULL_MODE = 2;
    ObjectReader objectReader;
    Set<String> statisticsName = new HashSet<String>();

    public void setJdbcClassLoader(IClassLoader jdbcClassLoader) {
        this.jdbcClassLoader = jdbcClassLoader;
    }

    public IClassLoader getJdbcClassLoader() {
        return this.jdbcClassLoader;
    }

    public SessionList getSessionList(String listName) {
        SessionList list = this.sessionsList.get(listName);
        if (list == null) {
            list = new SessionList();
            this.sessionsList.put(listName, list);
        }
        return list;
    }

    public void clearSessionList(String listName) {
        SessionList list = this.sessionsList.get(listName);
        if (list != null) {
            list.clear(false);
        }
    }

    public void removeSessionList(String listName) {
        SessionList list = this.sessionsList.get(listName);
        if (list != null) {
            list.clear(false);
            this.sessionsList.remove(list);
        }
    }

    public void removeActionList(String listName) {
        ActionList list = this.actionsList.get(listName);
        if (list != null) {
            list.clear();
            this.actionsList.remove(listName);
        }
    }

    public ActionList getActionList(String listName) {
        ActionList list = this.actionsList.get(listName);
        if (list == null) {
            list = new ActionList();
            this.actionsList.put(listName, list);
        }
        return list;
    }

    public synchronized void setLogs(Map<String, ILog> allLogs) {
        this.logs.clear();
        this.logs.putAll(allLogs);
        for (ILog log : allLogs.values()) {
            log.setObjectReader(this.objectReader);
        }
    }

    public Map<String, Map<String, Object>> getLogsState() {
        HashMap<String, Map<String, Object>> res = new HashMap<String, Map<String, Object>>();
        for (Log2 log2 : this.internalLogs) {
            ILog log = log2.log;
            res.put(log.getName(), new HashMap());
            if (Boolean.TRUE.equals(log.isConnected())) {
                ((Map)res.get(log.getName())).put("status", Messages.EngineSessionManager_1);
                ((Map)res.get(log.getName())).put("message", Messages.EngineSessionManager_1);
                continue;
            }
            if (log.getConnectionException() != null && log.getConnectionException().getMessage() != null) {
                ((Map)res.get(log.getName())).put("status", Messages.EngineSessionManager_5);
                ((Map)res.get(log.getName())).put("message", log.getConnectionException().getMessage());
                ((Map)res.get(log.getName())).put("stackTrace", log.getConnectionException());
                continue;
            }
            ((Map)res.get(log.getName())).put("status", Messages.EngineSessionManager_9);
            ((Map)res.get(log.getName())).put("message", Messages.EngineSessionManager_9);
        }
        return res;
    }

    public Collection<ILog> getLogs() {
        return this.logs.values();
    }

    public Map<String, Object> getSessionVariable(String sessionId) throws Exception {
        Map<String, Object> result = this.sessionsVariable.get(sessionId);
        if (result == null) {
            ILog log = this.getLog(sessionId);
            Integer iter = this.getSessionIter(sessionId);
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put(sessionId, iter);
            if (log != null) {
                this.refreshSessionVariables(map, null, log, true);
                result = this.sessionsVariable.get(sessionId);
            }
        }
        return result;
    }

    private Integer getSessionIter(String sessionId) {
        IEngineSessionHeader header = this.sessionsCached.getLastSession(sessionId);
        if (header != null) {
            return header.getIter();
        }
        return null;
    }

    private synchronized ILog getLog(String sessionId) {
        String id;
        IEngineSessionHeader header = this.sessionsCached.getLastSession(sessionId);
        if (header != null && (id = header.getIdLog()) != null) {
            return this.logs.get(id);
        }
        return null;
    }

    public Map<String, Object> getSessionError(String sessionId) throws DataFormatException, Exception {
        Map<String, Object> result = this.sessionsError.get(sessionId);
        if (result == null) {
            ILog log = this.getLog(sessionId);
            Integer iter = this.getSessionIter(sessionId);
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put(sessionId, iter);
            if (log != null) {
                this.refreshSessionErrors(map, null, log, true);
                result = this.sessionsError.get(sessionId);
            }
        }
        return result;
    }

    public Map<String, Object> getSessionWarning(String sessionId) throws Exception {
        Map<String, Object> result = this.sessionsWarning.get(sessionId);
        if (result == null) {
            ILog log = this.getLog(sessionId);
            Integer iter = this.getSessionIter(sessionId);
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put(sessionId, iter);
            if (log != null) {
                this.refreshSessionErrors(map, null, log, true);
                result = this.sessionsWarning.get(sessionId);
            }
        }
        return result;
    }

    public Map<String, Long> getSessionStatistic(String sessionId) throws Exception {
        IEngineSessionHeader session = this.sessionsCached.getLastSession(sessionId);
        if (session != null) {
            SessionStatistic stat = null;
            if (session.getEndDate() == null) {
                stat = null;
            } else {
                stat = this.sessionsStatistic.get(sessionId);
                if (stat != null) {
                    if (stat.date == null) {
                        stat = null;
                    } else if (!stat.date.equals(session.getEndDate())) {
                        stat = null;
                    }
                }
            }
            if (stat == null) {
                ILog log = this.getLog(sessionId);
                Integer iter = this.getSessionIter(sessionId);
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                map.put(sessionId, iter);
                if (log != null) {
                    HashMap<String, Object> criteria = new HashMap<String, Object>();
                    ArrayList<String> sessionIds = new ArrayList<String>();
                    sessionIds.add(sessionId);
                    criteria.put("sessionId", sessionIds);
                    this.refreshSessionStatistics(map, criteria, log);
                    if (session.getEndDate() == null) {
                        stat = null;
                    } else {
                        stat = this.sessionsStatistic.get(sessionId);
                        if (stat != null) {
                            if (stat.date == null) {
                                stat = null;
                            } else if (!stat.date.equals(session.getEndDate())) {
                                stat = null;
                            }
                        }
                    }
                }
            }
            if (stat != null) {
                return stat.getStatistics();
            }
        }
        return null;
    }

    public EngineSessionManager(ObjectReader objectReader) {
        this.objectReader = objectReader;
    }

    public IEngineActionHeader getActionHeader(String sessionId, int sessIter, String actionId, int actionIter) {
        Map<String, IEngineActionHeader> session = this.actionsHeader.get(sessionId);
        if (session != null) {
            return session.get(String.valueOf(sessIter) + "|" + actionId + "." + actionIter);
        }
        return null;
    }

    public Aggregates getActionStatistic(String listName, String sessionId, int sessIter, String actionId, int actionIter) {
        ActionTree action;
        SessionTree session;
        ActionList list;
        IEngineActionHeader header = this.getActionHeader(sessionId, sessIter, actionId, actionIter);
        if (header != null && (list = this.actionsList.get(listName)) != null && (session = list.getSessionTree()) != null && (action = session.getAction(header.getUUID())) != null) {
            return action.aggregation();
        }
        return null;
    }

    public synchronized Map<String, Object> getRuntimes() throws Exception {
        logger.debug("Connect...");
        for (ILog log : this.logs.values()) {
            log.connect();
        }
        logger.debug("Connected");
        HashMap<String, Object> runtime = new HashMap<String, Object>();
        for (ILog log : this.logs.values()) {
            runtime.putAll(log.refreshRuntimes());
        }
        return runtime;
    }

    public synchronized Map<String, Object> getDeliveries() throws Exception {
        logger.debug("Connect...");
        for (ILog log : this.logs.values()) {
            log.connect();
        }
        logger.debug("Connected");
        HashMap<String, Object> deliveries = new HashMap<String, Object>();
        for (ILog log : this.logs.values()) {
            log.refreshDeliveriesAndConfigurations();
            deliveries.putAll(log.getDeliveries());
        }
        return deliveries;
    }

    public synchronized Collection<IEngineSessionHeader> getSessionsExecutedByAction(String sessionId, String actionId) throws Exception {
        HashSet<IEngineSessionHeader> childSessionHeader = new HashSet<IEngineSessionHeader>();
        logger.debug("Connect...");
        for (ILog log : this.logs.values()) {
            log.connect();
        }
        logger.debug("Connected");
        ArrayList<String> idsToRefresh = new ArrayList<String>();
        for (ILog log : this.logs.values()) {
            idsToRefresh.addAll(log.getSessionExecutedByAction(sessionId, actionId));
        }
        if (!idsToRefresh.isEmpty()) {
            HashMap<String, Object> criteria = new HashMap<String, Object>();
            criteria.put("sessionId", idsToRefresh);
            for (ILog log : this.logs.values()) {
                childSessionHeader.addAll(log.refreshSessionHeader(criteria, false).values());
            }
        }
        return childSessionHeader;
    }

    public synchronized Collection<IEngineSessionHeader> getSessionChildSession(String sessionId) throws Exception {
        HashSet<IEngineSessionHeader> childSessionHeader = new HashSet<IEngineSessionHeader>();
        logger.debug("Connect...");
        ArrayList<ILog> connectedLog = new ArrayList<ILog>();
        for (ILog log : this.logs.values()) {
            try {
                if (!log.connect()) continue;
                connectedLog.add(log);
            }
            catch (Exception e) {
                logger.debug(String.format("Couldn't connect to:  %s", log.getName()));
            }
        }
        logger.debug("Connected");
        for (ILog log : connectedLog) {
            childSessionHeader.addAll(log.getSessionChildSession(sessionId));
        }
        return childSessionHeader;
    }

    public synchronized Set<String> getConfigurations() throws Exception {
        logger.debug("Connect...");
        for (ILog log : this.logs.values()) {
            log.connect();
        }
        logger.debug("Connected");
        HashSet<String> configurations = new HashSet<String>();
        for (ILog log : this.logs.values()) {
            log.refreshDeliveriesAndConfigurations();
            configurations.addAll(log.getConfigurations());
        }
        return configurations;
    }

    public Map<String, Object> getActionVariable(String listName, int sessIter, String actionId, int actionIter) {
        ActionList list = this.actionsList.get(listName);
        if (list != null) {
            Map<String, Map<String, Object>> session = list.actionsVariable;
            return session.get(String.valueOf(sessIter) + "|" + actionId + "." + actionIter);
        }
        return Collections.emptyMap();
    }

    public synchronized Object refreshSession(String sessionId, String actionListName, int mode, SubProgressMonitor subMonitor, boolean allIteration, Integer iter) throws Exception {
        ActionList actionList = this.getActionList(actionListName);
        boolean isReseted = false;
        if (actionList != null && actionList.getLastMode() != mode) {
            this.removeActionList(actionListName);
            actionList = this.getActionList(actionListName);
            isReseted = true;
        }
        actionList.setLastMode(mode);
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("sessionId", sessionId);
        Object sd = this.refreshSessionList(criteria, actionListName, allIteration, subMonitor);
        this.objectReader.setSessionDeltaIsReseted(sd, isReseted);
        IEngineSessionHeader esh = this.sessionsCached.getLastSession(sessionId);
        String strStartDate = esh.getStrBeginDate();
        String strEndDate = esh.getStrEndDate();
        String lastBeginDate = actionList.getLastBeginDate();
        String lastEndDate = actionList.getLastEndDate();
        String version = esh.getVersion();
        this.objectReader.setSessionHasChanged(sd, false);
        if (lastBeginDate != null && !lastBeginDate.equals(strStartDate)) {
            this.objectReader.setSessionHasChanged(sd, true);
        } else if (lastBeginDate == null) {
            this.objectReader.setSessionHasChanged(sd, true);
        } else if (esh.getEndDate() == null) {
            this.objectReader.setSessionHasChanged(sd, true);
        } else if (lastEndDate == null) {
            this.objectReader.setSessionHasChanged(sd, true);
        }
        actionList.setLastBeginDate(strStartDate);
        actionList.setLastEndDate(strEndDate);
        String reportLog = esh.getIdLog();
        ILog log = this.logs.get(reportLog);
        int nbAdded = 0;
        int nbAddedToCache = 0;
        int nbUpdateToCache = 0;
        int nbUpdated = 0;
        String maxEndActionDate = actionList.getMaxEndActionDate();
        String maxBeginActionDate = actionList.getMaxBeginActionDate();
        Map<String, IEngineActionHeader> cachedActions = this.actionsHeader.get(sessionId);
        if (log != null) {
            if (cachedActions == null) {
                cachedActions = new HashMap<String, IEngineActionHeader>();
                this.actionsHeader.put(sessionId, cachedActions);
            }
            Map<String, IEngineActionHeader> newActions = log.refreshActionHeader2(sessionId, maxBeginActionDate, maxEndActionDate, version, iter);
            HashMap<String, IEngineActionHeader> actionsToRefresh = new HashMap<String, IEngineActionHeader>();
            for (IEngineActionHeader newAction : newActions.values()) {
                if (subMonitor.isCanceled()) {
                    return sd;
                }
                String uid = String.valueOf(newAction.getSessionIter()) + "|" + newAction.getId() + "." + newAction.getIter();
                IEngineActionHeader cachedAction = cachedActions.get(uid);
                boolean cachedModification = false;
                if (cachedAction != null) {
                    if (!EngineSessionManager.equalsWithNull(newAction.getStrEndDate(), cachedAction.getStrEndDate())) {
                        cachedModification = true;
                        cachedAction = newAction;
                        ++nbUpdateToCache;
                    }
                } else {
                    cachedModification = true;
                    cachedAction = newAction;
                    ++nbAddedToCache;
                }
                actionsToRefresh.put(uid, cachedAction);
                if (cachedModification) {
                    cachedActions.put(uid, cachedAction);
                }
                if (actionList == null) continue;
                actionList.updateAction(cachedAction, this.objectReader, sd, mode == 0 || mode == 2);
                nbUpdated += actionList.getNbToUpdate();
                nbAdded += actionList.getNbToadd();
            }
            if (actionList != null && actionsToRefresh.size() > 0) {
                Map<String, Map<String, Object>> map3;
                SessionTree sessTree = actionList.getSessionTree();
                sessTree.buildTree(actionsToRefresh.values());
                Map<String, Map<String, Long>> map = log.refreshActionStatistic(actionsToRefresh, sessionId, 1, this.statisticsName, esh.getVersion());
                sessTree.refresh(map);
                if (!actionList.isStaticVarSet()) {
                    map3 = log.refreshStaticActionVariable(esh.getDeliveryId());
                    actionList.actionsStaticsVariable = map3;
                    actionList.setStaticVarSet(true);
                }
                if (!actionList.isAltIdsSet()) {
                    map3 = log.refreshAltIds(esh.getDeliveryId());
                    actionList.altIds = map3;
                    actionList.setAltIdsSet(true);
                }
                Map<String, Map<String, Object>> map2 = log.refreshActionVariable(actionsToRefresh.keySet(), sessionId, esh.getIter(), esh.getDeliveryId(), version, actionList);
                for (IEngineActionHeader action : actionsToRefresh.values()) {
                    IEngineVariableReader var;
                    if (subMonitor.isCanceled()) {
                        return sd;
                    }
                    Map<String, Object> staticVars = actionList.actionsStaticsVariable.get(action.getId());
                    Map<String, Object> vars = map2.get(action.getUUID());
                    if (vars == null) {
                        vars = new HashMap<String, Object>();
                        map2.put(action.getUUID(), vars);
                    }
                    if (staticVars != null) {
                        for (String key : staticVars.keySet()) {
                            Object dynVar = vars.get(key);
                            Object staticVar = staticVars.get(key);
                            if (dynVar == null) {
                                dynVar = this.objectReader.copyVariable(staticVar);
                                vars.put(key, dynVar);
                                continue;
                            }
                            this.objectReader.updateSourceVariable(dynVar, staticVar);
                        }
                    }
                    if (actionList.altIds != null) {
                        this.objectReader.updateActionHeaderAltIds(action, actionList.altIds.get(action.getId()));
                    }
                    if (action.getStrEndDate() != null) {
                        var = this.createVariable(null, "String", action.getStrEndDate(), "CORE_END_DATE", action.getSessionIter(), sessionId, null, action.getIter(), action.getId());
                        vars.put(var.getShortName(), this.objectReader.createVariable(var, false));
                        Date end = action.getEndDate();
                        Date start = action.getBeginDate();
                        if (start != null) {
                            long diff = end.getTime() - start.getTime();
                            var = this.createVariable(null, "Long", String.valueOf(diff), "CORE_DURATION", action.getSessionIter(), sessionId, null, action.getIter(), action.getId());
                            vars.put(var.getShortName(), this.objectReader.createVariable(var, false));
                        }
                        var = this.createVariable(null, "Integer", String.valueOf(action.getStatus()), "CORE_RET_CODE", action.getSessionIter(), sessionId, null, action.getIter(), action.getId());
                        vars.put(var.getShortName(), this.objectReader.createVariable(var, false));
                    }
                    if (action.getStrBeginDate() != null) {
                        var = this.createVariable(null, "String", action.getStrBeginDate(), "CORE_BEGIN_DATE", action.getSessionIter(), sessionId, null, action.getIter(), action.getId());
                        vars.put(var.getShortName(), this.objectReader.createVariable(var, false));
                    }
                    var = this.createVariable(null, "String", String.valueOf(action.getNbExecution()), "CORE_NB_EXECUTIONS", action.getSessionIter(), sessionId, null, action.getIter(), action.getId());
                    vars.put(var.getShortName(), this.objectReader.createVariable(var, false));
                }
                for (String key : map2.keySet()) {
                    if (actionList.actionsVariable.containsKey(key)) {
                        for (String key2 : map2.get(key).keySet()) {
                            if (actionList.actionsVariable.get(key).containsKey(key2)) {
                                if (actionList.actionsVariable.get(key).get(key2).equals(map2.get(key).get(key2))) continue;
                                actionList.actionsVariable.get(key).put(key2, map2.get(key).get(key2));
                                continue;
                            }
                            actionList.actionsVariable.get(key).put(key2, map2.get(key).get(key2));
                        }
                        continue;
                    }
                    actionList.actionsVariable.put(key, map2.get(key));
                }
            }
        }
        int nbLogToCache = 0;
        int nbLogToDelta = 0;
        if (mode == 1 || mode == 2) {
            Map<Integer, IEngineLogHeader> newLogss;
            Map<Integer, IEngineLogHeader> cachedLogs = this.logsHeader.get(sessionId);
            if (cachedLogs == null) {
                cachedLogs = new HashMap<Integer, IEngineLogHeader>();
                this.logsHeader.put(sessionId, cachedLogs);
            }
            if ((newLogss = log.refreshLogHeader(sessionId, actionList.getMaxLogNum())) != null) {
                HashSet<IEngineActionHeader> missParent = new HashSet<IEngineActionHeader>();
                for (IEngineLogHeader newLog : newLogss.values()) {
                    String id;
                    IEngineActionHeader cachedAction;
                    IEngineLogHeader logHeader;
                    Integer num = newLog.getNum();
                    IEngineLogHeader cachedLog = cachedLogs.get(num);
                    if (cachedLog == null) {
                        cachedLog = newLog;
                        cachedLogs.put(num, cachedLog);
                        ++nbLogToCache;
                    }
                    if (actionList == null || (logHeader = actionList.getLog(num)) != null) continue;
                    this.objectReader.addLogToDelta(sd, cachedLog);
                    ++nbLogToDelta;
                    if (cachedLog.getNum() > actionList.getMaxLogNum()) {
                        actionList.setMaxLogNum(cachedLog.getNum());
                    }
                    if (mode != 1 || (cachedAction = cachedActions.get(id = cachedLog.getParentUUID())) == null) continue;
                    missParent.add(cachedAction);
                }
                if (mode == 1) {
                    while (!missParent.isEmpty()) {
                        for (IEngineActionHeader action : new HashSet(missParent)) {
                            IEngineActionHeader parent;
                            actionList.updateAction(action, this.objectReader, sd, true);
                            nbUpdated += actionList.getNbToUpdate();
                            nbAdded += actionList.getNbToadd();
                            missParent.remove(action);
                            if (action.getParentId() == null || (parent = cachedActions.get(action.getParentUUID())) == null) continue;
                            missParent.add(parent);
                        }
                    }
                }
            }
        }
        logger.debug("Action add to cache: " + nbAddedToCache);
        logger.debug("Action update from cache: " + nbUpdateToCache);
        logger.debug("Action add to delta: " + nbAdded);
        logger.debug("Action add to delta for update:  " + nbUpdated);
        logger.debug("Log add to cache: " + nbLogToCache);
        logger.debug("Log add to delta: " + nbLogToDelta);
        return sd;
    }

    public synchronized Object refreshSessionList(Map<String, Object> criteria, String listName, boolean allIteration, SubProgressMonitor subMonitor) throws Exception {
        SessionList sessionsList = this.getSessionList(listName);
        this.internalLogs.clear();
        for (ILog log : this.logs.values()) {
            this.internalLogs.add(new Log2(log));
        }
        logger.debug("start");
        int nbAddedToCache = 0;
        int nbUpdateToCache = 0;
        int nbAdded = 0;
        int nbUpdated = 0;
        int nbRemoved = 0;
        HashSet<String> already = new HashSet<String>();
        HashSet<String> toRemoved = null;
        logger.debug("Connect...");
        subMonitor.setTaskName("Connect...");
        subMonitor.worked(1);
        ArrayList<Log2> okLogs = new ArrayList<Log2>();
        ArrayList<Log2> koLogs = new ArrayList<Log2>();
        for (Log2 log2 : this.internalLogs) {
            if (subMonitor.isCanceled()) {
                return null;
            }
            try {
                if (criteria.containsKey("runtimeId") && (!criteria.containsKey("runtimeId") || !criteria.get("runtimeId").equals(log2.log.getLogId()))) continue;
                log2.log.connect(false);
                log2.reset();
                okLogs.add(log2);
                logger.debug("Connected to: " + log2.log.getName());
                subMonitor.setTaskName("Connected to: " + log2.log.getName());
                subMonitor.worked(1);
            }
            catch (Exception e) {
                logger.debug(String.valueOf(Messages.EngineSessionManager_52) + log2.log.getName() + ": " + e.getLocalizedMessage());
                koLogs.add(log2);
            }
        }
        Object sd = null;
        if (sessionsList != null) {
            toRemoved = new HashSet<String>(sessionsList.list.keySet());
            sd = this.objectReader.createSessionDelta();
        }
        Date maxBeginDate = null;
        Date minBeginDate = null;
        for (Log2 log2 : okLogs) {
            if (subMonitor.isCanceled()) {
                return sd;
            }
            logger.debug(String.valueOf(Messages.EngineSessionManager_54) + log2.log.getClass().getName() + " " + log2.log.getName());
            subMonitor.setTaskName(String.valueOf(Messages.EngineSessionManager_54) + log2.log.getName());
            subMonitor.worked(1);
            Map<String, IEngineSessionHeader> newSessions = log2.log.refreshSessionHeader(criteria, allIteration);
            for (IEngineSessionHeader newSession : newSessions.values()) {
                boolean exists;
                if (already.contains(newSession.getUUID())) continue;
                newSession.setIdLog(log2.log.getLogId());
                already.add(newSession.getId());
                boolean bl = exists = sessionsList != null && sessionsList.getSessionContainer(newSession.getId()) != null;
                if (toRemoved != null && exists) {
                    toRemoved.remove(newSession.getId());
                }
                IEngineSessionHeader cachedSession = newSession;
                if (sessionsList == null) continue;
                IEngineSessionHeader listSession = null;
                listSession = allIteration ? sessionsList.get(newSession.getUUID()) : sessionsList.getLastSession(newSession.getId());
                if (listSession != null) {
                    if ((cachedSession.getEndDate() != null || listSession.getEndDate() != null) && EngineSessionManager.equalsWithNull(cachedSession.getEndDate(), listSession.getEndDate()) && EngineSessionManager.equalsWithNull(cachedSession.getBeginDate(), listSession.getBeginDate()) && cachedSession.getStatus() == listSession.getStatus()) continue;
                    this.objectReader.updateSession(cachedSession.getData(), listSession.getData());
                    this.objectReader.updateSessionToDelta(sd, listSession);
                    maxBeginDate = this.getMaxBeginDate(cachedSession, maxBeginDate);
                    minBeginDate = this.getMinBeginDate(cachedSession, minBeginDate);
                    log2.sessionToAddOrUpdate.put(cachedSession.getId(), cachedSession.getIter());
                    if (this.sessionsCached.get(cachedSession.getUUID()) != null) {
                        ++nbUpdated;
                    } else {
                        ++nbAddedToCache;
                    }
                    this.sessionsCached.add(cachedSession);
                    continue;
                }
                IEngineSessionHeader newSess = this.objectReader.addSessionToDelta(sd, cachedSession);
                sessionsList.add(newSess);
                maxBeginDate = this.getMaxBeginDate(cachedSession, maxBeginDate);
                minBeginDate = this.getMinBeginDate(cachedSession, minBeginDate);
                ++nbAdded;
                log2.sessionToAddOrUpdate.put(cachedSession.getId(), cachedSession.getIter());
                if (this.sessionsCached.get(cachedSession.getUUID()) != null) {
                    ++nbUpdated;
                } else {
                    ++nbAddedToCache;
                }
                this.sessionsCached.add(cachedSession);
            }
        }
        if (toRemoved != null) {
            for (String id : toRemoved) {
                sessionsList.remove(id);
                this.objectReader.removeSessionToDelta(sd, id);
                ++nbRemoved;
            }
        }
        boolean flowMode = false;
        for (Log2 log2 : okLogs) {
            if (subMonitor.isCanceled()) {
                return sd;
            }
            logger.debug(String.valueOf(Messages.EngineSessionManager_57) + log2.log.getClass().getName());
            subMonitor.setTaskName(String.valueOf(Messages.EngineSessionManager_57) + log2.log.getName());
            subMonitor.worked(1);
            if (log2.sessionToAddOrUpdate.size() <= 0) continue;
            if (maxBeginDate != null) {
                criteria.put("endDateTime", maxBeginDate);
            }
            if (minBeginDate != null) {
                criteria.put("beginDateTime", minBeginDate);
            }
            this.refreshSessionStatistics(log2.sessionToAddOrUpdate, criteria, log2.log);
            ArrayList<String> sessionIds = new ArrayList<String>();
            sessionIds.addAll(log2.sessionToAddOrUpdate.keySet());
            criteria.put("sessionId", sessionIds);
            this.refreshSessionErrors(log2.sessionToAddOrUpdate, criteria, log2.log, flowMode);
            this.refreshSessionVariables(log2.sessionToAddOrUpdate, criteria, log2.log, flowMode);
        }
        logger.debug("sessionCache added Sessions: " + nbAddedToCache);
        logger.debug("sessionCache updated Sessions: " + nbUpdateToCache);
        logger.debug("SessionDelta Session to delta: " + nbAdded);
        logger.debug("SessionDelta Session to update:  " + nbUpdated);
        logger.debug("SessionDelta Session to remove: " + nbRemoved);
        logger.debug("end");
        return sd;
    }

    private Date getMinBeginDate(IEngineSessionHeader sess, Date minBeginDate) {
        if (this.minDate == null) {
            Date date = this.minDate = sess.getBeginDate() != null ? sess.getBeginDate() : this.minDate;
        }
        if (this.minDate != null && sess.getBeginDate() != null && this.minDate.compareTo(sess.getBeginDate()) > 0) {
            this.minDate = sess.getBeginDate();
        }
        return this.minDate;
    }

    private void refreshSessionErrors(Map<String, Integer> sessions, Map<String, Object> criteria, ILog log, boolean refresh) throws Exception {
        if (refresh) {
            for (String sessId : sessions.keySet()) {
                this.sessionsError.put(sessId, new HashMap());
                this.sessionsWarning.put(sessId, new HashMap());
            }
            if (criteria == null) {
                criteria = new HashMap<String, Object>();
                ArrayList<String> sessionIds = new ArrayList<String>();
                sessionIds.addAll(sessions.keySet());
                criteria.put("sessionId", sessionIds);
            }
            Map<String, Map<String, Map<String, Object>>> errorsAndWarning = log.refreshSessionErrorAndWarning(sessions, criteria);
            Map<String, Map<String, Object>> errors = errorsAndWarning.get("errors");
            this.sessionsError.putAll(errors);
            Map<String, Map<String, Object>> warns = errorsAndWarning.get("warnings");
            this.sessionsWarning.putAll(warns);
        } else {
            for (String sessId : sessions.keySet()) {
                this.sessionsError.remove(sessId);
                this.sessionsWarning.remove(sessId);
            }
        }
    }

    private void refreshSessionVariables(Map<String, Integer> sessions, Map<String, Object> criteria, ILog log, boolean refresh) throws Exception {
        if (refresh) {
            if (criteria == null) {
                criteria = new HashMap<String, Object>();
                ArrayList<String> sessionIds = new ArrayList<String>();
                sessionIds.addAll(sessions.keySet());
                criteria.put("sessionId", sessionIds);
            }
            Map<String, Map<String, Object>> vars = log.refreshSessionVariable(sessions, criteria);
            for (String sessId : sessions.keySet()) {
                long l;
                IEngineSessionHeader session;
                Map<String, Object> var = vars.get(sessId);
                if (var == null) {
                    var = new HashMap<String, Object>();
                    vars.put(sessId, var);
                }
                if ((session = this.sessionsCached.getLastSession(sessId)) == null || !session.is1700()) continue;
                IEngineVariableReader _var = this.createVariable(null, "String", session.getStrBeginDate(), "CORE_BEGIN_DATE", session.getIter(), session.getId(), null, 0, null);
                var.put(_var.getShortName(), this.objectReader.createVariable(_var, false));
                if (session.getStrEndDate() != null) {
                    _var = this.createVariable(null, "String", session.getStrEndDate(), "CORE_END_DATE", session.getIter(), session.getId(), null, 0, null);
                    var.put(_var.getShortName(), this.objectReader.createVariable(_var, false));
                    Date end = session.getEndDate();
                    Date start = session.getBeginDate();
                    if (start != null) {
                        long diff = end.getTime() - start.getTime();
                        _var = this.createVariable(null, "Long", String.valueOf(diff), "CORE_DURATION", session.getIter(), sessId, null, 0, null);
                        var.put(_var.getShortName(), this.objectReader.createVariable(_var, false));
                    }
                }
                if (session.getTimeStamp() > -1L) {
                    _var = this.createVariable(null, "Long", String.valueOf(session.getTimeStamp()), "CORE_TIMESTAMP", session.getIter(), sessId, null, 0, null);
                    var.put(_var.getShortName(), this.objectReader.createVariable(_var, false));
                }
                if ((l = session.getSessionTimeStamp()) > 0L) {
                    _var = this.createVariable(null, "Long", String.valueOf(l), "CORE_SESSION_TIMESTAMP", session.getIter(), sessId, null, 0, null);
                    var.put(_var.getShortName(), this.objectReader.createVariable(_var, false));
                }
                if (session.getEngineHost() != null) {
                    _var = this.createVariable(null, "String", session.getEngineHost(), "CORE_ENGINE_HOST", session.getIter(), sessId, null, 0, null);
                    var.put(_var.getShortName(), this.objectReader.createVariable(_var, false));
                }
                if (session.getEnginePort() != null) {
                    _var = this.createVariable(null, "String", session.getEnginePort(), "CORE_ENGINE_PORT", session.getIter(), sessId, null, 0, null);
                    var.put(_var.getShortName(), this.objectReader.createVariable(_var, false));
                }
                if (session.getConfiguration() != null) {
                    _var = this.createVariable(null, "String", session.getConfiguration(), "CORE_SESSION_CONFIGURATION", session.getIter(), sessId, null, 0, null);
                    var.put(_var.getShortName(), this.objectReader.createVariable(_var, false));
                }
                if (session.getName() != null) {
                    _var = this.createVariable(null, "String", session.getName(), "CORE_SESSION_NAME", session.getIter(), sessId, null, 0, null);
                    var.put(_var.getShortName(), this.objectReader.createVariable(_var, false));
                }
                if (session.getId() == null) continue;
                _var = this.createVariable(null, "String", session.getId(), "CORE_SESSION_ID", session.getIter(), sessId, null, 0, null);
                var.put(_var.getShortName(), this.objectReader.createVariable(_var, false));
            }
            this.sessionsVariable.putAll(vars);
        } else {
            for (String sessId : sessions.keySet()) {
                this.sessionsVariable.remove(sessId);
            }
        }
    }

    private void refreshSessionStatistics(Map<String, Integer> sessions, Map<String, Object> criteria, ILog log) throws Exception {
        for (String sessId : sessions.keySet()) {
            this.sessionsStatistic.put(sessId, new SessionStatistic(sessId));
        }
        if (criteria.containsKey("sessionId")) {
            HashSet<String> sessionIds = new HashSet<String>();
            if (criteria.get("sessionId") instanceof Collection) {
                sessionIds.addAll((Collection)criteria.get("sessionId"));
            } else if (criteria.get("sessionId") instanceof String) {
                sessionIds.add((String)criteria.get("sessionId"));
            }
            sessionIds.addAll(sessions.keySet());
            criteria.put("sessionId", sessionIds);
        } else {
            criteria.put("sessionId", sessions.keySet());
        }
        Map<String, Map<Integer, Map<String, Long>>> stats = log.refreshSessionStatistics2(criteria, this.statisticsName);
        for (SessionStatistic _stats : this.sessionsStatistic.values()) {
            IEngineSessionHeader session;
            Map<Integer, Map<String, Long>> s = stats.get(_stats.sessionId);
            if (s != null) {
                _stats.putAll(s);
            }
            if ((session = this.sessionsCached.getLastSession(_stats.sessionId)) == null) continue;
            _stats.date = session.getEndDate();
        }
    }

    private Date getMaxBeginDate(IEngineSessionHeader sess, Date minDate) {
        if (minDate == null) {
            Date date = minDate = sess.getBeginDate() != null ? sess.getBeginDate() : minDate;
        }
        if (minDate != null && sess.getBeginDate() != null && minDate.compareTo(sess.getBeginDate()) < 0) {
            minDate = sess.getBeginDate();
        }
        return minDate;
    }

    private static int compareDate(String date1, String date2) {
        String _date1 = date1;
        _date1 = _date1 == null ? "" : _date1;
        String _date2 = date2;
        _date2 = _date2 == null ? "" : _date2;
        return _date1.compareTo(_date2);
    }

    public void clear() {
        this.clearCache();
        this.sessionsList = null;
        this.actionsList = null;
        this.sessionsError = null;
        this.sessionsWarning = null;
        this.sessionsVariable = null;
        for (Log2 intLog : this.internalLogs) {
            intLog.clear();
        }
        this.internalLogs.clear();
        this.internalLogs = null;
        this.jdbcClassLoader = null;
        for (ILog log : this.logs.values()) {
            try {
                log.clear();
            }
            catch (Exception e) {
                logger.warn("unexpected", (Throwable)e);
            }
        }
    }

    public void clearCache() {
        for (SessionList sessions : this.sessionsList.values()) {
            sessions.clear(false);
        }
        this.sessionsList.clear();
        this.sessionsCached.clear(true);
        for (ActionList actions : this.actionsList.values()) {
            actions.clear();
        }
        this.actionsList.clear();
        this.clear(this.sessionsError);
        this.clear(this.sessionsWarning);
        this.clear(this.sessionsVariable);
    }

    private void clear2(Map<String, Map<String, Map<String, Object>>> map) {
        for (Map<String, Map<String, Object>> map2 : map.values()) {
            for (Map<String, Object> map3 : map2.values()) {
                map3.clear();
            }
            map2.clear();
        }
        map.clear();
    }

    public void addStatisticName(String name) {
        this.statisticsName.add(name);
    }

    public void addStatisticName(String ... names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.statisticsName.add(name);
            ++n2;
        }
    }

    private void clear3(Map<String, SessionStatistic> map) {
        for (SessionStatistic map2 : map.values()) {
            map2.clear();
        }
        map.clear();
    }

    private void clear(Map<String, Map<String, Object>> map) {
        for (Map<String, Object> map2 : map.values()) {
            map2.clear();
        }
        map.clear();
    }

    public boolean testRuntime(String host, int port, String user, String password, String logDirectory) throws Exception {
        return EngineLog.test(host, port, user, password, logDirectory, this.jdbcClassLoader);
    }

    public static Map<String, Object> getRdbmsProperties(String host, int port, String user, String password) throws Exception {
        AnalyticsEngineWrapper engine = EngineRegistry.getDefault().getEngine(host, port, user, EngineLog.testConnection(password));
        Map<String, Object> map = engine.getLogProperties(null);
        String tmp = (String)map.get("userLogRdbmsUrl");
        String url = EngineLog.getHostFromEngineLogProperties(host, tmp);
        map.put("url", url);
        map.remove("userLogRdbmsUrl");
        tmp = (String)map.get("userLogRdbmsDriver");
        if (tmp != null) {
            map.put("driver", tmp);
        }
        map.remove("userLogRdbmsDriver");
        tmp = (String)map.get("userLogRdbmsUser");
        if (tmp != null) {
            map.put("user", tmp);
        }
        map.remove("userLogRdbmsUser");
        map.put("password", EngineLog.getPasswordFromEngineLogProperties(map));
        map.remove("userLogRdbmsPassword");
        map.remove("userLogRdbmsEncryptedPassword");
        tmp = (String)map.get("userLogRdbmsTablePrefix");
        if (tmp != null) {
            map.put("prefix", tmp);
        }
        map.remove("userLogRdbmsTablePrefix");
        tmp = (String)map.get("userLogRdbmsSchemaName");
        if (tmp != null) {
            map.put("schema", tmp);
        }
        map.remove("userLogRdbmsSchemaName");
        return map;
    }

    public boolean testRdbms(Map<String, String> properties, String logDirectory) throws Exception {
        return RdbmsLog.test(properties.get("url"), properties.get("driver"), properties.get("user"), properties.get("password"), properties.get("schemaName"), properties.get("prefix"), null, this.jdbcClassLoader);
    }

    public boolean testRdbms(String url, String driver, String user, String password, String schemaName, String tablePrefix, String id) throws Exception {
        return RdbmsLog.test(url, driver, user, password, schemaName, tablePrefix, id, this.jdbcClassLoader);
    }

    public boolean testRdbms(String connectionName, String schemaName, String tablePrefix, String id) throws Exception {
        return RdbmsLog.test(connectionName, schemaName, tablePrefix, id, this.jdbcClassLoader);
    }

    public static boolean equalsWithNull(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o2 == null) {
            return false;
        }
        if (o1 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static int compareWithNull(Comparable o1, Comparable o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1 == null) {
            return -1;
        }
        return o1.compareTo(o2);
    }

    private IEngineVariableReader createVariable(final String value, final String type, final String source, final String shortName, final int sessionIter, final String sessionId, final String name, final int actionIter, final String actionId) throws Exception {
        return new IEngineVariableReader(){

            @Override
            public String getValue() throws Exception {
                return value;
            }

            @Override
            public String getType() throws Exception {
                return type;
            }

            @Override
            public String getSource() throws Exception {
                return source;
            }

            @Override
            public String getShortName() throws Exception {
                return shortName;
            }

            @Override
            public int getSessionIter() throws Exception {
                return sessionIter;
            }

            @Override
            public String getSessionId() throws Exception {
                return sessionId;
            }

            @Override
            public String getName() throws Exception {
                return name;
            }

            @Override
            public int getActionIter() throws Exception {
                return actionIter;
            }

            @Override
            public String getActionId() throws Exception {
                return actionId;
            }

            @Override
            public int getNum() throws Exception {
                return -1;
            }
        };
    }

    private class Log2 {
        ILog log;
        Map<String, Integer> sessionToAddOrUpdate;

        public Log2(ILog log) {
            this.log = log;
        }

        public void reset() {
            this.sessionToAddOrUpdate = null;
            this.sessionToAddOrUpdate = new HashMap<String, Integer>();
        }

        private void clear() {
            this.log = null;
            if (this.sessionToAddOrUpdate != null) {
                this.sessionToAddOrUpdate.clear();
            }
            this.sessionToAddOrUpdate = null;
        }
    }

    public static interface LogListener {
        public void handleLogConnection(ILog var1, Exception var2, String var3);
    }

    public static interface ObjectReader<DELTA, SESSION, ACTION, VARIABLE> {
        public ListenerList<LogListener> getLogListener();

        public IEngineSessionHeader createSessionHeader(ISessionHeaderReader var1, ILog var2) throws Exception;

        public void updateSession(SESSION var1, SESSION var2);

        public void addLogToDelta(DELTA var1, IEngineLogHeader var2);

        public void updateActionToDelta(DELTA var1, IEngineActionHeader var2);

        public void addActionToDelta(DELTA var1, IEngineActionHeader var2);

        public IEngineActionHeader createActionHeader(IActionHeaderReader var1, long var2) throws Exception;

        public SESSION createSessionDelta() throws Exception;

        public IEngineSessionHeader addSessionToDelta(DELTA var1, IEngineSessionHeader var2);

        public void updateSessionToDelta(DELTA var1, IEngineSessionHeader var2);

        public void removeSessionToDelta(DELTA var1, String var2);

        public VARIABLE createVariable(IEngineVariableReader var1, boolean var2) throws Exception;

        public Object createStatistic(IEngineStatisticReader var1) throws Exception;

        public Object createError(IEngineErrorReader var1) throws Exception;

        public Object createWarning(IEngineErrorReader var1) throws Exception;

        public Object createDelivery(IEngineDeliveryReader var1) throws Exception;

        public Object createRuntime(IEngineRuntimeReader var1) throws Exception;

        public void setSessionHasChanged(DELTA var1, boolean var2) throws Exception;

        public void setSessionDeltaIsReseted(DELTA var1, boolean var2) throws Exception;

        public void updateActionHeader(IEngineActionHeader var1, int var2);

        public void updateAction(ACTION var1, ACTION var2);

        public IEngineLogHeader createLogHeader(ILogHeaderReader var1) throws Exception;

        public Object copyVariable(Object var1);

        public void updateValueVariable(Object var1, Object var2);

        public void updateSourceVariable(Object var1, Object var2);

        public void updateActionHeaderAltIds(IEngineActionHeader var1, Map<String, String> var2);
    }

    class SessionContainer {
        Map<Integer, IEngineSessionHeader> allIterations = new HashMap<Integer, IEngineSessionHeader>();
        IEngineSessionHeader lastSessionHeader;

        SessionContainer() {
        }

        public IEngineSessionHeader getLastSessionHeader() {
            return this.lastSessionHeader;
        }

        public Integer getLastIter() {
            if (this.lastSessionHeader != null) {
                return this.lastSessionHeader.getIter();
            }
            return null;
        }

        public void add(IEngineSessionHeader cachedSession) {
            this.allIterations.put(cachedSession.getIter(), cachedSession);
            if (this.lastSessionHeader == null || this.lastSessionHeader.getIter() <= cachedSession.getIter()) {
                this.lastSessionHeader = cachedSession;
            }
        }

        public void clear() {
            for (IEngineSessionHeader sesion : this.allIterations.values()) {
                sesion.clear();
            }
            this.allIterations.clear();
            this.allIterations = null;
            this.lastSessionHeader = null;
        }
    }

    public class SessionList {
        Map<String, SessionContainer> list = new HashMap<String, SessionContainer>();
        Map<String, IEngineSessionHeader> allSessions = new HashMap<String, IEngineSessionHeader>();
        Map<String, Object> lastCriteria;
        Date maxStartDate;

        public Map<String, SessionStatistic> getSessionsStatistic() {
            return EngineSessionManager.this.sessionsStatistic;
        }

        public void clear(boolean clearSubObject) {
            try {
                if (clearSubObject) {
                    for (SessionContainer container : this.list.values()) {
                        container.clear();
                    }
                }
                this.list.clear();
                this.list = null;
                this.allSessions.clear();
                this.allSessions = null;
                EngineSessionManager.this.clear3(EngineSessionManager.this.sessionsStatistic);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public IEngineSessionHeader get(String uuid) {
            return this.allSessions.get(uuid);
        }

        public IEngineSessionHeader getLastSession(String sessionId) {
            SessionContainer sess = this.list.get(sessionId);
            if (sess != null) {
                return sess.getLastSessionHeader();
            }
            return null;
        }

        public SessionContainer getSessionContainer(String sessionId) {
            return this.list.get(sessionId);
        }

        public void add(IEngineSessionHeader cachedSession) {
            SessionContainer container = this.list.get(cachedSession.getId());
            if (container == null) {
                container = new SessionContainer();
                this.list.put(cachedSession.getId(), container);
            }
            container.add(cachedSession);
            this.allSessions.put(cachedSession.getUUID(), cachedSession);
        }

        public void remove(String id) {
            SessionContainer container = this.list.get(id);
            if (container != null) {
                for (IEngineSessionHeader sess : container.allIterations.values()) {
                    this.allSessions.remove(sess.getUUID());
                }
            }
            this.list.remove(id);
        }

        public boolean setCriteria(Map<String, Object> criteria, Date maxStartDate) {
            boolean diff = false;
            if (this.lastCriteria == null || this.lastCriteria.size() != criteria.size()) {
                diff = true;
            }
            if (!diff) {
                for (String str : criteria.keySet()) {
                    Object o = this.lastCriteria.get(str);
                    if (o != null) continue;
                    diff = true;
                    break;
                }
            }
            this.lastCriteria = criteria;
            this.maxStartDate = diff ? null : maxStartDate;
            return diff;
        }
    }

    public class SessionStatistic {
        Date date;
        String sessionId;
        Map<Integer, Map<String, Long>> stats = new HashMap<Integer, Map<String, Long>>();

        public SessionStatistic(String sessId) {
            this.sessionId = sessId;
        }

        public void putAll(Map<Integer, Map<String, Long>> s) {
            this.stats = s;
        }

        public Map<String, Long> getStatistics() {
            HashMap<String, Long> map = new HashMap<String, Long>();
            for (Map<String, Long> m : this.stats.values()) {
                for (String key : m.keySet()) {
                    Long o = (Long)map.get(key);
                    Long o2 = m.get(key);
                    if (o == null) {
                        map.put(key, o2);
                        continue;
                    }
                    map.put(key, o + o2);
                }
            }
            return map;
        }

        public Long getStatistics(int iter, String name) {
            Map<String, Long> o = this.stats.get(iter);
            if (o != null) {
                return o.get(name);
            }
            return null;
        }

        public Map<String, Long> getStatistics(int iter) {
            return this.stats.get(iter);
        }

        public void clear() {
            if (this.stats != null) {
                this.stats.clear();
            }
        }
    }
}

