/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.log.aggregation;

import com.indy.engine.log.aggregation.Aggregate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class Aggregates {
    Map<String, Aggregate> aggregates = new HashMap<String, Aggregate>();

    void merge(Aggregates aggs) {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.aggregates.keySet());
        names.addAll(aggs.aggregates.keySet());
        for (String name : names) {
            Aggregate aggr1 = this.aggregates.get(name);
            Aggregate aggr2 = aggs.aggregates.get(name);
            if (aggr1 != null && aggr2 != null) {
                aggr1.merge(aggr2);
                continue;
            }
            if (aggr2 == null) continue;
            this.aggregates.put(name, aggr2);
        }
    }

    void addValue(String name, Long value) {
        Aggregate tmp = new Aggregate();
        tmp.values.add(value);
        tmp.min = value.longValue();
        tmp.max = value.longValue();
        Aggregate aggr = this.aggregates.get(name);
        if (aggr == null) {
            aggr = tmp;
            this.aggregates.put(name, aggr);
        } else {
            aggr.merge(tmp);
        }
    }

    public Long sum(String name) {
        Aggregate aggr = this.aggregates.get(name);
        if (aggr != null) {
            return aggr.sum();
        }
        return null;
    }

    public Map<String, Long> sumAll() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (String name : this.aggregates.keySet()) {
            Long val;
            Aggregate aggr = this.aggregates.get(name);
            if (aggr == null || (val = aggr.sum()) == null) continue;
            map.put(name, val);
        }
        return map;
    }
}

