/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.log.aggregation;

import com.indy.engine.log.aggregation.ActionTree;
import com.indy.engine.log.object.IEngineActionHeader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SessionTree
extends ActionTree {
    Map<String, ActionTree> allActions = new HashMap<String, ActionTree>();
    Map<String, String> names = new HashMap<String, String>();
    Map<String, String> parents = new HashMap<String, String>();

    public ActionTree getAction(String uuid) {
        ActionTree action = this.allActions.get(uuid);
        if (action == null) {
            action = new ActionTree();
            this.allActions.put(uuid, action);
            ActionTree parent = this.getParent(uuid);
            if (parent != null) {
                parent.children.put(uuid, action);
            }
            action.parent = parent;
        }
        return action;
    }

    public ActionTree getParent(String uuid) {
        String parentUUid = this.parents.get(uuid);
        if (parentUUid != null) {
            return this.getAction(parentUUid);
        }
        return null;
    }

    public void refresh(Map<String, Map<String, Long>> stats) {
        for (String name : stats.keySet()) {
            ActionTree at = this.getAction(name);
            Map<String, Long> map = stats.get(name);
            for (String varName : map.keySet()) {
                Long o = map.get(varName);
                if (!(o instanceof Long)) continue;
                at.addValue(varName, o);
            }
        }
    }

    @Override
    public void clear() {
        for (ActionTree at : this.allActions.values()) {
            at.clear();
        }
        this.allActions.clear();
        this.names.clear();
        this.parents.clear();
    }

    public void buildTree(Collection<IEngineActionHeader> newActions) {
        for (IEngineActionHeader header : newActions) {
            this.names.put(header.getUUID(), header.getRealName());
            this.parents.put(header.getUUID(), header.getParentUUID());
        }
    }
}

