/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.log.object;

import com.indy.engine.log.object.Criteria;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SessionCriteria
extends Criteria {
    public static final String NB_SESSIONS = "nbSessions";
    public static final String SESSION_ID = "sessionId";
    public static final String FILTER = "filter";
    public static final String STATUS = "statusList";
    public static final String CONFIGURATIONS = "configurations";
    public static final String SESSION_NAMES = "sessionNames";
    public static final String DELIVERIES = "deliveries";
    public static final String DELIVERY_ID = "deliveryIds";
    public static final String PACKAGE_ID = "packageIds";
    public static final String PROCESS_ID = "processIds";
    public static final String RUNTIMES = "runtimes";
    public static final String GUEST_HOSTS = "guestHosts";
    public static final String LAUNCH_MODES = "launchModes";
    public static final String EXEC_MODES = "execModes";
    public static final String BEGIN_DATE = "beginDate";
    public static final String END_DATE = "endDate";
    public static final String MIN_DURATION = "minDuration";
    public static final String MAX_DURATION = "maxDuration";
    public static final String BEGIN_DATE_TIME = "beginDateTime";
    public static final String END_DATE_TIME = "endDateTime";
    public static final String MIN_DURATION_MS = "minDurationMs";
    public static final String MAX_DURATION_MS = "maxDurationMs";
    public static final String SESSION_CASE_SENSITIV = "sessNamesCaseSensitiv";
    public static final String SESSION_CHILD_STANDALONE = "sessionChildStandalone";
    public static final String BOUNDARY_MODE = "boundaryMode";
    public static final String RUNTIME_ID = "runtimeId";
    private SimpleDateFormat sd = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private final Logger logger = LogManager.getLogger(this.getClass());

    public SessionCriteria(Map<String, Object> map) {
        super(map);
    }

    public Set<String> getSessionIds() {
        return this.get(SESSION_ID, String.class);
    }

    public String getFilter() {
        return (String)this.map.get(FILTER);
    }

    public Set<Integer> getStatusList() {
        return this.get(STATUS, Integer.class);
    }

    public int getNbSesions() {
        int nbSessions;
        int n = nbSessions = this.map != null && this.map.get(NB_SESSIONS) != null ? (Integer)this.map.get(NB_SESSIONS) : -1;
        if (nbSessions == -1) {
            nbSessions = this.getSessionIds().size() == 1 ? -2 : 20;
        }
        return nbSessions;
    }

    public Set<String> getConfigurations() {
        return this.get(CONFIGURATIONS, String.class);
    }

    public Set<String> getSessionNames() {
        return this.get(SESSION_NAMES, String.class);
    }

    public Set<String> getDeliveryNames() {
        return this.get(DELIVERIES, String.class);
    }

    public Set<String> getDeliveryIds() {
        return this.get(DELIVERY_ID, String.class);
    }

    public Set<String> getPackageIds() {
        return this.get(PACKAGE_ID, String.class);
    }

    public Set<String> getProcessIds() {
        return this.get(PROCESS_ID, String.class);
    }

    public Set<String> getRuntimes() {
        return this.get(RUNTIMES, String.class);
    }

    public Set<String> getGuestHosts() {
        return this.get(GUEST_HOSTS, String.class);
    }

    public Set<String> getLaunchMode() {
        return this.get(LAUNCH_MODES, String.class);
    }

    public Set<String> getExecMode() {
        return this.get(EXEC_MODES, String.class);
    }

    public Date getMinDate() {
        Date date = (Date)this.map.get(BEGIN_DATE);
        if (date != null) {
            try {
                date = this.sd.parse(this.sd.format(date));
            }
            catch (ParseException e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
        }
        return date;
    }

    public Date getMaxDate() {
        Date date = (Date)this.map.get(END_DATE);
        if (date != null) {
            try {
                date = new Date(this.sd.parse(this.sd.format(date)).getTime());
            }
            catch (ParseException e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
        }
        return date;
    }

    public String getMinDuration() {
        return (String)this.map.get(MIN_DURATION);
    }

    public String getMaxDuration() {
        return (String)this.map.get(MAX_DURATION);
    }

    public Date getMinDateTime() {
        return (Date)this.map.get(BEGIN_DATE_TIME);
    }

    public Date getMaxDateTime() {
        return (Date)this.map.get(END_DATE_TIME);
    }

    public Long getMinDurationMs() {
        return (Long)this.map.get(MIN_DURATION_MS);
    }

    public Long getMaxDurationMs() {
        return (Long)this.map.get(MAX_DURATION_MS);
    }

    public boolean isSessionNamesCaseSensitiv() {
        if (this.map.containsKey(SESSION_CASE_SENSITIV)) {
            return (Boolean)this.map.get(SESSION_CASE_SENSITIV);
        }
        return false;
    }

    public boolean isSessionChildStandalone() {
        if (this.map.containsKey(SESSION_CHILD_STANDALONE)) {
            return (Boolean)this.map.get(SESSION_CHILD_STANDALONE);
        }
        return false;
    }

    public String getBoundaryMode() {
        return (String)this.map.get(BOUNDARY_MODE);
    }
}

