/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.log.rdbms;

import com.indy.engine.log.reader.ISessionHeaderReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RdbmsSessionHeaderReader
implements ISessionHeaderReader {
    ResultSet rs;
    private String id;
    private String logName;
    private String logType;
    private long tstamp;
    private boolean is17;
    private long offset;
    private String deliveryVersion;
    private boolean isDeliveryVersionSet = false;
    private String comment;
    private boolean isCommentSet = false;
    private boolean isUserSet = false;
    private String user;
    private boolean isDeliveryTimeStampSet = false;
    private Long deliveryTimeStamp;
    private String checksum;
    private boolean isChecksumSet = false;
    private final Logger logger = LogManager.getLogger(this.getClass());
    String sessBeginDate = null;
    boolean sessBeginDateSet = false;
    String sessEndDate = null;
    boolean sessEndDateSet = false;
    int status = -1000;
    boolean statusSet = false;
    private String reportLog;
    String name;
    boolean nameSet = false;
    String hostName;
    boolean hostNameSet = false;
    int port;
    boolean portSet = false;
    String guestHost;
    boolean guestHostSet = false;
    String launchMode;
    boolean launchModeSet = false;
    String executionMode = null;
    boolean executionModeSet = false;
    String conf;
    boolean confSet = false;
    String parentSessionId;
    boolean parentSessionIdSet = false;
    Date beginDate;
    boolean beginDateSet = false;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    Date endDate;
    boolean endDateSet = false;
    int iter;
    boolean iterSet = false;
    private boolean isDeliveryIdSet;
    private String deliveryId;
    private String version;
    private boolean isVersionSet;
    private String firstActionId;
    private boolean isFirstActionIdSet;
    private boolean isActiveSet;
    private boolean isActive;
    private boolean timeStampSet;
    private long timeStamp;
    private boolean isPackageIdSet;
    private String packageId;
    private boolean isProcessIdSet;
    private String processId;

    public RdbmsSessionHeaderReader(String logName, String logType, ResultSet rs, String id2, long tstamp, boolean is17, long offset) {
        this.rs = rs;
        this.id = id2;
        this.logName = logName;
        this.tstamp = tstamp;
        this.is17 = is17;
        this.logType = logType;
        this.offset = offset;
    }

    public void init() {
    }

    @Override
    public String getStrBeginDate() throws SQLException {
        if (!this.sessBeginDateSet) {
            this.sessBeginDate = this.rs.getString("SESS_BEGIN_DATE");
        }
        this.sessBeginDateSet = true;
        return this.sessBeginDate;
    }

    @Override
    public String getStrEndDate() throws SQLException {
        if (!this.sessEndDateSet) {
            this.sessEndDate = this.rs.getString("SESS_END_DATE");
        }
        this.sessEndDateSet = true;
        return this.sessEndDate;
    }

    @Override
    public String getId() throws SQLException {
        return this.id;
    }

    @Override
    public int getStatus() throws SQLException {
        if (!this.statusSet) {
            String temp = this.rs.getString("SESS_RET_CODE");
            this.status = temp != null ? Integer.valueOf(temp) : 2;
            if (this.status == 2 && !this.isActive()) {
                this.status = -4;
            }
        }
        this.statusSet = true;
        return this.status;
    }

    @Override
    public String getLogName() {
        return this.logName;
    }

    @Override
    public String getLogType() {
        return this.logType;
    }

    @Override
    public String getName() throws SQLException {
        if (!this.nameSet) {
            this.name = this.rs.getString("SESS_NAME");
        }
        this.nameSet = true;
        return this.name;
    }

    @Override
    public String getEngineHost() throws SQLException {
        if (!this.hostNameSet) {
            this.hostName = this.rs.getString("SESS_ENGINE_HOST");
        }
        this.hostNameSet = true;
        return this.hostName;
    }

    @Override
    public int getEnginePort() throws SQLException {
        if (!this.portSet) {
            this.port = this.rs.getInt("SESS_ENGINE_PORT");
        }
        this.portSet = true;
        return this.port;
    }

    @Override
    public String getGuestHost() throws SQLException {
        if (!this.guestHostSet) {
            this.guestHost = this.rs.getString("SESS_GUEST_HOST");
        }
        this.guestHostSet = true;
        return this.guestHost;
    }

    @Override
    public String getLaunchMode() throws SQLException {
        if (!this.launchModeSet) {
            this.launchMode = this.rs.getString("SESS_LAUNCH_MODE");
        }
        this.launchModeSet = true;
        return this.launchMode;
    }

    @Override
    public String getExecutionMode() throws SQLException {
        if (!this.executionModeSet) {
            this.executionMode = this.rs.getString("SESS_EXECUTION_MODE");
        }
        this.executionModeSet = true;
        return this.executionMode;
    }

    @Override
    public String getConfiguration() throws SQLException {
        if (!this.confSet) {
            this.conf = this.rs.getString("SESS_CONF");
            if (this.conf == null && this.is1709()) {
                this.conf = this.rs.getString("DLV_CONF");
            }
        }
        this.confSet = false;
        return this.conf;
    }

    @Override
    public String getParentSessionId() throws SQLException {
        if (!this.parentSessionIdSet) {
            this.parentSessionId = this.rs.getString("SESS_PARENT_ID");
        }
        this.parentSessionIdSet = true;
        return this.parentSessionId;
    }

    @Override
    public Date getBeginDate() throws SQLException {
        String str;
        if (!this.beginDateSet && (str = this.getStrBeginDate()) != null) {
            try {
                this.beginDate = this.sdf.parse(str);
            }
            catch (ParseException e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
        }
        this.beginDateSet = true;
        return this.beginDate;
    }

    @Override
    public Date getEndDate() throws SQLException {
        String str;
        if (!this.endDateSet && (str = this.getStrEndDate()) != null) {
            try {
                this.endDate = this.sdf.parse(str);
            }
            catch (ParseException e) {
                this.logger.warn("unexpected", (Throwable)e);
            }
        }
        this.endDateSet = true;
        return this.endDate;
    }

    @Override
    public int getIter() throws SQLException {
        if (!this.iterSet) {
            this.iter = this.rs.getInt("SESS_ITER");
        }
        this.iterSet = true;
        return this.iter;
    }

    public void setIter(int iter) {
        this.iter = iter;
        this.iterSet = true;
    }

    @Override
    public String getLogClassName() {
        return null;
    }

    @Override
    public String getMessage() {
        return null;
    }

    @Override
    public boolean isStartByCommand() throws SQLException {
        String tmp = this.getExecutionMode();
        return tmp != null && tmp.equals("COMMAND_LINE");
    }

    @Override
    public String getDeliveryId() throws SQLException {
        if (!this.isDeliveryIdSet) {
            this.deliveryId = this.rs.getString("DLV_ID");
        }
        this.isDeliveryIdSet = true;
        return this.deliveryId;
    }

    @Override
    public String getVersion() throws SQLException {
        if (!this.isVersionSet) {
            try {
                this.version = this.rs.getString("V_VERSION");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isVersionSet = true;
        return this.version;
    }

    @Override
    public String getFirstActionId() throws Exception {
        if (!this.isFirstActionIdSet && this.getVersion() != null && this.getVersion().compareTo("1.7.0.0") >= 0) {
            try {
                this.firstActionId = this.rs.getString("SESS_ACT_ROOT_ID");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isFirstActionIdSet = true;
        return this.firstActionId;
    }

    private boolean is1709() throws SQLException {
        return this.getVersion() != null && this.getVersion().compareTo("1.7.0.9") >= 0;
    }

    @Override
    public String getPackageId() throws Exception {
        if (!this.isPackageIdSet && this.is1709()) {
            try {
                this.packageId = this.rs.getString("PCK_ID");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isPackageIdSet = true;
        return this.packageId;
    }

    @Override
    public String getProcessId() throws Exception {
        if (!this.isProcessIdSet && this.is1709()) {
            try {
                this.processId = this.rs.getString("PROC_ID");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.isProcessIdSet = true;
        return this.processId;
    }

    @Override
    public boolean isActive() throws SQLException {
        if (!this.isActiveSet) {
            if (this.getVersion() != null && this.getVersion().compareTo("1.7.0.0") >= 0) {
                long SESS_INACT_TIMEOUT = this.rs.getLong("SESS_INACT_TIMEOUT");
                long SESS_LAST_TSTAMP = this.rs.getLong("SESS_LAST_TSTAMP");
                long SESS_TSTAMP_OFFSET = this.rs.getLong("SESS_TSTAMP_OFFSET");
                long tmp = SESS_LAST_TSTAMP + SESS_TSTAMP_OFFSET + SESS_INACT_TIMEOUT - this.tstamp;
                this.isActive = SESS_INACT_TIMEOUT <= 0L || tmp > 0L;
            } else {
                this.isActive = true;
            }
        }
        this.isActiveSet = true;
        return this.isActive;
    }

    @Override
    public long getTimeStamp() throws SQLException {
        if (this.is17 && !this.timeStampSet) {
            this.timeStampSet = true;
            this.timeStamp = this.rs.getLong("SESS_BEGIN_TSTAMP");
            return this.timeStamp;
        }
        return -1L;
    }

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public String getDeliveryVersion() {
        if (!this.isDeliveryVersionSet) {
            try {
                this.deliveryVersion = this.rs.getString("DLV_VERSION");
                this.isDeliveryVersionSet = true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.deliveryVersion;
    }

    @Override
    public String getUser() {
        if (!this.isUserSet) {
            try {
                this.user = this.rs.getString("DLV_USER");
                this.isUserSet = true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.user;
    }

    @Override
    public String getComment() {
        if (!this.isCommentSet) {
            try {
                this.comment = this.rs.getString("DLV_COMMENT");
                this.isCommentSet = true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.comment;
    }

    @Override
    public Long getDeliveryTimeStamp() {
        if (!this.isDeliveryTimeStampSet) {
            try {
                this.deliveryTimeStamp = this.rs.getLong("DLV_TSTAMP");
                this.isDeliveryTimeStampSet = true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.deliveryTimeStamp;
    }

    @Override
    public String getChecksum() {
        if (!this.isChecksumSet) {
            try {
                this.checksum = this.rs.getString("CHECKSUM");
                this.isChecksumSet = true;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return this.checksum;
    }
}

