/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.edit.provider.custom;

import com.indy.map.Expression;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IReferencable;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RUsage;
import com.semarchy.xdi.designer.core.CodeCapability;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class MapperAdapter {
    private LabelProviderHelper srcImgProvider;
    private LabelProviderHelper trgImgProvider;
    private EditionHelper editionHelper;
    private IContainer targetContainer;
    private ILogicalField initialField;
    private Collection<IContainer> sourceContainers;

    public MapperAdapter(LabelProviderHelper srcImgProvider, LabelProviderHelper trgImgProvider, IContainer targetContainer, Collection<IContainer> sourceContainers, EditionHelper editionHelper, ILogicalField initialField) {
        this.srcImgProvider = srcImgProvider;
        this.trgImgProvider = trgImgProvider;
        this.targetContainer = targetContainer;
        this.sourceContainers = sourceContainers;
        this.editionHelper = editionHelper;
        this.initialField = initialField;
    }

    public IStructuredSelection getInitialSelection() {
        if (this.initialField != null) {
            return new StructuredSelection((Object)this.initialField);
        }
        return StructuredSelection.EMPTY;
    }

    public EditionHelper getEditionHelper() {
        return this.editionHelper;
    }

    public LabelProviderHelper getSrcImgProvider() {
        return this.srcImgProvider;
    }

    public LabelProviderHelper getTrgImgProvider() {
        return this.trgImgProvider;
    }

    public IContainer getTargetContainer() {
        return this.targetContainer;
    }

    public Collection<IContainer> getSourceContainers() {
        return this.sourceContainers;
    }

    public List<ILogicalField> getTargets(Object expression) {
        ArrayList<ILogicalField> res = new ArrayList<ILogicalField>();
        if (expression instanceof ILogicalField) {
            for (RUsage i : ((RSourceItem)((IReferencable)expression).getMapReference()).getUsage()) {
                if (!(i.getDataModel() instanceof Expression)) continue;
                res.add((ILogicalField)i.getDataModel().eContainer());
            }
        }
        return res;
    }

    public static interface EditionHelper {
        public void addListener(EditionHelperListener var1);

        public void removeListener(EditionHelperListener var1);

        public void setEditionContext(Object var1);

        public String convertToText(Object var1);

        public CodeCapability getCodeCapability();

        public EObject getEditedObject();

        public void performEdition(String var1);

        public List<Object> getSources();

        public List<Object> getSources(Object var1);

        public List<Object> getTargets(Object var1);
    }

    public static interface EditionHelperListener {
        public void handleValueChange();
    }

    public static interface LabelProviderHelper {
        public List<Image> getImages(Object var1);

        public Color getForeground(Object var1);

        public Font getFont(Object var1);

        public String getTooltip(Object var1);

        public Image getTooltipIcon(Object var1);
    }
}

