/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.base.core.auth;

import com.semarchy.xdi.base.core.auth.AuthenticationInfo;
import com.semarchy.xdi.base.core.auth.HeaderParser;
import jakarta.xml.bind.DatatypeConverter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Random;

public class BasicOrDigestAuthentication
extends AuthenticationInfo {
    private static final int cnoncelen = 40;
    private static final String[] zeroPad = new String[]{"00000000", "0000000", "000000", "00000", "0000", "000", "00", "0"};
    private static final char[] charArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Random random = new SecureRandom();
    private String userName;
    private String pwd;
    private String httpMethod;
    private String urlPath;
    private String algorithm;
    private boolean authQop = false;
    private String cNonce;
    private int nonceCount = 0;
    private String ha1;
    private String ha2;
    private HeaderParser headerParser;

    public BasicOrDigestAuthentication(String userName, String pwd, String httpMethod, URL url) {
        this.userName = userName;
        this.pwd = pwd;
        this.httpMethod = httpMethod;
        this.urlPath = url.getFile();
    }

    @Override
    public String getAuthenticationHeaderValue(String serverAuthenticationHeader) throws Exception {
        this.headerParser = new HeaderParser(serverAuthenticationHeader);
        if (serverAuthenticationHeader == null || "Basic".equalsIgnoreCase(this.headerParser.getScheme())) {
            String encoded = DatatypeConverter.printBase64Binary((byte[])(this.userName + ":" + this.pwd).getBytes(StandardCharsets.UTF_8));
            return "Basic " + encoded;
        }
        this.computeHa1();
        this.computeHa2(this.httpMethod, this.urlPath);
        String response = null;
        Object ncstring = null;
        String cnonce = this.getCNonce();
        if (this.authQop) {
            ncstring = Integer.toHexString(this.nonceCount).toLowerCase();
            int len = ((String)ncstring).length();
            if (len < 8) {
                ncstring = zeroPad[len] + (String)ncstring;
            }
            response = this.md5(this.ha1 + ":" + this.headerParser.getParameter("nonce") + ":" + (String)ncstring + ":" + cnonce + ":auth:" + this.ha2);
        } else {
            response = this.md5(this.ha1 + ":" + this.headerParser.getParameter("nonce") + ":" + this.ha2);
        }
        Object ncfield = "\"";
        if (this.authQop) {
            ncfield = "\", nc=" + (String)ncstring;
        }
        String value = this.headerParser.getScheme() + " username=\"" + this.userName + "\", realm=\"" + this.headerParser.getParameter("realm") + "\", nonce=\"" + this.headerParser.getParameter("nonce") + (String)ncfield + ", uri=\"" + this.urlPath + "\", response=\"" + response + "\", algorithm=\"" + this.algorithm;
        String opaque = this.headerParser.getParameter("opaque");
        if (opaque != null) {
            value = value + "\", opaque=\"" + opaque;
        }
        if (this.cNonce != null) {
            value = value + "\", cnonce=\"" + this.cNonce;
        }
        if (this.authQop) {
            value = value + "\", qop=\"auth";
        }
        value = value + "\"";
        return value;
    }

    private void computeHa1() throws Exception {
        this.algorithm = this.headerParser.getParameter("algorithm");
        if (this.algorithm == null || this.algorithm.isEmpty() || this.algorithm.equalsIgnoreCase("md5")) {
            this.algorithm = "md5";
            this.ha1 = this.md5(this.userName + ":" + this.headerParser.getParameter("realm") + ":" + this.pwd);
        } else if (this.algorithm.equalsIgnoreCase("md5-sess")) {
            this.ha1 = this.md5(this.md5(this.userName + ":" + this.headerParser.getParameter("realm") + ":" + this.pwd) + ":" + this.headerParser.getParameter("nonce") + ":" + this.getCNonce());
        }
    }

    private void computeHa2(String httpMethod, String urlPath) throws Exception {
        String qop = this.headerParser.getParameter("qop");
        if (qop == null || qop.isEmpty() || qop.equalsIgnoreCase("auth")) {
            this.authQop = true;
        }
        this.ha2 = this.md5(httpMethod + ":" + urlPath);
    }

    private String md5(String toEncode) throws Exception {
        byte[] bytesOfMessage = toEncode.getBytes(StandardCharsets.UTF_8);
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] thedigest = md.digest(bytesOfMessage);
        StringBuilder res = new StringBuilder(thedigest.length * 2);
        int i = 0;
        while (i < thedigest.length) {
            int hashchar = thedigest[i] >>> 4 & 0xF;
            res.append(charArray[hashchar]);
            hashchar = thedigest[i] & 0xF;
            res.append(charArray[hashchar]);
            ++i;
        }
        return res.toString();
    }

    private synchronized String getCNonce() {
        if (this.nonceCount < 1 || this.nonceCount >= 5) {
            this.setNewCnonce();
        }
        return this.cNonce;
    }

    private synchronized void setNewCnonce() {
        byte[] bb = new byte[20];
        char[] cc = new char[40];
        random.nextBytes(bb);
        int i = 0;
        while (i < 20) {
            int x = bb[i] + 128;
            cc[i * 2] = (char)(65 + x / 16);
            cc[i * 2 + 1] = (char)(65 + x % 16);
            ++i;
        }
        this.cNonce = new String(cc, 0, 40);
        this.nonceCount = 1;
    }
}

