/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.fileMetadata;

import com.stambia.jdbc.driver.file.fileManagment.IReadContext;
import com.stambia.jdbc.driver.file.fileMetadata.IMetadataColumn;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataColumn;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFilter;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFilterSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MetadataEnreg {
    IMetadataColumn[] lstColumns;
    String logicalName;
    Map<String, MetadataEnreg> children = new HashMap<String, MetadataEnreg>();
    int position;
    Map<Integer, IMetadataColumn> mapCol;
    private String id;
    List<MetadataFilter> filters = new ArrayList<MetadataFilter>();
    int ancestorLevel = 0;
    int occurenceStart = -1;
    int occurenceSize = -1;
    int occurenceNumber = -1;
    IMetadataColumn lastColumn;

    public int searchMaxLastRowPosition(MetadataEnreg enreg, int compare) {
        int i;
        if (enreg.getFilters() != null) {
            for (MetadataFilter filter : enreg.getFilters()) {
                i = filter.getLastLinePosition();
                if ((i *= -1) > 0 && i > compare) {
                    compare = i;
                }
                i = filter.getFirstLinePosition();
                if ((i *= -1) <= 0 || i <= compare) continue;
                compare = i;
            }
        }
        for (MetadataEnreg child : enreg.children.values()) {
            i = this.searchMaxLastRowPosition(child, compare);
            if (i <= 0 || i <= compare) continue;
            compare = i;
        }
        return compare;
    }

    public String getLogicalName() {
        return this.logicalName;
    }

    public void setLogicalName(String fileName) {
        this.logicalName = fileName;
    }

    public IMetadataColumn[] getLstColumns() {
        return this.lstColumns;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public IMetadataColumn getColumnByPosition(int pos) {
        if (this.mapCol == null) {
            this.mapCol = new HashMap<Integer, IMetadataColumn>();
            MetadataColumn[] list = (MetadataColumn[])this.getLstColumns();
            List<MetadataColumn> _list = Arrays.asList(list);
            Collections.sort(_list, new Comparator<MetadataColumn>(){

                @Override
                public int compare(MetadataColumn o1, MetadataColumn o2) {
                    return new Integer(o1.getPosition()).compareTo(new Integer(o2.getPosition()));
                }
            });
            int i = 0;
            while (i < list.length) {
                MetadataColumn mc = _list.get(i);
                this.mapCol.put(i, mc);
                ++i;
            }
        }
        return this.mapCol.get(pos);
    }

    public IMetadataColumn getColumn(int index) {
        if (index >= 0 && index < this.lstColumns.length) {
            return this.lstColumns[index];
        }
        return null;
    }

    public IMetadataColumn getColumn(String name) {
        IMetadataColumn col = null;
        int i = 0;
        while (i < this.lstColumns.length) {
            if (this.lstColumns[i].getName().equals(name)) {
                return this.lstColumns[i];
            }
            ++i;
        }
        return col;
    }

    public void setLstColumns(IMetadataColumn[] lstColumns) {
        this.lstColumns = lstColumns;
    }

    public MetadataEnreg findEnregByLogicalName(String name) {
        if (this.logicalName.equals(name)) {
            return this;
        }
        for (MetadataEnreg enreg : this.children.values()) {
            if ((enreg = enreg.findEnregByLogicalName(name)) == null) continue;
            return enreg;
        }
        return null;
    }

    public void setId(String nodeValue) {
        this.id = nodeValue;
    }

    public String getId() {
        return this.id;
    }

    public void add(MetadataEnreg enregChild) {
        this.children.put(enregChild.getLogicalName(), enregChild);
    }

    public void addFilter(MetadataFilter filter2) {
        this.filters.add(filter2);
    }

    public List<MetadataFilter> getFilters() {
        return this.filters;
    }

    public MetadataFilterSet setFilterSet(IReadContext context) {
        MetadataFilterSet filterSet = new MetadataFilterSet(context);
        filterSet.setAncestorLevel(this.ancestorLevel);
        filterSet.setOccurenceNumber(this.occurenceNumber);
        filterSet.setOccurenceSize(this.occurenceSize);
        filterSet.setOccurenceStart(this.occurenceStart);
        filterSet.setOrder(this.position);
        filterSet.addFilter(this.getFilters());
        filterSet.name = this.getLogicalName();
        for (MetadataEnreg enreg : this.children.values()) {
            MetadataFilterSet child = enreg.setFilterSet(context);
            filterSet.addChildren(child.name, child);
        }
        return filterSet;
    }

    public void setAncestorLevel(Integer valueOf) {
        this.ancestorLevel = valueOf;
    }

    public void setOccurenceStart(int occurenceStart) {
        this.occurenceStart = occurenceStart;
    }

    public void setOccurenceSize(int occurenceSize) {
        this.occurenceSize = occurenceSize;
    }

    public void setOccurenceNumber(int occurenceNumber) {
        this.occurenceNumber = occurenceNumber;
    }

    public void close() {
        if (this.children != null) {
            for (MetadataEnreg enreg : this.children.values()) {
                enreg.close();
            }
            this.children.clear();
            this.children = null;
        }
        if (this.lstColumns != null) {
            IMetadataColumn[] iMetadataColumnArray = this.lstColumns;
            int n = this.lstColumns.length;
            int n2 = 0;
            while (n2 < n) {
                IMetadataColumn col = iMetadataColumnArray[n2];
                col.close();
                ++n2;
            }
        }
    }

    public IMetadataColumn getLastColumn() {
        if (this.lastColumn == null) {
            int maxPosition = -1;
            IMetadataColumn _lastColumn = null;
            IMetadataColumn[] iMetadataColumnArray = this.lstColumns;
            int n = this.lstColumns.length;
            int n2 = 0;
            while (n2 < n) {
                IMetadataColumn col = iMetadataColumnArray[n2];
                if (col.getPosition() > maxPosition) {
                    maxPosition = col.getPosition();
                    _lastColumn = col;
                }
                ++n2;
            }
            this.lastColumn = _lastColumn;
        }
        return this.lastColumn;
    }

    public void setLastColumn(IMetadataColumn lastColumn) {
        this.lastColumn = lastColumn;
    }
}

