/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons;

import com.indy.engine.objects.data.baseobjects.SemaphoreManagerI;
import com.stambia.md.Attribute;
import com.stambia.md.MdNode;
import com.stambia.md.util.MdFactoryHelper;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class AttributeUtil {
    private AttributeUtil() {
    }

    public static void setAttribute(String attributeName, Object value, MdNode targetNode, MdNode sourceNode) {
        Property p = sourceNode.getLevel().getAttributeByShortCode(attributeName);
        Attribute a = MdFactoryHelper.createAttribute((String)(sourceNode.getDefType() + "." + attributeName));
        if (p != null) {
            if (p.isUnbounded()) {
                AttributeUtil.handleUnboundedValue(value, targetNode, p, a);
            } else {
                AttributeUtil.handleBoundedValue(value, targetNode, p, a);
            }
        }
    }

    private static void handleBoundedValue(Object value, MdNode targetNode, Property p, Attribute a) {
        String v = null;
        if (value instanceof String) {
            String stringValue = (String)value;
            if (!stringValue.trim().isEmpty()) {
                v = stringValue;
            }
        } else {
            String string = v = value == null ? "" : value.toString();
        }
        if (p.getType() == PropertyType.PASSWORD) {
            v = AttributeUtil.encryptPassword(v);
        }
        if (v != null) {
            if (value instanceof EObject) {
                EObject eObject = (EObject)value;
                a.setRef(eObject);
            } else {
                a.setValue(v);
            }
            targetNode.getAttribute().add((Object)a);
        }
    }

    private static void handleUnboundedValue(Object value, MdNode targetNode, Property p, Attribute a) {
        boolean addedVal = false;
        if (p.isKeyValue()) {
            addedVal = AttributeUtil.setValueEntryAttribute((Map)value, a);
            if (addedVal) {
                targetNode.getAttribute().add((Object)a);
            }
        } else {
            addedVal = AttributeUtil.setListValueAttribute((List)value, a);
            if (addedVal) {
                targetNode.getAttribute().add((Object)a);
            }
        }
    }

    private static String encryptPassword(String password) {
        try {
            SemaphoreManagerI semaphoreManager = new SemaphoreManagerI();
            semaphoreManager.getIsSemaphore("Incorrect Semaphore");
            password = semaphoreManager.setSemaphore(true, password);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return password;
    }

    private static boolean setListValueAttribute(List<?> value, Attribute a) {
        boolean addedVal = false;
        for (Object o : value) {
            if (o == null) continue;
            a.getValues().add((Object)o.toString());
            addedVal = true;
        }
        return addedVal;
    }

    private static boolean setValueEntryAttribute(Map<?, ?> value, Attribute a) {
        boolean addedVal = false;
        for (Object o : value.keySet()) {
            if (o == null) continue;
            a.getValueEntry().put((Object)((String)o), (Object)((String)value.get(o)));
            addedVal = true;
        }
        return addedVal;
    }
}

