/*
 * Decompiled with CFR 0.152.
 */
package com.indy.addons.xml.wizard;

import com.indy.addons.Messages;
import com.indy.addons.ScrolledCompositeWizardHelper;
import com.indy.addons.xml.wizard.XmlBeanWizard;
import com.indy.addons.xml.wizard.XmlWizardControler;
import com.indy.md.ui.editor.reverse.MdDiffBuilder;
import com.indy.md.ui.editor.reverse.MdDiffNode;
import com.indy.md.ui.editor.reverse.MdDiffNodeUI;
import com.indy.md.ui.editor.ui.MdWizard;
import com.indy.ui.out.qa.InternalIdentifier;
import com.stambia.md.Configuration;
import com.stambia.md.DocumentRoot;
import com.stambia.md.MdFactory;
import com.stambia.md.MdNode;
import com.stambia.md.custom.IncrementalReverser;
import com.stambia.md.impl.custom.CustomMdNode;
import com.stambia.md.util.MdAttributeNativeEvaluator;
import com.stambia.md.util.MdAttributeReader;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.jface.dialogs.IPageChangingListener;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.PageChangingEvent;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.xml.sax.SAXParseException;

public class XmlWizard
extends MdWizard {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private XmlWizardControler controler;
    private IWizardPage reverseModePage;
    private IWizardPage xmlPage;
    private IWizardPage xsdPage;
    private IWizardPage xsdRootPage;
    private IWizardPage selectivePage;
    MdDiffNodeUI diffNodeUI;
    Combo rootElements = null;
    Map<String, Boolean> reverseOptions = new HashMap<String, Boolean>();
    boolean fileAlreadyExits = true;

    public XmlWizard() {
        this.getDeleteReverseOptions().put("com.stambia.xml.element", true);
        this.getDeleteReverseOptions().put("com.stambia.xml.sequence", true);
        this.getDeleteReverseOptions().put("com.stambia.xml.choice", true);
        this.getDeleteReverseOptions().put("com.stambia.xml.all", true);
        this.getDeleteReverseOptions().put("com.stambia.xml.attribute", true);
        this.getDeleteReverseOptions().put("com.stambia.xml.root", false);
        this.getDeleteReverseOptions().put("com.stambia.xml.namespace", false);
        this.setWindowTitle(Messages.XmlWizard_0);
    }

    protected Map<String, Boolean> getDeleteReverseOptions() {
        return this.reverseOptions;
    }

    protected XmlWizardControler getControler() {
        return this.controler;
    }

    public void setNode(MdNode node) {
        this.setControler(new XmlWizardControler(node));
    }

    protected final void setControler(XmlWizardControler controler) {
        this.controler = controler;
    }

    public MdNode getNode() {
        return this.getControler().getReversedMd();
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage() == this.selectivePage && this.selectivePage.isPageComplete();
    }

    public void addPages() {
        this.getShell().setSize(600, 700);
        this.createTypePage();
        this.createXmlPage();
        this.createXsdPages();
        this.createSelectivePage();
        ((WizardDialog)this.getContainer()).addPageChangingListener(new IPageChangingListener(){

            public void handlePageChanging(final PageChangingEvent event) {
                block9: {
                    try {
                        if (event.getTargetPage() == XmlWizard.this.selectivePage) {
                            try {
                                new ProgressMonitorDialog(XmlWizard.this.getContainer().getShell()).run(false, false, new IRunnableWithProgress(){

                                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                        try {
                                            block11: {
                                                if (XmlWizard.this.getControler().getBean().getReversedType() == XmlBeanWizard.Type.CLIPBOARD) {
                                                    Clipboard clipboard = null;
                                                    try {
                                                        try {
                                                            clipboard = new Clipboard(XmlWizard.this.getContainer().getShell().getDisplay());
                                                            TextTransfer transfer = TextTransfer.getInstance();
                                                            String data = (String)clipboard.getContents((Transfer)transfer);
                                                            XmlWizard.this.getControler().getBean().setClipboardContent(data);
                                                            XmlWizard.this.getControler().reverseClipboard();
                                                            break block11;
                                                        }
                                                        catch (SAXParseException ex) {
                                                            throw new Exception(Messages.XmlWizard_4, ex);
                                                        }
                                                    }
                                                    finally {
                                                        if (clipboard != null) {
                                                            clipboard.dispose();
                                                        }
                                                    }
                                                }
                                                if (XmlWizard.this.getControler().getBean().getReversedType() == XmlBeanWizard.Type.XML) {
                                                    XmlWizard.this.getControler().reverseXML();
                                                } else {
                                                    XmlWizard.this.getControler().reverseXSD();
                                                }
                                            }
                                            (this).XmlWizard.this.diffNodeUI.getViewerHelper().setInput((Object)XmlWizard.this.loadSelectiveTree());
                                        }
                                        catch (Throwable ex) {
                                            event.doit = false;
                                            StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.jdbc.editor", Messages.XmlWizard_5, ex), 5);
                                            return;
                                        }
                                    }
                                });
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            catch (Exception e) {
                                XmlWizard.this.logger.warn("unexpected", (Throwable)e);
                            }
                            break block9;
                        }
                        if (event.getTargetPage() != XmlWizard.this.xsdRootPage) break block9;
                        XmlWizard.this.getControler().refreshXSDRootElement();
                        XmlWizard.this.rootElements.setItems(XmlWizard.this.getControler().getXsdRootElementNames());
                        XmlWizard.this.rootElements.setText("");
                        int i = 0;
                        while (i < XmlWizard.this.rootElements.getItemCount()) {
                            if (XmlWizard.this.rootElements.getItem(i).equals(XmlWizard.this.controler.getBean().getXsdRootElement())) {
                                XmlWizard.this.rootElements.select(i);
                                break;
                            }
                            ++i;
                        }
                    }
                    catch (Exception ex) {
                        if (ex instanceof InterruptedException) {
                            Thread.currentThread().interrupt();
                        }
                        event.doit = false;
                        StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.jdbc.editor", Messages.XmlWizard_7, (Throwable)ex), 4);
                    }
                }
            }
        });
    }

    private void createTypePage() {
        this.reverseModePage = new WizardPage("Type.Page"){

            public IWizardPage getNextPage() {
                if (XmlWizard.this.getControler().getBean().getReversedType() == XmlBeanWizard.Type.CLIPBOARD) {
                    return XmlWizard.this.selectivePage;
                }
                if (XmlWizard.this.getControler().getBean().getReversedType() == XmlBeanWizard.Type.XML) {
                    return XmlWizard.this.xmlPage;
                }
                return XmlWizard.this.xsdPage;
            }

            public void createControl(Composite parent) {
                ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite(parent);
                Composite main = new Composite((Composite)scrolled, 0);
                main.setLayout((Layout)new GridLayout());
                ((GridLayout)main.getLayout()).verticalSpacing = 25;
                Label l = new Label(main, 64);
                l.setLayoutData((Object)new GridData(4, 1, true, false));
                l.setText(Messages.XmlWizard_1);
                Group group = new Group(main, 0);
                group.setText(Messages.XmlWizard_14);
                group.setLayout((Layout)new GridLayout());
                group.setLayoutData((Object)new GridData(4, 1, true, false));
                final Button xsdB = new Button((Composite)group, 16);
                xsdB.setText(Messages.XmlWizard_15);
                xsdB.setLayoutData((Object)new GridData());
                xsdB.setSelection(true);
                final Button xmlB = new Button((Composite)group, 16);
                xmlB.setText(Messages.XmlWizard_16);
                xmlB.setLayoutData((Object)new GridData());
                Button clipB = new Button((Composite)group, 16);
                clipB.setText(Messages.XmlWizard_17);
                ScrolledCompositeWizardHelper.adaptToContent(scrolled, main);
                this.setControl((Control)scrolled);
                SelectionAdapter listener = new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (((Button)e.widget).getSelection()) {
                            if (e.widget == xmlB) {
                                XmlWizard.this.getControler().getBean().setReversedType(XmlBeanWizard.Type.XML);
                            } else if (e.widget == xsdB) {
                                XmlWizard.this.getControler().getBean().setReversedType(XmlBeanWizard.Type.XSD);
                            } else {
                                XmlWizard.this.getControler().getBean().setReversedType(XmlBeanWizard.Type.CLIPBOARD);
                            }
                        }
                    }
                };
                xmlB.addSelectionListener((SelectionListener)listener);
                xsdB.addSelectionListener((SelectionListener)listener);
                clipB.addSelectionListener((SelectionListener)listener);
            }
        };
        this.addPage(this.reverseModePage);
    }

    private void createXmlPage() {
        this.xmlPage = new WizardPage("Xml.Page"){
            File xmlFile;

            private void updateErrorMessage() {
                if (!this.isPageComplete()) {
                    this.setErrorMessage(Messages.XmlWizard_19);
                } else {
                    this.setErrorMessage(null);
                }
            }

            public IWizardPage getNextPage() {
                return XmlWizard.this.selectivePage;
            }

            public boolean isPageComplete() {
                return this.xmlFile != null && this.xmlFile.exists() && this.xmlFile.isFile();
            }

            public void createControl(Composite parent) {
                ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite(parent);
                Composite main = new Composite((Composite)scrolled, 0);
                main.setLayout((Layout)new GridLayout());
                ((GridLayout)main.getLayout()).verticalSpacing = 25;
                Label l = new Label(main, 64);
                l.setLayoutData((Object)new GridData(4, 1, true, false));
                l.setText(Messages.XmlWizard_20);
                Composite group = new Composite(main, 0);
                GridLayout gl = null;
                gl = new GridLayout(3, false);
                group.setLayout((Layout)gl);
                gl.marginWidth = 0;
                gl.marginHeight = 0;
                group.setLayoutData((Object)new GridData(4, 1, true, false));
                l = new Label(group, 0);
                l.setLayoutData((Object)new GridData());
                l.setText(Messages.XmlWizard_21);
                final Text xmlPath = new Text(group, 2048);
                xmlPath.setLayoutData((Object)new GridData(4, 1, true, false));
                xmlPath.setData("qa", (Object)InternalIdentifier.XML_WIZARD_TEXT_DEFAULT_XML_FILE.getId());
                Button b = new Button(group, 8);
                b.setLayoutData((Object)new GridData(3, 1, false, false));
                b.setText("...");
                b.setData("qa", (Object)InternalIdentifier.XML_WIZARD_BUTTON_BROWSE_DEFAULT_XML_FILE.getId());
                b.setToolTipText(Messages.XmlWizard_23);
                ScrolledCompositeWizardHelper.adaptToContent(scrolled, main);
                this.setControl((Control)scrolled);
                xmlPath.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        XmlWizard.this.getControler().getBean().setXmlPath(xmlPath.getText());
                        xmlFile = null;
                        try {
                            xmlFile = XmlWizard.this.getControler().getXMLFile();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        this.getContainer().updateButtons();
                        this.updateErrorMessage();
                    }
                });
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String file;
                        FileDialog fdlg = new FileDialog(this.getShell(), 4096);
                        fdlg.setFilterExtensions(new String[]{"*.xml", "*.*"});
                        String path = null;
                        try {
                            path = XmlWizard.this.getFile().evaluate("@xmlPath");
                            if (path != null && !path.trim().isEmpty()) {
                                path = new File(path).getParent();
                            }
                        }
                        catch (XPathExpressionException ex) {
                            ex.printStackTrace();
                        }
                        if (path != null) {
                            fdlg.setFilterPath(path);
                        }
                        if ((file = fdlg.open()) != null) {
                            xmlFile = new File(file);
                            try {
                                xmlPath.setText(MdAttributeNativeEvaluator.preserveNatuveEvaluationBlock((Configuration)XmlWizard.this.getFile(), (String)MdAttributeReader.readAttribute((String)"xmlPath", (MdNode)XmlWizard.this.getFile()), (String)xmlFile.getAbsolutePath()));
                            }
                            catch (Exception ex) {
                                xmlPath.setText(xmlFile.getAbsolutePath());
                            }
                        }
                        this.getContainer().updateButtons();
                        this.updateErrorMessage();
                    }
                });
                xmlPath.setText(XmlWizard.this.getControler().getBean().getXmlPath());
            }
        };
        this.addPage(this.xmlPage);
    }

    private void createXsdPages() {
        this.xsdPage = new WizardPage("Xsd.Page"){
            File xsdFile;

            private void updateErrorMessage() {
                if (this.isPageComplete()) {
                    this.setErrorMessage(null);
                } else {
                    this.setErrorMessage(Messages.XmlWizard_25);
                }
            }

            public IWizardPage getNextPage() {
                return XmlWizard.this.xsdRootPage;
            }

            public boolean isPageComplete() {
                return this.xsdFile != null && this.xsdFile.exists() && this.xsdFile.isFile();
            }

            public void createControl(Composite parent) {
                ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite(parent);
                Composite main = new Composite((Composite)scrolled, 0);
                main.setLayout((Layout)new GridLayout());
                ((GridLayout)main.getLayout()).verticalSpacing = 25;
                Label l = new Label(main, 64);
                l.setLayoutData((Object)new GridData(4, 1, true, false));
                l.setText(Messages.XmlWizard_26);
                Composite group = new Composite(main, 0);
                GridLayout gl = null;
                gl = new GridLayout(3, false);
                group.setLayout((Layout)gl);
                gl.marginWidth = 0;
                gl.marginHeight = 0;
                group.setLayoutData((Object)new GridData(4, 1, true, false));
                l = new Label(group, 0);
                l.setLayoutData((Object)new GridData());
                l.setText(Messages.XmlWizard_27);
                final Text xsdPath = new Text(group, 2048);
                xsdPath.setLayoutData((Object)new GridData(4, 1, true, false));
                xsdPath.setData("qa", (Object)InternalIdentifier.XML_WIZARD_TEXT_XSD_FILE.getId());
                xsdPath.setText(XmlWizard.this.getControler().getBean().getXsdPath());
                try {
                    this.xsdFile = XmlWizard.this.getControler().getXSDFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Button b = new Button(group, 8);
                b.setLayoutData((Object)new GridData(3, 1, false, false));
                b.setData("qa", (Object)InternalIdentifier.XML_WIZARD_BUTTON_BROWSE_XSD_FILE.getId());
                b.setText("...");
                b.setToolTipText(Messages.XmlWizard_29);
                l = new Label(group, 0);
                l.setLayoutData((Object)new GridData());
                l.setText(Messages.XmlWizard_30);
                final Text depth = new Text(group, 2048);
                depth.setLayoutData((Object)new GridData(4, 1, true, false));
                depth.setData("qa", (Object)InternalIdentifier.XML_WIZARD_TEXT_RECURSIVITY.getId());
                ScrolledCompositeWizardHelper.adaptToContent(scrolled, main);
                this.setControl((Control)scrolled);
                xsdPath.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        block11: {
                            XmlWizard.this.getControler().getBean().setXsdPath(xsdPath.getText());
                            try {
                                try {
                                    xsdFile = XmlWizard.this.getControler().getXSDFile();
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                    if (XmlWizard.this.getControler().getBean().getXsdRootElement() == null) {
                                        (this).XmlWizard.this.rootElements.setText("");
                                    } else {
                                        (this).XmlWizard.this.rootElements.setText(XmlWizard.this.getControler().getBean().getXsdRootElement());
                                    }
                                    break block11;
                                }
                            }
                            catch (Throwable throwable) {
                                if (XmlWizard.this.getControler().getBean().getXsdRootElement() == null) {
                                    (this).XmlWizard.this.rootElements.setText("");
                                } else {
                                    (this).XmlWizard.this.rootElements.setText(XmlWizard.this.getControler().getBean().getXsdRootElement());
                                }
                                throw throwable;
                            }
                            if (XmlWizard.this.getControler().getBean().getXsdRootElement() == null) {
                                (this).XmlWizard.this.rootElements.setText("");
                            } else {
                                (this).XmlWizard.this.rootElements.setText(XmlWizard.this.getControler().getBean().getXsdRootElement());
                            }
                        }
                        this.updateErrorMessage();
                        this.getContainer().updateButtons();
                    }
                });
                depth.setText("" + XmlWizard.this.getControler().getBean().getXsdRecursivityDepth());
                b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        String file;
                        FileDialog fdlg = new FileDialog(this.getShell(), 4096);
                        fdlg.setFilterExtensions(new String[]{"*.xsd", "*.*"});
                        String path = null;
                        try {
                            path = XmlWizard.this.getFile().evaluate("@xsdPath");
                            if (path != null && !path.trim().isEmpty()) {
                                path = new File(path).getParent();
                            }
                        }
                        catch (XPathExpressionException ex) {
                            ex.printStackTrace();
                        }
                        if (path != null) {
                            fdlg.setFilterPath(path);
                        }
                        if ((file = fdlg.open()) != null) {
                            xsdFile = new File(file);
                            try {
                                xsdPath.setText(MdAttributeNativeEvaluator.preserveNatuveEvaluationBlock((Configuration)XmlWizard.this.getFile(), (String)MdAttributeReader.readAttribute((String)"xsdPath", (MdNode)XmlWizard.this.getFile()), (String)xsdFile.getAbsolutePath()));
                            }
                            catch (Exception ex) {
                                xsdPath.setText(xsdFile.getAbsolutePath());
                            }
                            this.getContainer().updateButtons();
                        }
                        this.updateErrorMessage();
                    }
                });
                depth.addListener(25, new Listener(){

                    public void handleEvent(Event e) {
                        String string = e.text;
                        char[] chars = new char[string.length()];
                        string.getChars(0, chars.length, chars, 0);
                        int i = 0;
                        while (i < chars.length) {
                            if ('0' > chars[i] || chars[i] > '9') {
                                e.doit = false;
                                return;
                            }
                            ++i;
                        }
                    }
                });
                depth.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        XmlWizard.this.getControler().getBean().setXsdRecursivityDepth(Integer.valueOf(depth.getText()));
                    }
                });
            }
        };
        this.addPage(this.xsdPage);
        this.xsdRootPage = new WizardPage("XsdRoot.Page"){

            private void updateErrorMessage() {
                if (!this.isPageComplete()) {
                    this.setErrorMessage(Messages.XmlWizard_34);
                } else {
                    this.setErrorMessage(null);
                }
            }

            public IWizardPage getNextPage() {
                return XmlWizard.this.selectivePage;
            }

            public boolean isPageComplete() {
                return XmlWizard.this.getControler().getBean().getXsdRootElement() != null && !XmlWizard.this.getControler().getBean().getXsdRootElement().isEmpty();
            }

            public void createControl(Composite parent) {
                ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite(parent);
                Composite main = new Composite((Composite)scrolled, 0);
                main.setLayout((Layout)new GridLayout());
                ((GridLayout)main.getLayout()).verticalSpacing = 25;
                Label l = new Label(main, 64);
                l.setLayoutData((Object)new GridData(4, 1, true, false));
                l.setText(Messages.XmlWizard_35);
                Composite group = new Composite(main, 0);
                group.setLayout((Layout)new GridLayout(2, false));
                group.setLayoutData((Object)new GridData(4, 1, true, false));
                l = new Label(group, 64);
                l.setLayoutData((Object)new GridData());
                l.setText(Messages.XmlWizard_36);
                XmlWizard.this.rootElements = new Combo(group, 8);
                XmlWizard.this.rootElements.setLayoutData((Object)new GridData(4, 1, true, false));
                XmlWizard.this.rootElements.setData("qa", (Object)InternalIdentifier.XML_WIZARD_COMBO_ROOT_ELEMENT.getId());
                ScrolledCompositeWizardHelper.adaptToContent(scrolled, main);
                this.setControl((Control)scrolled);
                XmlWizard.this.rootElements.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        XmlWizard.this.getControler().getBean().setXsdRootElement((this).XmlWizard.this.rootElements.getItem((this).XmlWizard.this.rootElements.getSelectionIndex()));
                        this.updateErrorMessage();
                        this.getContainer().updateButtons();
                    }
                });
            }
        };
        this.addPage(this.xsdRootPage);
    }

    private void createSelectivePage() {
        this.selectivePage = new WizardPage(Messages.MDWizard_1){

            public void createControl(Composite parent) {
                TabbedPropertySheetWidgetFactory widgetFactory = new TabbedPropertySheetWidgetFactory();
                XmlWizard.this.diffNodeUI = new MdDiffNodeUI(widgetFactory);
                Composite main = widgetFactory.createComposite(parent, 0);
                main.setLayout((Layout)new GridLayout());
                ((GridLayout)main.getLayout()).verticalSpacing = 0;
                XmlWizard.this.diffNodeUI.createSearchBar(main).setLayoutData((Object)new GridData(4, 1, true, false));
                XmlWizard.this.diffNodeUI.createOptionComposite(main).setLayoutData((Object)new GridData(4, 1, true, false));
                XmlWizard.this.diffNodeUI.createToolbar(main).setLayoutData((Object)new GridData(4, 1, true, false));
                ((GridLayout)main.getLayout()).verticalSpacing = 0;
                main.setLayoutData((Object)new GridData(1808));
                CheckboxTreeViewer diffViewer = XmlWizard.this.diffNodeUI.createViewer(main);
                diffViewer.getControl().setLayoutData((Object)new GridData(1808));
                diffViewer.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        MdDiffNode d = (MdDiffNode)element;
                        if (d.getState() == MdDiffNode.State.OLD) {
                            Boolean b = XmlWizard.this.getDeleteReverseOptions().get(d.getOldNode().getDefType());
                            return b == Boolean.TRUE;
                        }
                        return true;
                    }
                });
                this.setControl((Control)main);
            }
        };
        this.addPage(this.selectivePage);
        this.selectivePage.setDescription(Messages.MDWizard_1);
        this.selectivePage.setTitle(Messages.MDWizard_2);
    }

    protected MdNode getFile() {
        return this.getNode();
    }

    protected boolean handleDiffViewerCheckState() {
        MessageDialog dialog;
        int result;
        return this.diffNodeUI.getViewerHelper().getCheckedElements().length != 0 || (result = (dialog = new MessageDialog(this.getShell(), Messages.XmlWizard_37, null, Messages.XmlWizard_38, 5, new String[]{Messages.XmlWizard_39, Messages.XmlWizard_40}, 0)).open()) != 1;
    }

    protected MdNode computeDiffStateResult(Map<MdNode, MdNode> reversedMap) throws Exception {
        VisitHandler handler = new VisitHandler();
        handler.newToOldMap = reversedMap;
        ArrayList<String> toDelete = new ArrayList<String>();
        for (String s : this.getDeleteReverseOptions().keySet()) {
            if (this.getDeleteReverseOptions().get(s) != Boolean.TRUE) continue;
            toDelete.add(s);
        }
        MdDiffNodeUI.DiffState diffState = this.diffNodeUI.computeDiffState((MdDiffNodeUI.IVisitorHandler)handler, toDelete);
        return diffState.getResultingMdNode();
    }

    public boolean performFinish() {
        HashMap<MdNode, MdNode> reversedMap;
        DocumentRoot root;
        block7: {
            MdNode originalServiceNode = this.getFile();
            while (originalServiceNode.eContainer() instanceof MdNode) {
                originalServiceNode = (MdNode)originalServiceNode.eContainer();
            }
            root = (DocumentRoot)originalServiceNode.eContainer();
            reversedMap = new HashMap<MdNode, MdNode>();
            if (this.handleDiffViewerCheckState()) break block7;
            return false;
        }
        try {
            if (this.xmlPage == this.getContainer().getCurrentPage()) {
                this.loadSelectiveTree();
                this.diffNodeUI.getViewerHelper().setAllChecked(true);
            }
            MdNode result = this.computeDiffStateResult(reversedMap);
            reversedMap.put((MdNode)result.getNode().get(0), this.getNode());
            ((MdNode)result.getNode().get(0)).setAttribute("xsdPath", this.getControler().getBean().getXsdPath(), false);
            ((MdNode)result.getNode().get(0)).setAttribute("xmlPath", this.getControler().getBean().getXmlPath(), false);
            if (result.getName() == null || result.getName().isEmpty()) {
                result.setName(this.getControler().createNewMd().getName());
            }
            ArrayList excludeAttributeToUpdate = new ArrayList();
            boolean updateName = this.getFile().getName() == null || this.getFile().getName().isEmpty();
            TreeIterator it = result.eAllContents();
            while (it.hasNext()) {
                EObject o = (EObject)it.next();
                if (!(o instanceof MdNode)) continue;
                ((MdNode)o).setSubstituteContainer(null);
            }
            result.setSubstituteContainer(null);
            IncrementalReverser ir = new IncrementalReverser((EObject)root, reversedMap, excludeAttributeToUpdate, updateName, null, this.getDeleteReverseOptions(), (IncrementalReverser.IReverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, null, true);
            ir.reverse();
            return true;
        }
        catch (Exception e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "com.indy.addons", Messages.MDWizard_3, (Throwable)e));
            return false;
        }
    }

    protected MdNode createNonContainerMdNode() {
        return new CustomMdNode(){

            public EList<MdNode> getNode() {
                if (this.node == null) {
                    this.node = new EObjectEList(MdNode.class, (InternalEObject)this, 7);
                }
                return this.node;
            }
        };
    }

    protected MdDiffNode loadSelectiveTree() {
        MdNode newNode = this.getControler().createNewMd();
        MdNode newroot = MdFactory.eINSTANCE.createMdNode();
        newroot.setSubstituteContainer(newNode.getSubstituteContainer());
        newroot.setDefType("com.stambia.xml.xsd");
        newroot.getNode().add((Object)newNode);
        newroot.setName("dummyRoot");
        newNode.setSubstituteContainer(null);
        MdNode dummyRoot = this.createNonContainerMdNode();
        dummyRoot.setName("dummyRoot");
        dummyRoot.setDefType("com.stambia.xml.xsd");
        dummyRoot.getNode().add((Object)this.getFile());
        dummyRoot.setSubstituteContainer(this.getFile().eContainer());
        try {
            this.getFile().setSubstituteContainer((EObject)dummyRoot);
            MdDiffNode diffNode = new MdDiffNode(null, dummyRoot, newroot, null, false);
            HashMap<String, IncrementalReverser.DefaulteverseMatchingStrategy> modes = new HashMap<String, IncrementalReverser.DefaulteverseMatchingStrategy>();
            modes.put("com.stambia.xml.xsd", IncrementalReverser.DefaulteverseMatchingStrategy.ByNaturalOrder);
            MdDiffBuilder.buildTree((IncrementalReverser.DefaulteverseMatchingStrategy)IncrementalReverser.DefaulteverseMatchingStrategy.ByName, (MdDiffNode)diffNode, (Set)Collections.EMPTY_SET, null, modes);
            MdDiffNode mdDiffNode = diffNode;
            return mdDiffNode;
        }
        finally {
            this.getFile().setSubstituteContainer(null);
        }
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    private class VisitHandler
    implements MdDiffNodeUI.IVisitorHandler {
        Map<MdNode, MdNode> newToOldMap;

        private VisitHandler() {
        }

        public void handleVisited(MdDiffNode diff, MdNode createdNode) {
            MdNode n = diff.getState() == MdDiffNode.State.NEW ? diff.getNewNode() : diff.getOldNode();
        }
    }
}

