/*
 * Decompiled with CFR 0.152.
 */
package com.indy.file.wizard;

import com.indy.addons.Messages;
import com.indy.addons.ScrolledCompositeWizardHelper;
import com.indy.file.composite.DirectoryComposite;
import com.indy.file.composite.FileFieldPropertiesComposite;
import com.indy.file.composite.FilePropertiesComposite;
import com.indy.md.ui.editor.ui.MdWizard;
import com.indy.md.ui.editor.ui.MdWizardPage;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.custom.Util;
import com.stambia.md.util.MdFactoryHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DirectoryWizard
extends MdWizard {
    protected MdNode file;
    private MdWizardPage directoryPage;
    MdWizardPage activePage;
    boolean fileAlreadyExits = true;

    public void addPages() {
        this.getShell().setSize(600, 700);
        this.setWindowTitle(Messages.DirectoryWizard_0);
        this.init();
    }

    public void init() {
        this.directoryPage = new MdWizardPage(Messages.DirectoryWizard_1, this.getNode()){

            public void setVisible(boolean visible) {
                DirectoryWizard.this.activePage = !visible ? null : this;
                super.setVisible(visible);
            }

            public void createControl(Composite parent) {
                ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite(parent);
                DirectoryComposite directoryComposite = new DirectoryComposite((Composite)scrolled, 0){

                    @Override
                    public MdNode getDirectory() {
                        return this.getNode();
                    }

                    @Override
                    public void handleIsComplete(boolean complete) {
                        this.setPageComplete(complete);
                    }
                };
                directoryComposite.setLayoutData(new GridData(4, 4, true, true));
                ScrolledCompositeWizardHelper.adaptToContent(scrolled, directoryComposite);
                this.setControl((Control)scrolled);
                this.setPageComplete(directoryComposite.isComplete());
            }
        };
        this.directoryPage.setTitle(Messages.DirectoryWizard_2);
        this.directoryPage.setDescription(Messages.DirectoryWizard_3);
        this.addPage((IWizardPage)this.directoryPage);
        MdWizardPage secondFilePage = new MdWizardPage(Messages.DirectoryWizard_4, this.getNode()){
            boolean lastComplete;

            public void setVisible(boolean visible) {
                if (!visible) {
                    this.lastComplete = this.isPageComplete();
                    this.setPageComplete(true);
                } else {
                    this.setPageComplete(this.lastComplete);
                }
                super.setVisible(visible);
            }

            public void createControl(Composite parent) {
                ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite(parent);
                FilePropertiesComposite composite = new FilePropertiesComposite((Composite)scrolled, 0){

                    @Override
                    public void handleModification(Object object) {
                        String msg = this.isNameValid();
                        if (msg != null) {
                            this.setPageComplete(false);
                            this.setMessage(msg, 3);
                        } else {
                            this.setMessage(null);
                            this.setPageComplete(this.isComplete());
                        }
                    }

                    @Override
                    public MdNode getFile() {
                        return DirectoryWizard.this.getFile();
                    }
                };
                composite.setLayoutData(new GridData(4, 4, true, true));
                ScrolledCompositeWizardHelper.adaptToContent(scrolled, composite);
                this.setControl((Control)scrolled);
            }
        };
        secondFilePage.setTitle(Messages.DirectoryWizard_5);
        secondFilePage.setDescription(Messages.DirectoryWizard_6);
        this.addPage((IWizardPage)secondFilePage);
        MdWizardPage thirdFilePage = new MdWizardPage(Messages.DirectoryWizard_7, this.getNode()){

            public void createControl(Composite parent) {
                ScrolledComposite scrolled = ScrolledCompositeWizardHelper.createScrolledComposite(parent);
                FileFieldPropertiesComposite reverseComposite = new FileFieldPropertiesComposite((Composite)scrolled, 0){

                    @Override
                    public void handleModification() {
                        this.setPageComplete(this.isComplete());
                    }

                    @Override
                    public MdNode getFile() {
                        return DirectoryWizard.this.getFile();
                    }
                };
                reverseComposite.setLayoutData(new GridData(4, 4, true, true));
                ScrolledCompositeWizardHelper.adaptToContent(scrolled, reverseComposite);
                this.setControl((Control)scrolled);
            }
        };
        thirdFilePage.setTitle(Messages.DirectoryWizard_8);
        thirdFilePage.setDescription(Messages.DirectoryWizard_9);
        this.addPage((IWizardPage)thirdFilePage);
    }

    protected MdNode getFile() {
        if (this.file == null) {
            this.fileAlreadyExits = false;
            this.file = MdFactoryHelper.createMdNode((String)"com.stambia.file.file");
            Util.commandOnActiveTransaction((EObject)this.getNode(), (EStructuralFeature)MdPackage.eINSTANCE.getMdNode_Node(), (Object)this.file, (int)1);
        }
        return this.file;
    }

    public boolean performFinish() {
        if (this.activePage == this.directoryPage && !this.fileAlreadyExits) {
            Util.commandOnActiveTransaction((EObject)this.getNode(), (EStructuralFeature)MdPackage.eINSTANCE.getMdNode_Node(), (Object)this.file, (int)2);
        }
        return true;
    }

    public boolean performCancel() {
        return super.performCancel();
    }
}

