/*
 * Decompiled with CFR 0.152.
 */
package com.indy.file.xml.editor;

import com.indy.addons.Messages;
import com.indy.file.xml.editor.XsdValidationException;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.osgi.service.log.LogService;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLDocumentProvider
extends TextFileDocumentProvider {
    private HashMap<String, Validator> validators = new HashMap();
    private SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");

    public XMLDocumentProvider() {
        try {
            this.factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        }
        catch (Exception e) {
            ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger(XMLDocumentProvider.class).debug("External Entity disablement not supported", (Object)e);
        }
        try {
            this.factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        }
        catch (Exception e) {
            ((LogService)E4InjectorHelper.getService(LogService.class)).getLogger(XMLDocumentProvider.class).debug("External Entity disablement not supported", (Object)e);
        }
    }

    public void validate(IDocument doc, File xsdFile) throws Exception {
        if (xsdFile == null || !xsdFile.isFile()) {
            return;
        }
        Validator validator = this.validators.get(xsdFile.getAbsolutePath());
        if (validator == null) {
            Schema schema = this.factory.newSchema(xsdFile);
            validator = schema.newValidator();
            validator.setErrorHandler(new XmlErrorHandler());
            this.validators.put(xsdFile.getAbsolutePath(), validator);
        }
        XmlErrorHandler handler = (XmlErrorHandler)validator.getErrorHandler();
        handler.clear();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(doc.get()));
        validator.validate(new SAXSource(is));
        if (!handler.isEmpty()) {
            MultiStatus status = new MultiStatus("com.indy.jdbc.editor", 4, Messages.XMLDocumentProvider_0, null);
            for (Exception exception : handler.getWarning()) {
                status.add((IStatus)new Status(2, "com.indy.jdbc.editor", exception.getMessage(), (Throwable)exception));
            }
            for (Exception exception : handler.getErrors()) {
                status.add((IStatus)new Status(4, "com.indy.jdbc.editor", exception.getMessage(), (Throwable)exception));
            }
            for (Exception exception : handler.getFatals()) {
                status.add((IStatus)new Status(4, "com.indy.jdbc.editor", exception.getMessage(), (Throwable)exception));
            }
            throw new XsdValidationException((IStatus)status, handler.getWarning(), handler.getErrors(), handler.getFatals());
        }
    }

    public static class XmlErrorHandler
    implements ErrorHandler {
        private List<SAXParseException> errors = new ArrayList<SAXParseException>();
        private List<SAXParseException> fatals = new ArrayList<SAXParseException>();
        private List<SAXParseException> warning = new ArrayList<SAXParseException>();

        @Override
        public void error(SAXParseException arg0) throws SAXException {
            this.errors.add(arg0);
        }

        @Override
        public void fatalError(SAXParseException arg0) throws SAXException {
            this.fatals.add(arg0);
        }

        @Override
        public void warning(SAXParseException arg0) throws SAXException {
            this.warning.add(arg0);
        }

        public List<SAXParseException> getErrors() {
            return this.errors;
        }

        public List<SAXParseException> getFatals() {
            return this.fatals;
        }

        public List<SAXParseException> getWarning() {
            return this.warning;
        }

        public void clear() {
            this.errors.clear();
            this.fatals.clear();
            this.warning.clear();
        }

        public boolean isEmpty() {
            return this.errors.size() + this.fatals.size() + this.warning.size() == 0;
        }
    }
}

