/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri;

import com.indy.emf.uri.StatusListener;
import com.indy.emf.uri.ValidationStatus;
import com.indy.emf.uri.internal.MarkerHelper;
import com.indy.emf.uri.validation2.Validation;
import com.indy.emf.uri.validation2.ValidationJob;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.preferences.license.License;
import com.semarchy.xdi.designer.preferences.license.LicenseOffline;
import com.semarchy.xdi.designer.preferences.license.LicenseServer;
import com.semarchy.xdi.designer.preferences.license.LicenseToleranceData;
import com.semarchy.xdi.designer.preferences.license.LicenseTrial;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class CacheUtil {
    public static final String REFRENCE_ATTRIBUTE_ID = "com.indy.emf.uri.referenceId";
    public static final String RESOURCE_MARKER_ID = "com.stambia.resource.marker";
    public static final String MARKER_ATT_COMPONENT_ROLE = "com.semarchy.resource.marker.roleRequired.role";
    public static final QualifiedName RESOURCE_PROPERTY_IS_DUPLICATE = new QualifiedName("com.emf.uri", "isDuplicate");
    public static final QualifiedName RESOURCE_PROPERTY_HAS_DUPLICATE = new QualifiedName("com.emf.uri", "hasDuplicate");
    public static final QualifiedName RESOURCE_PROPERTY_ACTIVE_FILE_ID = new QualifiedName("com.emf.uri", "activeFileId");
    static List<StatusListener> listeners = Collections.synchronizedList(new ArrayList());

    public static void reInitCache() {
        try {
            MarkerHelper.INSTANCE.destroyMarkers();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        ((ICacheService)E4InjectorHelper.getService(ICacheService.class)).init(true);
    }

    public static void checkLicense() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ValidationJob.INSTANCE.scheduleChangePopup();
    }

    public static void addStatusListener(StatusListener listener) {
        listeners.add(listener);
    }

    public static void removeStatusListener(StatusListener listener) {
        listeners.remove(listener);
    }

    public static List<StatusListener> getListeners() {
        return listeners;
    }

    public static LicenseInformations getLicenseInformations() {
        LicenseInformations i = new LicenseInformations();
        License l = Validation.INSTANCE.getLicense();
        LicenseToleranceData timeInfo = Validation.INSTANCE.getLicenseTimeData();
        i.licenseMode = l.getMode();
        switch (l.getMode()) {
            case OFFLINE: {
                i.remainingTolerance = timeInfo.getFormatRemainingToleranceTime();
                i.defalyBefforeAdvertizing = timeInfo.getFormatDelayFirstTolerance();
                i.group = ((LicenseOffline)l).getGroup();
                i.status = l.getStatus().toString();
                i.macAddress = Validation.INSTANCE.getClient().getMacAdressesList();
                i.expirationDate = l.getExpirationDate();
                i.licenseServerURL = null;
                break;
            }
            case LOCAL: 
            case ONLINE: {
                i.remainingTolerance = timeInfo.getFormatRemainingToleranceTime();
                i.defalyBefforeAdvertizing = timeInfo.getFormatDelayFirstTolerance();
                i.group = ((LicenseServer)l).getGroup();
                i.status = l.getStatus().toString();
                i.macAddress = Validation.INSTANCE.getClient().getMacAdressesList();
                i.expirationDate = l.getExpirationDate();
                i.licenseServerURL = ((LicenseServer)l).getLicenseServerURL();
                if (i.licenseServerURL != null && !i.licenseServerURL.isEmpty()) break;
                if (i.licenseMode == Validation.Mode.ONLINE) {
                    i.licenseServerURL = "https://license-xdi.semarchy.com";
                    break;
                }
                i.licenseServerURL = System.getenv("XDI_DESIGNER_LICENSE_SERVER_URL");
                break;
            }
            case TRIAL: {
                i.remainingTolerance = "";
                i.defalyBefforeAdvertizing = "";
                i.group = "";
                i.status = l.getStatus() != ValidationStatus.EXPIRED ? ValidationStatus.VALID.toString() : l.getStatus().toString();
                i.macAddress = ((LicenseTrial)l).getMacAddress();
                i.expirationDate = l.getExpirationDate();
                i.licenseServerURL = "";
            }
        }
        return i;
    }

    public static class LicenseInformations {
        String macAddress;
        Date expirationDate;
        Validation.Mode licenseMode;
        String licenseServerURL;
        String group;
        String defalyBefforeAdvertizing;
        String remainingTolerance;
        String status;

        public String getMacAddress() {
            return this.macAddress;
        }

        public String getMacAddressesToDisplay() {
            return Validation.INSTANCE.getClient().getMacAddressesToDisplay();
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public Validation.Mode getLicenseMode() {
            return this.licenseMode;
        }

        public String getLicenseServerURL() {
            if (this.licenseServerURL == null) {
                return "";
            }
            return this.licenseServerURL;
        }

        public String getGroup() {
            if (this.group == null) {
                return "";
            }
            return this.group;
        }

        public String getDefalyBefforeAdvertizing() {
            if (this.defalyBefforeAdvertizing == null) {
                return "";
            }
            return this.defalyBefforeAdvertizing;
        }

        public String getRemainingTolerance() {
            if (this.remainingTolerance == null) {
                return "";
            }
            return this.remainingTolerance;
        }

        public String getStatus() {
            if (this.status == null) {
                return "";
            }
            return this.status;
        }
    }
}

