/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.action;

import com.indy.emf.uri.Messages;
import com.indy.emf.uri.action.XDIResourceIDGenerator;
import com.indy.ui.custom.out.Util;
import com.semarchy.xdi.designer.core.indexation.IndexationRegisterExtension;
import com.semarchy.xdi.designer.core.models.EMFResourceOptions;
import com.semarchy.xdi.designer.core.models.IndyXMLResource;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public class ActionReinitId
implements IWorkbenchWindowActionDelegate {
    private ISelection selection;
    private static final Logger logger = LogManager.getLogger(ActionReinitId.class);

    public void dispose() {
        this.selection = null;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        if (this.selection instanceof IStructuredSelection) {
            final ArrayList list = new ArrayList(((IStructuredSelection)this.selection).toList());
            if (!MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Reinit Internal ids", (String)"You are about to reset internal ids. All the opened editors will be closed without saving their current modifications. Do you want to proceed?")) {
                return;
            }
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
            WorkspaceJob job = new WorkspaceJob("Reset ids"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    try {
                        Stream<URI> uris = list.stream().filter(IFile.class::isInstance).map(o -> URIUtils.convertIPathToEMFURI2((IPath)((IFile)o).getFullPath()));
                        PlatformUI.getWorkbench().getOperationSupport().getOperationHistory().execute(XDIResourceIDGenerator.createOperation(uris.collect(Collectors.toList())), null, null);
                    }
                    catch (ExecutionException e) {
                        return new Status(4, ((Object)((Object)this)).getClass(), this.getName(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            job.setUser(true);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.error("unexpected", (Throwable)e);
            }
        }
    }

    public static Map<String, String> reinit(IPath toPath, Collection<IFile> files, IProgressMonitor monitor, Map<String, String> oldIdToNewIdMapRef) {
        TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        ResourceSet rs = editingDomain.getResourceSet();
        ((ResourceSetImpl)rs).setURIResourceMap(new WeakHashMap());
        rs.setURIConverter((URIConverter)new InternalResourceURIConverter(false));
        rs.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_BATCH_VALIDATION, Boolean.TRUE);
        rs.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_REF_SYNC", Boolean.TRUE);
        rs.getLoadOptions().put("com.indy.gmf.map.LOAD_OPTION_NO_MAP_UPDATE", Boolean.TRUE);
        rs.getLoadOptions().put(EMFResourceOptions.LOAD_OPTION_NO_EXTERNAIZATION_LOADING, Boolean.TRUE);
        rs.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        rs.getLoadOptions().put("PROCESS_DANGLING_HREF", "RECORD");
        rs.getLoadOptions().put("com.indy.md.ui.validateMdXML", Boolean.TRUE);
        rs.getLoadOptions().put("com.indy.emf.uri.resource.load.detectDuplicateId", Boolean.TRUE);
        try {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            HashMap<String, String> oldIdToNewId = new HashMap<String, String>();
            Resource r = toPath == null ? null : rs.getResource(Util.convertIPathToEMFURI2((IPath)toPath), true);
            String fromRootIr = r == null ? null : EcoreUtil.getID((EObject)((EObject)((EObject)r.getContents().get(0)).eContents().get(0)));
            for (IFile file : files) {
                Resource re;
                monitor.subTask(file.getFullPath().toString() + Messages.ActionReinitId_1);
                boolean readOnly = file.isReadOnly();
                if (readOnly) {
                    file.setReadOnly(false);
                }
                if ((re = rs.getResource(Util.convertIFileToEMFURI((IFile)file), false)) instanceof IndyXMLResource) {
                    re.unload();
                    ((IndyXMLResource)re).getIntrinsicIDToEObjectMap().clear();
                    re = null;
                }
                if (re == null) {
                    re = rs.getResource(Util.convertIFileToEMFURI((IFile)file), true);
                }
                resources.add(re);
                monitor.worked(1);
            }
            Collections.sort(resources, new ResourceComparator());
            for (Resource re : resources) {
                if (re instanceof IndyXMLResource) {
                    EObject oo = (EObject)((EObject)re.getContents().get(0)).eContents().get(0);
                    String oldId = oo.eGet((EStructuralFeature)oo.eClass().getEIDAttribute()).toString();
                    monitor.subTask(re.getURI().toString() + Messages.ActionReinitId_5);
                    Map newMapId = ((IndyXMLResource)re).reinitAllId(fromRootIr, oldIdToNewIdMapRef == null ? oldIdToNewId : oldIdToNewIdMapRef);
                    oldIdToNewId.putAll(newMapId);
                    String newId = oo.eGet((EStructuralFeature)oo.eClass().getEIDAttribute()).toString();
                    if (oldIdToNewIdMapRef != null) {
                        oldIdToNewIdMapRef.putAll(newMapId);
                    }
                    monitor.worked(1);
                    logger.info("reinit id {} ({}->{})", (Object)re, (Object)oldId, (Object)newId);
                    continue;
                }
                oldIdToNewId.putAll(oldIdToNewIdMapRef);
            }
            for (Resource re : resources) {
                monitor.subTask(String.valueOf(re.getURI()) + Messages.ActionReinitId_7);
                HashMap<String, Object> saveOptions = new HashMap<String, Object>();
                Util util = Util.INSTANCE;
                util.getClass();
                saveOptions.put("URI_HANDLER", new Util.URIHandlerImpl2(util, oldIdToNewIdMapRef == null ? oldIdToNewId : oldIdToNewIdMapRef));
                saveOptions.put("ENCODING", "UTF-8");
                saveOptions.put("com.indy.gmf.map.SAVE_OPTION_NO_REF_SAVE", Boolean.TRUE);
                saveOptions.put("com.indy.gmf.proc.util.ProcResourceImpl.saveOption.noCrossRefModel", Boolean.TRUE);
                try {
                    re.save(saveOptions);
                }
                catch (IOException e) {
                    logger.error("unexpected", (Throwable)e);
                }
                monitor.worked(1);
            }
            HashMap<String, String> hashMap = oldIdToNewId;
            return hashMap;
        }
        catch (Exception e) {
            logger.error("unexpected", (Throwable)e);
        }
        finally {
            editingDomain.dispose();
        }
        return Collections.emptyMap();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        action.setEnabled(false);
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            ICacheService cache = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
            for (Object obj : (IStructuredSelection)selection) {
                if (!(obj instanceof IFile) || !IndexationRegisterExtension.EXTENSION_MANAGER.getExtensionFile().containsKey(((IFile)obj).getFileExtension())) continue;
                ICacheService.SourceState s = cache.getSourceState(Util.convertIFileToEMFURI((IFile)((IFile)obj)));
                if (!Boolean.getBoolean(System.getProperty("com.stambia.team")) && s != null && !s.sourceExists()) continue;
                action.setEnabled(true);
                break;
            }
        }
    }

    private static class ResourceComparator
    implements Comparator<Resource> {
        private ResourceComparator() {
        }

        ResourceType getResourceType(Resource r) {
            String s = r.getURI().toPlatformString(true).toLowerCase();
            if (s.endsWith(".md")) {
                return ResourceType.MD;
            }
            if (s.endsWith(".proc")) {
                return ResourceType.PROC;
            }
            if (s.endsWith(".map")) {
                return ResourceType.MAPPING;
            }
            return ResourceType.OTHER;
        }

        @Override
        public int compare(Resource o1, Resource o2) {
            ResourceType type2;
            ResourceType type1 = this.getResourceType(o1);
            if (type1 == (type2 = this.getResourceType(o2))) {
                return o1.getURI().toPlatformString(true).compareTo(o2.getURI().toPlatformString(true));
            }
            switch (type1) {
                case MAPPING: {
                    switch (type2) {
                        case MD: {
                            return 1;
                        }
                        case OTHER: {
                            return -1;
                        }
                        case PROC: {
                            return -1;
                        }
                    }
                    break;
                }
                case MD: {
                    switch (type2) {
                        case MAPPING: {
                            return -1;
                        }
                        case OTHER: {
                            return -1;
                        }
                        case PROC: {
                            return -1;
                        }
                    }
                    break;
                }
                case PROC: {
                    switch (type2) {
                        case MD: {
                            return 1;
                        }
                        case OTHER: {
                            return -1;
                        }
                        case MAPPING: {
                            return 1;
                        }
                    }
                    break;
                }
                case OTHER: {
                    return 1;
                }
            }
            return 0;
        }
    }

    private static enum ResourceType {
        PROC,
        MAPPING,
        MD,
        OTHER;

    }
}

