/*
 * Decompiled with CFR 0.152.
 */
package com.indy.emf.uri.internal;

import com.indy.emf.uri.Messages;
import com.indy.emf.uri.internal.ICacheConsole;
import com.indy.emf.uri.internal.MarkerHelper;
import com.indy.ui.custom.out.tools.ApplicationHelper;
import com.semarchy.xdi.designer.core.services.ICacheService;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ICacheConsole.class}, immediate=true)
public class WorkspaceCallbackComponent
implements ICacheConsole {
    MessageConsole console;
    private ICacheService cacheService;
    private Logger logger = LogManager.getLogger(WorkspaceCallbackComponent.class);
    private WorkspaceJob markerJob = new WorkspaceJob("Refresh markers"){

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            try {
                if (ApplicationHelper.isRunningWorkbench()) {
                    MarkerHelper.INSTANCE.updateStambiaMarkers();
                }
            }
            catch (Exception e) {
                WorkspaceCallbackComponent.this.logger.error("Failed to update markers", (Throwable)e);
            }
            return Status.OK_STATUS;
        }
    };

    @Reference(service=ICacheService.class, policy=ReferencePolicy.DYNAMIC)
    public void bind(ICacheService cache) {
        cache.addUpdateTask(Messages.WorkspaceCallbackComponent_refreshConsoleSubtask, this::refreshConsole);
        cache.addUpdateTask(Messages.WorkspaceCallbackComponent_updatingMarkerSubtask, this::updateMarkers);
        this.cacheService = cache;
    }

    public void unbind(ICacheService cache) {
        cache.removeUpdateTask(Messages.WorkspaceCallbackComponent_refreshConsoleSubtask);
        cache.removeUpdateTask(Messages.WorkspaceCallbackComponent_updatingMarkerSubtask);
        this.cacheService = null;
    }

    @Override
    public void refreshAndActivate() {
        this.refreshConsole();
        this.console.activate();
    }

    private MessageConsole getConsole() {
        if (this.console == null) {
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            IConsoleManager conMan = plugin.getConsoleManager();
            this.console = new MessageConsole("Cache", null);
            conMan.addConsoles(new IConsole[]{this.console});
        }
        return this.console;
    }

    private void refreshConsole() {
        if (!ApplicationHelper.isRunningWorkbench()) {
            return;
        }
        this.getConsole().clearConsole();
        ICacheService.Statistics stat = this.cacheService.getStatistics();
        String msg = NLS.bind((String)Messages.WorkspaceCallbackComponent_cacheConsole, (Object[])new Object[]{stat.getResourcesNumber(), stat.getElementNumber()});
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (MessageConsoleStream stream = this.console.newMessageStream();){
                stream.println(msg);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logger.error("Unexpected", (Throwable)e);
        }
    }

    private void updateMarkers() {
        this.markerJob.cancel();
        this.markerJob.schedule(100L);
    }
}

