/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.preferences.license;

import com.indy.emf.uri.ValidationStatus;
import com.indy.emf.uri.validation2.Validation;
import com.semarchy.xdi.designer.preferences.license.HostInformation;
import com.semarchy.xdi.designer.preferences.license.License;
import com.semarchy.xdi.designer.preferences.license.LicenseToleranceData;
import com.semarchy.xdi.designer.preferences.license.RegistryHelper;
import com.semarchy.xdi.license.server.model.Messages;
import com.semarchy.xdi.license.server.model.Token;
import com.semarchy.xdi.license.server.model.Utils;
import com.stambia.ui.licence.manager.tools.Connection;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.runtime.Assert;
import org.xml.sax.InputSource;

public class LicenseServer
extends License {
    String uuid = UUID.randomUUID().toString();
    private Date expirationDate;
    protected String serverURL;
    protected String licenseKey;
    private String validLicenseServerAddress;
    private String newLicenseServerAddress;
    private boolean connectionSuccess = false;
    private String group;
    SimpleDateFormat hourFormatter = new SimpleDateFormat("mm:ss");
    private final Logger logger = LogManager.getLogger(this.getClass());

    public LicenseServer(Validation.Mode mode) {
        Assert.isTrue((mode == Validation.Mode.LOCAL || mode == Validation.Mode.ONLINE ? 1 : 0) != 0);
        this.mode = mode;
    }

    @Override
    public Validation.Mode getMode() {
        return this.mode;
    }

    public void setLicenseKey(String licenseKey) {
        this.licenseKey = licenseKey;
    }

    public void setLicenseServerURL(String url) {
        this.serverURL = url;
    }

    public String getGroupAddress(String address) {
        try {
            URL url = new URL(address);
            Object curentGroup = url.getPath();
            curentGroup = curentGroup == null || ((String)curentGroup).isEmpty() || ((String)curentGroup).replace("/", "").isEmpty() ? (String)curentGroup + "/default" : "";
            int i = address.indexOf("?");
            Object currentAddress = address;
            if (i > 0) {
                currentAddress = address.substring(0, i);
            }
            if (((String)currentAddress).endsWith("/")) {
                currentAddress = ((String)currentAddress).substring(0, ((String)currentAddress).length() - 1);
            }
            int index = ((String)currentAddress).indexOf("//");
            String addressWithoutPRotocol = ((String)currentAddress).substring(index + 2);
            String addressEnd = addressWithoutPRotocol.replace("/", "/api/2/");
            currentAddress = url.getProtocol() + "://" + addressEnd;
            return (String)currentAddress + (String)curentGroup;
        }
        catch (MalformedURLException e) {
            this.logger.warn("unexpected", (Throwable)e);
            return address;
        }
    }

    public String getLicenseServerURL() {
        return this.serverURL;
    }

    protected ValidationStatus invokeLicenseToken(String elligibleAddress, HttpClientResponseHandler<ValidationStatus> responseHandler) throws Exception {
        String groupAddress;
        Object currentGroup = "";
        Validation.INSTANCE.getClient().refreshInformation();
        String macS = Validation.INSTANCE.getClient().getMacAdressesList();
        String currentLicenseKey = this.licenseKey;
        if (currentLicenseKey == null || currentLicenseKey.isEmpty()) {
            currentLicenseKey = System.getenv().get("XDI_DESIGNER_LICENSE_KEY");
        }
        String decodedLicenceKey = null;
        try {
            decodedLicenceKey = new String(Base64.getDecoder().decode(currentLicenseKey));
        }
        catch (Exception ex) {
            throw new License.InvalidLicenseFormatxception("The license key is invalid.", ex);
        }
        int separator = decodedLicenceKey.indexOf(":");
        if (separator > -1) {
            currentGroup = decodedLicenceKey.substring(0, separator);
        }
        String groupKey = decodedLicenceKey.substring(separator + 1);
        if (((String)currentGroup).length() > 1) {
            this.group = currentGroup;
            currentGroup = elligibleAddress.endsWith("/") ? URLEncoder.encode((String)currentGroup, "UTF-8") : "/" + URLEncoder.encode((String)currentGroup, "UTF-8");
        }
        this.newLicenseServerAddress = groupAddress = this.getGroupAddress(elligibleAddress + (String)currentGroup);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uuid", this.uuid);
        params.put("macs", macS);
        params.put("user", System.getProperty("user.name"));
        params.put("ip", Validation.INSTANCE.getClient().getHostAddress());
        params.put("host", Validation.INSTANCE.getClient().getHostName());
        params.put("os", Validation.INSTANCE.getClient().getOs());
        params.put("jvm", Validation.INSTANCE.getClient().getJvm());
        params.put("stbversion", Validation.INSTANCE.getClient().getVersion());
        if (groupKey.length() > 0) {
            params.put("key", groupKey);
        }
        return (ValidationStatus)((Object)Connection.invoke((String)(groupAddress + "/token/designer"), params, responseHandler));
    }

    @Override
    public ValidationStatus checkValidity(LicenseToleranceData timeInfo) {
        this.setErrorMessage(null);
        String elligibleAddress = this.getLicenseServerURL();
        if (elligibleAddress == null || elligibleAddress.isEmpty()) {
            elligibleAddress = this.mode == Validation.Mode.ONLINE ? "https://license-xdi.semarchy.com" : System.getenv().get("XDI_DESIGNER_LICENSE_SERVER_URL");
        }
        ValidationStatus status = ValidationStatus.UNSET;
        try {
            return this.invokeLicenseToken(elligibleAddress, (HttpClientResponseHandler<ValidationStatus>)((HttpClientResponseHandler)r -> {
                ValidationStatus validationStatus = ValidationStatus.UNSET;
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (InputStream inputStream = r.getEntity().getContent();){
                        InputSource is = new InputSource();
                        is.setByteStream(inputStream);
                        JAXBElement elt = (JAXBElement)unMarshaller.unmarshal(is);
                        Object o = elt.getValue();
                        this.connectionSuccess = true;
                        if (o instanceof Messages) {
                            Messages messages = (Messages)o;
                            String msg = Utils.printMessages((Messages)messages);
                            if (msg != null && !msg.isEmpty()) {
                                this.setErrorMessage(msg);
                            }
                            validationStatus = ValidationStatus.REFUSED;
                        } else if (o instanceof Token) {
                            Token token = (Token)o;
                            this.validLicenseServerAddress = this.newLicenseServerAddress;
                            this.newLicenseServerAddress = null;
                            licenseToleranceData.refreshDelay = token.getRefreshDelay();
                            if (licenseToleranceData.refreshDelay < 0) {
                                licenseToleranceData.refreshDelay = 30;
                            }
                            licenseToleranceData.remainingTolerance = token.getToleranceLevel1Duration() + token.getToleranceLevel2Duration();
                            licenseToleranceData.refusedTolerance = token.getToleranceKillDuration() != null ? token.getToleranceKillDuration() : -1L;
                            licenseToleranceData.tolerance2 = token.getToleranceLevel2Duration();
                            this.expirationDate = token.getEndDate() != null && token.getEndDate().toGregorianCalendar() != null ? token.getEndDate().toGregorianCalendar().getTime() : null;
                            this.authorizedPermissions = token.getPermission();
                            validationStatus = ValidationStatus.VALID;
                        }
                        HostInformation.networkIssuesHasBeenLoged = false;
                        return validationStatus;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (JAXBException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        catch (Exception e) {
            HostInformation.networkIssuesHasBeenLoged = true;
            status = this.connectionSuccess && e instanceof IOException ? ValidationStatus.CONNECTION_LOST : ValidationStatus.ERROR;
            if (e instanceof License.InvalidLicenseFormatxception) {
                this.setErrorMessage(e.getMessage());
            } else {
                this.setErrorMessage("Error while contacting server");
            }
            this.logger.warn(com.indy.emf.uri.Messages.Validation_123, (Throwable)e);
            if (this.newLicenseServerAddress != null && this.validLicenseServerAddress != null && !this.newLicenseServerAddress.equals(this.validLicenseServerAddress)) {
                if (status == ValidationStatus.REFUSED) {
                    status = ValidationStatus.ERROR;
                }
            } else if (status == ValidationStatus.ERROR) {
                status = ValidationStatus.UNSET;
            }
            return status;
        }
    }

    @Override
    public Date getExpirationDate() {
        return this.expirationDate;
    }

    @Override
    protected List<String> getPermissions() {
        HashSet<String> l = new HashSet<String>(super.getPermissions());
        return new ArrayList<String>(l);
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    @Override
    public String readFromRegistry() throws License.InvalidLicenseChecksumException {
        try {
            String s = RegistryHelper.INSTANCE.read("LicenseComponentPermissionList");
            if (s != null && !s.isEmpty()) {
                this.authorizedPermissions = Arrays.asList(s.split(","));
            }
        }
        catch (Exception e) {
            this.authorizedPermissions = Collections.emptyList();
        }
        try {
            this.expirationDate = this.dateFormater.parse(RegistryHelper.INSTANCE.read("ExpirationDate"));
        }
        catch (Exception ex) {
            this.expirationDate = null;
        }
        this.licenseKey = RegistryHelper.INSTANCE.read("LicenseKey");
        this.serverURL = RegistryHelper.INSTANCE.read("LicenseServerURL");
        return RegistryHelper.INSTANCE.read("Checksum");
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public String computeChecksum(LicenseToleranceData timeInfo) {
        String str = String.join((CharSequence)"/", this.getMode().name(), this.getFormatExpirationDate(), String.join((CharSequence)",", this.getPermissions().toArray(new String[this.getPermissions().size()])), Integer.toString(timeInfo.refreshDelay), Long.toString(timeInfo.refusedTolerance), Long.toString(timeInfo.remainingTolerance), Long.toString(timeInfo.tolerance2));
        try {
            return this.computeHash(str);
        }
        catch (Exception e) {
            this.logger.warn("unexpected", (Throwable)e);
            return null;
        }
    }
}

