/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.preferences.license;

import com.indy.emf.uri.validation2.Validation;
import com.indy.ui.custom.out.services.IUserPreferencesStorageService;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.preferences.license.License;
import com.semarchy.xdi.designer.preferences.license.LicenseOffline;
import com.semarchy.xdi.designer.preferences.license.LicenseServer;
import com.semarchy.xdi.designer.preferences.license.LicenseToleranceData;
import com.semarchy.xdi.designer.preferences.license.LicenseTrial;

public class RegistryHelper {
    public static final String LICENSE_SERVER_URL = "LicenseServerURL";
    public static final String LICENSE_KEY = "LicenseKey";
    public static final String LICENSE_KEY_FILE = "LicenseKeyFile";
    public static final String LICENSE_COMPONENT_PERMISSION_LIST = "LicenseComponentPermissionList";
    public static final String LICENSE_MODE = "LicenseMode";
    public static final String LICENSE_TOKEN_REFRESH_DELAY = "LicenseTokenRefreshDelay";
    public static final String LICENSE_REFUSED_TOLERANCE_DELAY = "LicenseRefusedToleranceDelay";
    public static final String LICENSE_INTERRUPTION_TOLERANCE_REMAINING_DELAY = "LicenseInterruptionToleranceRemainingDelay";
    public static final String LICENSE_INTERRUPTION_TOLERANCE_DELAY = "LicenseInterruptionToleranceDelay";
    public static final String LICENSE_CHECKSUM = "Checksum";
    public static final String LICENSE_TRIAL_KEY = "TrialKey";
    public static final String LICENSE_EXPIRATION_DATE = "ExpirationDate";
    public static final RegistryHelper INSTANCE = new RegistryHelper();
    private IUserPreferencesStorageService storageService = null;

    private IUserPreferencesStorageService getSorageService() {
        if (this.storageService == null) {
            this.storageService = (IUserPreferencesStorageService)E4InjectorHelper.getService(IUserPreferencesStorageService.class);
        }
        return this.storageService;
    }

    private void write(String key, String value) {
        if (value != null && value.isEmpty()) {
            value = null;
        }
        this.getSorageService().write(key, value);
    }

    public String read(String key) {
        return this.getSorageService().read(key);
    }

    public void write(License l) {
        if (l instanceof LicenseServer) {
            this.write((LicenseServer)l);
        } else if (l instanceof LicenseTrial) {
            this.write((LicenseTrial)l);
        } else if (l instanceof LicenseOffline) {
            this.write((LicenseOffline)l);
        }
    }

    public void write(LicenseToleranceData timeInfo) {
        this.write(LICENSE_TOKEN_REFRESH_DELAY, timeInfo.refreshDelay < 0 ? "0" : Integer.toString(timeInfo.refreshDelay));
        this.write(LICENSE_REFUSED_TOLERANCE_DELAY, timeInfo.refusedTolerance < 0L ? "0" : Long.toString(timeInfo.refusedTolerance));
        this.write(LICENSE_INTERRUPTION_TOLERANCE_REMAINING_DELAY, timeInfo.remainingTolerance < 0L ? "0" : Long.toString(timeInfo.remainingTolerance));
        this.write(LICENSE_INTERRUPTION_TOLERANCE_DELAY, timeInfo.tolerance2 < 0L ? "0" : Long.toString(timeInfo.tolerance2));
    }

    private void write(LicenseServer l) {
        this.write(LICENSE_MODE, l.getMode().name());
        this.write(LICENSE_COMPONENT_PERMISSION_LIST, String.join((CharSequence)",", l.authorizedPermissions));
        this.write(LICENSE_SERVER_URL, l.serverURL);
        this.write(LICENSE_KEY, l.licenseKey);
        this.write(LICENSE_EXPIRATION_DATE, l.getFormatExpirationDate());
        this.write(LICENSE_CHECKSUM, l.computeChecksum(Validation.INSTANCE.getLicenseTimeData()));
    }

    private void write(LicenseTrial l) {
        this.write(LICENSE_MODE, l.getMode().name());
        this.write(LICENSE_TRIAL_KEY, l.getTrialKey());
        this.write(LICENSE_EXPIRATION_DATE, l.getFormatExpirationDate());
        this.write(LICENSE_CHECKSUM, l.computeChecksum(Validation.INSTANCE.getLicenseTimeData()));
    }

    private void write(LicenseOffline l) {
        this.write(LICENSE_MODE, l.getMode().name());
        this.write(LICENSE_COMPONENT_PERMISSION_LIST, String.join((CharSequence)",", l.authorizedPermissions));
        this.write(LICENSE_KEY_FILE, l.getLicenseKeyFilePath());
        this.write(LICENSE_EXPIRATION_DATE, l.getFormatExpirationDate());
        this.write(LICENSE_CHECKSUM, l.computeChecksum(Validation.INSTANCE.getLicenseTimeData()));
    }
}

