/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.actions;

import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.Datastore;
import com.indy.map.Field;
import com.indy.map.IMetaData;
import com.indy.map.MapPackage;
import com.stambia.md.MdNode;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class RepairMetaData
implements IObjectActionDelegate {
    public static final String ID = "org.eclipse.gmf.examples.mindmap.popup.MindmapCreateResourceActionID";
    private Logger logger = LogManager.getLogger(RepairMetaData.class);
    private WeakReference<Datastore> datastore;

    public void run(IAction action) {
        if (this.datastore == null) {
            return;
        }
        Datastore ds = (Datastore)this.datastore.get();
        if (ds == null) {
            return;
        }
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)ds);
        if (ted != null) {
            CompoundCommand cc = new CompoundCommand(Messages.RepairMetaData_1 + String.valueOf(ds.getAlias()));
            for (Field srcField : ds.getField()) {
                if (!srcField.getRef().eIsProxy()) continue;
                cc.append(this.repairReference(srcField, (MdNode)ds.getRef(), ted));
            }
            if (cc.getCommandList().size() > 0 && ted != null) {
                ted.getCommandStack().execute((Command)cc);
            }
        }
    }

    public Command repairReference(Field metaData, MdNode parent, TransactionalEditingDomain ted) {
        block3: {
            try {
                List list = (List)parent.evaluateMdSet("*[contains(@tech:mappingType,'Mapping') and @name='" + metaData.getName() + "']");
                if (list.size() > 0 && list.get(0) instanceof MdNode) {
                    return new SetCommand((EditingDomain)ted, (EObject)metaData, (EStructuralFeature)MapPackage.eINSTANCE.getField_Ref(), (Object)((MdNode)list.get(0)));
                }
            }
            catch (XPathExpressionException e) {
                if (!this.logger.isDebugEnabled()) break block3;
                this.logger.error("Failed to repair metadata {}", (Object)metaData.getName(), (Object)e);
            }
        }
        return null;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean enable = false;
        GraphicalEditPart selectedElement = (GraphicalEditPart)((StructuredSelection)selection).getFirstElement();
        Datastore datastore = null;
        IMetaData metaData = null;
        if (selectedElement != null && !(metaData = (IMetaData)selectedElement.resolveSemanticElement()).getRef().eIsProxy() && metaData instanceof Datastore) {
            datastore = (Datastore)metaData;
            for (Field srcField : datastore.getField()) {
                if (!srcField.getRef().eIsProxy()) continue;
                enable = true;
                break;
            }
        }
        action.setEnabled(enable);
        this.datastore = enable ? new WeakReference<Object>(datastore) : null;
    }
}

