/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.actions;

import com.indy.gmf.map.diagram.custom.actions.AbstractSortFilterAction;
import com.indy.gmf.map.diagram.custom.actions.SortAction;
import com.indy.map.Datastore;
import com.indy.map.IContainer;
import com.indy.map.ref.RDatastore;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;

public class SortInverseAction
extends AbstractSortFilterAction {
    public static final String INVERSE_MODE = "inverse";

    @Override
    public void run(IAction action) {
        if (action.isChecked()) {
            this.putDetail(INVERSE_MODE, "true");
        } else {
            this.putDetail(INVERSE_MODE, "false");
        }
        this.refresh();
    }

    public static boolean isInverseMode(GraphicalEditPart gep) {
        EAnnotation annotation = SortAction.getSortAnnotation(gep);
        return annotation != null && annotation.getDetails().get((Object)INVERSE_MODE) != null && ((String)annotation.getDetails().get((Object)INVERSE_MODE)).equals("true");
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (this.ed != null && this.editPart != null) {
            IContainer container = (IContainer)this.editPart.resolveSemanticElement();
            if (container instanceof Datastore && ((RDatastore)((Datastore)container).getMapReference()).isHierarchical()) {
                action.setEnabled(false);
            } else {
                action.setEnabled(true);
                if (SortInverseAction.isInverseMode(this.editPart)) {
                    action.setChecked(true);
                } else {
                    action.setChecked(false);
                }
            }
        }
    }
}

