/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.actions.handler;

import com.indy.gmf.map.diagram.custom.actions.handler.MappigDuplicateAnythingCommand;
import com.indy.gmf.proc.diagram.non_rcp.custom.cpypaste.CopyPasteBuffer;
import com.indy.gmf.proc.diagram.non_rcp.custom.cpypaste.CustomCopyCommand;
import com.indy.gmf.proc.diagram.non_rcp.custom.cpypaste.CustomPasteCommand;
import com.indy.gmf.proc.diagram.non_rcp.custom.cpypaste.DuplicateAnythingCommand;
import com.indy.map.ILogicalField;
import com.indy.map.Map;
import com.indy.map.MapPackage;
import com.indy.map.SetDescriptor;
import com.indy.map.custom.commands.ComputeDatasetsCommand;
import com.indy.ui.custom.out.gmf.EMFCommandWrapper;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.ui.action.global.GlobalActionId;
import org.eclipse.gmf.runtime.common.ui.services.action.global.IGlobalActionContext;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.providers.DiagramGlobalActionHandler;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class CustomMapGlobalActionHandler
extends DiagramGlobalActionHandler {
    public ICommand getCommand(IGlobalActionContext cntxt) {
        IWorkbenchPart part = cntxt.getActivePart();
        if (!(part instanceof IDiagramWorkbenchPart)) {
            return null;
        }
        IDiagramWorkbenchPart diagramPart = (IDiagramWorkbenchPart)part;
        String actionId = cntxt.getActionId();
        if (actionId.equals(GlobalActionId.DELETE)) {
            return this.getDeleteCommandReplacement(diagramPart, cntxt);
        }
        if (actionId.equals(GlobalActionId.PASTE)) {
            return this.getPasteCommand(diagramPart);
        }
        if (actionId.equals(GlobalActionId.COPY)) {
            return this.getCopyCommand(cntxt);
        }
        return super.getCommand(cntxt);
    }

    protected boolean canPaste(IGlobalActionContext cntxt) {
        return CopyPasteBuffer.INSTANCE.containsData();
    }

    private ICommand getPasteCommand(IDiagramWorkbenchPart diagramPart) {
        TransactionalEditingDomain editingDomain = diagramPart.getDiagramEditPart().getEditingDomain();
        boolean readOnly = editingDomain.isReadOnly(diagramPart.getDiagram().eResource());
        if (!readOnly) {
            readOnly = editingDomain.isReadOnly(diagramPart.getDiagram().getElement().eResource());
        }
        if (readOnly) {
            return null;
        }
        CompositeCommand cc = new CompositeCommand("Paste Command");
        CustomPasteCommand cpc = new CustomPasteCommand(editingDomain, diagramPart){

            protected DuplicateAnythingCommand createDuplicateCmd(TransactionalEditingDomain editingDomain, IDiagramWorkbenchPart diagramPart) {
                return new MappigDuplicateAnythingCommand(editingDomain, diagramPart.getDiagram());
            }
        };
        cpc.add((IUndoableOperation)EMFCommandWrapper.of((TransactionalEditingDomain)editingDomain, (Command)new ComputeDatasetsCommand(editingDomain, (Map)diagramPart.getDiagram().getElement())));
        cc.add((IUndoableOperation)cpc);
        return cc;
    }

    private ICommand getCopyCommand(IGlobalActionContext cntxt) {
        List<Object> toCopyElements = new ArrayList<EObject>(this.getSelectedElements(cntxt.getSelection()));
        ArrayList toremove = new ArrayList();
        for (Object e : toCopyElements) {
            if (!(e instanceof ILogicalField) && !(e instanceof SetDescriptor)) continue;
            toremove.add(e);
        }
        toCopyElements.removeAll(toremove);
        toCopyElements = EcoreUtil.filterDescendants(toCopyElements);
        List<EditPart> list = this.getSelectedEditParts(cntxt.getSelection());
        return new CustomCopyCommand("Copy", toCopyElements, list);
    }

    private ICommand getDeleteCommandReplacement(IDiagramWorkbenchPart part, IGlobalActionContext cntxt) {
        GroupRequest deleteReq = new GroupRequest((Object)"delete");
        TransactionalEditingDomain editingDomain = this.getTransactionalEditingDomain(part);
        if (editingDomain == null) {
            return null;
        }
        CompositeTransactionalCommand compositeCommand = new CompositeTransactionalCommand(editingDomain, cntxt.getLabel());
        Object[] objects = ((IStructuredSelection)cntxt.getSelection()).toArray();
        int i = 0;
        while (i < objects.length) {
            EditPart editPart = (EditPart)objects[i];
            org.eclipse.gef.commands.Command command = editPart.getCommand((Request)deleteReq);
            if (command != null) {
                compositeCommand.compose((IUndoableOperation)new CommandProxy(command));
            }
            ++i;
        }
        if (!compositeCommand.isEmpty() && compositeCommand.canExecute()) {
            return compositeCommand;
        }
        return null;
    }

    private TransactionalEditingDomain getTransactionalEditingDomain(IDiagramWorkbenchPart part) {
        EditingDomain domain;
        TransactionalEditingDomain result = null;
        IEditingDomainProvider provider = (IEditingDomainProvider)part.getAdapter(IEditingDomainProvider.class);
        if (provider != null && (domain = provider.getEditingDomain()) instanceof TransactionalEditingDomain) {
            result = (TransactionalEditingDomain)domain;
        }
        return result;
    }

    protected List<EObject> getSelectedElements(ISelection selection) {
        LinkedList<EObject> results = new LinkedList<EObject>();
        if (selection == null || selection.isEmpty()) {
            return results;
        }
        for (Object selectedElement : (IStructuredSelection)selection) {
            EObject element = (EObject)((EditPart)selectedElement).getAdapter(EObject.class);
            if (!MapPackage.eINSTANCE.eContents().contains((Object)element.eClass()) || element instanceof Map) continue;
            results.add(element);
        }
        return results;
    }

    private List<EditPart> getSelectedEditParts(ISelection selection) {
        List l = ((IStructuredSelection)selection).toList();
        return l.stream().filter(EditPart.class::isInstance).map(o -> (EditPart)o).collect(Collectors.toList());
    }
}

