/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.edit.policies;

import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.Clause;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.InputParameter;
import com.indy.map.MapPackage;
import com.indy.map.TargetFilter;
import com.indy.map.Variable;
import com.indy.map.compute.validator.MappingValidator;
import com.indy.map.diagram.part.MapDiagramEditorPlugin;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramDragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;

public class TargetFilterDragDropEditPolicy
extends DiagramDragDropEditPolicy {
    public void showTargetFeedback(Request request) {
        Command c = this.getCommand(request);
        if (c != null && c.canExecute() && this.revertColor == null) {
            this.revertColor = this.getHost().getFigure().getBackgroundColor();
            this.opacity = this.getHost().getFigure().isOpaque();
            this.getHost().getFigure().setBackgroundColor(MapDiagramEditorPlugin.getInstance().mixColors(ColorConstants.blue, this.revertColor));
            this.getHost().getFigure().setOpaque(true);
        }
    }

    public void eraseTargetFeedback(Request request) {
        if (this.revertColor != null) {
            this.getHost().getFigure().setBackgroundColor(this.revertColor);
            this.getHost().getFigure().setOpaque(this.opacity);
            this.revertColor = null;
        }
    }

    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        return this.createViewAndElement((IGraphicalEditPart)this.getHost(), dropRequest);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Command createViewAndElement(IGraphicalEditPart selectedElement, DropObjectsRequest request) {
        Object dragObject;
        if (request.getObjects() == null || request.getObjects().size() <= 0 || !((dragObject = request.getObjects().get(0)) instanceof ILogicalField) && !(dragObject instanceof Variable) && !(dragObject instanceof InputParameter)) return null;
        Clause trgObject = (Clause)selectedElement.resolveSemanticElement();
        String oldValue = "";
        if (trgObject.getExpression() != null) {
            oldValue = trgObject.getExpression();
        }
        Object addValue = "";
        if (dragObject instanceof ILogicalField) {
            IContainer srcContainer;
            addValue = ((ILogicalField)dragObject).getFullPath();
            if (!(trgObject instanceof TargetFilter)) return UnexecutableCommand.INSTANCE;
            if (dragObject instanceof ILogicalField ? MappingValidator.INSTANCE.canCreateLink((EObject)(srcContainer = (IContainer)((EObject)dragObject).eContainer()), trgObject.eContainer()).isError() : !(dragObject instanceof Variable)) {
                return UnexecutableCommand.INSTANCE;
            }
        } else if (dragObject instanceof Variable) {
            srcObject = (Variable)request.getObjects().get(0);
            addValue = "%{" + srcObject.getAlias().toString() + "}%";
        } else if (dragObject instanceof InputParameter) {
            srcObject = (InputParameter)request.getObjects().get(0);
            addValue = "%{" + srcObject.getName().toString() + "}%";
        }
        String newValue = (String)addValue + " = 1";
        if (oldValue != null && !oldValue.isEmpty()) {
            newValue = oldValue + " and " + (String)addValue + " = 1";
        }
        SetRequest srJoin = new SetRequest(selectedElement.getEditingDomain(), (EObject)trgObject, (EStructuralFeature)MapPackage.eINSTANCE.getClause_Expression(), (Object)newValue);
        SetValueCommand svc = new SetValueCommand(srJoin);
        CompoundCommand cmd = new CompoundCommand(Messages.TargetFilterDragDropEditPolicy_9);
        cmd.add((Command)new ICommandProxy((ICommand)svc));
        return cmd;
    }
}

