/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.figures;

import com.indy.gmf.map.diagram.custom.figures.IBlendableFigure;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.swt.graphics.Color;

public class BlendableRectangleFigure
extends RectangleFigure
implements IBlendableFigure {
    private boolean alphaBlended = false;

    public BlendableRectangleFigure() {
        SchemeBorder.Scheme sch = new SchemeBorder.Scheme(new Color[]{ColorConstants.button, ColorConstants.buttonLightest, ColorConstants.button}, new Color[]{ColorConstants.buttonDarkest, ColorConstants.buttonDarker, ColorConstants.button});
        SchemeBorder border = new SchemeBorder(sch);
        this.setBorder((Border)border);
    }

    public void paint(Graphics graphics) {
        graphics.pushState();
        graphics.setAlpha(!this.alphaBlended ? 255 : 20);
        super.paint(graphics);
        graphics.popState();
    }

    @Override
    public void setAlphaBlended(boolean value) {
        if (value == this.alphaBlended) {
            return;
        }
        this.alphaBlended = value;
        for (IBlendableFigure f : this.getDescendantBlendableFigures((IFigure)this)) {
            f.setAlphaBlended(value);
        }
        this.repaint();
    }

    private List<IBlendableFigure> getDescendantBlendableFigures(IFigure f) {
        ArrayList<IBlendableFigure> l = new ArrayList<IBlendableFigure>();
        for (Object o : f.getChildren()) {
            if (o instanceof IBlendableFigure) {
                l.add((IBlendableFigure)o);
                continue;
            }
            l.addAll(this.getDescendantBlendableFigures((IFigure)o));
        }
        return l;
    }

    @Override
    public boolean isAlphaBlended() {
        return this.alphaBlended;
    }
}

