/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.search;

import com.indy.gmf.map.diagram.messages.Messages;
import com.indy.map.Clause;
import com.indy.map.ComputedField;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IReferencable;
import com.indy.map.Join;
import com.indy.map.Template;
import com.indy.map.Variable;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RComputedField;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RExpressionStatus;
import com.indy.map.ref.RItem;
import com.indy.map.ref.RProblem;
import com.indy.map.ref.RTemplate;
import com.indy.ui.custom.out.search.AbstractSearchBar;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.internal.navigator.NavigatorDecoratingLabelProvider;
import org.eclipse.ui.navigator.CommonViewer;

public class SearchBar
extends AbstractSearchBar {
    private static Image error;
    private static Image warning;
    private static Image error_gray;
    private static Image warning_gray;
    private static Image container;
    private static Image field;
    private static Image join;
    private static Image filter;
    private static Image variable;
    private static Image template;
    private Mode mode = Mode.NAME;
    private boolean showError = false;
    private boolean showWarning = false;
    private boolean showContainer = true;
    private boolean showField = true;
    private boolean showTemplate = true;
    private boolean showVariable = true;
    private boolean showFilter = true;
    private boolean showJoin = true;
    private boolean showExpression = true;

    static {
        try {
            error = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.edit/icons/full/other/error_obj.gif")).createImage();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            warning = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.edit/icons/full/other/warning_obj.gif")).createImage();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            error_gray = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.edit/icons/full/other/error_obj_gray.gif")).createImage();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            warning_gray = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.edit/icons/full/other/warning_obj_gray.gif")).createImage();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            container = ImageDescriptor.createFromURL((URL)new URL("platform:plugin/com.indy.gmf.map.edit/icons/full/obj16x16/MappingTable16x16.png")).createImage();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            field = ImageDescriptor.createFromURL((URL)new URL("platform:plugin/com.indy.gmf.map.edit/icons/full/obj16x16/query.rdbms.column.png")).createImage();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            filter = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.edit/icons/full/obj16x16/Filtre16x16SimpleBleu.gif")).createImage();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            join = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.edit/icons/full/obj16x16/JoinFondNormal16x16.gif")).createImage();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            variable = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.map.edit/icons/full/obj16/Variables16x16.png")).createImage();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        try {
            template = ImageDescriptor.createFromURL((URL)new URL("platform:/plugin/com.indy.gmf.process.edit/icons/full/obj16/SubActionProcess.png")).createImage();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public SearchBar(URIEditorInput editorInput) {
        super(editorInput, "com.indy.gmf.map.diagram.search.viewerContentBinding1", new String[]{"com.indy.gmf.map.diagram.searchMapContent"});
    }

    private Integer evalType(Object object) {
        if (object instanceof IContainer) {
            return 1;
        }
        if (object instanceof ComputedField) {
            return 3;
        }
        if (object instanceof ILogicalField) {
            return 2;
        }
        if (object instanceof Clause) {
            return 4;
        }
        if (object instanceof Variable) {
            return 6;
        }
        return 5;
    }

    protected void customizeViewer() {
        super.customizeViewer();
        this.getViewer().setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Integer type2;
                Integer type1 = SearchBar.this.evalType(e1);
                int res = type1.compareTo(type2 = SearchBar.this.evalType(e2));
                if (res == 0) {
                    String sa = ((ILabelProvider)((CommonViewer)viewer).getLabelProvider()).getText(e1);
                    String sb = ((ILabelProvider)((CommonViewer)viewer).getLabelProvider()).getText(e2);
                    return sa.compareTo(sb);
                }
                return res;
            }
        });
        DecorationListener decorationListener = new DecorationListener();
        this.getViewer().getTree().addListener(41, (Listener)decorationListener);
        this.getViewer().getTree().addListener(42, (Listener)decorationListener);
        this.getViewer().getTree().addListener(40, (Listener)decorationListener);
        this.getViewer().getTree().getVerticalBar().addSelectionListener((SelectionListener)decorationListener);
        this.getViewer().setLabelProvider((IBaseLabelProvider)new NavigatorDecoratingLabelProvider((ILabelProvider)this.getViewer().getLabelProvider()){

            public String getToolTipText(Object element) {
                if (SearchBar.this.showError || SearchBar.this.showWarning) {
                    Object obj = null;
                    obj = element instanceof IAdaptable ? ((IAdaptable)element).getAdapter(EObject.class) : element;
                    if (!(obj instanceof IReferencable)) {
                        return null;
                    }
                    StringBuffer buf = new StringBuffer();
                    RItem it = (RItem)((IReferencable)obj).getMapReference();
                    if (it != null) {
                        for (RProblem p : it.getProblem()) {
                            buf.append(String.valueOf(p.getCode()) + ":" + p.getErrorMessage() + "\n");
                        }
                        if (obj instanceof ILogicalField) {
                            for (Expression ex : ((ILogicalField)obj).getExpression()) {
                                RExpression exRef = (RExpression)ex.getMapReference();
                                if (exRef == null) continue;
                                for (RProblem p : exRef.getProblem()) {
                                    buf.append(String.valueOf(p.getCode()) + ":" + p.getErrorMessage() + "\n");
                                }
                            }
                        }
                    }
                    return buf.toString();
                }
                return null;
            }

            public void initialize(ColumnViewer viewer, ViewerColumn column) {
                super.initialize(viewer, column);
                ColumnViewerToolTipSupport.enableFor((ColumnViewer)viewer);
            }
        });
    }

    protected ViewerFilter createViewerFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                switch (SearchBar.this.mode) {
                    case NAME: {
                        return this.check4Name(element);
                    }
                    case EXPRESSION: {
                        return this.check4Expression(element);
                    }
                }
                return true;
            }

            private boolean check4Expression(Object element) {
                Object t = SearchBar.this.getFilterText();
                t = "(?s).*" + ((String)t).replace("*", ".*") + ".*";
                EObject obj = (EObject)element;
                if (obj instanceof ILogicalField) {
                    if (!SearchBar.this.showExpression) {
                        return false;
                    }
                    boolean hasError = false;
                    boolean hasProblem = false;
                    boolean match = true;
                    boolean hasExpression = false;
                    for (Expression ex : ((ILogicalField)obj).getExpression()) {
                        RExpression ref = (RExpression)ex.getMapReference();
                        for (RProblem p : ref.getProblem()) {
                            if (p.getProblemType() == RProblem.Type.ERROR) {
                                hasError = true;
                                break;
                            }
                            if (p.getProblemType() != RProblem.Type.WARNING) continue;
                            hasProblem = true;
                        }
                        if (ex.getExpression() == null) continue;
                        hasExpression = true;
                        if (ex.getExpression().matches((String)t)) continue;
                        match = false;
                        break;
                    }
                    if (obj instanceof ComputedField) {
                        RComputedField ref = (RComputedField)((ComputedField)obj).getMapReference();
                        hasExpression = ((ComputedField)obj).getFormula() != null && !((ComputedField)obj).getFormula().trim().isEmpty();
                        for (RProblem p : ref.getProblem()) {
                            if (p.getProblemType() == RProblem.Type.ERROR) {
                                hasError = true;
                                break;
                            }
                            if (p.getProblemType() != RProblem.Type.WARNING) continue;
                            hasProblem = true;
                        }
                        if (!((ComputedField)obj).getFormula().matches((String)t)) {
                            match = false;
                        }
                    }
                    if (!hasExpression && !"".matches((String)t)) {
                        return false;
                    }
                    if (SearchBar.this.showError && !hasError) {
                        return false;
                    }
                    if (SearchBar.this.showWarning && !hasProblem) {
                        return false;
                    }
                    return match;
                }
                if (obj instanceof Clause) {
                    if (obj instanceof Join ? !SearchBar.this.showJoin : !SearchBar.this.showFilter) {
                        return false;
                    }
                    if (SearchBar.this.showError || SearchBar.this.showWarning) {
                        boolean hasProblem;
                        RClause ref = (RClause)((Clause)obj).getMapReference();
                        boolean hasError = ref.getStatus() == RExpressionStatus.ERROR;
                        boolean bl = hasProblem = ref.getStatus() == RExpressionStatus.WARNING;
                        if (SearchBar.this.showError && !hasError) {
                            return false;
                        }
                        if (SearchBar.this.showWarning && !hasProblem) {
                            return false;
                        }
                    }
                    return ((Clause)obj).getExpression() != null && ((Clause)obj).getExpression().matches((String)t);
                }
                return false;
            }

            private boolean check4Name(Object element) {
                Object t = SearchBar.this.getFilterText().toLowerCase();
                t = ".*" + ((String)t).replace("*", ".*") + ".*";
                Object obj = element;
                String s = null;
                if (obj instanceof ILogicalField) {
                    if (!SearchBar.this.showField) {
                        return false;
                    }
                    s = ((ILogicalField)obj).getFullPath();
                } else if (obj instanceof IContainer) {
                    if (!SearchBar.this.showContainer) {
                        return false;
                    }
                    s = ((IContainer)obj).getAlias().toString();
                } else if (obj instanceof Variable) {
                    if (!SearchBar.this.showVariable) {
                        return false;
                    }
                    s = ((Variable)obj).getAlias().toString();
                } else if (obj instanceof Template) {
                    if (!SearchBar.this.showTemplate) {
                        return false;
                    }
                    s = ((Template)obj).getName();
                }
                boolean res = false;
                try {
                    res = s != null && s.toLowerCase().matches((String)t);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (res && (SearchBar.this.showError || SearchBar.this.showWarning)) {
                    res = false;
                    RItem it = (RItem)((IReferencable)obj).getMapReference();
                    if (it != null) {
                        for (RProblem p : it.getProblem()) {
                            if (p.getProblemType() == RProblem.Type.ERROR && SearchBar.this.showError) {
                                res = true;
                                break;
                            }
                            if (p.getProblemType() != RProblem.Type.WARNING || !SearchBar.this.showWarning) continue;
                            res = true;
                            break;
                        }
                        if (obj instanceof ILogicalField && !res) {
                            block3: for (Expression ex : ((ILogicalField)obj).getExpression()) {
                                RExpression exRef = (RExpression)ex.getMapReference();
                                if (exRef == null) continue;
                                for (RProblem p : exRef.getProblem()) {
                                    if (p.getProblemType() == RProblem.Type.ERROR && SearchBar.this.showError) {
                                        res = true;
                                        continue block3;
                                    }
                                    if (p.getProblemType() != RProblem.Type.WARNING || !SearchBar.this.showWarning) continue;
                                    res = true;
                                    continue block3;
                                }
                            }
                        }
                    }
                }
                return res;
            }
        };
    }

    protected void createSearchModeComposite(Composite modeComposite) {
        final FormToolkit tk = new FormToolkit(modeComposite.getDisplay());
        modeComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                tk.dispose();
            }
        });
        RowLayout rlw = new RowLayout();
        rlw.wrap = true;
        modeComposite.setLayout((Layout)rlw);
        final Button btName = new Button(modeComposite, 16);
        btName.setEnabled(false);
        btName.setSelection(true);
        Hyperlink hName = tk.createHyperlink(modeComposite, Messages.SearchBar_25, 0);
        final Button btCode = new Button(modeComposite, 16);
        btCode.setEnabled(false);
        Hyperlink hCode = tk.createHyperlink(modeComposite, Messages.SearchBar_26, 0);
        ToolBar toolbar = new ToolBar(modeComposite, 0x800100);
        tk.adapt((Composite)toolbar);
        ToolItem errors = new ToolItem(toolbar, 32);
        errors.setToolTipText(Messages.SearchBar_27);
        errors.setImage(error_gray);
        errors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((ToolItem)e.widget).getSelection()) {
                    ((ToolItem)e.widget).setImage(error);
                    SearchBar.this.showError = true;
                } else {
                    ((ToolItem)e.widget).setImage(error_gray);
                    SearchBar.this.showError = false;
                }
                SearchBar.this.refreshViewer();
            }
        });
        ToolItem warning = new ToolItem(toolbar, 32);
        warning.setToolTipText(Messages.SearchBar_28);
        warning.setImage(warning_gray);
        warning.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (((ToolItem)e.widget).getSelection()) {
                    ((ToolItem)e.widget).setImage(warning);
                    SearchBar.this.showWarning = true;
                } else {
                    ((ToolItem)e.widget).setImage(warning_gray);
                    SearchBar.this.showWarning = false;
                }
                SearchBar.this.refreshViewer();
            }
        });
        final Composite toolbarComposite = tk.createComposite(modeComposite);
        toolbarComposite.setLayout((Layout)new StackLayout());
        final ToolBar nameToolbar = new ToolBar(toolbarComposite, 0x800100);
        tk.adapt((Composite)nameToolbar);
        ToolItem containerIt = new ToolItem(nameToolbar, 32);
        containerIt.setToolTipText(Messages.SearchBar_29);
        containerIt.setSelection(true);
        containerIt.setImage(container);
        containerIt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchBar.this.showContainer = ((ToolItem)e.widget).getSelection();
                SearchBar.this.refreshViewer();
            }
        });
        ToolItem fieldIt = new ToolItem(nameToolbar, 32);
        fieldIt.setToolTipText(Messages.SearchBar_30);
        fieldIt.setImage(field);
        fieldIt.setSelection(true);
        fieldIt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchBar.this.showField = ((ToolItem)e.widget).getSelection();
                SearchBar.this.refreshViewer();
            }
        });
        ToolItem templateIt = new ToolItem(nameToolbar, 32);
        templateIt.setToolTipText(Messages.SearchBar_31);
        templateIt.setImage(template);
        templateIt.setSelection(true);
        templateIt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchBar.this.showTemplate = ((ToolItem)e.widget).getSelection();
                SearchBar.this.refreshViewer();
            }
        });
        ToolItem variableIt = new ToolItem(nameToolbar, 32);
        variableIt.setToolTipText(Messages.SearchBar_32);
        variableIt.setImage(variable);
        variableIt.setSelection(true);
        variableIt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchBar.this.showVariable = ((ToolItem)e.widget).getSelection();
                SearchBar.this.refreshViewer();
            }
        });
        final ToolBar expressionToolbar = new ToolBar(toolbarComposite, 0x800100);
        tk.adapt((Composite)expressionToolbar);
        ToolItem filterIt = new ToolItem(expressionToolbar, 32);
        filterIt.setToolTipText(Messages.SearchBar_33);
        filterIt.setImage(filter);
        filterIt.setSelection(true);
        filterIt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchBar.this.showFilter = ((ToolItem)e.widget).getSelection();
                SearchBar.this.refreshViewer();
            }
        });
        ToolItem joinIt = new ToolItem(expressionToolbar, 32);
        joinIt.setToolTipText(Messages.SearchBar_34);
        joinIt.setImage(join);
        joinIt.setSelection(true);
        joinIt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchBar.this.showJoin = ((ToolItem)e.widget).getSelection();
                SearchBar.this.refreshViewer();
            }
        });
        ToolItem expressionIt = new ToolItem(expressionToolbar, 32);
        expressionIt.setToolTipText(Messages.SearchBar_35);
        expressionIt.setImage(field);
        expressionIt.setSelection(true);
        expressionIt.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchBar.this.showExpression = ((ToolItem)e.widget).getSelection();
                SearchBar.this.refreshViewer();
            }
        });
        ((StackLayout)toolbarComposite.getLayout()).topControl = nameToolbar;
        hName.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                ((StackLayout)toolbarComposite.getLayout()).topControl = nameToolbar;
                toolbarComposite.layout(true);
                btName.setSelection(true);
                btCode.setSelection(false);
                SearchBar.this.mode = Mode.NAME;
                SearchBar.this.refreshViewer();
            }
        });
        hCode.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                ((StackLayout)toolbarComposite.getLayout()).topControl = expressionToolbar;
                toolbarComposite.layout(true);
                btCode.setSelection(true);
                btName.setSelection(false);
                SearchBar.this.mode = Mode.EXPRESSION;
                SearchBar.this.refreshViewer();
            }
        });
    }

    protected void handleSelectionChanged(SelectionChangedEvent event) {
        if (event.getSelection().isEmpty()) {
            return;
        }
        IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IDiagramGraphicalViewer viewer = (IDiagramGraphicalViewer)editor.getAdapter(GraphicalViewer.class);
        EObject obj = (EObject)((IStructuredSelection)event.getSelection()).getFirstElement();
        URI objURI = obj.eIsProxy() ? ((InternalEObject)obj).eProxyURI() : EcoreUtil.getURI((EObject)obj);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)((DiagramRootEditPart)viewer.getRootEditPart()).getContents().getModel());
        obj = domain.getResourceSet().getEObject(objURI, true);
        if (obj instanceof Template) {
            Request rq = new Request();
            rq.setType((Object)"com.indy.gmf.map.diagram.custom.edit.policies.TemplateToolEditPolicy.request.selectTool");
            rq.getExtendedData().put("com.indy.gmf.map.diagram.custom.edit.policies.TemplateToolEditPolicy.template", obj);
            CompoundCommand cc = new CompoundCommand(Messages.SearchBar_36);
            for (IContainer ts : ((RTemplate)((Template)obj).getMapReference()).getTargetRef()) {
                Command cmd;
                EditPart ep = ((IGraphicalEditPart)((DiagramRootEditPart)viewer.getRootEditPart()).getContents()).findEditPart((EditPart)viewer.getRootEditPart(), (EObject)ts);
                if (ep == null || (cmd = ep.getCommand(rq)) == null) continue;
                cc.add(cmd);
            }
            if (!cc.isEmpty() && cc.canExecute()) {
                viewer.getDiagramEditDomain().getDiagramCommandStack().execute((Command)cc);
            }
        } else {
            EditPart ep = ((IGraphicalEditPart)((DiagramRootEditPart)viewer.getRootEditPart()).getContents()).findEditPart((EditPart)viewer.getRootEditPart(), obj);
            while (ep == null && (obj instanceof Field || obj instanceof Expression)) {
                obj = obj.eContainer();
                ep = ((IGraphicalEditPart)((DiagramRootEditPart)viewer.getRootEditPart()).getContents()).findEditPart((EditPart)viewer.getRootEditPart(), obj);
            }
            if (ep != null) {
                StructuredSelection s = new StructuredSelection((Object)ep);
                viewer.setSelection((ISelection)s);
                viewer.reveal(ep);
                IEditorPart ed = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                ed.getSite().getSelectionProvider().setSelection((ISelection)s);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().activate((IWorkbenchPart)ed);
            }
        }
    }

    public void init(Object input) {
        this.getViewer().setInput(input);
    }

    private class DecorationListener
    implements Listener,
    SelectionListener {
        Object lastClassItem = null;

        private DecorationListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 41: {
                    this.measureItem(event);
                    break;
                }
                case 42: {
                    this.paintItem(event);
                    break;
                }
                case 40: {
                    this.eraseItem(event);
                }
            }
        }

        private void eraseItem(Event event) {
            event.detail &= 0xFFFFFFEF;
        }

        private void paintItem(Event event) {
            TreeItem item = (TreeItem)event.item;
            if (this.lastClassItem == null) {
                this.lastClassItem = SearchBar.this.evalType(item.getData());
            } else {
                int t = SearchBar.this.evalType(item.getData());
                if (!this.lastClassItem.equals(t)) {
                    Rectangle bounds = item.getBounds(event.index);
                    event.gc.setForeground(event.widget.getDisplay().getSystemColor(15));
                    event.gc.drawLine(0, bounds.y, bounds.x + bounds.width, bounds.y);
                    this.lastClassItem = t;
                }
            }
        }

        private void measureItem(Event event) {
            Rectangle r = SearchBar.this.getViewer().getTree().getClientArea();
            event.width = r.width;
        }

        public void widgetSelected(SelectionEvent e) {
            this.lastClassItem = null;
            SearchBar.this.getViewer().getTree().redraw();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private static enum Mode {
        NAME,
        EXPRESSION;

    }
}

