/*
 * Decompiled with CFR 0.152.
 */
package com.indy.gmf.map.diagram.custom.tooltip;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PopUpHelper;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class TooltipHelper
extends PopUpHelper {
    private IFigure lastSourceFigure;
    private Listener controlListener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 7: {
                    this.hideWhenOutside(event);
                    break;
                }
                case 5: {
                    this.hideWhenOutside(event);
                    break;
                }
                case 32: {
                    this.handleMouseHover(event);
                    break;
                }
                case 6: {
                    this.handleMouseHover(event);
                    break;
                }
                case 3: {
                    TooltipHelper.this.lastSourceFigure = null;
                    TooltipHelper.this.hide();
                }
            }
        }

        private boolean isWithinHoverArea(Event e) {
            if (TooltipHelper.this.lastSourceFigure == null) {
                return false;
            }
            org.eclipse.draw2d.geometry.Rectangle b = TooltipHelper.this.lastSourceFigure.getBounds().getCopy();
            TooltipHelper.this.lastSourceFigure.translateToAbsolute((Translatable)b);
            org.eclipse.swt.graphics.Point p = TooltipHelper.this.control.toDisplay(b.x, b.y);
            org.eclipse.draw2d.geometry.Rectangle r = new org.eclipse.draw2d.geometry.Rectangle(p.x, p.y, b.width, b.height);
            org.eclipse.swt.graphics.Point location = TooltipHelper.this.getShell().getLocation();
            r = r.union(new org.eclipse.draw2d.geometry.Rectangle(location.x, location.y, ((TooltipHelper)TooltipHelper.this).getShell().getSize().x, ((TooltipHelper)TooltipHelper.this).getShell().getSize().y));
            org.eclipse.swt.graphics.Point pointer = TooltipHelper.this.control.toDisplay(e.x, e.y);
            return r.contains(new Point(pointer.x, pointer.y));
        }

        private void handleMouseHover(Event e) {
            IFigure f = TooltipHelper.this.getFigureAt(e.x, e.y);
            if (f != TooltipHelper.this.lastSourceFigure) {
                if (TooltipHelper.this.isShowing()) {
                    if (!this.isWithinHoverArea(e)) {
                        TooltipHelper.this.hide();
                        TooltipHelper.this.lastSourceFigure = null;
                    }
                } else if (f != null && f instanceof ITooltipable) {
                    org.eclipse.swt.graphics.Point p = TooltipHelper.this.control.toDisplay(e.x, e.y);
                    TooltipHelper.this.displayFigure(((ITooltipable)f).getImprovedTooltip(), p.x, p.y);
                    TooltipHelper.this.lastSourceFigure = f;
                }
            }
        }

        private void hideWhenOutside(Event event) {
            if (TooltipHelper.this.isShowing() && !this.isWithinHoverArea(event)) {
                TooltipHelper.this.lastSourceFigure = null;
                TooltipHelper.this.hide();
            }
        }
    };

    public TooltipHelper(Control c) {
        super(c, 16388);
        this.getShell().setBackground(ColorConstants.tooltipBackground);
        this.getShell().setForeground(ColorConstants.tooltipForeground);
        c.addListener(5, this.controlListener);
        c.addListener(7, this.controlListener);
        c.addListener(32, this.controlListener);
        c.addListener(6, this.controlListener);
        c.addListener(3, this.controlListener);
    }

    public void dispose() {
        if (this.control != null && !this.control.isDisposed()) {
            this.control.removeListener(5, this.controlListener);
            this.control.removeListener(7, this.controlListener);
            this.control.removeListener(32, this.controlListener);
            this.control.removeListener(6, this.controlListener);
            this.control.removeListener(3, this.controlListener);
        }
        super.dispose();
    }

    protected void displayFigure(IFigure tip, int eventX, int eventY) {
        if (tip == null) {
            return;
        }
        this.getLightweightSystem().setContents(tip);
        Dimension BaseDIM = new Dimension(210, 160);
        Dimension prefSz = tip.getPreferredSize(-1, -1).getCopy();
        tip.setPreferredSize(new Dimension(Math.min(BaseDIM.width, prefSz.width) + 10, Math.min(BaseDIM.height, prefSz.height) + 10));
        Point displayPoint = this.computeWindowLocation(tip, eventX, eventY);
        Dimension shellSize = this.getLightweightSystem().getRootFigure().getPreferredSize().getExpanded(this.getShellTrimSize());
        this.setShellBounds(displayPoint.x, displayPoint.y, shellSize.width, shellSize.height);
        this.show();
    }

    private Point computeWindowLocation(IFigure tip, int eventX, int eventY) {
        Rectangle clientArea = this.control.getDisplay().getClientArea();
        Point preferredLocation = new Point(eventX, eventY + 26);
        Dimension tipSize = this.getLightweightSystem().getRootFigure().getPreferredSize().getExpanded(this.getShellTrimSize());
        if (preferredLocation.y + tipSize.height > clientArea.height) {
            preferredLocation.y = eventY - tipSize.height;
        }
        if (preferredLocation.x + tipSize.width > clientArea.width) {
            preferredLocation.x -= preferredLocation.x + tipSize.width - clientArea.width;
        }
        return preferredLocation;
    }

    public IFigure getFigureAt(int x, int y) {
        IFigure f = ((FigureCanvas)this.control).getLightweightSystem().getRootFigure().findMouseEventTargetAt(x, y);
        return f;
    }

    protected void hookShellListeners() {
    }

    public static interface ITooltipable {
        public IFigure getImprovedTooltip();

        public void setImprovedTooltip(IFigure var1);
    }
}

